/*
 * Decompiled with CFR 0.152.
 */
package io.trino.tests.product;

import com.google.common.base.CharMatcher;
import com.google.common.collect.ImmutableList;
import com.google.common.io.Resources;
import io.trino.tempto.BeforeMethodWithContext;
import io.trino.tempto.ProductTest;
import io.trino.tempto.query.QueryExecutor;
import io.trino.tests.product.utils.QueryExecutors;
import java.io.IOException;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Objects;
import org.assertj.core.api.Assertions;
import org.assertj.core.data.Percentage;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;

public class TestParquet
extends ProductTest {
    private static final Percentage DOUBLE_COMPARISON_ACCURACY = Percentage.withPercentage((double)1.1E-10);
    private static final String[] TPCDS_TABLES = new String[]{"call_center", "catalog_page", "catalog_returns", "catalog_sales", "customer", "customer_address", "customer_demographics", "date_dim", "household_demographics", "income_band", "inventory", "item", "promotion", "reason", "ship_mode", "store", "store_returns", "store_sales", "time_dim", "warehouse", "web_page", "web_returns", "web_sales", "web_site"};
    private static final String[] TPCH_TABLES = new String[]{"nation", "region", "part", "supplier", "partsupp", "customer", "orders", "lineitem"};
    private volatile boolean initialized;

    @BeforeMethodWithContext
    public void init() {
        if (this.initialized) {
            return;
        }
        QueryExecutors.onTrino().executeQuery("CREATE SCHEMA hive.tpch", new QueryExecutor.QueryParam[0]);
        QueryExecutors.onTrino().executeQuery("CREATE SCHEMA hive.tpcds", new QueryExecutor.QueryParam[0]);
        for (String table : TPCDS_TABLES) {
            QueryExecutors.onTrino().executeQuery("CREATE TABLE hive.tpcds." + table + " WITH (format='PARQUET') AS SELECT * FROM tpcds.sf1." + table, new QueryExecutor.QueryParam[0]);
        }
        for (String table : TPCH_TABLES) {
            QueryExecutors.onTrino().executeQuery("CREATE TABLE hive.tpch." + table + " WITH (format='PARQUET') AS SELECT * FROM tpch.sf1." + table, new QueryExecutor.QueryParam[0]);
        }
        this.initialized = true;
    }

    @Test(groups={"parquet", "profile_specific_tests"}, dataProvider="tpcdsQueries")
    public void testTpcds(String queryId) throws IOException {
        String query = Resources.toString((URL)Resources.getResource((String)("sql-tests/testcases/tpcds/q" + queryId + ".sql")), (Charset)StandardCharsets.UTF_8);
        List expected = (List)Resources.readLines((URL)Resources.getResource((String)("sql-tests/testcases/tpcds/q" + queryId + ".result")), (Charset)StandardCharsets.UTF_8).stream().filter(line -> !line.startsWith("--")).collect(ImmutableList.toImmutableList());
        QueryExecutors.onTrino().executeQuery("USE hive.tpcds", new QueryExecutor.QueryParam[0]);
        this.assertResults(expected, query);
    }

    @Test(groups={"parquet", "profile_specific_tests"}, dataProvider="tpchQueries")
    public void testTpch(String queryId) throws IOException {
        String query = Resources.toString((URL)Resources.getResource((String)("sql-tests/testcases/hive_tpch/q" + queryId + ".sql")), (Charset)StandardCharsets.UTF_8);
        List expected = (List)Resources.readLines((URL)Resources.getResource((String)("sql-tests/testcases/hive_tpch/q" + queryId + ".result")), (Charset)StandardCharsets.UTF_8).stream().filter(line -> !line.startsWith("--")).collect(ImmutableList.toImmutableList());
        QueryExecutors.onTrino().executeQuery("USE hive.tpch", new QueryExecutor.QueryParam[0]);
        this.assertResults(expected, query);
    }

    private void assertResults(List<String> expected, String query) {
        List result = QueryExecutors.onTrino().executeQuery(query, new QueryExecutor.QueryParam[0]).rows();
        Assertions.assertThat((int)result.size()).isEqualTo(expected.size());
        for (int i = 0; i < expected.size(); ++i) {
            String expectedRow = expected.get(i);
            String[] expectedValues = expectedRow.split("\\|");
            List resultRow = (List)result.get(i);
            Assertions.assertThat((int)expectedValues.length).isEqualTo(resultRow.size());
            for (int j = 0; j < expectedValues.length; ++j) {
                String expectedValue = expectedValues[j];
                Object resultValue = resultRow.get(j);
                if (resultValue instanceof Double) {
                    expectedValue = this.trimIfNeeded(expectedValue);
                    BigDecimal expectedDecimal = new BigDecimal(expectedValue);
                    BigDecimal resultDecimal = BigDecimal.valueOf((Double)resultValue);
                    resultDecimal = resultDecimal.setScale(expectedDecimal.scale(), RoundingMode.HALF_DOWN);
                    Assertions.assertThat((BigDecimal)expectedDecimal).isCloseTo(resultDecimal, DOUBLE_COMPARISON_ACCURACY);
                    continue;
                }
                if (resultValue instanceof BigDecimal) {
                    Assertions.assertThat((String)this.trimIfNeeded(Objects.toString(resultValue))).isEqualTo(this.trimIfNeeded(expectedValue));
                    continue;
                }
                Assertions.assertThat((String)Objects.toString(resultValue)).isEqualTo(expectedValue);
            }
        }
    }

    private String trimIfNeeded(String value) {
        if (value.contains(".")) {
            return CharMatcher.is((char)'.').trimTrailingFrom((CharSequence)CharMatcher.is((char)'0').trimTrailingFrom((CharSequence)value));
        }
        return value;
    }

    /*
     * Exception decompiling
     */
    @DataProvider
    public static Object[][] tpchQueries() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * java.lang.UnsupportedOperationException
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.NewAnonymousArray.getDimSize(NewAnonymousArray.java:142)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.isNewArrayLambda(LambdaRewriter.java:455)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:409)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:167)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:105)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExpressionRewriterHelper.applyForwards(ExpressionRewriterHelper.java:12)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriterToArgs(AbstractMemberFunctionInvokation.java:101)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriter(AbstractMemberFunctionInvokation.java:88)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriter(AbstractMemberFunctionInvokation.java:87)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.CastExpression.applyExpressionRewriter(CastExpression.java:128)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.StructuredReturn.rewriteExpressions(StructuredReturn.java:99)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewrite(LambdaRewriter.java:88)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.rewriteLambdas(Op04StructuredStatement.java:1137)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:912)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    @DataProvider
    public static Object[][] tpcdsQueries() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * java.lang.UnsupportedOperationException
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.NewAnonymousArray.getDimSize(NewAnonymousArray.java:142)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.isNewArrayLambda(LambdaRewriter.java:455)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:409)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:167)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:105)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExpressionRewriterHelper.applyForwards(ExpressionRewriterHelper.java:12)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriterToArgs(AbstractMemberFunctionInvokation.java:101)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriter(AbstractMemberFunctionInvokation.java:88)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriter(AbstractMemberFunctionInvokation.java:87)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.CastExpression.applyExpressionRewriter(CastExpression.java:128)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.StructuredReturn.rewriteExpressions(StructuredReturn.java:99)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewrite(LambdaRewriter.java:88)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.rewriteLambdas(Op04StructuredStatement.java:1137)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:912)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static /* synthetic */ Object[][] lambda$tpcdsQueries$13(int x$0) {
        return new Object[x$0][];
    }

    private static /* synthetic */ Object[][] lambda$tpchQueries$5(int x$0) {
        return new Object[x$0][];
    }
}

