/*
 * Decompiled with CFR 0.152.
 */
package io.trino.tests.product.deltalake;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import io.trino.tempto.BeforeMethodWithContext;
import io.trino.tempto.assertions.QueryAssert;
import io.trino.tempto.query.QueryExecutor;
import io.trino.testing.TestingNames;
import io.trino.testng.services.Flaky;
import io.trino.tests.product.deltalake.BaseTestDeltaLakeS3Storage;
import io.trino.tests.product.deltalake.util.DatabricksVersion;
import io.trino.tests.product.deltalake.util.DeltaLakeTestUtils;
import io.trino.tests.product.utils.QueryExecutors;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;
import org.assertj.core.api.AssertProvider;
import org.assertj.core.api.Assertions;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;

public class TestDeltaLakeDatabricksInsertCompatibility
extends BaseTestDeltaLakeS3Storage {
    private Optional<DatabricksVersion> databricksRuntimeVersion;

    @BeforeMethodWithContext
    public void setup() {
        super.setUp();
        this.databricksRuntimeVersion = DeltaLakeTestUtils.getDatabricksRuntimeVersion();
    }

    @Test(groups={"delta-lake-databricks", "delta-lake-oss", "profile_specific_tests"})
    @Flaky(issue="https://github.com/trinodb/trino/issues/14391", match="\\Q[Databricks][DatabricksJDBCDriver](500593) Communication link failure. Failed to connect to server. Reason: HTTP retry after response received with no Retry-After header, error: HTTP Response code: 503, Error message: Unknown.")
    public void testInsertCompatibility() {
        String tableName = "test_dl_insert_" + TestingNames.randomNameSuffix();
        QueryExecutors.onDelta().executeQuery("CREATE TABLE default." + tableName + "         (a_number INT, a_string STRING)         USING delta          LOCATION 's3://" + this.bucketName + "/databricks-compatibility-test-" + tableName + "'", new QueryExecutor.QueryParam[0]);
        try {
            QueryExecutors.onDelta().executeQuery("INSERT INTO default." + tableName + " VALUES (1,'ala'), (2, 'kota')", new QueryExecutor.QueryParam[0]);
            QueryExecutors.onDelta().executeQuery("INSERT INTO default." + tableName + " VALUES (3, 'psa')", new QueryExecutor.QueryParam[0]);
            QueryExecutors.onTrino().executeQuery("INSERT INTO delta.default." + tableName + " VALUES (4, 'lwa'), (5, 'jeza')", new QueryExecutor.QueryParam[0]);
            QueryExecutors.onTrino().executeQuery("INSERT INTO delta.default." + tableName + " VALUES (6, 'wilka')", new QueryExecutor.QueryParam[0]);
            ImmutableList expectedRows = ImmutableList.of((Object)QueryAssert.Row.row((Object[])new Object[]{1, "ala"}), (Object)QueryAssert.Row.row((Object[])new Object[]{2, "kota"}), (Object)QueryAssert.Row.row((Object[])new Object[]{3, "psa"}), (Object)QueryAssert.Row.row((Object[])new Object[]{4, "lwa"}), (Object)QueryAssert.Row.row((Object[])new Object[]{5, "jeza"}), (Object)QueryAssert.Row.row((Object[])new Object[]{6, "wilka"}));
            ((QueryAssert)Assertions.assertThat((AssertProvider)QueryExecutors.onDelta().executeQuery("SELECT * FROM default." + tableName, new QueryExecutor.QueryParam[0]))).containsOnly((List)expectedRows);
            ((QueryAssert)Assertions.assertThat((AssertProvider)QueryExecutors.onTrino().executeQuery("SELECT * FROM delta.default." + tableName, new QueryExecutor.QueryParam[0]))).containsOnly((List)expectedRows);
        }
        finally {
            DeltaLakeTestUtils.dropDeltaTableWithRetry("default." + tableName);
        }
    }

    @Test(groups={"delta-lake-databricks", "profile_specific_tests"})
    @Flaky(issue="https://github.com/trinodb/trino/issues/14391", match="\\Q[Databricks][DatabricksJDBCDriver](500593) Communication link failure. Failed to connect to server. Reason: HTTP retry after response received with no Retry-After header, error: HTTP Response code: 503, Error message: Unknown.")
    public void testPartitionedInsertCompatibility() {
        String tableName = "test_dl_partitioned_insert_" + TestingNames.randomNameSuffix();
        QueryExecutors.onDelta().executeQuery("CREATE TABLE default." + tableName + "         (a_number INT, a_string STRING)         USING delta          PARTITIONED BY (a_number)         LOCATION 's3://" + this.bucketName + "/databricks-compatibility-test-" + tableName + "'", new QueryExecutor.QueryParam[0]);
        try {
            QueryExecutors.onDelta().executeQuery("INSERT INTO default." + tableName + " VALUES (1,'ala'), (2, 'kota')", new QueryExecutor.QueryParam[0]);
            QueryExecutors.onDelta().executeQuery("INSERT INTO default." + tableName + " VALUES (3, 'osla')", new QueryExecutor.QueryParam[0]);
            QueryExecutors.onTrino().executeQuery("INSERT INTO delta.default." + tableName + " VALUES (3, 'psa'), (4, 'bobra')", new QueryExecutor.QueryParam[0]);
            QueryExecutors.onTrino().executeQuery("INSERT INTO delta.default." + tableName + " VALUES (4, 'lwa'), (5, 'jeza')", new QueryExecutor.QueryParam[0]);
            ImmutableList expectedRows = ImmutableList.of((Object)QueryAssert.Row.row((Object[])new Object[]{1, "ala"}), (Object)QueryAssert.Row.row((Object[])new Object[]{2, "kota"}), (Object)QueryAssert.Row.row((Object[])new Object[]{3, "osla"}), (Object)QueryAssert.Row.row((Object[])new Object[]{3, "psa"}), (Object)QueryAssert.Row.row((Object[])new Object[]{4, "bobra"}), (Object)QueryAssert.Row.row((Object[])new Object[]{4, "lwa"}), (Object)QueryAssert.Row.row((Object[])new Object[]{5, "jeza"}));
            ((QueryAssert)Assertions.assertThat((AssertProvider)QueryExecutors.onDelta().executeQuery("SELECT * FROM default." + tableName, new QueryExecutor.QueryParam[0]))).containsOnly((List)expectedRows);
            ((QueryAssert)Assertions.assertThat((AssertProvider)QueryExecutors.onTrino().executeQuery("SELECT * FROM delta.default." + tableName, new QueryExecutor.QueryParam[0]))).containsOnly((List)expectedRows);
        }
        finally {
            DeltaLakeTestUtils.dropDeltaTableWithRetry("default." + tableName);
        }
    }

    @Test(groups={"delta-lake-databricks", "delta-lake-oss", "profile_specific_tests"})
    @Flaky(issue="https://github.com/trinodb/trino/issues/14391", match="\\Q[Databricks][DatabricksJDBCDriver](500593) Communication link failure. Failed to connect to server. Reason: HTTP retry after response received with no Retry-After header, error: HTTP Response code: 503, Error message: Unknown.")
    public void testTrinoPartitionedDifferentOrderInsertCompatibility() {
        String tableName = "test_dl_trino_partitioned_different_order_insert_" + TestingNames.randomNameSuffix();
        QueryExecutors.onTrino().executeQuery("CREATE TABLE delta.default." + tableName + "         (a_number INT, first VARCHAR, second VARCHAR)         WITH (         partitioned_by = ARRAY['second', 'first'],         location = 's3://" + this.bucketName + "/databricks-compatibility-test-" + tableName + "')", new QueryExecutor.QueryParam[0]);
        try {
            QueryExecutors.onTrino().executeQuery("INSERT INTO delta.default." + tableName + " VALUES (1, 'first', 'second')", new QueryExecutor.QueryParam[0]);
            ImmutableList expectedRows = ImmutableList.of((Object)QueryAssert.Row.row((Object[])new Object[]{1, "first", "second"}));
            ((QueryAssert)Assertions.assertThat((AssertProvider)QueryExecutors.onDelta().executeQuery("SELECT * FROM default." + tableName, new QueryExecutor.QueryParam[0]))).containsOnly((List)expectedRows);
            ((QueryAssert)Assertions.assertThat((AssertProvider)QueryExecutors.onTrino().executeQuery("SELECT * FROM delta.default." + tableName, new QueryExecutor.QueryParam[0]))).containsOnly((List)expectedRows);
        }
        finally {
            QueryExecutors.onTrino().executeQuery("DROP TABLE delta.default." + tableName, new QueryExecutor.QueryParam[0]);
        }
    }

    @Test(groups={"delta-lake-databricks", "delta-lake-oss", "profile_specific_tests"})
    @Flaky(issue="https://github.com/trinodb/trino/issues/14391", match="\\Q[Databricks][DatabricksJDBCDriver](500593) Communication link failure. Failed to connect to server. Reason: HTTP retry after response received with no Retry-After header, error: HTTP Response code: 503, Error message: Unknown.")
    public void testDeltaPartitionedDifferentOrderInsertCompatibility() {
        String tableName = "test_dl_delta_partitioned_different_order_insert_" + TestingNames.randomNameSuffix();
        QueryExecutors.onDelta().executeQuery("CREATE TABLE default." + tableName + "         (a_number INT, first STRING, second STRING)         USING delta          PARTITIONED BY (second, first)         LOCATION 's3://" + this.bucketName + "/databricks-compatibility-test-" + tableName + "'", new QueryExecutor.QueryParam[0]);
        try {
            QueryExecutors.onDelta().executeQuery("INSERT INTO default." + tableName + " VALUES (1, 'first', 'second')", new QueryExecutor.QueryParam[0]);
            ImmutableList expectedRows = ImmutableList.of((Object)QueryAssert.Row.row((Object[])new Object[]{1, "first", "second"}));
            ((QueryAssert)Assertions.assertThat((AssertProvider)QueryExecutors.onDelta().executeQuery("SELECT * FROM default." + tableName, new QueryExecutor.QueryParam[0]))).containsOnly((List)expectedRows);
            ((QueryAssert)Assertions.assertThat((AssertProvider)QueryExecutors.onTrino().executeQuery("SELECT * FROM delta.default." + tableName, new QueryExecutor.QueryParam[0]))).containsOnly((List)expectedRows);
        }
        finally {
            DeltaLakeTestUtils.dropDeltaTableWithRetry("default." + tableName);
        }
    }

    @Test(groups={"delta-lake-databricks", "profile_specific_tests"})
    @Flaky(issue="https://github.com/trinodb/trino/issues/14391", match="\\Q[Databricks][DatabricksJDBCDriver](500593) Communication link failure. Failed to connect to server. Reason: HTTP retry after response received with no Retry-After header, error: HTTP Response code: 503, Error message: Unknown.")
    public void testInsertNonLowercaseColumnsCompatibility() {
        String tableName = "test_dl_insert_nonlowercase_columns_" + TestingNames.randomNameSuffix();
        QueryExecutors.onDelta().executeQuery("CREATE TABLE default." + tableName + "         (lower_case_string STRING, UPPER_CASE_STRING STRING, MiXeD_CaSe_StRiNg STRING)         USING delta          LOCATION 's3://" + this.bucketName + "/databricks-compatibility-test-" + tableName + "'", new QueryExecutor.QueryParam[0]);
        try {
            QueryExecutors.onDelta().executeQuery("INSERT INTO default." + tableName + " VALUES ('databricks', 'DATABRICKS', 'DaTaBrIcKs'), ('databricks', 'DATABRICKS', NULL)", new QueryExecutor.QueryParam[0]);
            QueryExecutors.onDelta().executeQuery("INSERT INTO default." + tableName + " VALUES (NULL, NULL, 'DaTaBrIcKs'), (NULL, NULL, NULL)", new QueryExecutor.QueryParam[0]);
            QueryExecutors.onTrino().executeQuery("INSERT INTO delta.default." + tableName + " VALUES ('trino', 'TRINO', 'TrInO'), ('trino', 'TRINO', NULL)", new QueryExecutor.QueryParam[0]);
            QueryExecutors.onTrino().executeQuery("INSERT INTO delta.default." + tableName + " VALUES (NULL, NULL, 'TrInO'), (NULL, NULL, NULL)", new QueryExecutor.QueryParam[0]);
            ImmutableList expectedRows = ImmutableList.of((Object)QueryAssert.Row.row((Object[])new Object[]{"databricks", "DATABRICKS", "DaTaBrIcKs"}), (Object)QueryAssert.Row.row((Object[])new Object[]{"databricks", "DATABRICKS", null}), (Object)QueryAssert.Row.row((Object[])new Object[]{null, null, "DaTaBrIcKs"}), (Object)QueryAssert.Row.row((Object[])new Object[]{null, null, null}), (Object)QueryAssert.Row.row((Object[])new Object[]{"trino", "TRINO", "TrInO"}), (Object)QueryAssert.Row.row((Object[])new Object[]{"trino", "TRINO", null}), (Object)QueryAssert.Row.row((Object[])new Object[]{null, null, "TrInO"}), (Object)QueryAssert.Row.row((Object[])new Object[]{null, null, null}));
            ((QueryAssert)Assertions.assertThat((AssertProvider)QueryExecutors.onDelta().executeQuery("SELECT * FROM default." + tableName, new QueryExecutor.QueryParam[0]))).containsOnly((List)expectedRows);
            ((QueryAssert)Assertions.assertThat((AssertProvider)QueryExecutors.onTrino().executeQuery("SELECT * FROM delta.default." + tableName, new QueryExecutor.QueryParam[0]))).containsOnly((List)expectedRows);
        }
        finally {
            DeltaLakeTestUtils.dropDeltaTableWithRetry("default." + tableName);
        }
    }

    @Test(groups={"delta-lake-databricks", "profile_specific_tests"})
    @Flaky(issue="https://github.com/trinodb/trino/issues/14391", match="\\Q[Databricks][DatabricksJDBCDriver](500593) Communication link failure. Failed to connect to server. Reason: HTTP retry after response received with no Retry-After header, error: HTTP Response code: 503, Error message: Unknown.")
    public void testInsertNestedNonLowercaseColumnsCompatibility() {
        String tableName = "test_dl_insert_nested_nonlowercase_columns_" + TestingNames.randomNameSuffix();
        QueryExecutors.onDelta().executeQuery("CREATE TABLE default." + tableName + "         (an_int INT, nested STRUCT<lower_case_string: STRING, UPPER_CASE_STRING: STRING, MiXeD_CaSe_StRiNg: STRING>)         USING delta          LOCATION 's3://" + this.bucketName + "/databricks-compatibility-test-" + tableName + "'", new QueryExecutor.QueryParam[0]);
        try {
            QueryExecutors.onDelta().executeQuery("INSERT INTO default." + tableName + " VALUES (1, struct('databricks', 'DATABRICKS', 'DaTaBrIcKs')), (2, struct('databricks', 'DATABRICKS', NULL))", new QueryExecutor.QueryParam[0]);
            QueryExecutors.onDelta().executeQuery("INSERT INTO default." + tableName + " VALUES (3, struct(NULL, NULL, 'DaTaBrIcKs')),(4, struct(NULL, NULL, NULL))", new QueryExecutor.QueryParam[0]);
            QueryExecutors.onTrino().executeQuery("INSERT INTO delta.default." + tableName + " VALUES (10, ROW('trino', 'TRINO', 'TrInO')), (20, ROW('trino', 'TRINO', NULL))", new QueryExecutor.QueryParam[0]);
            QueryExecutors.onTrino().executeQuery("INSERT INTO delta.default." + tableName + " VALUES (30, ROW(NULL, NULL, 'TrInO')), (40, ROW(NULL, NULL, NULL))", new QueryExecutor.QueryParam[0]);
            ImmutableList expectedRows = ImmutableList.of((Object)QueryAssert.Row.row((Object[])new Object[]{1, "databricks", "DATABRICKS", "DaTaBrIcKs"}), (Object)QueryAssert.Row.row((Object[])new Object[]{2, "databricks", "DATABRICKS", null}), (Object)QueryAssert.Row.row((Object[])new Object[]{3, null, null, "DaTaBrIcKs"}), (Object)QueryAssert.Row.row((Object[])new Object[]{4, null, null, null}), (Object)QueryAssert.Row.row((Object[])new Object[]{10, "trino", "TRINO", "TrInO"}), (Object)QueryAssert.Row.row((Object[])new Object[]{20, "trino", "TRINO", null}), (Object)QueryAssert.Row.row((Object[])new Object[]{30, null, null, "TrInO"}), (Object)QueryAssert.Row.row((Object[])new Object[]{40, null, null, null}));
            ((QueryAssert)Assertions.assertThat((AssertProvider)QueryExecutors.onDelta().executeQuery("SELECT an_int, nested.lower_case_string, nested.UPPER_CASE_STRING, nested.MiXeD_CaSe_StRiNg FROM default." + tableName, new QueryExecutor.QueryParam[0]))).containsOnly((List)expectedRows);
            ((QueryAssert)Assertions.assertThat((AssertProvider)QueryExecutors.onTrino().executeQuery("SELECT an_int, nested.lower_case_string, nested.UPPER_CASE_STRING, nested.MiXeD_CaSe_StRiNg FROM delta.default." + tableName, new QueryExecutor.QueryParam[0]))).containsOnly((List)expectedRows);
        }
        finally {
            DeltaLakeTestUtils.dropDeltaTableWithRetry("default." + tableName);
        }
    }

    @Test(groups={"delta-lake-databricks", "profile_specific_tests"})
    @Flaky(issue="https://github.com/trinodb/trino/issues/14391", match="\\Q[Databricks][DatabricksJDBCDriver](500593) Communication link failure. Failed to connect to server. Reason: HTTP retry after response received with no Retry-After header, error: HTTP Response code: 503, Error message: Unknown.")
    public void testPartitionedInsertNonLowercaseColumnsCompatibility() {
        String tableName = "test_dl_partitioned_insert_nonlowercase_columns" + TestingNames.randomNameSuffix();
        QueryExecutors.onDelta().executeQuery("CREATE TABLE default." + tableName + "         (lower_case_string STRING, UPPER_CASE_STRING STRING, MiXeD_CaSe_StRiNg STRING)         USING delta          PARTITIONED BY (MiXeD_CaSe_StRiNg)         LOCATION 's3://" + this.bucketName + "/databricks-compatibility-test-" + tableName + "'", new QueryExecutor.QueryParam[0]);
        try {
            QueryExecutors.onDelta().executeQuery("INSERT INTO default." + tableName + " VALUES ('databricks', 'DATABRICKS', 'DaTaBrIcKs'), ('databricks', 'DATABRICKS', NULL)", new QueryExecutor.QueryParam[0]);
            QueryExecutors.onDelta().executeQuery("INSERT INTO default." + tableName + " VALUES (NULL, NULL, 'DaTaBrIcKs'), (NULL, NULL, NULL)", new QueryExecutor.QueryParam[0]);
            QueryExecutors.onTrino().executeQuery("INSERT INTO delta.default." + tableName + " VALUES ('trino', 'TRINO', 'TrInO'), ('trino', 'TRINO', NULL)", new QueryExecutor.QueryParam[0]);
            QueryExecutors.onTrino().executeQuery("INSERT INTO delta.default." + tableName + " VALUES (NULL, NULL, 'TrInO'), (NULL, NULL, NULL)", new QueryExecutor.QueryParam[0]);
            ImmutableList expectedRows = ImmutableList.of((Object)QueryAssert.Row.row((Object[])new Object[]{"databricks", "DATABRICKS", "DaTaBrIcKs"}), (Object)QueryAssert.Row.row((Object[])new Object[]{"databricks", "DATABRICKS", null}), (Object)QueryAssert.Row.row((Object[])new Object[]{null, null, "DaTaBrIcKs"}), (Object)QueryAssert.Row.row((Object[])new Object[]{null, null, null}), (Object)QueryAssert.Row.row((Object[])new Object[]{"trino", "TRINO", "TrInO"}), (Object)QueryAssert.Row.row((Object[])new Object[]{"trino", "TRINO", null}), (Object)QueryAssert.Row.row((Object[])new Object[]{null, null, "TrInO"}), (Object)QueryAssert.Row.row((Object[])new Object[]{null, null, null}));
            ((QueryAssert)Assertions.assertThat((AssertProvider)QueryExecutors.onDelta().executeQuery("SELECT * FROM default." + tableName, new QueryExecutor.QueryParam[0]))).containsOnly((List)expectedRows);
            ((QueryAssert)Assertions.assertThat((AssertProvider)QueryExecutors.onTrino().executeQuery("SELECT * FROM delta.default." + tableName, new QueryExecutor.QueryParam[0]))).containsOnly((List)expectedRows);
        }
        finally {
            DeltaLakeTestUtils.dropDeltaTableWithRetry("default." + tableName);
        }
    }

    @Test(groups={"delta-lake-databricks", "profile_specific_tests"})
    @Flaky(issue="https://github.com/trinodb/trino/issues/14391", match="\\Q[Databricks][DatabricksJDBCDriver](500593) Communication link failure. Failed to connect to server. Reason: HTTP retry after response received with no Retry-After header, error: HTTP Response code: 503, Error message: Unknown.")
    public void testDeleteCompatibility() {
        String tableName = "test_delete_compatibility_" + TestingNames.randomNameSuffix();
        QueryExecutors.onDelta().executeQuery("CREATE TABLE default." + tableName + " (a int, b int) USING DELTA LOCATION 's3://" + this.bucketName + "/databricks-compatibility-test-" + tableName + "'", new QueryExecutor.QueryParam[0]);
        try {
            QueryExecutors.onDelta().executeQuery("INSERT INTO default." + tableName + " VALUES (1, 2), (2, 3), (3, 4), (4, 5), (5, 6)", new QueryExecutor.QueryParam[0]);
            QueryExecutors.onTrino().executeQuery("DELETE FROM delta.default." + tableName + " WHERE a % 2 = 0", new QueryExecutor.QueryParam[0]);
            ImmutableList expectedRows = ImmutableList.of((Object)QueryAssert.Row.row((Object[])new Object[]{1, 2}), (Object)QueryAssert.Row.row((Object[])new Object[]{3, 4}), (Object)QueryAssert.Row.row((Object[])new Object[]{5, 6}));
            ((QueryAssert)Assertions.assertThat((AssertProvider)QueryExecutors.onDelta().executeQuery("SELECT * FROM default." + tableName, new QueryExecutor.QueryParam[0]))).containsOnly((List)expectedRows);
            ((QueryAssert)Assertions.assertThat((AssertProvider)QueryExecutors.onTrino().executeQuery("SELECT * FROM delta.default." + tableName, new QueryExecutor.QueryParam[0]))).containsOnly((List)expectedRows);
        }
        finally {
            DeltaLakeTestUtils.dropDeltaTableWithRetry("default." + tableName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(groups={"delta-lake-databricks", "profile_specific_tests"}, dataProvider="compressionCodecs")
    @Flaky(issue="https://github.com/trinodb/trino/issues/14391", match="\\Q[Databricks][DatabricksJDBCDriver](500593) Communication link failure. Failed to connect to server. Reason: HTTP retry after response received with no Retry-After header, error: HTTP Response code: 503, Error message: Unknown.")
    public void testCompression(String compressionCodec) {
        String tableName = "test_compression_" + compressionCodec + "_" + TestingNames.randomNameSuffix();
        String trinoTableName = "delta.default." + tableName;
        String location = "s3://" + this.bucketName + "/databricks-compatibility-test-" + tableName;
        QueryExecutors.onTrino().executeQuery("CREATE TABLE " + trinoTableName + " WITH (location = '" + location + "') AS TABLE tpch.tiny.nation WITH NO DATA", new QueryExecutor.QueryParam[0]);
        try {
            if ("LZ4".equals(compressionCodec)) {
                QueryAssert.assertQueryFailure(() -> QueryExecutors.onTrino().executeQuery("SET SESSION delta.compression_codec = '" + compressionCodec + "'", new QueryExecutor.QueryParam[0])).hasMessageMatching("Query failed .* Unsupported codec: LZ4");
            } else {
                QueryExecutors.onTrino().executeQuery("SET SESSION delta.compression_codec = '" + compressionCodec + "'", new QueryExecutor.QueryParam[0]);
                QueryExecutors.onTrino().executeQuery("INSERT INTO " + trinoTableName + " TABLE tpch.tiny.nation", new QueryExecutor.QueryParam[0]);
                List expected = (List)QueryExecutors.onTrino().executeQuery("TABLE tpch.tiny.nation", new QueryExecutor.QueryParam[0]).rows().stream().map(row -> QueryAssert.Row.row((Object[])row.toArray())).collect(ImmutableList.toImmutableList());
                ((QueryAssert)Assertions.assertThat((AssertProvider)QueryExecutors.onTrino().executeQuery("SELECT * FROM " + trinoTableName, new QueryExecutor.QueryParam[0]))).containsOnly(expected);
                if ("ZSTD".equals(compressionCodec) && this.databricksRuntimeVersion.orElseThrow().isOlderThan(DatabricksVersion.DATABRICKS_104_RUNTIME_VERSION)) {
                    QueryAssert.assertQueryFailure(() -> QueryExecutors.onDelta().executeQuery("SELECT * FROM default." + tableName, new QueryExecutor.QueryParam[0])).hasMessageContaining("java.lang.ClassNotFoundException: org.apache.hadoop.io.compress.ZStandardCodec");
                } else {
                    ((QueryAssert)Assertions.assertThat((AssertProvider)QueryExecutors.onDelta().executeQuery("SELECT * FROM default." + tableName, new QueryExecutor.QueryParam[0]))).containsOnly(expected);
                }
            }
        }
        finally {
            QueryExecutors.onTrino().executeQuery("DROP TABLE " + trinoTableName, new QueryExecutor.QueryParam[0]);
        }
    }

    @Test(groups={"delta-lake-databricks", "profile_specific_tests"})
    @Flaky(issue="https://github.com/trinodb/trino/issues/14391", match="\\Q[Databricks][DatabricksJDBCDriver](500593) Communication link failure. Failed to connect to server. Reason: HTTP retry after response received with no Retry-After header, error: HTTP Response code: 503, Error message: Unknown.")
    public void verifyCompressionCodecsDataProvider() {
        ((QueryAssert)Assertions.assertThat((AssertProvider)QueryExecutors.onTrino().executeQuery("SHOW SESSION LIKE 'delta.compression_codec'", new QueryExecutor.QueryParam[0]))).containsOnly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{"delta.compression_codec", "SNAPPY", "SNAPPY", "varchar", "Compression codec to use when writing new data files. Possible values: " + Stream.of(this.compressionCodecs()).map(arguments -> (String)Iterables.getOnlyElement(Arrays.asList(arguments))).collect(ImmutableList.toImmutableList())})});
    }

    @DataProvider
    public Object[][] compressionCodecs() {
        return new Object[][]{{"NONE"}, {"SNAPPY"}, {"LZ4"}, {"ZSTD"}, {"GZIP"}};
    }

    @Test(groups={"delta-lake-databricks", "delta-lake-exclude-73", "profile_specific_tests"})
    @Flaky(issue="https://github.com/trinodb/trino/issues/14391", match="\\Q[Databricks][DatabricksJDBCDriver](500593) Communication link failure. Failed to connect to server. Reason: HTTP retry after response received with no Retry-After header, error: HTTP Response code: 503, Error message: Unknown.")
    public void testWritesToTableWithGeneratedColumnFails() {
        String tableName = "test_writes_into_table_with_generated_column_" + TestingNames.randomNameSuffix();
        try {
            QueryExecutors.onDelta().executeQuery("CREATE TABLE default." + tableName + " (a INT, b BOOLEAN GENERATED ALWAYS AS (CAST(true AS BOOLEAN))) USING DELTA LOCATION 's3://" + this.bucketName + "/databricks-compatibility-test-" + tableName + "'", new QueryExecutor.QueryParam[0]);
            QueryExecutors.onDelta().executeQuery("INSERT INTO default." + tableName + " (a) VALUES (1), (2), (3)", new QueryExecutor.QueryParam[0]);
            ((QueryAssert)Assertions.assertThat((AssertProvider)QueryExecutors.onTrino().executeQuery("SELECT a, b FROM " + tableName, new QueryExecutor.QueryParam[0]))).containsOnly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{1, true}), QueryAssert.Row.row((Object[])new Object[]{2, true}), QueryAssert.Row.row((Object[])new Object[]{3, true})});
            QueryAssert.assertQueryFailure(() -> QueryExecutors.onTrino().executeQuery("INSERT INTO delta.default." + tableName + " VALUES (1, false)", new QueryExecutor.QueryParam[0])).hasMessageContaining("Writing to tables with generated columns is not supported");
            QueryAssert.assertQueryFailure(() -> QueryExecutors.onTrino().executeQuery("UPDATE delta.default." + tableName + " SET a = 3 WHERE b = true", new QueryExecutor.QueryParam[0])).hasMessageContaining("Writing to tables with generated columns is not supported");
            QueryAssert.assertQueryFailure(() -> QueryExecutors.onTrino().executeQuery("DELETE FROM delta.default." + tableName + " WHERE a = 3", new QueryExecutor.QueryParam[0])).hasMessageContaining("Writing to tables with generated columns is not supported");
            QueryAssert.assertQueryFailure(() -> QueryExecutors.onTrino().executeQuery("MERGE INTO delta.default." + tableName + " t USING delta.default." + tableName + " s ON (t.a = s.a) WHEN MATCHED THEN UPDATE SET b = false", new QueryExecutor.QueryParam[0])).hasMessageContaining("Writing to tables with generated columns is not supported");
        }
        finally {
            DeltaLakeTestUtils.dropDeltaTableWithRetry("default." + tableName);
        }
    }
}

