/*
 * Decompiled with CFR 0.152.
 */
package io.trino.tests.product.hive;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import io.trino.jdbc.Row;
import io.trino.jdbc.TrinoArray;
import io.trino.tempto.assertions.QueryAssert;
import io.trino.tempto.context.ThreadLocalTestContextHolder;
import io.trino.tempto.fulfillment.table.MutableTablesState;
import io.trino.tempto.fulfillment.table.TableDefinition;
import io.trino.tempto.fulfillment.table.TableHandle;
import io.trino.tempto.fulfillment.table.TableInstance;
import io.trino.tempto.fulfillment.table.hive.HiveTableDefinition;
import io.trino.tempto.query.QueryExecutor;
import io.trino.tempto.query.QueryResult;
import io.trino.tests.product.hive.Engine;
import io.trino.tests.product.hive.HiveProductTest;
import io.trino.tests.product.utils.QueryExecutors;
import java.math.BigDecimal;
import java.sql.JDBCType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.assertj.core.api.AssertProvider;
import org.assertj.core.api.Assertions;
import org.testng.Assert;

public abstract class BaseTestHiveCoercion
extends HiveProductTest {
    protected void doTestHiveCoercion(HiveTableDefinition tableDefinition) {
        String tableName = BaseTestHiveCoercion.mutableTableInstanceOf((TableDefinition)tableDefinition).getNameInDatabase();
        String floatToDoubleType = tableName.toLowerCase(Locale.ENGLISH).contains("parquet") ? "DOUBLE" : "REAL";
        String floatToDecimalVal = tableName.toLowerCase(Locale.ENGLISH).contains("parquet") ? "12345.12345" : "12345.12300";
        String decimalToFloatVal = tableName.toLowerCase(Locale.ENGLISH).contains("parquet") ? "12345.12345" : "12345.124";
        this.insertTableRows(tableName, floatToDoubleType);
        BaseTestHiveCoercion.alterTableColumnTypes(tableName);
        this.assertProperAlteredTableSchema(tableName);
        ImmutableList allColumns = ImmutableList.of((Object)"row_to_row", (Object)"list_to_list", (Object)"map_to_map", (Object)"tinyint_to_smallint", (Object)"tinyint_to_int", (Object)"tinyint_to_bigint", (Object)"smallint_to_int", (Object)"smallint_to_bigint", (Object)"int_to_bigint", (Object)"bigint_to_varchar", (Object)"float_to_double", (Object)"double_to_float", (Object[])new String[]{"shortdecimal_to_shortdecimal", "shortdecimal_to_longdecimal", "longdecimal_to_shortdecimal", "longdecimal_to_longdecimal", "float_to_decimal", "double_to_decimal", "decimal_to_float", "decimal_to_double", "short_decimal_to_varchar", "long_decimal_to_varchar", "short_decimal_to_bounded_varchar", "long_decimal_to_bounded_varchar", "varchar_to_bigger_varchar", "varchar_to_smaller_varchar", "char_to_bigger_char", "char_to_smaller_char", "timestamp_to_string", "timestamp_to_bounded_varchar", "timestamp_to_smaller_varchar", "id"});
        Function<Engine, Map> expected = engine -> this.expectedValuesForEngineProvider((Engine)((Object)engine), tableName, decimalToFloatVal, floatToDecimalVal);
        List<String> prestoReadColumns = this.removeUnsupportedColumnsForTrino((List<String>)allColumns, tableName);
        Map expectedPrestoResults = expected.apply(Engine.TRINO);
        if (this.expectedExceptionsWithTrinoContext().isEmpty()) {
            Assert.assertEquals((Set)ImmutableSet.copyOf(prestoReadColumns), expectedPrestoResults.keySet());
        }
        String prestoSelectQuery = String.format("SELECT %s FROM %s", String.join((CharSequence)", ", prestoReadColumns), tableName);
        this.assertQueryResults(Engine.TRINO, prestoSelectQuery, expectedPrestoResults, prestoReadColumns, 2, tableName);
        List<String> hiveReadColumns = this.removeUnsupportedColumnsForHive((List<String>)allColumns, tableName);
        Map expectedHiveResults = expected.apply(Engine.HIVE);
        String hiveSelectQuery = String.format("SELECT %s FROM %s", String.join((CharSequence)", ", hiveReadColumns), tableName);
        this.assertQueryResults(Engine.HIVE, hiveSelectQuery, expectedHiveResults, hiveReadColumns, 2, tableName);
        this.assertNestedSubFields(tableName);
    }

    protected void insertTableRows(String tableName, String floatToDoubleType) {
        QueryExecutors.onTrino().executeQuery(String.format("INSERT INTO %1$s VALUES (  CAST(ROW ('as is', -1, 100, 2323, 12345, 2) AS ROW(keep VARCHAR, ti2si TINYINT, si2int SMALLINT, int2bi INTEGER, bi2vc BIGINT, lower2uppercase BIGINT)),   ARRAY [CAST(ROW (2, -101, 12345, 'removed') AS ROW (ti2int TINYINT, si2bi SMALLINT, bi2vc BIGINT, remove VARCHAR))],   MAP (ARRAY [TINYINT '2'], ARRAY [CAST(ROW (-3, 2323, REAL '0.5') AS ROW (ti2bi TINYINT, int2bi INTEGER, float2double %2$s))]),   TINYINT '-1',   TINYINT '2',   TINYINT '-3',   SMALLINT '100',   SMALLINT '-101',   INTEGER '2323',   12345,   REAL '0.5',   DOUBLE '0.5',   DECIMAL '12345678.12',   DECIMAL '12345678.12',   DECIMAL '12345678.123456123456',   DECIMAL '12345678.123456123456',   %2$s '12345.12345',   DOUBLE '12345.12345',   DECIMAL '12345.12345',   DECIMAL '12345.12345',   DECIMAL '12345.12345',   DECIMAL '12345678.123456123456',   DECIMAL '12345.12345',   DECIMAL '12345678.123456123456',   'abc',   'abc',   'abc',   'abc',   TIMESTAMP '2121-07-15 15:30:12.123',   TIMESTAMP '2121-07-15 15:30:12.123',   TIMESTAMP '2121-07-15 15:30:12.123',   1), (  CAST(ROW (NULL, 1, -100, -2323, -12345, 2) AS ROW(keep VARCHAR, ti2si TINYINT, si2int SMALLINT, int2bi INTEGER, bi2vc BIGINT, lower2uppercase BIGINT)),   ARRAY [CAST(ROW (-2, 101, -12345, NULL) AS ROW (ti2int TINYINT, si2bi SMALLINT, bi2vc BIGINT, remove VARCHAR))],   MAP (ARRAY [TINYINT '-2'], ARRAY [CAST(ROW (null, -2323, REAL '-1.5') AS ROW (ti2bi TINYINT, int2bi INTEGER, float2double %2$s))]),   TINYINT '1',   TINYINT '-2',   NULL,   SMALLINT '-100',   SMALLINT '101',   INTEGER '-2323',   -12345,   REAL '-1.5',   DOUBLE '-1.5',   DECIMAL '-12345678.12',   DECIMAL '-12345678.12',   DECIMAL '-12345678.123456123456',   DECIMAL '-12345678.123456123456',   %2$s '-12345.12345',   DOUBLE '-12345.12345',   DECIMAL '-12345.12345',   DECIMAL '-12345.12345',   DECIMAL '-12345.12345',   DECIMAL '-12345678.123456123456',   DECIMAL '-12345.12345',   DECIMAL '-12345678.123456123456',   '\ud83d\udcb0\ud83d\udcb0\ud83d\udcb0',   '\ud83d\udcb0\ud83d\udcb0\ud83d\udcb0',   '\ud83d\udcb0\ud83d\udcb0\ud83d\udcb0',   '\ud83d\udcb0\ud83d\udcb0\ud83d\udcb0',   TIMESTAMP '1970-01-01 00:00:00.123',   TIMESTAMP '1970-01-01 00:00:00.123',   TIMESTAMP '1970-01-01 00:00:00.123',   1)", tableName, floatToDoubleType), new QueryExecutor.QueryParam[0]);
    }

    protected Map<String, List<Object>> expectedValuesForEngineProvider(Engine engine, String tableName, String decimalToFloatVal, String floatToDecimalVal) {
        Predicate<String> isFormat = formatName -> tableName.toLowerCase(Locale.ENGLISH).contains((CharSequence)formatName);
        String hiveValueForCaseChangeField = isFormat.test("rctext") || isFormat.test("textfile") ? "\"lower2uppercase\":2" : (this.getHiveVersionMajor() == 3 && isFormat.test("orc") ? "\"LOWER2UPPERCASE\":null" : "\"LOWER2UPPERCASE\":2");
        return ImmutableMap.builder().put((Object)"row_to_row", (Object)ImmutableList.of((Object)(engine == Engine.TRINO ? this.rowBuilder().addField("keep", (Object)"as is").addField("ti2si", (Object)-1).addField("si2int", (Object)100).addField("int2bi", (Object)2323L).addField("bi2vc", (Object)"12345").addField("lower2uppercase", (Object)2L).build() : String.format("{\"keep\":\"as is\",\"ti2si\":-1,\"si2int\":100,\"int2bi\":2323,\"bi2vc\":\"12345\",%s}", hiveValueForCaseChangeField)), (Object)(engine == Engine.TRINO ? this.rowBuilder().addField("keep", null).addField("ti2si", (Object)1).addField("si2int", (Object)-100).addField("int2bi", (Object)-2323L).addField("bi2vc", (Object)"-12345").addField("lower2uppercase", (Object)2L).build() : String.format("{\"keep\":null,\"ti2si\":1,\"si2int\":-100,\"int2bi\":-2323,\"bi2vc\":\"-12345\",%s}", hiveValueForCaseChangeField)))).put((Object)"list_to_list", (Object)ImmutableList.of((Object)(engine == Engine.TRINO ? ImmutableList.of((Object)this.rowBuilder().addField("ti2int", (Object)2).addField("si2bi", (Object)-101L).addField("bi2vc", (Object)"12345").build()) : "[{\"ti2int\":2,\"si2bi\":-101,\"bi2vc\":\"12345\"}]"), (Object)(engine == Engine.TRINO ? ImmutableList.of((Object)this.rowBuilder().addField("ti2int", (Object)-2).addField("si2bi", (Object)101L).addField("bi2vc", (Object)"-12345").build()) : "[{\"ti2int\":-2,\"si2bi\":101,\"bi2vc\":\"-12345\"}]"))).put((Object)"map_to_map", (Object)ImmutableList.of((Object)(engine == Engine.TRINO ? ImmutableMap.of((Object)2, (Object)this.rowBuilder().addField("ti2bi", (Object)-3L).addField("int2bi", (Object)2323L).addField("float2double", (Object)0.5).addField("add", null).build()) : "{2:{\"ti2bi\":-3,\"int2bi\":2323,\"float2double\":0.5,\"add\":null}}"), (Object)(engine == Engine.TRINO ? ImmutableMap.of((Object)-2, (Object)this.rowBuilder().addField("ti2bi", null).addField("int2bi", (Object)-2323L).addField("float2double", (Object)-1.5).addField("add", null).build()) : "{-2:{\"ti2bi\":null,\"int2bi\":-2323,\"float2double\":-1.5,\"add\":null}}"))).put((Object)"tinyint_to_smallint", (Object)ImmutableList.of((Object)-1, (Object)1)).put((Object)"tinyint_to_int", (Object)ImmutableList.of((Object)2, (Object)-2)).put((Object)"tinyint_to_bigint", Arrays.asList(-3L, null)).put((Object)"smallint_to_int", (Object)ImmutableList.of((Object)100, (Object)-100)).put((Object)"smallint_to_bigint", (Object)ImmutableList.of((Object)-101L, (Object)101L)).put((Object)"int_to_bigint", (Object)ImmutableList.of((Object)2323L, (Object)-2323L)).put((Object)"bigint_to_varchar", (Object)ImmutableList.of((Object)"12345", (Object)"-12345")).put((Object)"float_to_double", (Object)ImmutableList.of((Object)0.5, (Object)-1.5)).put((Object)"double_to_float", (Object)ImmutableList.of((Object)0.5, (Object)-1.5)).put((Object)"shortdecimal_to_shortdecimal", (Object)ImmutableList.of((Object)new BigDecimal("12345678.1200"), (Object)new BigDecimal("-12345678.1200"))).put((Object)"shortdecimal_to_longdecimal", (Object)ImmutableList.of((Object)new BigDecimal("12345678.1200"), (Object)new BigDecimal("-12345678.1200"))).put((Object)"longdecimal_to_shortdecimal", (Object)ImmutableList.of((Object)new BigDecimal("12345678.12"), (Object)new BigDecimal("-12345678.12"))).put((Object)"longdecimal_to_longdecimal", (Object)ImmutableList.of((Object)new BigDecimal("12345678.12345612345600"), (Object)new BigDecimal("-12345678.12345612345600"))).put((Object)"float_to_decimal", (Object)ImmutableList.of((Object)new BigDecimal(floatToDecimalVal), (Object)new BigDecimal("-" + floatToDecimalVal))).put((Object)"double_to_decimal", (Object)ImmutableList.of((Object)new BigDecimal("12345.12345"), (Object)new BigDecimal("-12345.12345"))).put((Object)"decimal_to_float", (Object)ImmutableList.of((Object)Float.valueOf(Float.parseFloat(decimalToFloatVal)), (Object)Float.valueOf(-Float.parseFloat(decimalToFloatVal)))).put((Object)"decimal_to_double", (Object)ImmutableList.of((Object)12345.12345, (Object)-12345.12345)).put((Object)"short_decimal_to_varchar", (Object)ImmutableList.of((Object)"12345.12345", (Object)"-12345.12345")).put((Object)"long_decimal_to_varchar", (Object)ImmutableList.of((Object)"12345678.123456123456", (Object)"-12345678.123456123456")).put((Object)"short_decimal_to_bounded_varchar", (Object)ImmutableList.of((Object)"12345.12345", (Object)"12345.12345")).put((Object)"long_decimal_to_bounded_varchar", (Object)ImmutableList.of((Object)"12345678.123456123456", (Object)"-12345678.123456123456")).put((Object)"varchar_to_bigger_varchar", (Object)ImmutableList.of((Object)"abc", (Object)"\ud83d\udcb0\ud83d\udcb0\ud83d\udcb0")).put((Object)"varchar_to_smaller_varchar", (Object)ImmutableList.of((Object)"ab", (Object)"\ud83d\udcb0\ud83d\udcb0")).put((Object)"char_to_bigger_char", (Object)ImmutableList.of((Object)"abc ", (Object)"\ud83d\udcb0\ud83d\udcb0\ud83d\udcb0 ")).put((Object)"char_to_smaller_char", (Object)ImmutableList.of((Object)"ab", (Object)"\ud83d\udcb0\ud83d\udcb0")).put((Object)"timestamp_to_string", (Object)ImmutableList.of((Object)"2121-07-15 15:30:12.123", (Object)"1970-01-01 00:00:00.123")).put((Object)"timestamp_to_bounded_varchar", (Object)ImmutableList.of((Object)"2121-07-15 15:30:12.123", (Object)"1970-01-01 00:00:00.123")).put((Object)"timestamp_to_smaller_varchar", (Object)ImmutableList.of((Object)"2121", (Object)"1970")).put((Object)"id", (Object)ImmutableList.of((Object)1, (Object)1)).buildOrThrow();
    }

    protected List<String> removeUnsupportedColumnsForHive(List<String> columns, String tableName) {
        Map<ColumnContext, String> expectedExceptions = this.expectedExceptionsWithHiveContext();
        String hiveVersion = this.getHiveVersionMajor() + "." + this.getHiveVersionMinor();
        Set unsupportedColumns = (Set)expectedExceptions.keySet().stream().filter(context -> context.hiveVersion().orElseThrow().equals(hiveVersion) && tableName.contains(context.format())).map(ColumnContext::column).collect(ImmutableSet.toImmutableSet());
        return (List)columns.stream().filter(column -> !unsupportedColumns.contains(column)).collect(ImmutableList.toImmutableList());
    }

    protected List<String> removeUnsupportedColumnsForTrino(List<String> columns, String tableName) {
        Map<ColumnContext, String> expectedExceptions = this.expectedExceptionsWithTrinoContext();
        Set unsupportedColumns = (Set)expectedExceptions.keySet().stream().filter(context -> tableName.contains(context.format())).map(ColumnContext::column).collect(ImmutableSet.toImmutableSet());
        return (List)columns.stream().filter(column -> !unsupportedColumns.contains(column)).collect(ImmutableList.toImmutableList());
    }

    private void assertNestedSubFields(String tableName) {
        Predicate<String> isFormat = formatName -> tableName.toLowerCase(Locale.ENGLISH).contains((CharSequence)formatName);
        ImmutableMap expectedNestedFieldTrino = ImmutableMap.of((Object)"nested_field", (Object)ImmutableList.of((Object)2L, (Object)2L));
        ImmutableMap expectedNestedFieldHive = this.getHiveVersionMajor() == 3 && isFormat.test("orc") ? ImmutableMap.of((Object)"nested_field", Arrays.asList(null, null)) : expectedNestedFieldTrino;
        String subfieldQueryLowerCase = String.format("SELECT row_to_row.lower2uppercase nested_field FROM %s", tableName);
        String subfieldQueryUpperCase = String.format("SELECT row_to_row.LOWER2UPPERCASE nested_field FROM %s", tableName);
        ImmutableList expectedColumns = ImmutableList.of((Object)"nested_field");
        this.assertQueryResults(Engine.TRINO, subfieldQueryUpperCase, (Map<String, List<Object>>)expectedNestedFieldTrino, (List<String>)expectedColumns, 2, tableName);
        this.assertQueryResults(Engine.TRINO, subfieldQueryLowerCase, (Map<String, List<Object>>)expectedNestedFieldTrino, (List<String>)expectedColumns, 2, tableName);
        if (isFormat.test("rcbinary")) {
            Assertions.assertThatThrownBy(() -> this.lambda$assertNestedSubFields$7(subfieldQueryUpperCase, (Map)expectedNestedFieldTrino, (List)expectedColumns, tableName)).hasMessageContaining("org.apache.hadoop.hive.ql.metadata.HiveException");
            Assertions.assertThatThrownBy(() -> this.lambda$assertNestedSubFields$8(subfieldQueryLowerCase, (Map)expectedNestedFieldTrino, (List)expectedColumns, tableName)).hasMessageContaining("org.apache.hadoop.hive.ql.metadata.HiveException");
        } else if (isFormat.test("parquet")) {
            this.assertQueryResults(Engine.HIVE, subfieldQueryUpperCase, (Map<String, List<Object>>)expectedNestedFieldHive, (List<String>)expectedColumns, 2, tableName);
            if (this.getHiveVersionMajor() == 1) {
                Assertions.assertThatThrownBy(() -> this.lambda$assertNestedSubFields$9(subfieldQueryLowerCase, (Map)expectedNestedFieldHive, (List)expectedColumns, tableName)).hasMessageContaining("java.sql.SQLException");
            } else {
                this.assertQueryResults(Engine.HIVE, subfieldQueryLowerCase, (Map<String, List<Object>>)expectedNestedFieldHive, (List<String>)expectedColumns, 2, tableName);
            }
        } else {
            this.assertQueryResults(Engine.HIVE, subfieldQueryUpperCase, (Map<String, List<Object>>)expectedNestedFieldHive, (List<String>)expectedColumns, 2, tableName);
            this.assertQueryResults(Engine.HIVE, subfieldQueryLowerCase, (Map<String, List<Object>>)expectedNestedFieldHive, (List<String>)expectedColumns, 2, tableName);
        }
    }

    protected Map<ColumnContext, String> expectedExceptionsWithHiveContext() {
        return ImmutableMap.builder().put((Object)BaseTestHiveCoercion.columnContext("1.1", "parquet", "row_to_row"), (Object)"org.apache.hadoop.io.LongWritable cannot be cast to org.apache.hadoop.io.IntWritable").put((Object)BaseTestHiveCoercion.columnContext("1.1", "parquet", "list_to_list"), (Object)"org.apache.hadoop.io.LongWritable cannot be cast to org.apache.hadoop.hive.serde2.io.ShortWritable").put((Object)BaseTestHiveCoercion.columnContext("1.1", "parquet", "map_to_map"), (Object)"org.apache.hadoop.io.LongWritable cannot be cast to org.apache.hadoop.hive.serde2.io.ByteWritable").put((Object)BaseTestHiveCoercion.columnContext("1.1", "parquet", "tinyint_to_bigint"), (Object)"org.apache.hadoop.io.LongWritable cannot be cast to org.apache.hadoop.hive.serde2.io.ByteWritable").put((Object)BaseTestHiveCoercion.columnContext("1.1", "parquet", "smallint_to_bigint"), (Object)"org.apache.hadoop.io.LongWritable cannot be cast to org.apache.hadoop.hive.serde2.io.ShortWritable").put((Object)BaseTestHiveCoercion.columnContext("1.1", "parquet", "int_to_bigint"), (Object)"org.apache.hadoop.io.LongWritable cannot be cast to org.apache.hadoop.io.IntWritable").put((Object)BaseTestHiveCoercion.columnContext("1.1", "rcbinary", "row_to_row"), (Object)"java.util.ArrayList cannot be cast to org.apache.hadoop.hive.serde2.lazybinary.LazyBinaryStruct").put((Object)BaseTestHiveCoercion.columnContext("1.1", "rcbinary", "list_to_list"), (Object)"java.util.ArrayList cannot be cast to org.apache.hadoop.hive.serde2.lazybinary.LazyBinaryArray").put((Object)BaseTestHiveCoercion.columnContext("1.1", "rcbinary", "map_to_map"), (Object)"java.util.HashMap cannot be cast to org.apache.hadoop.hive.serde2.lazybinary.LazyBinaryMap").put((Object)BaseTestHiveCoercion.columnContext("1.2", "orc", "map_to_map"), (Object)"Unknown encoding kind: DIRECT_V2").put((Object)BaseTestHiveCoercion.columnContext("1.2", "parquet", "list_to_list"), (Object)"java.lang.UnsupportedOperationException: Cannot inspect java.util.ArrayList").put((Object)BaseTestHiveCoercion.columnContext("1.2", "rcbinary", "row_to_row"), (Object)"java.util.ArrayList cannot be cast to org.apache.hadoop.hive.serde2.lazybinary.LazyBinaryStruct").put((Object)BaseTestHiveCoercion.columnContext("1.2", "rcbinary", "list_to_list"), (Object)"java.util.ArrayList cannot be cast to org.apache.hadoop.hive.serde2.lazybinary.LazyBinaryArray").put((Object)BaseTestHiveCoercion.columnContext("1.2", "rcbinary", "map_to_map"), (Object)"java.util.HashMap cannot be cast to org.apache.hadoop.hive.serde2.lazybinary.LazyBinaryMap").put((Object)BaseTestHiveCoercion.columnContext("2.1", "parquet", "row_to_row"), (Object)"org.apache.hadoop.io.LongWritable cannot be cast to org.apache.hadoop.io.IntWritable").put((Object)BaseTestHiveCoercion.columnContext("2.1", "parquet", "list_to_list"), (Object)"org.apache.hadoop.io.LongWritable cannot be cast to org.apache.hadoop.hive.serde2.io.ShortWritable").put((Object)BaseTestHiveCoercion.columnContext("2.1", "parquet", "map_to_map"), (Object)"org.apache.hadoop.io.LongWritable cannot be cast to org.apache.hadoop.hive.serde2.io.ByteWritable").put((Object)BaseTestHiveCoercion.columnContext("2.1", "parquet", "tinyint_to_bigint"), (Object)"org.apache.hadoop.io.LongWritable cannot be cast to org.apache.hadoop.hive.serde2.io.ByteWritable").put((Object)BaseTestHiveCoercion.columnContext("2.1", "parquet", "smallint_to_bigint"), (Object)"org.apache.hadoop.io.LongWritable cannot be cast to org.apache.hadoop.hive.serde2.io.ShortWritable").put((Object)BaseTestHiveCoercion.columnContext("2.1", "parquet", "int_to_bigint"), (Object)"org.apache.hadoop.io.LongWritable cannot be cast to org.apache.hadoop.io.IntWritable").put((Object)BaseTestHiveCoercion.columnContext("2.1", "rcbinary", "row_to_row"), (Object)"java.util.ArrayList cannot be cast to org.apache.hadoop.hive.serde2.lazybinary.LazyBinaryStruct").put((Object)BaseTestHiveCoercion.columnContext("2.1", "rcbinary", "list_to_list"), (Object)"java.util.ArrayList cannot be cast to org.apache.hadoop.hive.serde2.lazybinary.LazyBinaryArray").put((Object)BaseTestHiveCoercion.columnContext("2.1", "rcbinary", "map_to_map"), (Object)"java.util.HashMap cannot be cast to org.apache.hadoop.hive.serde2.lazybinary.LazyBinaryMap").put((Object)BaseTestHiveCoercion.columnContext("3.1", "parquet", "row_to_row"), (Object)"org.apache.hadoop.io.LongWritable cannot be cast to org.apache.hadoop.io.IntWritable").put((Object)BaseTestHiveCoercion.columnContext("3.1", "parquet", "list_to_list"), (Object)"org.apache.hadoop.io.LongWritable cannot be cast to org.apache.hadoop.hive.serde2.io.ShortWritable").put((Object)BaseTestHiveCoercion.columnContext("3.1", "parquet", "map_to_map"), (Object)"org.apache.hadoop.io.LongWritable cannot be cast to org.apache.hadoop.hive.serde2.io.ByteWritable").put((Object)BaseTestHiveCoercion.columnContext("3.1", "parquet", "tinyint_to_bigint"), (Object)"org.apache.hadoop.io.LongWritable cannot be cast to org.apache.hadoop.hive.serde2.io.ByteWritable").put((Object)BaseTestHiveCoercion.columnContext("3.1", "parquet", "smallint_to_bigint"), (Object)"org.apache.hadoop.io.LongWritable cannot be cast to org.apache.hadoop.hive.serde2.io.ShortWritable").put((Object)BaseTestHiveCoercion.columnContext("3.1", "parquet", "int_to_bigint"), (Object)"org.apache.hadoop.io.LongWritable cannot be cast to org.apache.hadoop.io.IntWritable").put((Object)BaseTestHiveCoercion.columnContext("3.1", "rcbinary", "row_to_row"), (Object)"java.util.ArrayList cannot be cast to org.apache.hadoop.hive.serde2.lazybinary.LazyBinaryStruct").put((Object)BaseTestHiveCoercion.columnContext("3.1", "rcbinary", "list_to_list"), (Object)"java.util.ArrayList cannot be cast to org.apache.hadoop.hive.serde2.lazybinary.LazyBinaryArray").put((Object)BaseTestHiveCoercion.columnContext("3.1", "rcbinary", "map_to_map"), (Object)"java.util.LinkedHashMap cannot be cast to org.apache.hadoop.hive.serde2.lazybinary.LazyBinaryMap").buildOrThrow();
    }

    protected Map<ColumnContext, String> expectedExceptionsWithTrinoContext() {
        return ImmutableMap.of();
    }

    private void assertQueryResults(Engine engine, String query, Map<String, List<Object>> expected, List<String> columns, int rowCount, String tableName) {
        QueryResult actual = BaseTestHiveCoercion.execute(engine, query, new QueryExecutor.QueryParam[0]);
        ImmutableList.Builder rowsBuilder = ImmutableList.builder();
        for (int row = 0; row < rowCount; ++row) {
            ArrayList<Object> currentRow = new ArrayList<Object>();
            for (int column = 0; column < columns.size(); ++column) {
                String columnName = columns.get(column);
                Preconditions.checkArgument((boolean)expected.containsKey(columnName), (Object)"columnName should be present in expected results");
                currentRow.add(expected.get(columnName).get(row));
            }
            rowsBuilder.add((Object)new QueryAssert.Row(currentRow));
        }
        ImmutableList expectedRows = rowsBuilder.build();
        this.assertColumnTypes(actual, tableName, engine, columns);
        for (int sqlIndex = 1; sqlIndex <= columns.size(); ++sqlIndex) {
            String column = columns.get(sqlIndex - 1);
            if (column.equals("row_to_row") || column.equals("map_to_map")) {
                io.airlift.testing.Assertions.assertEqualsIgnoreOrder((Iterable)actual.column(sqlIndex), BaseTestHiveCoercion.column((List<QueryAssert.Row>)expectedRows, sqlIndex), (String)String.format("%s field is not equal", column));
                continue;
            }
            if (column.equals("list_to_list")) {
                io.airlift.testing.Assertions.assertEqualsIgnoreOrder(engine == Engine.TRINO ? BaseTestHiveCoercion.extract(actual.column(sqlIndex)) : actual.column(sqlIndex), BaseTestHiveCoercion.column((List<QueryAssert.Row>)expectedRows, sqlIndex), (String)"list_to_list field is not equal");
                continue;
            }
            ((QueryAssert)Assertions.assertThat((AssertProvider)actual.project(new int[]{sqlIndex}))).containsOnly(BaseTestHiveCoercion.project((List<QueryAssert.Row>)expectedRows, sqlIndex));
        }
    }

    private void assertProperAlteredTableSchema(String tableName) {
        String floatType = tableName.toLowerCase(Locale.ENGLISH).contains("parquet") ? "double" : "real";
        ((QueryAssert)Assertions.assertThat((AssertProvider)QueryExecutors.onTrino().executeQuery("SHOW COLUMNS FROM " + tableName, new QueryExecutor.QueryParam[0]).project(new int[]{1, 2}))).containsExactlyInOrder(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{"row_to_row", "row(keep varchar, ti2si smallint, si2int integer, int2bi bigint, bi2vc varchar, lower2uppercase bigint)"}), QueryAssert.Row.row((Object[])new Object[]{"list_to_list", "array(row(ti2int integer, si2bi bigint, bi2vc varchar))"}), QueryAssert.Row.row((Object[])new Object[]{"map_to_map", "map(integer, row(ti2bi bigint, int2bi bigint, float2double double, add tinyint))"}), QueryAssert.Row.row((Object[])new Object[]{"tinyint_to_smallint", "smallint"}), QueryAssert.Row.row((Object[])new Object[]{"tinyint_to_int", "integer"}), QueryAssert.Row.row((Object[])new Object[]{"tinyint_to_bigint", "bigint"}), QueryAssert.Row.row((Object[])new Object[]{"smallint_to_int", "integer"}), QueryAssert.Row.row((Object[])new Object[]{"smallint_to_bigint", "bigint"}), QueryAssert.Row.row((Object[])new Object[]{"int_to_bigint", "bigint"}), QueryAssert.Row.row((Object[])new Object[]{"bigint_to_varchar", "varchar"}), QueryAssert.Row.row((Object[])new Object[]{"float_to_double", "double"}), QueryAssert.Row.row((Object[])new Object[]{"double_to_float", floatType}), QueryAssert.Row.row((Object[])new Object[]{"shortdecimal_to_shortdecimal", "decimal(18,4)"}), QueryAssert.Row.row((Object[])new Object[]{"shortdecimal_to_longdecimal", "decimal(20,4)"}), QueryAssert.Row.row((Object[])new Object[]{"longdecimal_to_shortdecimal", "decimal(12,2)"}), QueryAssert.Row.row((Object[])new Object[]{"longdecimal_to_longdecimal", "decimal(38,14)"}), QueryAssert.Row.row((Object[])new Object[]{"float_to_decimal", "decimal(10,5)"}), QueryAssert.Row.row((Object[])new Object[]{"double_to_decimal", "decimal(10,5)"}), QueryAssert.Row.row((Object[])new Object[]{"decimal_to_float", floatType}), QueryAssert.Row.row((Object[])new Object[]{"decimal_to_double", "double"}), QueryAssert.Row.row((Object[])new Object[]{"short_decimal_to_varchar", "varchar"}), QueryAssert.Row.row((Object[])new Object[]{"long_decimal_to_varchar", "varchar"}), QueryAssert.Row.row((Object[])new Object[]{"short_decimal_to_bounded_varchar", "varchar(30)"}), QueryAssert.Row.row((Object[])new Object[]{"long_decimal_to_bounded_varchar", "varchar(30)"}), QueryAssert.Row.row((Object[])new Object[]{"varchar_to_bigger_varchar", "varchar(4)"}), QueryAssert.Row.row((Object[])new Object[]{"varchar_to_smaller_varchar", "varchar(2)"}), QueryAssert.Row.row((Object[])new Object[]{"char_to_bigger_char", "char(4)"}), QueryAssert.Row.row((Object[])new Object[]{"char_to_smaller_char", "char(2)"}), QueryAssert.Row.row((Object[])new Object[]{"timestamp_to_string", "varchar"}), QueryAssert.Row.row((Object[])new Object[]{"timestamp_to_bounded_varchar", "varchar(30)"}), QueryAssert.Row.row((Object[])new Object[]{"timestamp_to_smaller_varchar", "varchar(4)"}), QueryAssert.Row.row((Object[])new Object[]{"id", "bigint"})});
    }

    private void assertColumnTypes(QueryResult queryResult, String tableName, Engine engine, List<String> columns) {
        JDBCType floatType = engine == Engine.TRINO ? (tableName.toLowerCase(Locale.ENGLISH).contains("parquet") ? JDBCType.DOUBLE : JDBCType.REAL) : (tableName.toLowerCase(Locale.ENGLISH).contains("parquet") ? JDBCType.DOUBLE : JDBCType.FLOAT);
        ImmutableMap expectedTypes = ImmutableMap.builder().put((Object)"row_to_row", (Object)(engine == Engine.TRINO ? JDBCType.JAVA_OBJECT : JDBCType.STRUCT)).put((Object)"list_to_list", (Object)JDBCType.ARRAY).put((Object)"map_to_map", (Object)JDBCType.JAVA_OBJECT).put((Object)"tinyint_to_smallint", (Object)JDBCType.SMALLINT).put((Object)"tinyint_to_int", (Object)JDBCType.INTEGER).put((Object)"tinyint_to_bigint", (Object)JDBCType.BIGINT).put((Object)"smallint_to_int", (Object)JDBCType.INTEGER).put((Object)"smallint_to_bigint", (Object)JDBCType.BIGINT).put((Object)"int_to_bigint", (Object)JDBCType.BIGINT).put((Object)"bigint_to_varchar", (Object)JDBCType.VARCHAR).put((Object)"float_to_double", (Object)JDBCType.DOUBLE).put((Object)"double_to_float", (Object)floatType).put((Object)"shortdecimal_to_shortdecimal", (Object)JDBCType.DECIMAL).put((Object)"shortdecimal_to_longdecimal", (Object)JDBCType.DECIMAL).put((Object)"longdecimal_to_shortdecimal", (Object)JDBCType.DECIMAL).put((Object)"longdecimal_to_longdecimal", (Object)JDBCType.DECIMAL).put((Object)"float_to_decimal", (Object)JDBCType.DECIMAL).put((Object)"double_to_decimal", (Object)JDBCType.DECIMAL).put((Object)"decimal_to_float", (Object)floatType).put((Object)"decimal_to_double", (Object)JDBCType.DOUBLE).put((Object)"short_decimal_to_varchar", (Object)JDBCType.VARCHAR).put((Object)"long_decimal_to_varchar", (Object)JDBCType.VARCHAR).put((Object)"short_decimal_to_bounded_varchar", (Object)JDBCType.VARCHAR).put((Object)"long_decimal_to_bounded_varchar", (Object)JDBCType.VARCHAR).put((Object)"varchar_to_bigger_varchar", (Object)JDBCType.VARCHAR).put((Object)"varchar_to_smaller_varchar", (Object)JDBCType.VARCHAR).put((Object)"char_to_bigger_char", (Object)JDBCType.CHAR).put((Object)"char_to_smaller_char", (Object)JDBCType.CHAR).put((Object)"id", (Object)JDBCType.BIGINT).put((Object)"nested_field", (Object)JDBCType.BIGINT).put((Object)"timestamp_to_string", (Object)JDBCType.VARCHAR).put((Object)"timestamp_to_bounded_varchar", (Object)JDBCType.VARCHAR).put((Object)"timestamp_to_smaller_varchar", (Object)JDBCType.VARCHAR).buildOrThrow();
        ((QueryAssert)Assertions.assertThat((AssertProvider)queryResult)).hasColumns((List)columns.stream().map(((Map)expectedTypes)::get).collect(ImmutableList.toImmutableList()));
    }

    private static void alterTableColumnTypes(String tableName) {
        String floatType = tableName.toLowerCase(Locale.ENGLISH).contains("parquet") ? "double" : "float";
        QueryExecutors.onHive().executeQuery(String.format("ALTER TABLE %s CHANGE COLUMN row_to_row row_to_row struct<keep:string, ti2si:smallint, si2int:int, int2bi:bigint, bi2vc:string, LOWER2UPPERCASE:bigint>", tableName), new QueryExecutor.QueryParam[0]);
        QueryExecutors.onHive().executeQuery(String.format("ALTER TABLE %s CHANGE COLUMN list_to_list list_to_list array<struct<ti2int:int, si2bi:bigint, bi2vc:string>>", tableName), new QueryExecutor.QueryParam[0]);
        QueryExecutors.onHive().executeQuery(String.format("ALTER TABLE %s CHANGE COLUMN map_to_map map_to_map map<int,struct<ti2bi:bigint, int2bi:bigint, float2double:double, add:tinyint>>", tableName), new QueryExecutor.QueryParam[0]);
        QueryExecutors.onHive().executeQuery(String.format("ALTER TABLE %s CHANGE COLUMN tinyint_to_smallint tinyint_to_smallint smallint", tableName), new QueryExecutor.QueryParam[0]);
        QueryExecutors.onHive().executeQuery(String.format("ALTER TABLE %s CHANGE COLUMN tinyint_to_int tinyint_to_int int", tableName), new QueryExecutor.QueryParam[0]);
        QueryExecutors.onHive().executeQuery(String.format("ALTER TABLE %s CHANGE COLUMN tinyint_to_bigint tinyint_to_bigint bigint", tableName), new QueryExecutor.QueryParam[0]);
        QueryExecutors.onHive().executeQuery(String.format("ALTER TABLE %s CHANGE COLUMN smallint_to_int smallint_to_int int", tableName), new QueryExecutor.QueryParam[0]);
        QueryExecutors.onHive().executeQuery(String.format("ALTER TABLE %s CHANGE COLUMN smallint_to_bigint smallint_to_bigint bigint", tableName), new QueryExecutor.QueryParam[0]);
        QueryExecutors.onHive().executeQuery(String.format("ALTER TABLE %s CHANGE COLUMN int_to_bigint int_to_bigint bigint", tableName), new QueryExecutor.QueryParam[0]);
        QueryExecutors.onHive().executeQuery(String.format("ALTER TABLE %s CHANGE COLUMN bigint_to_varchar bigint_to_varchar string", tableName), new QueryExecutor.QueryParam[0]);
        QueryExecutors.onHive().executeQuery(String.format("ALTER TABLE %s CHANGE COLUMN float_to_double float_to_double double", tableName), new QueryExecutor.QueryParam[0]);
        QueryExecutors.onHive().executeQuery(String.format("ALTER TABLE %s CHANGE COLUMN double_to_float double_to_float %s", tableName, floatType), new QueryExecutor.QueryParam[0]);
        QueryExecutors.onHive().executeQuery(String.format("ALTER TABLE %s CHANGE COLUMN shortdecimal_to_shortdecimal shortdecimal_to_shortdecimal DECIMAL(18,4)", tableName), new QueryExecutor.QueryParam[0]);
        QueryExecutors.onHive().executeQuery(String.format("ALTER TABLE %s CHANGE COLUMN shortdecimal_to_longdecimal shortdecimal_to_longdecimal DECIMAL(20,4)", tableName), new QueryExecutor.QueryParam[0]);
        QueryExecutors.onHive().executeQuery(String.format("ALTER TABLE %s CHANGE COLUMN longdecimal_to_shortdecimal longdecimal_to_shortdecimal DECIMAL(12,2)", tableName), new QueryExecutor.QueryParam[0]);
        QueryExecutors.onHive().executeQuery(String.format("ALTER TABLE %s CHANGE COLUMN longdecimal_to_longdecimal longdecimal_to_longdecimal DECIMAL(38,14)", tableName), new QueryExecutor.QueryParam[0]);
        QueryExecutors.onHive().executeQuery(String.format("ALTER TABLE %s CHANGE COLUMN float_to_decimal float_to_decimal DECIMAL(10,5)", tableName), new QueryExecutor.QueryParam[0]);
        QueryExecutors.onHive().executeQuery(String.format("ALTER TABLE %s CHANGE COLUMN double_to_decimal double_to_decimal DECIMAL(10,5)", tableName), new QueryExecutor.QueryParam[0]);
        QueryExecutors.onHive().executeQuery(String.format("ALTER TABLE %s CHANGE COLUMN decimal_to_float decimal_to_float %s", tableName, floatType), new QueryExecutor.QueryParam[0]);
        QueryExecutors.onHive().executeQuery(String.format("ALTER TABLE %s CHANGE COLUMN decimal_to_double decimal_to_double double", tableName), new QueryExecutor.QueryParam[0]);
        QueryExecutors.onHive().executeQuery(String.format("ALTER TABLE %s CHANGE COLUMN short_decimal_to_varchar short_decimal_to_varchar string", tableName), new QueryExecutor.QueryParam[0]);
        QueryExecutors.onHive().executeQuery(String.format("ALTER TABLE %s CHANGE COLUMN long_decimal_to_varchar long_decimal_to_varchar string", tableName), new QueryExecutor.QueryParam[0]);
        QueryExecutors.onHive().executeQuery(String.format("ALTER TABLE %s CHANGE COLUMN short_decimal_to_bounded_varchar short_decimal_to_bounded_varchar varchar(30)", tableName), new QueryExecutor.QueryParam[0]);
        QueryExecutors.onHive().executeQuery(String.format("ALTER TABLE %s CHANGE COLUMN long_decimal_to_bounded_varchar long_decimal_to_bounded_varchar varchar(30)", tableName), new QueryExecutor.QueryParam[0]);
        QueryExecutors.onHive().executeQuery(String.format("ALTER TABLE %s CHANGE COLUMN varchar_to_bigger_varchar varchar_to_bigger_varchar varchar(4)", tableName), new QueryExecutor.QueryParam[0]);
        QueryExecutors.onHive().executeQuery(String.format("ALTER TABLE %s CHANGE COLUMN varchar_to_smaller_varchar varchar_to_smaller_varchar varchar(2)", tableName), new QueryExecutor.QueryParam[0]);
        QueryExecutors.onHive().executeQuery(String.format("ALTER TABLE %s CHANGE COLUMN char_to_bigger_char char_to_bigger_char char(4)", tableName), new QueryExecutor.QueryParam[0]);
        QueryExecutors.onHive().executeQuery(String.format("ALTER TABLE %s CHANGE COLUMN char_to_smaller_char char_to_smaller_char char(2)", tableName), new QueryExecutor.QueryParam[0]);
        QueryExecutors.onHive().executeQuery(String.format("ALTER TABLE %s CHANGE COLUMN timestamp_to_string timestamp_to_string string", tableName), new QueryExecutor.QueryParam[0]);
        QueryExecutors.onHive().executeQuery(String.format("ALTER TABLE %s CHANGE COLUMN timestamp_to_bounded_varchar timestamp_to_bounded_varchar varchar(30)", tableName), new QueryExecutor.QueryParam[0]);
        QueryExecutors.onHive().executeQuery(String.format("ALTER TABLE %s CHANGE COLUMN timestamp_to_smaller_varchar timestamp_to_smaller_varchar varchar(4)", tableName), new QueryExecutor.QueryParam[0]);
    }

    protected static TableInstance<?> mutableTableInstanceOf(TableDefinition tableDefinition) {
        if (tableDefinition.getDatabase().isPresent()) {
            return BaseTestHiveCoercion.mutableTableInstanceOf(tableDefinition, (String)tableDefinition.getDatabase().get());
        }
        return BaseTestHiveCoercion.mutableTableInstanceOf(BaseTestHiveCoercion.tableHandleInSchema(tableDefinition));
    }

    private static TableInstance<?> mutableTableInstanceOf(TableDefinition tableDefinition, String database) {
        return BaseTestHiveCoercion.mutableTableInstanceOf(BaseTestHiveCoercion.tableHandleInSchema(tableDefinition).inDatabase(database));
    }

    private static TableInstance<?> mutableTableInstanceOf(TableHandle tableHandle) {
        return ((MutableTablesState)ThreadLocalTestContextHolder.testContext().getDependency(MutableTablesState.class)).get(tableHandle);
    }

    private static TableHandle tableHandleInSchema(TableDefinition tableDefinition) {
        TableHandle tableHandle = TableHandle.tableHandle((String)tableDefinition.getName());
        if (tableDefinition.getSchema().isPresent()) {
            tableHandle = tableHandle.inSchema((String)tableDefinition.getSchema().get());
        }
        return tableHandle;
    }

    private Row.Builder rowBuilder() {
        return Row.builder();
    }

    private static QueryAssert.Row project(QueryAssert.Row row, int ... columns) {
        return new QueryAssert.Row(Arrays.stream(columns).mapToObj(column -> row.getValues().get(column - 1)).collect(Collectors.toList()));
    }

    private static List<QueryAssert.Row> project(List<QueryAssert.Row> rows, int ... columns) {
        return (List)rows.stream().map(row -> BaseTestHiveCoercion.project(row, columns)).collect(ImmutableList.toImmutableList());
    }

    private static List<?> column(List<QueryAssert.Row> rows, int sqlColumnIndex) {
        return rows.stream().map(row -> BaseTestHiveCoercion.project(row, sqlColumnIndex).getValues().get(0)).collect(Collectors.toList());
    }

    private static List<List<?>> extract(List<TrinoArray> arrays) {
        return (List)arrays.stream().map(trinoArray -> ImmutableList.copyOf((Object[])((Object[])trinoArray.getArray()))).collect(ImmutableList.toImmutableList());
    }

    public static ColumnContext columnContext(String version, String format, String column) {
        return new ColumnContext(Optional.of(version), format, column);
    }

    public static ColumnContext columnContext(String format, String column) {
        return new ColumnContext(Optional.empty(), format, column);
    }

    private static QueryResult execute(Engine engine, String sql, QueryExecutor.QueryParam ... params) {
        return engine.queryExecutor().executeQuery(sql, params);
    }

    private /* synthetic */ void lambda$assertNestedSubFields$9(String subfieldQueryLowerCase, Map expectedNestedFieldHive, List expectedColumns, String tableName) throws Throwable {
        this.assertQueryResults(Engine.HIVE, subfieldQueryLowerCase, expectedNestedFieldHive, expectedColumns, 2, tableName);
    }

    private /* synthetic */ void lambda$assertNestedSubFields$8(String subfieldQueryLowerCase, Map expectedNestedFieldTrino, List expectedColumns, String tableName) throws Throwable {
        this.assertQueryResults(Engine.HIVE, subfieldQueryLowerCase, expectedNestedFieldTrino, expectedColumns, 2, tableName);
    }

    private /* synthetic */ void lambda$assertNestedSubFields$7(String subfieldQueryUpperCase, Map expectedNestedFieldTrino, List expectedColumns, String tableName) throws Throwable {
        this.assertQueryResults(Engine.HIVE, subfieldQueryUpperCase, expectedNestedFieldTrino, expectedColumns, 2, tableName);
    }

    public record ColumnContext(Optional<String> hiveVersion, String format, String column) {
        public ColumnContext {
            Objects.requireNonNull(hiveVersion, "hiveVersion is null");
            Objects.requireNonNull(format, "format is null");
            Objects.requireNonNull(column, "column is null");
        }
    }
}

