/*
 * Decompiled with CFR 0.152.
 */
package io.trino.tests.product.hive;

import com.google.inject.Inject;
import io.trino.tempto.ProductTest;
import io.trino.tempto.Requirement;
import io.trino.tempto.Requirements;
import io.trino.tempto.RequirementsProvider;
import io.trino.tempto.assertions.QueryAssert;
import io.trino.tempto.configuration.Configuration;
import io.trino.tempto.fulfillment.table.MutableTableRequirement;
import io.trino.tempto.fulfillment.table.MutableTablesState;
import io.trino.tempto.fulfillment.table.TableDefinition;
import io.trino.tempto.fulfillment.table.TableRequirements;
import io.trino.tempto.fulfillment.table.hive.HiveDataSource;
import io.trino.tempto.fulfillment.table.hive.HiveTableDefinition;
import io.trino.tempto.fulfillment.table.hive.InlineDataSource;
import io.trino.tempto.query.QueryExecutionException;
import io.trino.tempto.query.QueryExecutor;
import io.trino.tempto.query.QueryResult;
import io.trino.tests.product.utils.QueryExecutors;
import java.util.Locale;
import java.util.Optional;
import org.assertj.core.api.AssertProvider;
import org.assertj.core.api.Assertions;
import org.testng.annotations.Test;

public class TestTablePartitioningSelect
extends ProductTest
implements RequirementsProvider {
    private static final HiveTableDefinition SINGLE_INT_COLUMN_PARTITIONEND_TEXTFILE = TestTablePartitioningSelect.singleIntColumnPartitionedTableDefinition("TEXTFILE", Optional.of("DELIMITED FIELDS TERMINATED BY '|'"));
    private static final HiveTableDefinition SINGLE_INT_COLUMN_PARTITIONED_ORC = TestTablePartitioningSelect.singleIntColumnPartitionedTableDefinition("ORC", Optional.empty());
    private static final HiveTableDefinition SINGLE_INT_COLUMN_PARTITIONED_RCFILE = TestTablePartitioningSelect.singleIntColumnPartitionedTableDefinition("RCFILE", Optional.of("SERDE 'org.apache.hadoop.hive.serde2.columnar.ColumnarSerDe'"));
    private static final HiveTableDefinition SINGLE_INT_COLUMN_PARTITIONED_PARQUET = TestTablePartitioningSelect.singleIntColumnPartitionedTableDefinition("PARQUET", Optional.empty());
    private static final HiveTableDefinition SINGLE_INT_COLUMN_PARTITIONED_AVRO = TestTablePartitioningSelect.singleIntColumnPartitionedTableDefinition("AVRO", Optional.of("SERDE 'org.apache.hadoop.hive.serde2.avro.AvroSerDe'"));
    private static final String TABLE_NAME = "test_table";
    @Inject
    private MutableTablesState tablesState;

    private static HiveTableDefinition singleIntColumnPartitionedTableDefinition(String fileFormat, Optional<String> serde) {
        String tableName = fileFormat.toLowerCase(Locale.ENGLISH) + "_single_int_column_partitioned";
        HiveDataSource dataSource = InlineDataSource.createResourceDataSource((String)tableName, (String)("io/trino/tests/product/hive/data/single_int_column/data." + fileFormat.toLowerCase(Locale.ENGLISH)));
        HiveDataSource invalidData = InlineDataSource.createStringDataSource((String)tableName, (String)"INVALID DATA");
        return HiveTableDefinition.builder((String)tableName).setCreateTableDDLTemplate(TestTablePartitioningSelect.buildSingleIntColumnPartitionedTableDDL(fileFormat, serde)).addPartition("part_col = 1", invalidData).addPartition("part_col = 2", dataSource).build();
    }

    private static String buildSingleIntColumnPartitionedTableDDL(String fileFormat, Optional<String> rowFormat) {
        StringBuilder sb = new StringBuilder();
        sb.append("CREATE %EXTERNAL% TABLE %NAME%(");
        sb.append("   col INT");
        sb.append(") ");
        sb.append("PARTITIONED BY (part_col INT) ");
        if (rowFormat.isPresent()) {
            sb.append("ROW FORMAT ").append(rowFormat.get());
        }
        sb.append(" STORED AS " + fileFormat);
        sb.append(" TBLPROPERTIES ('transactional'='false')");
        return sb.toString();
    }

    public Requirement getRequirements(Configuration configuration) {
        return Requirements.allOf((Requirement[])new Requirement[]{TableRequirements.mutableTable((TableDefinition)SINGLE_INT_COLUMN_PARTITIONEND_TEXTFILE, (String)TABLE_NAME, (MutableTableRequirement.State)MutableTableRequirement.State.LOADED), TableRequirements.mutableTable((TableDefinition)SINGLE_INT_COLUMN_PARTITIONED_ORC, (String)TABLE_NAME, (MutableTableRequirement.State)MutableTableRequirement.State.LOADED), TableRequirements.mutableTable((TableDefinition)SINGLE_INT_COLUMN_PARTITIONED_RCFILE, (String)TABLE_NAME, (MutableTableRequirement.State)MutableTableRequirement.State.LOADED), TableRequirements.mutableTable((TableDefinition)SINGLE_INT_COLUMN_PARTITIONED_PARQUET, (String)TABLE_NAME, (MutableTableRequirement.State)MutableTableRequirement.State.LOADED), TableRequirements.mutableTable((TableDefinition)SINGLE_INT_COLUMN_PARTITIONED_AVRO, (String)TABLE_NAME, (MutableTableRequirement.State)MutableTableRequirement.State.LOADED)});
    }

    @Test
    public void testSelectPartitionedHiveTableDifferentFormats() {
        String tableNameInDatabase = this.tablesState.get(TABLE_NAME).getNameInDatabase();
        String selectFromOnePartitionsSql = "SELECT * FROM " + tableNameInDatabase + " WHERE part_col = 2";
        QueryResult onePartitionQueryResult = QueryExecutors.onTrino().executeQuery(selectFromOnePartitionsSql, new QueryExecutor.QueryParam[0]);
        ((QueryAssert)Assertions.assertThat((AssertProvider)onePartitionQueryResult)).containsOnly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{42, 2})});
        try {
            ((QueryAssert)Assertions.assertThat((AssertProvider)QueryExecutors.onTrino().executeQuery("SELECT * FROM " + tableNameInDatabase, new QueryExecutor.QueryParam[0]))).containsOnly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{42, 2}), QueryAssert.Row.row((Object[])new Object[]{null, 1})});
        }
        catch (QueryExecutionException queryExecutionException) {
            // empty catch block
        }
    }
}

