/*
 * Decompiled with CFR 0.152.
 */
package io.trino.tests.product.hive.util;

import com.google.common.collect.Iterables;
import io.trino.tempto.query.QueryExecutor;
import io.trino.tempto.query.QueryResult;
import io.trino.tests.product.utils.QueryExecutors;
import java.util.List;

public final class CachingTestUtils {
    private CachingTestUtils() {
    }

    public static CacheStats getCacheStats() {
        QueryResult queryResult = QueryExecutors.onTrino().executeQuery("SELECT   sum(Cached_rrc_requests) as cachedreads,   sum(Remote_rrc_requests + Direct_rrc_requests) as remotereads,   sum(Nonlocal_rrc_requests) as nonlocalreads FROM jmx.current.\"rubix:catalog=hive,type=detailed,name=stats\";", new QueryExecutor.QueryParam[0]);
        long cachedReads = (Long)((List)Iterables.getOnlyElement((Iterable)queryResult.rows())).get((Integer)queryResult.tryFindColumnIndex("cachedreads").get() - 1);
        long remoteReads = (Long)((List)Iterables.getOnlyElement((Iterable)queryResult.rows())).get((Integer)queryResult.tryFindColumnIndex("remotereads").get() - 1);
        long nonLocalReads = (Long)((List)Iterables.getOnlyElement((Iterable)queryResult.rows())).get((Integer)queryResult.tryFindColumnIndex("nonlocalreads").get() - 1);
        long asyncDownloadedMb = (Long)((List)Iterables.getOnlyElement((Iterable)QueryExecutors.onTrino().executeQuery("SELECT sum(Count) FROM jmx.current.\"metrics:name=rubix.bookkeeper.count.async_downloaded_mb\"", new QueryExecutor.QueryParam[0]).rows())).get(0);
        return new CacheStats(cachedReads, remoteReads, nonLocalReads, asyncDownloadedMb);
    }

    public static class CacheStats {
        private final long cachedReads;
        private final long remoteReads;
        private final long nonLocalReads;
        private final long asyncDownloadedMb;

        public CacheStats(long cachedReads, long remoteReads, long nonLocalReads, long asyncDownloadedMb) {
            this.cachedReads = cachedReads;
            this.remoteReads = remoteReads;
            this.nonLocalReads = nonLocalReads;
            this.asyncDownloadedMb = asyncDownloadedMb;
        }

        public long getCachedReads() {
            return this.cachedReads;
        }

        public long getRemoteReads() {
            return this.remoteReads;
        }

        public long getNonLocalReads() {
            return this.nonLocalReads;
        }

        public long getAsyncDownloadedMb() {
            return this.asyncDownloadedMb;
        }
    }
}

