/*
 * Decompiled with CFR 0.152.
 */
package io.trino.tests.product.iceberg;

import io.trino.tempto.ProductTest;
import io.trino.tempto.assertions.QueryAssert;
import io.trino.tempto.query.QueryExecutor;
import io.trino.testing.TestingNames;
import io.trino.tests.product.utils.QueryExecutors;
import org.assertj.core.api.AssertProvider;
import org.assertj.core.api.Assertions;
import org.testng.annotations.Test;

public class TestIcebergHiveTablesCompatibility
extends ProductTest {
    @Test(groups={"iceberg", "storage_formats", "hms_only"})
    public void testIcebergSelectFromHiveTable() {
        String tableName = "test_iceberg_select_from_hive_" + TestingNames.randomNameSuffix();
        QueryExecutors.onTrino().executeQuery("CREATE TABLE hive.default." + tableName + "(a bigint)", new QueryExecutor.QueryParam[0]);
        QueryAssert.assertQueryFailure(() -> QueryExecutors.onTrino().executeQuery("SELECT * FROM iceberg.default." + tableName, new QueryExecutor.QueryParam[0])).hasMessageMatching("Query failed \\(#\\w+\\):\\Q Not an Iceberg table: default." + tableName);
        QueryAssert.assertQueryFailure(() -> QueryExecutors.onTrino().executeQuery("SELECT * FROM iceberg.default.\"" + tableName + "$data\"", new QueryExecutor.QueryParam[0])).hasMessageMatching("Query failed \\(#\\w+\\):\\Q line 1:15: Table 'iceberg.default." + tableName + "$data' does not exist");
        QueryAssert.assertQueryFailure(() -> QueryExecutors.onTrino().executeQuery("SELECT * FROM iceberg.default.\"" + tableName + "$files\"", new QueryExecutor.QueryParam[0])).hasMessageMatching("Query failed \\(#\\w+\\):\\Q line 1:15: Table 'iceberg.default." + tableName + "$files' does not exist");
        QueryExecutors.onTrino().executeQuery("DROP TABLE hive.default." + tableName, new QueryExecutor.QueryParam[0]);
    }

    @Test(groups={"iceberg", "storage_formats", "hms_only"})
    public void testHiveSelectFromIcebergTable() {
        String tableName = "test_hive_select_from_iceberg_" + TestingNames.randomNameSuffix();
        QueryExecutors.onTrino().executeQuery("CREATE TABLE iceberg.default." + tableName + "(a bigint)", new QueryExecutor.QueryParam[0]);
        QueryAssert.assertQueryFailure(() -> QueryExecutors.onTrino().executeQuery("SELECT * FROM hive.default." + tableName, new QueryExecutor.QueryParam[0])).hasMessageMatching(String.format("Query failed \\(#\\w+\\):\\Q Cannot query Iceberg table 'default.%s'", tableName));
        QueryAssert.assertQueryFailure(() -> QueryExecutors.onTrino().executeQuery("SELECT * FROM hive.default.\"" + tableName + "$partitions\"", new QueryExecutor.QueryParam[0])).hasMessageMatching("Query failed \\(#\\w+\\):\\Q line 1:15: Table 'hive.default." + tableName + "$partitions' does not exist");
        QueryAssert.assertQueryFailure(() -> QueryExecutors.onTrino().executeQuery("SELECT * FROM hive.default.\"" + tableName + "$properties\"", new QueryExecutor.QueryParam[0])).hasMessageMatching("Query failed \\(#\\w+\\):\\Q line 1:15: Table 'hive.default." + tableName + "$properties' does not exist");
        QueryExecutors.onTrino().executeQuery("DROP TABLE iceberg.default." + tableName, new QueryExecutor.QueryParam[0]);
    }

    @Test(groups={"iceberg", "storage_formats", "hms_only"})
    public void testIcebergCannotCreateTableNamesakeToHiveTable() {
        String tableName = "test_iceberg_create_namesake_hive_table_" + TestingNames.randomNameSuffix();
        QueryExecutors.onTrino().executeQuery("CREATE TABLE hive.default." + tableName + "(a bigint)", new QueryExecutor.QueryParam[0]);
        QueryAssert.assertQueryFailure(() -> QueryExecutors.onTrino().executeQuery("CREATE TABLE iceberg.default." + tableName + "(a bigint)", new QueryExecutor.QueryParam[0])).hasMessageMatching("Query failed \\(#\\w+\\):\\Q line 1:1: Table 'iceberg.default." + tableName + "' of unsupported type already exists");
        QueryExecutors.onTrino().executeQuery("DROP TABLE hive.default." + tableName, new QueryExecutor.QueryParam[0]);
    }

    @Test(groups={"iceberg", "storage_formats", "hms_only"})
    public void testHiveCannotCreateTableNamesakeToIcebergTable() {
        String tableName = "test_hive_create_namesake_iceberg_table_" + TestingNames.randomNameSuffix();
        QueryExecutors.onTrino().executeQuery("CREATE TABLE iceberg.default." + tableName + "(a bigint)", new QueryExecutor.QueryParam[0]);
        QueryAssert.assertQueryFailure(() -> QueryExecutors.onTrino().executeQuery("CREATE TABLE hive.default." + tableName + "(a bigint)", new QueryExecutor.QueryParam[0])).hasMessageMatching("Query failed \\(#\\w+\\):\\Q line 1:1: Table 'hive.default." + tableName + "' of unsupported type already exists");
        QueryExecutors.onTrino().executeQuery("DROP TABLE iceberg.default." + tableName, new QueryExecutor.QueryParam[0]);
    }

    @Test(groups={"iceberg", "storage_formats", "hms_only"})
    public void testHiveSelectTableColumns() {
        String hiveTableName = "test_hive_table_columns_table_" + TestingNames.randomNameSuffix();
        QueryExecutors.onTrino().executeQuery("CREATE TABLE hive.default." + hiveTableName + "(a bigint)", new QueryExecutor.QueryParam[0]);
        String icebergTableName = "test_iceberg_table_columns_table_" + TestingNames.randomNameSuffix();
        QueryExecutors.onTrino().executeQuery("CREATE TABLE iceberg.default." + icebergTableName + "(a bigint)", new QueryExecutor.QueryParam[0]);
        ((QueryAssert)Assertions.assertThat((AssertProvider)QueryExecutors.onTrino().executeQuery(String.format("SELECT table_cat, table_schem, table_name, column_name FROM system.jdbc.columns WHERE table_cat = 'hive' AND table_schem = 'default' AND table_name = '%s'", hiveTableName), new QueryExecutor.QueryParam[0]))).containsOnly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{"hive", "default", hiveTableName, "a"})});
        ((QueryAssert)Assertions.assertThat((AssertProvider)QueryExecutors.onTrino().executeQuery(String.format("SELECT table_cat, table_schem, table_name, column_name FROM system.jdbc.columns WHERE table_cat = 'hive' AND table_schem = 'default' AND table_name = '%s'", icebergTableName), new QueryExecutor.QueryParam[0]))).hasNoRows();
        QueryExecutors.onTrino().executeQuery("DROP TABLE hive.default." + hiveTableName, new QueryExecutor.QueryParam[0]);
        QueryExecutors.onTrino().executeQuery("DROP TABLE iceberg.default." + icebergTableName, new QueryExecutor.QueryParam[0]);
    }

    @Test(groups={"iceberg", "storage_formats", "hms_only"})
    public void testHiveListsIcebergTable() {
        String tableName = "test_hive_lists_iceberg_table_" + TestingNames.randomNameSuffix();
        QueryExecutors.onTrino().executeQuery("CREATE TABLE iceberg.default." + tableName + "(a bigint)", new QueryExecutor.QueryParam[0]);
        ((QueryAssert)Assertions.assertThat((AssertProvider)QueryExecutors.onTrino().executeQuery("SHOW TABLES FROM hive.default", new QueryExecutor.QueryParam[0]))).contains(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{tableName})});
        QueryExecutors.onTrino().executeQuery("DROP TABLE iceberg.default." + tableName, new QueryExecutor.QueryParam[0]);
    }

    @Test(groups={"iceberg", "storage_formats", "hms_only"})
    public void testIcebergListsHiveTable() {
        String tableName = "test_iceberg_lists_hive_table_" + TestingNames.randomNameSuffix();
        QueryExecutors.onTrino().executeQuery("CREATE TABLE hive.default." + tableName + "(a bigint)", new QueryExecutor.QueryParam[0]);
        ((QueryAssert)Assertions.assertThat((AssertProvider)QueryExecutors.onTrino().executeQuery("SHOW TABLES FROM iceberg.default", new QueryExecutor.QueryParam[0]))).contains(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{tableName})});
        QueryExecutors.onTrino().executeQuery("DROP TABLE hive.default." + tableName, new QueryExecutor.QueryParam[0]);
    }
}

