/*
 * Decompiled with CFR 0.152.
 */
package io.trino.tests.product.kafka;

import io.trino.tempto.ProductTest;
import io.trino.tempto.assertions.QueryAssert;
import io.trino.tempto.query.QueryExecutor;
import io.trino.tests.product.utils.QueryExecutors;
import org.assertj.core.api.AssertProvider;
import org.assertj.core.api.Assertions;
import org.testng.annotations.Test;

public class TestKafkaAvroWritesSmokeTest
extends ProductTest {
    private static final String KAFKA_CATALOG = "kafka";
    private static final String ALL_DATATYPES_AVRO_TABLE_NAME = "product_tests.write_all_datatypes_avro";
    private static final String STRUCTURAL_AVRO_TABLE_NAME = "product_tests.write_structural_datatype_avro";

    @Test(groups={"kafka", "profile_specific_tests"})
    public void testInsertPrimitiveDataType() {
        ((QueryAssert)Assertions.assertThat((AssertProvider)QueryExecutors.onTrino().executeQuery(String.format("INSERT INTO %s.%s VALUES ('jasio', 9223372036854775807, 1234567890.123456789, true), ('stasio', -9223372036854775808, -1234567890.123456789, false), (null, null, null, null), ('krzysio', 9223372036854775807, 1234567890.123456789, false), ('kasia', 9223372036854775807, null, null)", KAFKA_CATALOG, ALL_DATATYPES_AVRO_TABLE_NAME), new QueryExecutor.QueryParam[0]))).updatedRowsCountIsEqualTo(5);
        ((QueryAssert)Assertions.assertThat((AssertProvider)QueryExecutors.onTrino().executeQuery(String.format("SELECT * FROM %s.%s", KAFKA_CATALOG, ALL_DATATYPES_AVRO_TABLE_NAME), new QueryExecutor.QueryParam[0]))).containsOnly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{"jasio", Long.MAX_VALUE, 1.2345678901234567E9, true}), QueryAssert.Row.row((Object[])new Object[]{"stasio", Long.MIN_VALUE, -1.2345678901234567E9, false}), QueryAssert.Row.row((Object[])new Object[]{null, null, null, null}), QueryAssert.Row.row((Object[])new Object[]{"krzysio", Long.MAX_VALUE, 1.2345678901234567E9, false}), QueryAssert.Row.row((Object[])new Object[]{"kasia", Long.MAX_VALUE, null, null})});
    }

    @Test(groups={"kafka", "profile_specific_tests"})
    public void testInsertStructuralDataType() {
        QueryAssert.assertQueryFailure(() -> QueryExecutors.onTrino().executeQuery(String.format("INSERT INTO %s.%s VALUES (ARRAY[100, 102], map_from_entries(ARRAY[('key1', 'value1')]))", KAFKA_CATALOG, STRUCTURAL_AVRO_TABLE_NAME), new QueryExecutor.QueryParam[0])).hasMessageMatching("Query failed \\(.+\\): Unsupported column type 'array\\(bigint\\)' for column 'c_array'");
    }
}

