/*
 * Decompiled with CFR 0.152.
 */
package io.trino.tests.product.mariadb;

import io.trino.tempto.ProductTest;
import io.trino.tempto.assertions.QueryAssert;
import io.trino.tempto.query.QueryExecutor;
import io.trino.tempto.query.QueryResult;
import io.trino.tests.product.utils.QueryExecutors;
import org.assertj.core.api.AssertProvider;
import org.assertj.core.api.Assertions;
import org.testng.annotations.Test;

public class TestMariaDb
extends ProductTest {
    @Test(groups={"mariadb", "profile_specific_tests"})
    public void testCreateTableAsSelect() {
        QueryExecutors.onTrino().executeQuery("DROP TABLE IF EXISTS mariadb.test.nation", new QueryExecutor.QueryParam[0]);
        QueryResult result = QueryExecutors.onTrino().executeQuery("CREATE TABLE mariadb.test.nation AS SELECT * FROM tpch.tiny.nation", new QueryExecutor.QueryParam[0]);
        try {
            ((QueryAssert)Assertions.assertThat((AssertProvider)result)).updatedRowsCountIsEqualTo(25);
            ((QueryAssert)Assertions.assertThat((AssertProvider)QueryExecutors.onTrino().executeQuery("SELECT COUNT(*) FROM mariadb.test.nation", new QueryExecutor.QueryParam[0]))).containsOnly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{25})});
        }
        finally {
            QueryExecutors.onTrino().executeQuery("DROP TABLE mariadb.test.nation", new QueryExecutor.QueryParam[0]);
        }
    }
}

