/*
 * Decompiled with CFR 0.152.
 */
package io.trino.tests.product;

import com.google.common.collect.ImmutableList;
import com.google.common.io.Resources;
import io.trino.tempto.BeforeMethodWithContext;
import io.trino.tempto.ProductTest;
import io.trino.tempto.query.QueryExecutor;
import io.trino.tests.product.TpcTestUtils;
import io.trino.tests.product.utils.QueryExecutors;
import java.io.IOException;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.List;
import org.testng.annotations.Test;

public class TestParquet
extends ProductTest {
    private volatile boolean initialized;

    @BeforeMethodWithContext
    public void init() {
        if (this.initialized) {
            return;
        }
        TpcTestUtils.createTpcdsAndTpchDatasets("hive");
        this.initialized = true;
    }

    @Test(groups={"parquet", "profile_specific_tests"}, dataProvider="tpcdsQueries", dataProviderClass=TpcTestUtils.class)
    public void testTpcds(String queryId) throws IOException {
        String query = Resources.toString((URL)Resources.getResource((String)("sql-tests/testcases/tpcds/q" + queryId + ".sql")), (Charset)StandardCharsets.UTF_8);
        List expected = (List)Resources.readLines((URL)Resources.getResource((String)("sql-tests/testcases/tpcds/q" + queryId + ".result")), (Charset)StandardCharsets.UTF_8).stream().filter(line -> !line.startsWith("--")).collect(ImmutableList.toImmutableList());
        QueryExecutors.onTrino().executeQuery("USE hive.tpcds", new QueryExecutor.QueryParam[0]);
        TpcTestUtils.assertResults(expected, query);
    }

    @Test(groups={"parquet", "profile_specific_tests"}, dataProvider="tpchQueries", dataProviderClass=TpcTestUtils.class)
    public void testTpch(String queryId) throws IOException {
        String query = Resources.toString((URL)Resources.getResource((String)("sql-tests/testcases/hive_tpch/q" + queryId + ".sql")), (Charset)StandardCharsets.UTF_8);
        List expected = (List)Resources.readLines((URL)Resources.getResource((String)("sql-tests/testcases/hive_tpch/q" + queryId + ".result")), (Charset)StandardCharsets.UTF_8).stream().filter(line -> !line.startsWith("--")).collect(ImmutableList.toImmutableList());
        QueryExecutors.onTrino().executeQuery("USE hive.tpch", new QueryExecutor.QueryParam[0]);
        TpcTestUtils.assertResults(expected, query);
    }
}

