/*
 * Decompiled with CFR 0.152.
 */
package io.trino.tests.product.cassandra;

import io.trino.tempto.ProductTest;
import io.trino.tempto.Requirement;
import io.trino.tempto.RequirementsProvider;
import io.trino.tempto.assertions.QueryAssert;
import io.trino.tempto.configuration.Configuration;
import io.trino.tempto.fulfillment.table.TableDefinition;
import io.trino.tempto.fulfillment.table.TableRequirements;
import io.trino.tempto.query.QueryExecutor;
import io.trino.tempto.query.QueryResult;
import io.trino.tests.product.cassandra.MultiColumnKeyTableDefinition;
import io.trino.tests.product.utils.QueryExecutors;
import org.assertj.core.api.AssertProvider;
import org.assertj.core.api.Assertions;
import org.testng.annotations.Test;

public class TestSelectMultiColumnKey
extends ProductTest
implements RequirementsProvider {
    public Requirement getRequirements(Configuration configuration) {
        return TableRequirements.immutableTable((TableDefinition)MultiColumnKeyTableDefinition.CASSANDRA_MULTI_COLUMN_KEY);
    }

    @Test(groups={"cassandra", "profile_specific_tests"})
    public void testSelectWithEqualityFilterOnClusteringKey() {
        String sql = String.format("SELECT value FROM %s.%s.%s WHERE key = 'a1'", "cassandra", "test", MultiColumnKeyTableDefinition.CASSANDRA_MULTI_COLUMN_KEY.getName());
        QueryResult queryResult = QueryExecutors.onTrino().executeQuery(sql, new QueryExecutor.QueryParam[0]);
        ((QueryAssert)Assertions.assertThat((AssertProvider)queryResult)).containsOnly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{"Test value 1"})});
    }

    @Test(groups={"cassandra", "profile_specific_tests"})
    public void testSelectWithEqualityFilterOnPrimaryAndClusteringKeys() {
        String sql = String.format("SELECT value FROM %s.%s.%s WHERE user_id = 'Alice' and key = 'a1' and updated_at = TIMESTAMP '2015-01-01 01:01:01Z'", "cassandra", "test", MultiColumnKeyTableDefinition.CASSANDRA_MULTI_COLUMN_KEY.getName());
        QueryResult queryResult = QueryExecutors.onTrino().executeQuery(sql, new QueryExecutor.QueryParam[0]);
        ((QueryAssert)Assertions.assertThat((AssertProvider)queryResult)).containsOnly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{"Test value 1"})});
    }

    @Test(groups={"cassandra", "profile_specific_tests"})
    public void testSelectWithMixedFilterOnPrimaryAndClusteringKeys() {
        String sql = String.format("SELECT value FROM %s.%s.%s WHERE user_id = 'Alice' and key < 'b' and updated_at >= TIMESTAMP '2015-01-01 01:01:01Z'", "cassandra", "test", MultiColumnKeyTableDefinition.CASSANDRA_MULTI_COLUMN_KEY.getName());
        QueryResult queryResult = QueryExecutors.onTrino().executeQuery(sql, new QueryExecutor.QueryParam[0]);
        ((QueryAssert)Assertions.assertThat((AssertProvider)queryResult)).containsOnly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{"Test value 1"})});
    }

    @Test(groups={"cassandra", "profile_specific_tests"})
    public void testSelectWithFilterOnPrimaryKeyNoMatch() {
        String sql = String.format("SELECT value FROM %s.%s.%s WHERE user_id = 'George'", "cassandra", "test", MultiColumnKeyTableDefinition.CASSANDRA_MULTI_COLUMN_KEY.getName());
        QueryResult queryResult = QueryExecutors.onTrino().executeQuery(sql, new QueryExecutor.QueryParam[0]);
        ((QueryAssert)Assertions.assertThat((AssertProvider)queryResult)).hasNoRows();
    }

    @Test(groups={"cassandra", "profile_specific_tests"})
    public void testSelectWithFilterOnPrefixOfClusteringKey() {
        String sql = String.format("SELECT value FROM %s.%s.%s WHERE user_id = 'Bob' and key = 'b1'", "cassandra", "test", MultiColumnKeyTableDefinition.CASSANDRA_MULTI_COLUMN_KEY.getName());
        QueryResult queryResult = QueryExecutors.onTrino().executeQuery(sql, new QueryExecutor.QueryParam[0]);
        ((QueryAssert)Assertions.assertThat((AssertProvider)queryResult)).containsOnly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{"Test value 2"})});
    }

    @Test(groups={"cassandra", "profile_specific_tests"})
    public void testSelectWithFilterOnSecondClusteringKey() {
        String sql = String.format("SELECT value FROM %s.%s.%s WHERE user_id = 'Bob' and updated_at = TIMESTAMP '2014-02-02 03:04:05Z'", "cassandra", "test", MultiColumnKeyTableDefinition.CASSANDRA_MULTI_COLUMN_KEY.getName());
        QueryResult queryResult = QueryExecutors.onTrino().executeQuery(sql, new QueryExecutor.QueryParam[0]);
        ((QueryAssert)Assertions.assertThat((AssertProvider)queryResult)).containsOnly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{"Test value 2"})});
    }
}

