/*
 * Decompiled with CFR 0.152.
 */
package io.trino.tests.product.cli;

import com.google.common.collect.ImmutableList;
import com.google.inject.Inject;
import com.google.inject.name.Named;
import io.trino.tempto.AfterMethodWithContext;
import io.trino.tempto.Requirement;
import io.trino.tempto.Requirements;
import io.trino.tempto.RequirementsProvider;
import io.trino.tempto.configuration.Configuration;
import io.trino.tempto.fulfillment.ldap.LdapObjectRequirement;
import io.trino.tempto.fulfillment.table.TableDefinition;
import io.trino.tempto.fulfillment.table.TableRequirements;
import io.trino.tempto.fulfillment.table.hive.tpch.TpchTableDefinitions;
import io.trino.tempto.process.CliProcess;
import io.trino.tests.product.ImmutableLdapObjectDefinitions;
import io.trino.tests.product.cli.TrinoCliLauncher;
import io.trino.tests.product.cli.TrinoCliProcess;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import org.assertj.core.api.Assertions;
import org.testng.annotations.Test;

public class TestTrinoLdapCli
extends TrinoCliLauncher
implements RequirementsProvider {
    private static final String SELECT_FROM_NATION = "SELECT * FROM hive.default.nation;";
    @Inject(optional=true)
    @Named(value="databases.presto.cli_ldap_truststore_path")
    private String ldapTruststorePath;
    @Inject(optional=true)
    @Named(value="databases.presto.cli_ldap_truststore_password")
    private String ldapTruststorePassword;
    @Inject(optional=true)
    @Named(value="databases.presto.cli_ldap_user_name")
    private String ldapUserName;
    @Inject(optional=true)
    @Named(value="databases.presto.cli_ldap_server_address")
    private String ldapServerAddress;
    @Inject(optional=true)
    @Named(value="databases.presto.cli_ldap_user_password")
    private String ldapUserPassword;
    @Inject(optional=true)
    @Named(value="databases.presto.file_user_password")
    private String fileUserPassword;
    @Inject(optional=true)
    @Named(value="databases.OnlyFileUser@presto.file_user_password")
    private String onlyFileUserPassword;

    @Override
    @AfterMethodWithContext
    public void stopCli() throws InterruptedException {
        super.stopCli();
    }

    public Requirement getRequirements(Configuration configuration) {
        return Requirements.compose((Requirement[])new Requirement[]{new LdapObjectRequirement(Arrays.asList(ImmutableLdapObjectDefinitions.AMERICA_ORG, ImmutableLdapObjectDefinitions.ASIA_ORG, ImmutableLdapObjectDefinitions.EUROPE_ORG, ImmutableLdapObjectDefinitions.DEFAULT_GROUP, ImmutableLdapObjectDefinitions.PARENT_GROUP, ImmutableLdapObjectDefinitions.CHILD_GROUP, ImmutableLdapObjectDefinitions.DEFAULT_GROUP_USER, ImmutableLdapObjectDefinitions.PARENT_GROUP_USER, ImmutableLdapObjectDefinitions.CHILD_GROUP_USER, ImmutableLdapObjectDefinitions.ORPHAN_USER, ImmutableLdapObjectDefinitions.SPECIAL_USER, ImmutableLdapObjectDefinitions.USER_IN_MULTIPLE_GROUPS, ImmutableLdapObjectDefinitions.USER_IN_AMERICA, ImmutableLdapObjectDefinitions.USER_IN_EUROPE)), TableRequirements.immutableTable((TableDefinition)TpchTableDefinitions.NATION)});
    }

    @Test(groups={"ldap", "ldap_cli", "profile_specific_tests"}, timeOut=300000L)
    public void shouldRunQueryWithLdap() throws IOException {
        this.launchTrinoCliWithServerArgument(new String[0]);
        this.trino.waitForPrompt();
        this.trino.getProcessInput().println(SELECT_FROM_NATION);
        Assertions.assertThat((List)CliProcess.trimLines(this.trino.readLinesUntilPrompt())).containsAll((Iterable)this.nationTableInteractiveLines);
    }

    @Test(groups={"ldap", "ldap_cli", "profile_specific_tests"}, timeOut=300000L)
    public void shouldRunBatchQueryWithLdap() throws IOException {
        this.launchTrinoCliWithServerArgument("--execute", SELECT_FROM_NATION);
        Assertions.assertThat((List)CliProcess.trimLines((List)this.trino.readRemainingOutputLines())).containsAll((Iterable)this.nationTableBatchLines);
    }

    @Test(groups={"ldap", "ldap_cli", "profile_specific_tests"}, timeOut=300000L)
    public void shouldRunQueryFromFileWithLdap() throws IOException {
        File temporayFile = File.createTempFile("test-sql", null);
        temporayFile.deleteOnExit();
        Files.writeString(temporayFile.toPath(), (CharSequence)"SELECT * FROM hive.default.nation;\n", new OpenOption[0]);
        this.launchTrinoCliWithServerArgument("--file", temporayFile.getAbsolutePath());
        Assertions.assertThat((List)CliProcess.trimLines((List)this.trino.readRemainingOutputLines())).containsAll((Iterable)this.nationTableBatchLines);
    }

    @Test(groups={"ldap", "ldap_cli", "profile_specific_tests"}, timeOut=300000L)
    public void shouldPassQueryForLdapUserInMultipleGroups() throws IOException {
        this.ldapUserName = (String)ImmutableLdapObjectDefinitions.USER_IN_MULTIPLE_GROUPS.getAttributes().get("cn");
        this.launchTrinoCliWithServerArgument("--catalog", "hive", "--schema", "default", "--execute", SELECT_FROM_NATION);
        Assertions.assertThat((List)CliProcess.trimLines((List)this.trino.readRemainingOutputLines())).containsAll((Iterable)this.nationTableBatchLines);
    }

    @Test(groups={"ldap", "ldap_cli", "ldap_multiple_binds", "profile_specific_tests"}, timeOut=300000L)
    public void shouldPassQueryForAlternativeLdapBind() throws IOException {
        this.ldapUserName = (String)ImmutableLdapObjectDefinitions.USER_IN_AMERICA.getAttributes().get("cn");
        this.launchTrinoCliWithServerArgument("--catalog", "hive", "--schema", "default", "--execute", SELECT_FROM_NATION);
        Assertions.assertThat((List)CliProcess.trimLines((List)this.trino.readRemainingOutputLines())).containsAll((Iterable)this.nationTableBatchLines);
    }

    @Test(groups={"ldap", "ldap_cli", "profile_specific_tests"}, timeOut=300000L)
    public void shouldFailQueryForLdapUserInChildGroup() throws IOException {
        this.ldapUserName = (String)ImmutableLdapObjectDefinitions.CHILD_GROUP_USER.getAttributes().get("cn");
        this.launchTrinoCliWithServerArgument("--catalog", "hive", "--schema", "default", "--execute", SELECT_FROM_NATION);
        Assertions.assertThat((List)CliProcess.trimLines((List)this.trino.readRemainingErrorLines())).anySatisfy(line -> Assertions.assertThat((String)line).contains(new CharSequence[]{String.format("User [%s] not a member of an authorized group", this.ldapUserName)}));
    }

    @Test(groups={"ldap", "ldap_cli", "profile_specific_tests"}, timeOut=300000L)
    public void shouldFailQueryForLdapUserInParentGroup() throws IOException {
        this.ldapUserName = (String)ImmutableLdapObjectDefinitions.PARENT_GROUP_USER.getAttributes().get("cn");
        this.launchTrinoCliWithServerArgument("--catalog", "hive", "--schema", "default", "--execute", SELECT_FROM_NATION);
        Assertions.assertThat((List)CliProcess.trimLines((List)this.trino.readRemainingErrorLines())).anySatisfy(line -> Assertions.assertThat((String)line).contains(new CharSequence[]{String.format("User [%s] not a member of an authorized group", this.ldapUserName)}));
    }

    @Test(groups={"ldap", "ldap_cli", "profile_specific_tests"}, timeOut=300000L)
    public void shouldFailQueryForOrphanLdapUser() throws IOException {
        this.ldapUserName = (String)ImmutableLdapObjectDefinitions.ORPHAN_USER.getAttributes().get("cn");
        this.launchTrinoCliWithServerArgument("--catalog", "hive", "--schema", "default", "--execute", SELECT_FROM_NATION);
        Assertions.assertThat((List)CliProcess.trimLines((List)this.trino.readRemainingErrorLines())).anySatisfy(line -> Assertions.assertThat((String)line).contains(new CharSequence[]{String.format("User [%s] not a member of an authorized group", this.ldapUserName)}));
    }

    @Test(groups={"ldap", "ldap_cli", "ldap_multiple_binds", "profile_specific_tests"}, timeOut=300000L)
    public void shouldFailQueryForFailedBind() throws IOException {
        this.ldapUserName = (String)ImmutableLdapObjectDefinitions.USER_IN_EUROPE.getAttributes().get("cn");
        this.launchTrinoCliWithServerArgument("--catalog", "hive", "--schema", "default", "--execute", SELECT_FROM_NATION);
        Assertions.assertThat((List)CliProcess.trimLines((List)this.trino.readRemainingErrorLines())).anySatisfy(line -> Assertions.assertThat((String)line).contains(new CharSequence[]{"Invalid credentials"}));
    }

    @Test(groups={"ldap", "ldap_cli", "profile_specific_tests"}, timeOut=300000L)
    public void shouldFailQueryForWrongLdapPassword() throws IOException {
        this.ldapUserPassword = "wrong_password";
        this.launchTrinoCliWithServerArgument("--execute", SELECT_FROM_NATION);
        Assertions.assertThat((List)CliProcess.trimLines((List)this.trino.readRemainingErrorLines())).anySatisfy(line -> Assertions.assertThat((String)line).contains(new CharSequence[]{"Invalid credentials"}));
    }

    @Test(groups={"ldap", "ldap_cli", "profile_specific_tests"}, timeOut=300000L)
    public void shouldFailQueryForWrongLdapUser() throws IOException {
        this.ldapUserName = "invalid_user";
        this.launchTrinoCliWithServerArgument("--execute", SELECT_FROM_NATION);
        Assertions.assertThat((List)CliProcess.trimLines((List)this.trino.readRemainingErrorLines())).anySatisfy(line -> Assertions.assertThat((String)line).contains(new CharSequence[]{"Access Denied"}));
    }

    @Test(groups={"ldap", "ldap_cli", "profile_specific_tests"}, timeOut=300000L)
    public void shouldFailQueryForEmptyUser() throws IOException {
        this.ldapUserName = "";
        this.launchTrinoCliWithServerArgument("--execute", SELECT_FROM_NATION);
        Assertions.assertThat((List)CliProcess.trimLines((List)this.trino.readRemainingErrorLines())).anySatisfy(line -> Assertions.assertThat((String)line).contains(new CharSequence[]{"Both username and password must be specified"}));
    }

    @Test(groups={"ldap", "ldap_cli", "profile_specific_tests"}, timeOut=300000L)
    public void shouldFailQueryForLdapWithoutPassword() throws IOException {
        this.launchTrinoCli("--server", this.ldapServerAddress, "--truststore-path", this.ldapTruststorePath, "--truststore-password", this.ldapTruststorePassword, "--user", this.ldapUserName, "--execute", SELECT_FROM_NATION);
        Assertions.assertThat((List)CliProcess.trimLines((List)this.trino.readRemainingErrorLines())).anySatisfy(line -> Assertions.assertThat((String)line).contains(new CharSequence[]{"Authentication failed: Unauthorized"}));
    }

    @Test(groups={"ldap", "ldap_cli", "profile_specific_tests"}, timeOut=300000L)
    public void shouldFailQueryForLdapWithoutHttps() throws IOException {
        this.ldapServerAddress = String.format("http://%s:8443", this.serverHost);
        this.launchTrinoCliWithServerArgument("--execute", SELECT_FROM_NATION);
        Assertions.assertThat((List)CliProcess.trimLines((List)this.trino.readRemainingErrorLines())).anySatisfy(line -> Assertions.assertThat((String)line).contains(new CharSequence[]{"TLS/SSL required for authentication with username and password"}));
        this.skipAfterMethodWithContext();
    }

    @Test(groups={"ldap", "ldap_cli", "profile_specific_tests"}, timeOut=300000L)
    public void shouldFailForIncorrectTrustStore() throws IOException {
        this.ldapTruststorePassword = "wrong_password";
        this.launchTrinoCliWithServerArgument("--execute", SELECT_FROM_NATION);
        Assertions.assertThat((List)CliProcess.trimLines((List)this.trino.readRemainingErrorLines())).anySatisfy(line -> Assertions.assertThat((String)line).contains(new CharSequence[]{"Error setting up SSL: keystore password was incorrect"}));
        this.skipAfterMethodWithContext();
    }

    private void skipAfterMethodWithContext() {
        this.trino.close();
        this.trino = null;
    }

    @Test(groups={"ldap", "ldap_cli", "profile_specific_tests"}, timeOut=300000L)
    public void shouldPassForCredentialsWithSpecialCharacters() throws IOException {
        this.ldapUserName = (String)ImmutableLdapObjectDefinitions.SPECIAL_USER.getAttributes().get("cn");
        this.ldapUserPassword = (String)ImmutableLdapObjectDefinitions.SPECIAL_USER.getAttributes().get("userPassword");
        this.launchTrinoCliWithServerArgument("--catalog", "hive", "--schema", "default", "--execute", SELECT_FROM_NATION);
        Assertions.assertThat((List)CliProcess.trimLines((List)this.trino.readRemainingOutputLines())).containsAll((Iterable)this.nationTableBatchLines);
    }

    @Test(groups={"ldap", "ldap_cli", "profile_specific_tests"}, timeOut=300000L)
    public void shouldFailForUserWithColon() throws IOException {
        this.ldapUserName = "UserWith:Colon";
        this.launchTrinoCliWithServerArgument("--execute", SELECT_FROM_NATION);
        Assertions.assertThat((List)CliProcess.trimLines((List)this.trino.readRemainingErrorLines())).anySatisfy(line -> Assertions.assertThat((String)line).contains(new CharSequence[]{"Illegal character ':' found in username"}));
        this.skipAfterMethodWithContext();
    }

    @Test(groups={"ldap_and_file_cli", "profile_specific_tests"}, timeOut=300000L)
    public void shouldRunQueryWithFileAuthenticator() throws IOException {
        this.ldapUserPassword = this.fileUserPassword;
        this.launchTrinoCliWithServerArgument(new String[0]);
        this.trino.waitForPrompt();
        this.trino.getProcessInput().println(SELECT_FROM_NATION);
        Assertions.assertThat((List)CliProcess.trimLines(this.trino.readLinesUntilPrompt())).containsAll((Iterable)this.nationTableInteractiveLines);
    }

    @Test(groups={"ldap_and_file_cli", "profile_specific_tests"}, timeOut=300000L)
    public void shouldRunQueryForAnotherUserWithOnlyFileAuthenticator() throws IOException {
        this.ldapUserName = "OnlyFileUser";
        this.ldapUserPassword = this.onlyFileUserPassword;
        this.launchTrinoCliWithServerArgument(new String[0]);
        this.trino.waitForPrompt();
        this.trino.getProcessInput().println(SELECT_FROM_NATION);
        Assertions.assertThat((List)CliProcess.trimLines(this.trino.readLinesUntilPrompt())).containsAll((Iterable)this.nationTableInteractiveLines);
    }

    private void launchTrinoCliWithServerArgument(String ... arguments) throws IOException {
        Objects.requireNonNull(this.ldapTruststorePath, "ldapTruststorePath is null");
        Objects.requireNonNull(this.ldapTruststorePassword, "ldapTruststorePassword is null");
        Objects.requireNonNull(this.ldapUserName, "ldapUserName is null");
        Objects.requireNonNull(this.ldapServerAddress, "ldapServerAddress is null");
        Objects.requireNonNull(this.ldapUserPassword, "ldapUserPassword is null");
        ImmutableList.Builder prestoClientOptions = ImmutableList.builder();
        prestoClientOptions.add((Object[])new String[]{"--server", this.ldapServerAddress, "--truststore-path", this.ldapTruststorePath, "--truststore-password", this.ldapTruststorePassword, "--user", this.ldapUserName, "--password"});
        prestoClientOptions.add((Object[])arguments);
        ProcessBuilder processBuilder = this.getProcessBuilder((List<String>)prestoClientOptions.build());
        processBuilder.environment().put("TRINO_PASSWORD", this.ldapUserPassword);
        this.trino = new TrinoCliProcess(processBuilder.start());
    }
}

