/*
 * Decompiled with CFR 0.152.
 */
package io.trino.tests.product.deltalake;

import com.google.common.collect.ImmutableList;
import com.google.common.reflect.ClassPath;
import com.google.inject.Inject;
import io.trino.tempto.BeforeMethodWithContext;
import io.trino.tempto.ProductTest;
import io.trino.tempto.assertions.QueryAssert;
import io.trino.tempto.hadoop.hdfs.HdfsClient;
import io.trino.tempto.query.QueryExecutor;
import io.trino.tests.product.utils.QueryExecutors;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.assertj.core.api.AssertProvider;
import org.assertj.core.api.Assertions;
import org.testng.annotations.Test;

public abstract class BaseTestDeltaLakeHdfsReads
extends ProductTest {
    private String regionResourcePath;
    @Inject
    private HdfsClient hdfsClient;

    public BaseTestDeltaLakeHdfsReads(String regionResourcePath) {
        this.regionResourcePath = Objects.requireNonNull(regionResourcePath, "regionResourcePath is null");
    }

    @BeforeMethodWithContext
    public void setUp() throws IOException {
        String dstPath = "/tmp/region";
        this.hdfsClient.createDirectory(dstPath);
        List resources = (List)ClassPath.from((ClassLoader)((Object)((Object)this)).getClass().getClassLoader()).getResources().stream().filter(resourceInfo -> resourceInfo.getResourceName().startsWith(this.regionResourcePath)).collect(ImmutableList.toImmutableList());
        for (ClassPath.ResourceInfo resourceInfo2 : resources) {
            InputStream resourceInputStream = resourceInfo2.asByteSource().openBufferedStream();
            try {
                String fileName = resourceInfo2.getResourceName().replaceFirst("^" + Pattern.quote(this.regionResourcePath), Matcher.quoteReplacement(dstPath));
                this.hdfsClient.saveFile(fileName, resourceInputStream);
            }
            finally {
                if (resourceInputStream == null) continue;
                resourceInputStream.close();
            }
        }
    }

    @Test(groups={"delta-lake-hdfs", "profile_specific_tests"})
    public void testReads() {
        QueryExecutors.onTrino().executeQuery("CALL delta.system.register_table('default', 'region', 'hdfs://hadoop-master:9000/tmp/region')", new QueryExecutor.QueryParam[0]);
        ((QueryAssert)Assertions.assertThat((AssertProvider)QueryExecutors.onTrino().executeQuery("SELECT count(*) FROM delta.default.region", new QueryExecutor.QueryParam[0]))).containsOnly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{5L})});
        QueryExecutors.onTrino().executeQuery("DROP TABLE delta.default.region", new QueryExecutor.QueryParam[0]);
    }
}

