/*
 * Decompiled with CFR 0.152.
 */
package io.trino.tests.product.deltalake;

import com.amazonaws.services.glue.AWSGlueAsync;
import com.amazonaws.services.glue.AWSGlueAsyncClientBuilder;
import com.amazonaws.services.glue.model.Database;
import com.amazonaws.services.glue.model.EntityNotFoundException;
import com.amazonaws.services.glue.model.GetDatabaseRequest;
import com.amazonaws.services.glue.model.GetTableRequest;
import com.amazonaws.services.glue.model.Table;
import com.google.common.collect.ImmutableSet;
import io.airlift.log.Logger;
import io.trino.plugin.hive.metastore.glue.converter.GlueToTrinoConverter;
import io.trino.tempto.ProductTest;
import io.trino.tempto.query.QueryExecutor;
import io.trino.tempto.query.QueryResult;
import io.trino.testng.services.Flaky;
import io.trino.tests.product.utils.QueryExecutors;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.testng.annotations.Test;

public class TestDatabricksWithGlueMetastoreCleanUp
extends ProductTest {
    private static final Logger log = Logger.get(TestDatabricksWithGlueMetastoreCleanUp.class);
    private static final Instant SCHEMA_CLEANUP_THRESHOLD = Instant.now().minus(7L, ChronoUnit.DAYS);
    private static final long MAX_JOB_TIME_MILLIS = TimeUnit.MINUTES.toMillis(5L);

    @Test(groups={"delta-lake-databricks", "profile_specific_tests"})
    @Flaky(issue="https://github.com/trinodb/trino/issues/14391", match="\\Q[Databricks][DatabricksJDBCDriver](500593) Communication link failure. Failed to connect to server. Reason: \\E(HTTP retry after response received with no Retry-After header, error: HTTP Response code: 503|HTTP Response code: 504), Error message: Unknown.")
    public void testCleanUpOldTablesUsingDelta() {
        AWSGlueAsync glueClient = (AWSGlueAsync)AWSGlueAsyncClientBuilder.standard().build();
        long startTime = System.currentTimeMillis();
        List<String> schemas = QueryExecutors.onTrino().executeQuery("SELECT DISTINCT(table_schema) FROM information_schema.tables", new QueryExecutor.QueryParam[0]).rows().stream().map(row -> (String)row.get(0)).filter(schema -> schema.toLowerCase(Locale.ENGLISH).startsWith("test") || schema.equals("default")).collect(Collectors.toUnmodifiableList());
        QueryExecutors.onTrino().executeQuery("SET SESSION hive.hive_views_legacy_translation = true", new QueryExecutor.QueryParam[0]);
        schemas.forEach(schema -> this.cleanSchema((String)schema, startTime, glueClient));
    }

    private void cleanSchema(String schema, long startTime, AWSGlueAsync glueClient) {
        Database database;
        try {
            database = glueClient.getDatabase(new GetDatabaseRequest().withName(schema)).getDatabase();
        }
        catch (EntityNotFoundException ignored) {
            return;
        }
        if (database.getCreateTime().toInstant().isAfter(SCHEMA_CLEANUP_THRESHOLD)) {
            log.info("Skip dropping recently created schema %s", new Object[]{schema});
            return;
        }
        Set allTestTableNames = (Set)this.findAllTablesInSchema(schema).stream().filter(name -> name.toLowerCase(Locale.ENGLISH).startsWith("test")).collect(ImmutableSet.toImmutableSet());
        log.info("Found %d tables to drop in schema %s", new Object[]{allTestTableNames.size(), schema});
        int droppedTablesCount = 0;
        for (String tableName : allTestTableNames) {
            try {
                Table table = glueClient.getTable(new GetTableRequest().withDatabaseName(schema).withName(tableName)).getTable();
                Instant createTime = table.getCreateTime().toInstant();
                if (createTime.isBefore(SCHEMA_CLEANUP_THRESHOLD)) {
                    if (GlueToTrinoConverter.getTableType((Table)table).contains("VIEW")) {
                        QueryExecutors.onTrino().executeQuery(String.format("DROP VIEW IF EXISTS %s.%s", schema, tableName), new QueryExecutor.QueryParam[0]);
                        log.info("Dropped view %s.%s", new Object[]{schema, tableName});
                    } else {
                        QueryExecutors.onTrino().executeQuery(String.format("DROP TABLE IF EXISTS %s.%s", schema, tableName), new QueryExecutor.QueryParam[0]);
                        log.info("Dropped table %s.%s", new Object[]{schema, tableName});
                    }
                    ++droppedTablesCount;
                }
                if (System.currentTimeMillis() - startTime <= MAX_JOB_TIME_MILLIS) continue;
                break;
            }
            catch (Exception e) {
                log.warn((Throwable)e, "Exception while dropping table %s.%s", new Object[]{schema, tableName});
            }
        }
        log.info("Dropped %d tables in schema %s", new Object[]{droppedTablesCount, schema});
        if (!schema.equals("default") && this.findAllTablesInSchema(schema).isEmpty()) {
            try {
                QueryExecutors.onTrino().executeQuery("DROP SCHEMA IF EXISTS " + schema, new QueryExecutor.QueryParam[0]);
                log.info("Dropped schema %s", new Object[]{schema});
            }
            catch (Exception e) {
                log.warn((Throwable)e, "Tried to delete schema %s but failed", new Object[]{schema});
            }
        }
    }

    private Set<String> findAllTablesInSchema(String schema) {
        try {
            QueryResult allTables = QueryExecutors.onTrino().executeQuery(String.format("SELECT table_name FROM information_schema.tables WHERE table_schema = '%s'", schema), new QueryExecutor.QueryParam[0]);
            return allTables.rows().stream().map(row -> (String)row.get(0)).collect(Collectors.toUnmodifiableSet());
        }
        catch (Exception e) {
            log.warn((Throwable)e, "Exception while fetching tables for schema %s", new Object[]{schema});
            return ImmutableSet.of();
        }
    }
}

