/*
 * Decompiled with CFR 0.152.
 */
package io.trino.tests.product.deltalake;

import com.google.common.collect.ImmutableList;
import io.trino.tempto.assertions.QueryAssert;
import io.trino.tempto.query.QueryExecutor;
import io.trino.testing.TestingNames;
import io.trino.tests.product.deltalake.BaseTestDeltaLakeS3Storage;
import io.trino.tests.product.deltalake.util.DeltaLakeTestUtils;
import io.trino.tests.product.utils.QueryExecutors;
import java.util.List;
import org.assertj.core.api.AssertProvider;
import org.assertj.core.api.Assertions;
import org.testng.annotations.Test;

public class TestDeltaLakePartitioningCompatibility
extends BaseTestDeltaLakeS3Storage {
    @Test(groups={"delta-lake-oss", "profile_specific_tests"})
    public void testSparkCanReadFromCtasTableCreatedByTrinoWithSpecialCharactersInPartitioningColumn() {
        this.testSparkCanReadFromCtasTableCreatedByTrinoWithSpecialCharactersInPartitioningColumnWithCpIntervalSet(1);
        this.testSparkCanReadFromCtasTableCreatedByTrinoWithSpecialCharactersInPartitioningColumnWithCpIntervalSet(20);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testSparkCanReadFromCtasTableCreatedByTrinoWithSpecialCharactersInPartitioningColumnWithCpIntervalSet(int interval) {
        String tableName = String.format("test_dl_create_table_partition_by_special_char_with_%d_partitions_%s", interval, TestingNames.randomNameSuffix());
        String tableDirectory = "delta-compatibility-test-" + tableName;
        ImmutableList expected = ImmutableList.of((Object)QueryAssert.Row.row((Object[])new Object[]{1, "with-hyphen"}), (Object)QueryAssert.Row.row((Object[])new Object[]{2, "with.dot"}), (Object)QueryAssert.Row.row((Object[])new Object[]{3, "with:colon"}), (Object)QueryAssert.Row.row((Object[])new Object[]{4, "with/slash"}), (Object)QueryAssert.Row.row((Object[])new Object[]{5, "with\\\\backslash"}), (Object)QueryAssert.Row.row((Object[])new Object[]{6, "with=equal"}), (Object)QueryAssert.Row.row((Object[])new Object[]{7, "with?question"}), (Object)QueryAssert.Row.row((Object[])new Object[]{8, "with!exclamation"}), (Object)QueryAssert.Row.row((Object[])new Object[]{9, "with%percent"}), (Object)QueryAssert.Row.row((Object[])new Object[]{10, "with space"}));
        QueryExecutors.onTrino().executeQuery(String.format("CREATE TABLE delta.default.%s (id, col_name)WITH(location = 's3://%s/%s', partitioned_by = ARRAY['col_name'], checkpoint_interval = " + interval + ") AS VALUES (1, 'with-hyphen'),(2, 'with.dot'),(3, 'with:colon'),(4, 'with/slash'),(5, 'with\\\\backslash'),(6, 'with=equal'),(7, 'with?question'),(8, 'with!exclamation'),(9, 'with%%percent'),(10, 'with space')", tableName, this.bucketName, tableDirectory), new QueryExecutor.QueryParam[0]);
        try {
            ((QueryAssert)Assertions.assertThat((AssertProvider)QueryExecutors.onDelta().executeQuery("SELECT * FROM " + tableName, new QueryExecutor.QueryParam[0]))).containsOnly((List)expected);
            ((QueryAssert)Assertions.assertThat((AssertProvider)QueryExecutors.onTrino().executeQuery("SELECT * FROM delta.default." + tableName, new QueryExecutor.QueryParam[0]))).contains((List)expected);
        }
        finally {
            DeltaLakeTestUtils.dropDeltaTableWithRetry("default." + tableName);
        }
    }

    @Test(groups={"delta-lake-oss", "profile_specific_tests"})
    public void testTrinoCanReadFromCtasTableCreatedBySparkWithSpecialCharactersInPartitioningColumn() {
        this.testTrinoCanReadFromCtasTableCreatedBySparkWithSpecialCharactersInPartitioningColumnWithCpIntervalSet(1);
        this.testTrinoCanReadFromCtasTableCreatedBySparkWithSpecialCharactersInPartitioningColumnWithCpIntervalSet(20);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testTrinoCanReadFromCtasTableCreatedBySparkWithSpecialCharactersInPartitioningColumnWithCpIntervalSet(int interval) {
        String tableName = String.format("test_dl_create_table_partition_by_special_char_with_%d_partitions_%s", interval, TestingNames.randomNameSuffix());
        String tableDirectory = "delta-compatibility-test-" + tableName;
        ImmutableList expected = ImmutableList.of((Object)QueryAssert.Row.row((Object[])new Object[]{1, "with-hyphen"}), (Object)QueryAssert.Row.row((Object[])new Object[]{2, "with.dot"}), (Object)QueryAssert.Row.row((Object[])new Object[]{3, "with:colon"}), (Object)QueryAssert.Row.row((Object[])new Object[]{4, "with/slash"}), (Object)QueryAssert.Row.row((Object[])new Object[]{5, "with\\backslash"}), (Object)QueryAssert.Row.row((Object[])new Object[]{6, "with=equal"}), (Object)QueryAssert.Row.row((Object[])new Object[]{7, "with?question"}), (Object)QueryAssert.Row.row((Object[])new Object[]{8, "with!exclamation"}), (Object)QueryAssert.Row.row((Object[])new Object[]{9, "with%percent"}), (Object)QueryAssert.Row.row((Object[])new Object[]{10, "with space"}));
        QueryExecutors.onDelta().executeQuery(String.format("CREATE TABLE default.%s USING DELTA OPTIONS (checkpointInterval = " + interval + ") PARTITIONED BY (`col_name`) LOCATION 's3://%s/%s' AS SELECT * FROM (VALUES (1, 'with-hyphen'),(2, 'with.dot'),(3, 'with:colon'),(4, 'with/slash'),(5, 'with\\\\backslash'),(6, 'with=equal'),(7, 'with?question'),(8, 'with!exclamation'),(9, 'with%%percent'),(10, 'with space')) t(id, col_name)", tableName, this.bucketName, tableDirectory), new QueryExecutor.QueryParam[0]);
        try {
            ((QueryAssert)Assertions.assertThat((AssertProvider)QueryExecutors.onDelta().executeQuery("SELECT * FROM " + tableName, new QueryExecutor.QueryParam[0]))).containsOnly((List)expected);
            ((QueryAssert)Assertions.assertThat((AssertProvider)QueryExecutors.onTrino().executeQuery("SELECT * FROM delta.default." + tableName, new QueryExecutor.QueryParam[0]))).contains((List)expected);
        }
        finally {
            DeltaLakeTestUtils.dropDeltaTableWithRetry("default." + tableName);
        }
    }

    @Test(groups={"delta-lake-oss", "profile_specific_tests"})
    public void testSparkCanReadTableCreatedByTrinoWithSpecialCharactersInPartitioningColumn() {
        this.testSparkCanReadTableCreatedByTrinoWithSpecialCharactersInPartitioningColumnWithCpIntervalSet(1);
        this.testSparkCanReadTableCreatedByTrinoWithSpecialCharactersInPartitioningColumnWithCpIntervalSet(20);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testSparkCanReadTableCreatedByTrinoWithSpecialCharactersInPartitioningColumnWithCpIntervalSet(int interval) {
        String tableName = String.format("test_dl_create_table_partition_by_special_char_with_%d_partitions_%s", interval, TestingNames.randomNameSuffix());
        String tableDirectory = "delta-compatibility-test-" + tableName;
        ImmutableList expected = ImmutableList.of((Object)QueryAssert.Row.row((Object[])new Object[]{1, "with-hyphen"}), (Object)QueryAssert.Row.row((Object[])new Object[]{2, "with.dot"}), (Object)QueryAssert.Row.row((Object[])new Object[]{3, "with:colon"}), (Object)QueryAssert.Row.row((Object[])new Object[]{4, "with/slash"}), (Object)QueryAssert.Row.row((Object[])new Object[]{5, "with\\\\backslash"}), (Object)QueryAssert.Row.row((Object[])new Object[]{6, "with=equal"}), (Object)QueryAssert.Row.row((Object[])new Object[]{7, "with?question"}), (Object)QueryAssert.Row.row((Object[])new Object[]{8, "with!exclamation"}), (Object)QueryAssert.Row.row((Object[])new Object[]{9, "with%percent"}), (Object)QueryAssert.Row.row((Object[])new Object[]{10, "with space"}));
        QueryExecutors.onTrino().executeQuery(String.format("CREATE TABLE delta.default.%s (id INTEGER, col_name VARCHAR) WITH(location = 's3://%s/%s', partitioned_by = ARRAY['col_name'], checkpoint_interval = " + interval + ") ", tableName, this.bucketName, tableDirectory), new QueryExecutor.QueryParam[0]);
        try {
            QueryExecutors.onTrino().executeQuery(String.format("INSERT INTO delta.default.%s VALUES(1, 'with-hyphen'), (2, 'with.dot'), (3, 'with:colon'), (4, 'with/slash'), (5, 'with\\\\backslash'), (6, 'with=equal'), (7, 'with?question'), (8, 'with!exclamation'), (9, 'with%%percent'),(10, 'with space')", tableName), new QueryExecutor.QueryParam[0]);
            ((QueryAssert)Assertions.assertThat((AssertProvider)QueryExecutors.onDelta().executeQuery("SELECT * FROM " + tableName, new QueryExecutor.QueryParam[0]))).containsOnly((List)expected);
            ((QueryAssert)Assertions.assertThat((AssertProvider)QueryExecutors.onTrino().executeQuery("SELECT * FROM delta.default." + tableName, new QueryExecutor.QueryParam[0]))).contains((List)expected);
        }
        finally {
            DeltaLakeTestUtils.dropDeltaTableWithRetry("default." + tableName);
        }
    }

    @Test(groups={"delta-lake-oss", "profile_specific_tests"})
    public void testTrinoCanReadTableCreatedBySaprkWithSpecialCharactersInPartitioningColumn() {
        this.testTrinoCanReadTableCreatedBySparkWithSpecialCharactersInPartitioningColumnWithCpIntervalSet(1);
        this.testTrinoCanReadTableCreatedBySparkWithSpecialCharactersInPartitioningColumnWithCpIntervalSet(20);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testTrinoCanReadTableCreatedBySparkWithSpecialCharactersInPartitioningColumnWithCpIntervalSet(int interval) {
        String tableName = String.format("test_dl_create_table_partition_by_special_char_with_%d_partitions_%s", interval, TestingNames.randomNameSuffix());
        String tableDirectory = "delta-compatibility-test-" + tableName;
        ImmutableList expected = ImmutableList.of((Object)QueryAssert.Row.row((Object[])new Object[]{1, "with-hyphen"}), (Object)QueryAssert.Row.row((Object[])new Object[]{2, "with.dot"}), (Object)QueryAssert.Row.row((Object[])new Object[]{3, "with:colon"}), (Object)QueryAssert.Row.row((Object[])new Object[]{4, "with/slash"}), (Object)QueryAssert.Row.row((Object[])new Object[]{5, "with\\backslash"}), (Object)QueryAssert.Row.row((Object[])new Object[]{6, "with=equal"}), (Object)QueryAssert.Row.row((Object[])new Object[]{7, "with?question"}), (Object)QueryAssert.Row.row((Object[])new Object[]{8, "with!exclamation"}), (Object)QueryAssert.Row.row((Object[])new Object[]{9, "with%percent"}), (Object)QueryAssert.Row.row((Object[])new Object[]{10, "with space"}));
        QueryExecutors.onDelta().executeQuery(String.format("CREATE TABLE default.%s (id INTEGER, col_name STRING) USING DELTA OPTIONS (checkpointInterval = " + interval + ") PARTITIONED BY (`col_name`) LOCATION 's3://%s/%s'", tableName, this.bucketName, tableDirectory), new QueryExecutor.QueryParam[0]);
        try {
            QueryExecutors.onDelta().executeQuery(String.format("INSERT INTO default.%s VALUES(1, 'with-hyphen'), (2, 'with.dot'), (3, 'with:colon'), (4, 'with/slash'), (5, 'with\\\\backslash'), (6, 'with=equal'), (7, 'with?question'), (8, 'with!exclamation'), (9, 'with%%percent'),(10, 'with space')", tableName), new QueryExecutor.QueryParam[0]);
            ((QueryAssert)Assertions.assertThat((AssertProvider)QueryExecutors.onDelta().executeQuery("SELECT * FROM " + tableName, new QueryExecutor.QueryParam[0]))).containsOnly((List)expected);
            ((QueryAssert)Assertions.assertThat((AssertProvider)QueryExecutors.onTrino().executeQuery("SELECT * FROM delta.default." + tableName, new QueryExecutor.QueryParam[0]))).contains((List)expected);
        }
        finally {
            DeltaLakeTestUtils.dropDeltaTableWithRetry("default." + tableName);
        }
    }

    @Test(groups={"delta-lake-oss", "profile_specific_tests"})
    public void testSparkCanReadFromTableUpdatedByTrino() {
        this.testSparkCanReadFromTableUpdatedByTrinoWithCpIntervalSet(1);
        this.testSparkCanReadFromTableUpdatedByTrinoWithCpIntervalSet(20);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testSparkCanReadFromTableUpdatedByTrinoWithCpIntervalSet(int interval) {
        String tableName = String.format("test_dl_create_table_partition_by_special_char_with_%d_partitions_%s", interval, TestingNames.randomNameSuffix());
        String tableDirectory = "delta-compatibility-test-" + tableName;
        ImmutableList expected = ImmutableList.of((Object)QueryAssert.Row.row((Object[])new Object[]{101, "with-hyphen"}), (Object)QueryAssert.Row.row((Object[])new Object[]{102, "with.dot"}), (Object)QueryAssert.Row.row((Object[])new Object[]{103, "with:colon"}), (Object)QueryAssert.Row.row((Object[])new Object[]{104, "with/slash"}), (Object)QueryAssert.Row.row((Object[])new Object[]{105, "with\\\\backslash"}), (Object)QueryAssert.Row.row((Object[])new Object[]{106, "with=equal"}), (Object)QueryAssert.Row.row((Object[])new Object[]{107, "with?question"}), (Object)QueryAssert.Row.row((Object[])new Object[]{108, "with!exclamation"}), (Object)QueryAssert.Row.row((Object[])new Object[]{109, "with%percent"}), (Object)QueryAssert.Row.row((Object[])new Object[]{110, "with space"}));
        QueryExecutors.onTrino().executeQuery(String.format("CREATE TABLE delta.default.%s (id, col_name) WITH(location = 's3://%s/%s', partitioned_by = ARRAY['col_name'], checkpoint_interval = " + interval + ") AS VALUES (1, 'with-hyphen'),(2, 'with.dot'),(3, 'with:colon'),(4, 'with/slash'),(5, 'with\\\\backslash'),(6, 'with=equal'),(7, 'with?question'),(8, 'with!exclamation'),(9, 'with%%percent'),(10, 'with space')", tableName, this.bucketName, tableDirectory), new QueryExecutor.QueryParam[0]);
        try {
            QueryExecutors.onTrino().executeQuery(String.format("UPDATE delta.default.%s SET id = id + 100", tableName), new QueryExecutor.QueryParam[0]);
            ((QueryAssert)Assertions.assertThat((AssertProvider)QueryExecutors.onDelta().executeQuery("SELECT * FROM " + tableName, new QueryExecutor.QueryParam[0]))).containsOnly((List)expected);
            ((QueryAssert)Assertions.assertThat((AssertProvider)QueryExecutors.onTrino().executeQuery("SELECT * FROM delta.default." + tableName, new QueryExecutor.QueryParam[0]))).contains((List)expected);
        }
        finally {
            DeltaLakeTestUtils.dropDeltaTableWithRetry("default." + tableName);
        }
    }

    @Test(groups={"delta-lake-oss", "profile_specific_tests"})
    public void testTrinoCanReadFromTableUpdatedBySpark() {
        this.testTrinoCanReadFromTableUpdatedBySparkWithCpIntervalSet(1);
        this.testTrinoCanReadFromTableUpdatedBySparkWithCpIntervalSet(20);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testTrinoCanReadFromTableUpdatedBySparkWithCpIntervalSet(int interval) {
        String tableName = String.format("test_dl_create_table_partition_by_special_char_with_%d_partitions_%s", interval, TestingNames.randomNameSuffix());
        String tableDirectory = "delta-compatibility-test-" + tableName;
        ImmutableList expected = ImmutableList.of((Object)QueryAssert.Row.row((Object[])new Object[]{101, "with-hyphen"}), (Object)QueryAssert.Row.row((Object[])new Object[]{102, "with.dot"}), (Object)QueryAssert.Row.row((Object[])new Object[]{103, "with:colon"}), (Object)QueryAssert.Row.row((Object[])new Object[]{104, "with/slash"}), (Object)QueryAssert.Row.row((Object[])new Object[]{105, "with\\backslash"}), (Object)QueryAssert.Row.row((Object[])new Object[]{106, "with=equal"}), (Object)QueryAssert.Row.row((Object[])new Object[]{107, "with?question"}), (Object)QueryAssert.Row.row((Object[])new Object[]{108, "with!exclamation"}), (Object)QueryAssert.Row.row((Object[])new Object[]{109, "with%percent"}), (Object)QueryAssert.Row.row((Object[])new Object[]{110, "with space"}));
        QueryExecutors.onDelta().executeQuery(String.format("CREATE TABLE default.%s USING DELTA OPTIONS (checkpointInterval = " + interval + ") PARTITIONED BY (`col_name`) LOCATION 's3://%s/%s' AS SELECT * FROM (VALUES (1, 'with-hyphen'),(2, 'with.dot'),(3, 'with:colon'),(4, 'with/slash'),(5, 'with\\\\backslash'),(6, 'with=equal'),(7, 'with?question'),(8, 'with!exclamation'),(9, 'with%%percent'),(10, 'with space')) t(id, col_name)", tableName, this.bucketName, tableDirectory), new QueryExecutor.QueryParam[0]);
        try {
            QueryExecutors.onDelta().executeQuery(String.format("UPDATE default.%s SET id = id + 100", tableName), new QueryExecutor.QueryParam[0]);
            ((QueryAssert)Assertions.assertThat((AssertProvider)QueryExecutors.onDelta().executeQuery("SELECT * FROM " + tableName, new QueryExecutor.QueryParam[0]))).containsOnly((List)expected);
            ((QueryAssert)Assertions.assertThat((AssertProvider)QueryExecutors.onTrino().executeQuery("SELECT * FROM delta.default." + tableName, new QueryExecutor.QueryParam[0]))).contains((List)expected);
        }
        finally {
            DeltaLakeTestUtils.dropDeltaTableWithRetry("default." + tableName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(groups={"delta-lake-oss", "profile_specific_tests"})
    public void testTrinoCanReadFromTablePartitionChangedBySpark() {
        String tableName = "test_dl_create_table_partition_changed_by_spark_" + TestingNames.randomNameSuffix();
        String tableDirectory = "delta-compatibility-test-" + tableName;
        ImmutableList expected = ImmutableList.of((Object)QueryAssert.Row.row((Object[])new Object[]{1, "part"}));
        QueryExecutors.onDelta().executeQuery(String.format("CREATE TABLE default.%s USING DELTA PARTITIONED BY (`original_part_col`) LOCATION 's3://%s/%s' AS SELECT 1 AS original_part_col, 'part' AS new_part_col", tableName, this.bucketName, tableDirectory), new QueryExecutor.QueryParam[0]);
        try {
            ((QueryAssert)Assertions.assertThat((AssertProvider)QueryExecutors.onTrino().executeQuery("SELECT * FROM delta.default." + tableName, new QueryExecutor.QueryParam[0]))).contains((List)expected);
            QueryExecutors.onDelta().executeQuery("REPLACE TABLE default." + tableName + " USING DELTA PARTITIONED BY (new_part_col) AS SELECT * FROM " + tableName, new QueryExecutor.QueryParam[0]);
            ((QueryAssert)Assertions.assertThat((AssertProvider)QueryExecutors.onTrino().executeQuery("SELECT * FROM delta.default." + tableName, new QueryExecutor.QueryParam[0]))).contains((List)expected);
        }
        finally {
            DeltaLakeTestUtils.dropDeltaTableWithRetry("default." + tableName);
        }
    }

    @Test(groups={"delta-lake-oss", "profile_specific_tests"})
    public void testPartitionedByNonLowercaseColumn() {
        String tableName = "test_dl_partitioned_by_non_lowercase_" + TestingNames.randomNameSuffix();
        String tableDirectory = "delta-compatibility-test-" + tableName;
        QueryExecutors.onDelta().executeQuery(String.format("CREATE TABLE default.%s USING DELTA PARTITIONED BY (`PART`) LOCATION 's3://%s/%s' AS SELECT 1 AS data, 2 AS `PART`", tableName, this.bucketName, tableDirectory), new QueryExecutor.QueryParam[0]);
        try {
            ((QueryAssert)Assertions.assertThat((AssertProvider)QueryExecutors.onTrino().executeQuery("SELECT * FROM delta.default." + tableName, new QueryExecutor.QueryParam[0]))).contains(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{1, 2})});
            QueryExecutors.onTrino().executeQuery("INSERT INTO delta.default." + tableName + " VALUES (3, 4)", new QueryExecutor.QueryParam[0]);
            ((QueryAssert)Assertions.assertThat((AssertProvider)QueryExecutors.onTrino().executeQuery("SELECT * FROM delta.default." + tableName, new QueryExecutor.QueryParam[0]))).contains(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{1, 2}), QueryAssert.Row.row((Object[])new Object[]{3, 4})});
            QueryExecutors.onTrino().executeQuery("DELETE FROM delta.default." + tableName + " WHERE data = 3", new QueryExecutor.QueryParam[0]);
            ((QueryAssert)Assertions.assertThat((AssertProvider)QueryExecutors.onTrino().executeQuery("SELECT * FROM delta.default." + tableName, new QueryExecutor.QueryParam[0]))).contains(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{1, 2})});
            QueryExecutors.onTrino().executeQuery("UPDATE delta.default." + tableName + " SET part = 20", new QueryExecutor.QueryParam[0]);
            ((QueryAssert)Assertions.assertThat((AssertProvider)QueryExecutors.onTrino().executeQuery("SELECT * FROM delta.default." + tableName, new QueryExecutor.QueryParam[0]))).contains(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{1, 20})});
            QueryExecutors.onTrino().executeQuery("MERGE INTO delta.default." + tableName + " USING (SELECT 1 a) input ON true WHEN MATCHED THEN DELETE", new QueryExecutor.QueryParam[0]);
            ((QueryAssert)Assertions.assertThat((AssertProvider)QueryExecutors.onTrino().executeQuery("SELECT * FROM delta.default." + tableName, new QueryExecutor.QueryParam[0]))).hasNoRows();
        }
        finally {
            DeltaLakeTestUtils.dropDeltaTableWithRetry("default." + tableName);
        }
    }
}

