/*
 * Decompiled with CFR 0.152.
 */
package io.trino.tests.product.hive;

import com.google.common.collect.ImmutableList;
import io.trino.tempto.assertions.QueryAssert;
import io.trino.tempto.query.QueryExecutor;
import io.trino.tests.product.hive.HiveProductTest;
import io.trino.tests.product.utils.QueryExecutors;
import java.sql.SQLException;
import java.util.List;
import org.assertj.core.api.AssertProvider;
import org.assertj.core.api.Assertions;
import org.testng.annotations.Test;

public class TestHivePropertiesTable
extends HiveProductTest {
    @Test
    public void testTrinoViewPropertiesTable() throws Exception {
        QueryExecutors.onTrino().executeQuery("DROP TABLE IF EXISTS test_trino_view_properties_base", new QueryExecutor.QueryParam[0]);
        QueryExecutors.onTrino().executeQuery("DROP VIEW IF EXISTS test_trino_view_properties", new QueryExecutor.QueryParam[0]);
        QueryExecutors.onTrino().executeQuery("CREATE TABLE test_trino_view_properties_base (col INT)", new QueryExecutor.QueryParam[0]);
        QueryExecutors.onTrino().executeQuery("CREATE VIEW test_trino_view_properties AS SELECT * FROM test_trino_view_properties_base", new QueryExecutor.QueryParam[0]);
        ((QueryAssert)Assertions.assertThat((AssertProvider)QueryExecutors.onTrino().executeQuery("SHOW COLUMNS FROM \"test_trino_view_properties$properties\"", new QueryExecutor.QueryParam[0]))).containsExactlyInOrder(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{"comment", "varchar", "", ""}), QueryAssert.Row.row((Object[])new Object[]{"presto_query_id", "varchar", "", ""}), QueryAssert.Row.row((Object[])new Object[]{"presto_version", "varchar", "", ""}), QueryAssert.Row.row((Object[])new Object[]{"presto_view", "varchar", "", ""}), QueryAssert.Row.row((Object[])new Object[]{"transient_lastddltime", "varchar", "", ""}), QueryAssert.Row.row((Object[])new Object[]{"trino_created_by", "varchar", "", ""})});
        ((QueryAssert)Assertions.assertThat((AssertProvider)QueryExecutors.onTrino().executeQuery("SELECT * FROM \"test_trino_view_properties$properties\"", new QueryExecutor.QueryParam[0]))).hasRowsCount(1).containsExactlyInOrder(new QueryAssert.Row[]{new QueryAssert.Row(TestHivePropertiesTable.getTablePropertiesOnHive("test_trino_view_properties"))});
        QueryExecutors.onTrino().executeQuery("DROP VIEW IF EXISTS test_trino_view_properties", new QueryExecutor.QueryParam[0]);
        QueryExecutors.onTrino().executeQuery("DROP TABLE IF EXISTS test_trino_view_properties_base", new QueryExecutor.QueryParam[0]);
    }

    @Test(groups={"hive_views"})
    public void testHiveViewPropertiesTable() throws Exception {
        QueryExecutors.onTrino().executeQuery("DROP TABLE IF EXISTS test_hive_view_properties_base", new QueryExecutor.QueryParam[0]);
        QueryExecutors.onTrino().executeQuery("DROP VIEW IF EXISTS test_hive_view_properties", new QueryExecutor.QueryParam[0]);
        QueryExecutors.onTrino().executeQuery("CREATE TABLE test_hive_view_properties_base (col INT)", new QueryExecutor.QueryParam[0]);
        QueryExecutors.onHive().executeQuery("CREATE VIEW test_hive_view_properties AS SELECT * FROM test_hive_view_properties_base", new QueryExecutor.QueryParam[0]);
        ((QueryAssert)Assertions.assertThat((AssertProvider)QueryExecutors.onTrino().executeQuery("SHOW COLUMNS FROM \"test_hive_view_properties$properties\"", new QueryExecutor.QueryParam[0]))).contains(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{"transient_lastddltime", "varchar", "", ""})});
        ((QueryAssert)Assertions.assertThat((AssertProvider)QueryExecutors.onTrino().executeQuery("SELECT * FROM \"test_hive_view_properties$properties\"", new QueryExecutor.QueryParam[0]))).hasRowsCount(1).containsExactlyInOrder(new QueryAssert.Row[]{new QueryAssert.Row(TestHivePropertiesTable.getTablePropertiesOnHive("test_hive_view_properties"))});
        QueryExecutors.onTrino().executeQuery("DROP VIEW IF EXISTS test_hive_view_properties", new QueryExecutor.QueryParam[0]);
        QueryExecutors.onTrino().executeQuery("DROP TABLE IF EXISTS test_hive_view_properties_base", new QueryExecutor.QueryParam[0]);
    }

    private static List<String> getTablePropertiesOnHive(String tableName) throws SQLException {
        return (List)QueryExecutors.onHive().executeQuery("SHOW TBLPROPERTIES " + tableName, new QueryExecutor.QueryParam[0]).rows().stream().map(row -> (String)row.get(1)).collect(ImmutableList.toImmutableList());
    }
}

