/*
 * Decompiled with CFR 0.152.
 */
package io.trino.tests.product.hive;

import io.trino.tempto.AfterMethodWithContext;
import io.trino.tempto.BeforeMethodWithContext;
import io.trino.tempto.ProductTest;
import io.trino.tempto.assertions.QueryAssert;
import io.trino.tempto.query.QueryExecutor;
import io.trino.tests.product.utils.QueryExecutors;
import org.assertj.core.api.AssertProvider;
import org.assertj.core.api.Assertions;
import org.testng.annotations.Test;

public class TestSqlStandardAccessControlChecks
extends ProductTest {
    private String tableName = "alice_owned_table";
    private String viewName = "alice_owned_view";
    private QueryExecutor aliceExecutor;
    private QueryExecutor bobExecutor;
    private QueryExecutor charlieExecutor;
    private QueryExecutor caseSensitiveUserNameExecutor;
    private QueryExecutor hdfsExecutor;

    @BeforeMethodWithContext
    public void setup() {
        this.aliceExecutor = QueryExecutors.connectToTrino("alice@presto");
        this.bobExecutor = QueryExecutors.connectToTrino("bob@presto");
        this.charlieExecutor = QueryExecutors.connectToTrino("charlie@presto");
        this.caseSensitiveUserNameExecutor = QueryExecutors.connectToTrino("CaseSensitiveUserName@presto");
        this.hdfsExecutor = QueryExecutors.connectToTrino("hdfs@presto");
        this.aliceExecutor.executeQuery(String.format("DROP TABLE IF EXISTS %s", this.tableName), new QueryExecutor.QueryParam[0]);
        this.aliceExecutor.executeQuery(String.format("CREATE TABLE %s(month bigint, day bigint) WITH (partitioned_by = ARRAY['day'])", this.tableName), new QueryExecutor.QueryParam[0]);
        this.aliceExecutor.executeQuery(String.format("DROP VIEW IF EXISTS %s", this.viewName), new QueryExecutor.QueryParam[0]);
        this.aliceExecutor.executeQuery(String.format("CREATE VIEW %s AS SELECT month, day FROM %s", this.viewName, this.tableName), new QueryExecutor.QueryParam[0]);
    }

    @AfterMethodWithContext
    public void cleanup() {
        this.aliceExecutor = null;
        this.bobExecutor = null;
        this.charlieExecutor = null;
        this.caseSensitiveUserNameExecutor = null;
        this.hdfsExecutor = null;
    }

    @Test(groups={"authorization", "profile_specific_tests"})
    public void testAccessControlSelect() {
        QueryAssert.assertQueryFailure(() -> this.bobExecutor.executeQuery(String.format("SELECT * FROM %s", this.tableName), new QueryExecutor.QueryParam[0])).hasMessageContaining("Access Denied: Cannot select from table default.%s", new Object[]{this.tableName});
        this.aliceExecutor.executeQuery(String.format("GRANT SELECT ON %s TO bob", this.tableName), new QueryExecutor.QueryParam[0]);
        ((QueryAssert)Assertions.assertThat((AssertProvider)this.bobExecutor.executeQuery(String.format("SELECT * FROM %s", this.tableName), new QueryExecutor.QueryParam[0]))).hasNoRows();
        QueryAssert.assertQueryFailure(() -> this.bobExecutor.executeQuery(String.format("SELECT * FROM %s", this.viewName), new QueryExecutor.QueryParam[0])).hasMessageContaining("Access Denied: Cannot select from table default.%s", new Object[]{this.viewName});
        this.aliceExecutor.executeQuery(String.format("GRANT SELECT ON %s TO bob", this.viewName), new QueryExecutor.QueryParam[0]);
        ((QueryAssert)Assertions.assertThat((AssertProvider)this.bobExecutor.executeQuery(String.format("SELECT * FROM %s", this.viewName), new QueryExecutor.QueryParam[0]))).hasNoRows();
    }

    @Test(groups={"authorization", "profile_specific_tests"})
    public void testAccessControlSelectFromPartitions() {
        QueryAssert.assertQueryFailure(() -> this.bobExecutor.executeQuery(String.format("SELECT * FROM \"%s$partitions\"", this.tableName), new QueryExecutor.QueryParam[0])).hasMessageContaining("Access Denied: Cannot select from table default.%s$partitions", new Object[]{this.tableName});
        this.aliceExecutor.executeQuery(String.format("GRANT SELECT ON %s TO bob", this.tableName), new QueryExecutor.QueryParam[0]);
        ((QueryAssert)Assertions.assertThat((AssertProvider)this.bobExecutor.executeQuery(String.format("SELECT * FROM \"%s$partitions\"", this.tableName), new QueryExecutor.QueryParam[0]))).hasNoRows();
    }

    @Test(groups={"authorization", "profile_specific_tests"})
    public void testAccessControlInsert() {
        QueryAssert.assertQueryFailure(() -> this.bobExecutor.executeQuery(String.format("INSERT INTO %s VALUES (3, 22)", this.tableName), new QueryExecutor.QueryParam[0])).hasMessageContaining("Access Denied: Cannot insert into table default.%s", new Object[]{this.tableName});
        this.aliceExecutor.executeQuery(String.format("GRANT INSERT ON %s TO bob", this.tableName), new QueryExecutor.QueryParam[0]);
        ((QueryAssert)Assertions.assertThat((AssertProvider)this.bobExecutor.executeQuery(String.format("INSERT INTO %s VALUES (3, 22)", this.tableName), new QueryExecutor.QueryParam[0]))).hasRowsCount(1);
        ((QueryAssert)Assertions.assertThat((AssertProvider)this.aliceExecutor.executeQuery(String.format("SELECT * FROM %s", this.tableName), new QueryExecutor.QueryParam[0]))).hasRowsCount(1);
    }

    @Test(groups={"authorization", "profile_specific_tests"})
    public void testAccessControlUpdate() {
        QueryAssert.assertQueryFailure(() -> this.bobExecutor.executeQuery(String.format("UPDATE %s SET month=3, day=22", this.tableName), new QueryExecutor.QueryParam[0])).hasMessageContaining("Access Denied: Cannot update columns [month, day] in table default.%s", new Object[]{this.tableName});
        this.aliceExecutor.executeQuery(String.format("GRANT INSERT ON %s TO bob", this.tableName), new QueryExecutor.QueryParam[0]);
        QueryAssert.assertQueryFailure(() -> this.bobExecutor.executeQuery(String.format("UPDATE %s SET month=3, day=22", this.tableName), new QueryExecutor.QueryParam[0])).hasMessageContaining("Access Denied: Cannot update columns [month, day] in table default.%s", new Object[]{this.tableName});
        this.aliceExecutor.executeQuery(String.format("GRANT UPDATE ON %s TO bob", this.tableName), new QueryExecutor.QueryParam[0]);
        QueryAssert.assertQueryFailure(() -> this.bobExecutor.executeQuery(String.format("UPDATE %s SET month=3, day=22", this.tableName), new QueryExecutor.QueryParam[0])).hasMessageContaining("Modifying Hive table rows is only supported for transactional tables");
    }

    @Test(groups={"authorization", "profile_specific_tests"})
    public void testAccessControlDelete() {
        this.aliceExecutor.executeQuery(String.format("INSERT INTO %s VALUES (4, 13)", this.tableName), new QueryExecutor.QueryParam[0]);
        ((QueryAssert)Assertions.assertThat((AssertProvider)this.aliceExecutor.executeQuery(String.format("SELECT * FROM %s", this.tableName), new QueryExecutor.QueryParam[0]))).hasRowsCount(1);
        QueryAssert.assertQueryFailure(() -> this.bobExecutor.executeQuery(String.format("DELETE FROM %s WHERE day=4", this.tableName), new QueryExecutor.QueryParam[0])).hasMessageContaining("Access Denied: Cannot delete from table default.%s", new Object[]{this.tableName});
        this.aliceExecutor.executeQuery(String.format("GRANT DELETE ON %s TO bob", this.tableName), new QueryExecutor.QueryParam[0]);
        this.bobExecutor.executeQuery(String.format("DELETE FROM %s", this.tableName), new QueryExecutor.QueryParam[0]);
        ((QueryAssert)Assertions.assertThat((AssertProvider)this.aliceExecutor.executeQuery(String.format("SELECT * FROM %s", this.tableName), new QueryExecutor.QueryParam[0]))).hasNoRows();
    }

    @Test(groups={"authorization", "profile_specific_tests"})
    public void testAccessControlCreateTableAsSelect() {
        String createTableAsSelect = "bob_create_table_as_select";
        this.bobExecutor.executeQuery("DROP TABLE IF EXISTS " + createTableAsSelect, new QueryExecutor.QueryParam[0]);
        QueryAssert.assertQueryFailure(() -> this.bobExecutor.executeQuery(String.format("CREATE TABLE %s AS SELECT * FROM %s", createTableAsSelect, this.tableName), new QueryExecutor.QueryParam[0])).hasMessageContaining("Access Denied: Cannot select from table default.%s", new Object[]{this.tableName});
        this.aliceExecutor.executeQuery(String.format("GRANT SELECT ON %s TO bob", this.tableName), new QueryExecutor.QueryParam[0]);
        this.bobExecutor.executeQuery(String.format("CREATE TABLE %s AS SELECT * FROM %s", createTableAsSelect, this.tableName), new QueryExecutor.QueryParam[0]);
        ((QueryAssert)Assertions.assertThat((AssertProvider)this.bobExecutor.executeQuery(String.format("SELECT * FROM %s", createTableAsSelect), new QueryExecutor.QueryParam[0]))).hasNoRows();
        this.bobExecutor.executeQuery("DROP TABLE " + createTableAsSelect, new QueryExecutor.QueryParam[0]);
    }

    @Test(groups={"authorization", "profile_specific_tests"})
    public void testAccessControlDropTable() {
        QueryAssert.assertQueryFailure(() -> this.bobExecutor.executeQuery(String.format("DROP TABLE %s", this.tableName), new QueryExecutor.QueryParam[0])).hasMessageContaining("Access Denied: Cannot drop table default.%s", new Object[]{this.tableName});
        this.aliceExecutor.executeQuery(String.format("DROP TABLE %s", this.tableName), new QueryExecutor.QueryParam[0]);
        QueryAssert.assertQueryFailure(() -> this.aliceExecutor.executeQuery(String.format("SELECT * FROM %s", this.tableName), new QueryExecutor.QueryParam[0])).hasMessageContaining("does not exist");
    }

    @Test(groups={"authorization", "profile_specific_tests"})
    public void testAccessControlAlterTable() {
        ((QueryAssert)Assertions.assertThat((AssertProvider)this.aliceExecutor.executeQuery(String.format("SHOW COLUMNS FROM %s", this.tableName), new QueryExecutor.QueryParam[0]))).hasRowsCount(2);
        QueryAssert.assertQueryFailure(() -> this.bobExecutor.executeQuery(String.format("ALTER TABLE %s ADD COLUMN year bigint", this.tableName), new QueryExecutor.QueryParam[0])).hasMessageContaining("Access Denied: Cannot add a column to table default.%s", new Object[]{this.tableName});
        this.aliceExecutor.executeQuery(String.format("ALTER TABLE %s ADD COLUMN year bigint", this.tableName), new QueryExecutor.QueryParam[0]);
        ((QueryAssert)Assertions.assertThat((AssertProvider)this.aliceExecutor.executeQuery(String.format("SHOW COLUMNS FROM %s", this.tableName), new QueryExecutor.QueryParam[0]))).hasRowsCount(3);
    }

    @Test(groups={"authorization", "profile_specific_tests"})
    public void testAccessControlCreateView() {
        String viewName = "bob_view";
        String selectTableSql = String.format("SELECT * FROM %s", this.tableName);
        String createViewSql = String.format("CREATE VIEW %s AS %s", viewName, selectTableSql);
        this.bobExecutor.executeQuery(String.format("DROP VIEW IF EXISTS %s", viewName), new QueryExecutor.QueryParam[0]);
        this.bobExecutor.executeQuery("DROP VIEW IF EXISTS " + viewName, new QueryExecutor.QueryParam[0]);
        QueryAssert.assertQueryFailure(() -> this.bobExecutor.executeQuery(createViewSql, new QueryExecutor.QueryParam[0])).hasMessageContaining("Access Denied: Cannot select from table default.%s", new Object[]{this.tableName});
        this.aliceExecutor.executeQuery(String.format("GRANT SELECT ON %s TO bob", this.tableName), new QueryExecutor.QueryParam[0]);
        this.bobExecutor.executeQuery(createViewSql, new QueryExecutor.QueryParam[0]);
        ((QueryAssert)Assertions.assertThat((AssertProvider)this.bobExecutor.executeQuery(String.format("SELECT * FROM %s", viewName), new QueryExecutor.QueryParam[0]))).hasNoRows();
        QueryAssert.assertQueryFailure(() -> this.charlieExecutor.executeQuery(String.format("SELECT * FROM %s", viewName), new QueryExecutor.QueryParam[0])).hasMessageContaining("Access Denied: Cannot select from table default.%s", new Object[]{viewName});
        this.bobExecutor.executeQuery(String.format("GRANT SELECT ON %s TO charlie", viewName), new QueryExecutor.QueryParam[0]);
        QueryAssert.assertQueryFailure(() -> this.charlieExecutor.executeQuery(String.format("SELECT * FROM %s", viewName), new QueryExecutor.QueryParam[0])).hasMessageContaining("Access Denied: View owner does not have sufficient privileges: View owner 'bob' cannot create view that selects from default.%s", new Object[]{this.tableName});
        this.aliceExecutor.executeQuery(String.format("REVOKE SELECT ON %s FROM bob", this.tableName), new QueryExecutor.QueryParam[0]);
        this.aliceExecutor.executeQuery(String.format("GRANT SELECT ON %s TO bob WITH GRANT OPTION", this.tableName), new QueryExecutor.QueryParam[0]);
        ((QueryAssert)Assertions.assertThat((AssertProvider)this.bobExecutor.executeQuery(String.format("SELECT * FROM %s", viewName), new QueryExecutor.QueryParam[0]))).hasNoRows();
        ((QueryAssert)Assertions.assertThat((AssertProvider)this.charlieExecutor.executeQuery(String.format("SELECT * FROM %s", viewName), new QueryExecutor.QueryParam[0]))).hasNoRows();
        this.bobExecutor.executeQuery("DROP VIEW " + viewName, new QueryExecutor.QueryParam[0]);
    }

    @Test(groups={"authorization", "profile_specific_tests"})
    public void testAccessControlDropView() {
        String viewName = "alice_view_for_drop";
        this.aliceExecutor.executeQuery("DROP VIEW IF EXISTS " + viewName, new QueryExecutor.QueryParam[0]);
        this.aliceExecutor.executeQuery(String.format("CREATE VIEW %s AS SELECT * FROM %s", viewName, this.tableName), new QueryExecutor.QueryParam[0]);
        QueryAssert.assertQueryFailure(() -> this.bobExecutor.executeQuery(String.format("DROP VIEW %s", viewName), new QueryExecutor.QueryParam[0])).hasMessageContaining("Access Denied: Cannot drop view default.%s", new Object[]{viewName});
        this.aliceExecutor.executeQuery(String.format("DROP VIEW %s", viewName), new QueryExecutor.QueryParam[0]);
        QueryAssert.assertQueryFailure(() -> this.aliceExecutor.executeQuery(String.format("SELECT * FROM %s", viewName), new QueryExecutor.QueryParam[0])).hasMessageContaining("does not exist");
    }

    @Test(groups={"authorization", "profile_specific_tests"})
    public void testAccessControlSelectWithCaseSensitiveUserName() {
        QueryAssert.assertQueryFailure(() -> this.caseSensitiveUserNameExecutor.executeQuery(String.format("SELECT * FROM %s", this.tableName), new QueryExecutor.QueryParam[0])).hasMessageContaining("Access Denied: Cannot select from table default.%s", new Object[]{this.tableName});
        QueryExecutors.onHive().executeQuery("SET ROLE admin", new QueryExecutor.QueryParam[0]);
        QueryExecutors.onHive().executeQuery(String.format("GRANT SELECT ON TABLE %s TO USER casesensitiveusername", this.tableName), new QueryExecutor.QueryParam[0]);
        QueryAssert.assertQueryFailure(() -> this.caseSensitiveUserNameExecutor.executeQuery(String.format("SELECT * FROM %s", this.tableName), new QueryExecutor.QueryParam[0])).hasMessageContaining("Access Denied: Cannot select from table default.%s", new Object[]{this.tableName});
        QueryExecutors.onHive().executeQuery(String.format("GRANT SELECT ON TABLE %s TO USER CaseSensitiveUserName", this.tableName), new QueryExecutor.QueryParam[0]);
        ((QueryAssert)Assertions.assertThat((AssertProvider)this.caseSensitiveUserNameExecutor.executeQuery(String.format("SELECT * FROM %s", this.tableName), new QueryExecutor.QueryParam[0]))).hasNoRows();
        QueryAssert.assertQueryFailure(() -> this.caseSensitiveUserNameExecutor.executeQuery(String.format("SELECT * FROM %s", this.viewName), new QueryExecutor.QueryParam[0])).hasMessageContaining("Access Denied: Cannot select from table default.%s", new Object[]{this.viewName});
        QueryExecutors.onHive().executeQuery(String.format("GRANT SELECT ON TABLE %s TO USER CaseSensitiveUserName", this.viewName), new QueryExecutor.QueryParam[0]);
        ((QueryAssert)Assertions.assertThat((AssertProvider)this.caseSensitiveUserNameExecutor.executeQuery(String.format("SELECT * FROM %s", this.viewName), new QueryExecutor.QueryParam[0]))).hasNoRows();
    }

    @Test(groups={"authorization", "profile_specific_tests"})
    public void testAccessControlSetTableAuthorization() {
        String tableName = "set_table_authorization_test";
        this.aliceExecutor.executeQuery(String.format("CREATE TABLE %s(col1 bigint, col2 bigint)", tableName), new QueryExecutor.QueryParam[0]);
        QueryAssert.assertQueryFailure(() -> this.bobExecutor.executeQuery(String.format("ALTER TABLE %s SET AUTHORIZATION bob", tableName), new QueryExecutor.QueryParam[0])).hasMessageContaining("Access Denied: Cannot set authorization for table default.%s to USER bob", new Object[]{tableName});
        this.hdfsExecutor.executeQuery("SET SESSION legacy_catalog_roles=true", new QueryExecutor.QueryParam[0]);
        this.hdfsExecutor.executeQuery("SET ROLE ADMIN", new QueryExecutor.QueryParam[0]);
        this.hdfsExecutor.executeQuery(String.format("ALTER TABLE %s SET AUTHORIZATION bob", tableName), new QueryExecutor.QueryParam[0]);
        this.bobExecutor.executeQuery("DROP TABLE " + tableName, new QueryExecutor.QueryParam[0]);
    }

    @Test(groups={"authorization", "profile_specific_tests"})
    public void testAccessControlSetViewAuthorization() {
        QueryAssert.assertQueryFailure(() -> this.bobExecutor.executeQuery(String.format("ALTER VIEW %s SET AUTHORIZATION bob", this.viewName), new QueryExecutor.QueryParam[0])).hasMessageContaining("Access Denied: Cannot set authorization for view default.%s to USER bob", new Object[]{this.viewName});
        QueryAssert.assertQueryFailure(() -> this.bobExecutor.executeQuery(String.format("DROP VIEW %s", this.viewName), new QueryExecutor.QueryParam[0])).hasMessageContaining("Access Denied: Cannot drop view default.%s", new Object[]{this.viewName});
        this.hdfsExecutor.executeQuery("SET SESSION legacy_catalog_roles=true", new QueryExecutor.QueryParam[0]);
        this.hdfsExecutor.executeQuery("SET ROLE ADMIN", new QueryExecutor.QueryParam[0]);
        this.hdfsExecutor.executeQuery(String.format("ALTER VIEW %s SET AUTHORIZATION bob", this.viewName), new QueryExecutor.QueryParam[0]);
        this.bobExecutor.executeQuery(String.format("DROP VIEW %s", this.viewName), new QueryExecutor.QueryParam[0]);
    }

    @Test(groups={"authorization", "profile_specific_tests"})
    public void testAccessControlSetHiveViewAuthorization() {
        QueryExecutors.onHive().executeQuery("CREATE TABLE test_hive_table (col1 int)", new QueryExecutor.QueryParam[0]);
        QueryExecutors.onHive().executeQuery("CREATE VIEW test_hive_view AS SELECT * FROM test_hive_table", new QueryExecutor.QueryParam[0]);
        QueryAssert.assertQueryFailure(() -> this.bobExecutor.executeQuery("ALTER VIEW test_hive_view SET AUTHORIZATION bob", new QueryExecutor.QueryParam[0])).hasMessageContaining("Access Denied: Cannot set authorization for view default.test_hive_view to USER bob");
        QueryAssert.assertQueryFailure(() -> this.bobExecutor.executeQuery("DROP VIEW test_hive_view", new QueryExecutor.QueryParam[0])).hasMessageContaining("Access Denied: Cannot drop view default.test_hive_view");
        this.hdfsExecutor.executeQuery("SET SESSION legacy_catalog_roles=true", new QueryExecutor.QueryParam[0]);
        this.hdfsExecutor.executeQuery("SET ROLE ADMIN", new QueryExecutor.QueryParam[0]);
        this.hdfsExecutor.executeQuery("ALTER VIEW test_hive_view SET AUTHORIZATION bob", new QueryExecutor.QueryParam[0]);
        this.bobExecutor.executeQuery("DROP VIEW test_hive_view", new QueryExecutor.QueryParam[0]);
        QueryExecutors.onHive().executeQuery("DROP TABLE test_hive_table", new QueryExecutor.QueryParam[0]);
    }

    @Test(groups={"authorization", "profile_specific_tests"})
    public void testAccessControlShowColumns() {
        QueryAssert.assertQueryFailure(() -> this.bobExecutor.executeQuery(String.format("SHOW COLUMNS FROM %s", this.tableName), new QueryExecutor.QueryParam[0])).hasMessageContaining("Access Denied: Cannot show columns of table default.%s", new Object[]{this.tableName});
        this.aliceExecutor.executeQuery(String.format("GRANT SELECT ON %s TO bob", this.tableName), new QueryExecutor.QueryParam[0]);
        ((QueryAssert)Assertions.assertThat((AssertProvider)this.bobExecutor.executeQuery(String.format("SHOW COLUMNS FROM %s", this.tableName), new QueryExecutor.QueryParam[0]))).hasRowsCount(2);
    }

    @Test(groups={"authorization", "profile_specific_tests"})
    public void testAccessControlShowStatsFor() {
        QueryAssert.assertQueryFailure(() -> this.bobExecutor.executeQuery(String.format("SHOW STATS FOR %s", this.tableName), new QueryExecutor.QueryParam[0])).hasMessageContaining("Access Denied: Cannot select from table default.%s", new Object[]{this.tableName});
        this.aliceExecutor.executeQuery(String.format("GRANT SELECT ON %s TO bob", this.tableName), new QueryExecutor.QueryParam[0]);
        ((QueryAssert)Assertions.assertThat((AssertProvider)this.bobExecutor.executeQuery(String.format("SHOW STATS FOR %s", this.tableName), new QueryExecutor.QueryParam[0]))).hasRowsCount(3);
    }

    @Test(groups={"authorization", "profile_specific_tests"})
    public void testAccessControlFilterColumns() {
        ((QueryAssert)Assertions.assertThat((AssertProvider)this.bobExecutor.executeQuery(String.format("SELECT * FROM information_schema.columns WHERE table_name = '%s'", this.tableName), new QueryExecutor.QueryParam[0]))).hasNoRows();
        this.aliceExecutor.executeQuery(String.format("GRANT SELECT ON %s TO bob", this.tableName), new QueryExecutor.QueryParam[0]);
        ((QueryAssert)Assertions.assertThat((AssertProvider)this.bobExecutor.executeQuery(String.format("SELECT * FROM information_schema.columns WHERE table_name = '%s'", this.tableName), new QueryExecutor.QueryParam[0]))).hasRowsCount(2);
    }
}

