/*
 * Decompiled with CFR 0.152.
 */
package io.trino.tests.product.hudi;

import io.trino.tempto.ProductTest;
import io.trino.tempto.assertions.QueryAssert;
import io.trino.tempto.query.QueryExecutor;
import io.trino.testing.TestingNames;
import io.trino.tests.product.utils.QueryExecutors;
import org.testng.annotations.Test;

public class TestHudiHiveViewsCompatibility
extends ProductTest {
    @Test(groups={"hudi", "profile_specific_tests"})
    public void testHudiSelectFromHiveView() {
        String tableName = "hudi_from_hive_table_" + TestingNames.randomNameSuffix();
        String viewName = "hudi_from_trino_hive_view_" + TestingNames.randomNameSuffix();
        QueryExecutors.onTrino().executeQuery("CREATE TABLE hive.default." + tableName + " AS SELECT 1 a", new QueryExecutor.QueryParam[0]);
        QueryExecutors.onTrino().executeQuery("CREATE VIEW hive.default." + viewName + " AS TABLE hive.default." + tableName, new QueryExecutor.QueryParam[0]);
        QueryAssert.assertQueryFailure(() -> QueryExecutors.onTrino().executeQuery("SELECT * FROM hudi.default." + viewName, new QueryExecutor.QueryParam[0])).hasMessageMatching("Query failed \\(#\\w+\\):\\Q Not a Hudi table: default." + viewName);
        QueryExecutors.onTrino().executeQuery("DROP VIEW hive.default." + viewName, new QueryExecutor.QueryParam[0]);
        QueryExecutors.onTrino().executeQuery("DROP TABLE hive.default." + tableName, new QueryExecutor.QueryParam[0]);
    }

    @Test(groups={"hudi", "profile_specific_tests"})
    public void testHiveSelectFromHudiView() {
        QueryAssert.assertQueryFailure(() -> QueryExecutors.onTrino().executeQuery("CREATE VIEW hudi.default.a_new_view AS SELECT 1 a", new QueryExecutor.QueryParam[0])).hasMessageMatching("Query failed \\(#\\w+\\):\\Q This connector does not support creating views");
    }
}

