/*
 * Decompiled with CFR 0.152.
 */
package io.trino.tests.product.iceberg;

import com.google.common.collect.ImmutableList;
import io.airlift.concurrent.MoreFutures;
import io.trino.tempto.ProductTest;
import io.trino.tempto.assertions.QueryAssert;
import io.trino.tempto.query.QueryExecutionException;
import io.trino.tempto.query.QueryExecutor;
import io.trino.testing.TestingNames;
import io.trino.tests.product.utils.QueryExecutors;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.CyclicBarrier;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.stream.IntStream;
import org.assertj.core.api.AssertProvider;
import org.assertj.core.api.Assertions;
import org.testng.annotations.Test;

public class TestIcebergInsert
extends ProductTest {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(groups={"iceberg", "storage_formats_detailed", "hms_only"}, timeOut=60000L)
    public void testIcebergConcurrentInsert() throws Exception {
        int threads = 3;
        int insertsPerThread = 4;
        String tableName = "iceberg.default.test_insert_concurrent_" + TestingNames.randomNameSuffix();
        QueryExecutors.onTrino().executeQuery("CREATE TABLE " + tableName + "(a bigint)", new QueryExecutor.QueryParam[0]);
        ExecutorService executor = Executors.newFixedThreadPool(threads);
        try {
            CyclicBarrier barrier = new CyclicBarrier(threads);
            QueryExecutor onTrino = QueryExecutors.onTrino();
            List allInserted = (List)executor.invokeAll((Collection)IntStream.range(0, threads).mapToObj(thread -> () -> {
                ArrayList<Long> inserted = new ArrayList<Long>();
                for (int i = 0; i < insertsPerThread; ++i) {
                    barrier.await(20L, TimeUnit.SECONDS);
                    long value = (long)i + (long)insertsPerThread * (long)thread;
                    try {
                        onTrino.executeQuery("INSERT INTO " + tableName + " VALUES " + value, new QueryExecutor.QueryParam[0]);
                    }
                    catch (QueryExecutionException queryExecutionException) {
                        continue;
                    }
                    inserted.add(value);
                }
                return inserted;
            }).collect(ImmutableList.toImmutableList())).stream().map(MoreFutures::getDone).flatMap(Collection::stream).collect(ImmutableList.toImmutableList());
            Assertions.assertThat((List)allInserted).hasSizeBetween(insertsPerThread, threads * insertsPerThread);
            ((QueryAssert)Assertions.assertThat((AssertProvider)QueryExecutors.onTrino().executeQuery("SELECT * FROM " + tableName, new QueryExecutor.QueryParam[0]))).containsOnly((QueryAssert.Row[])allInserted.stream().map(xva$0 -> QueryAssert.Row.row((Object[])new Object[]{xva$0})).toArray(QueryAssert.Row[]::new));
            QueryExecutors.onTrino().executeQuery("DROP TABLE " + tableName, new QueryExecutor.QueryParam[0]);
        }
        finally {
            executor.shutdownNow();
        }
    }
}

