/*
 * Decompiled with CFR 0.152.
 */
package io.trino.tests.product;

import io.trino.tempto.ProductTest;
import io.trino.tempto.Requires;
import io.trino.tempto.assertions.QueryAssert;
import io.trino.tempto.context.ContextDsl;
import io.trino.tempto.context.ContextProvider;
import io.trino.tempto.fulfillment.table.hive.tpch.ImmutableTpchTablesRequirements;
import io.trino.tempto.query.QueryExecutor;
import io.trino.tempto.sql.SqlContexts;
import io.trino.tests.product.utils.QueryExecutors;
import org.assertj.core.api.AssertProvider;
import org.assertj.core.api.Assertions;
import org.testng.annotations.Test;

@Requires(value={ImmutableTpchTablesRequirements.ImmutableNationTable.class})
public class TestCreateDropView
extends ProductTest {
    @Test(groups={"create_drop_view"})
    public void createSimpleView() {
        ContextDsl.executeWith((ContextProvider)SqlContexts.createViewAs((String)"SELECT * FROM nation", (QueryExecutor)QueryExecutors.onTrino()), view -> ((QueryAssert)Assertions.assertThat((AssertProvider)QueryExecutors.onTrino().executeQuery(String.format("SELECT * FROM %s", view.getName()), new QueryExecutor.QueryParam[0]))).hasRowsCount(25));
    }

    @Test(groups={"create_drop_view"})
    public void querySimpleViewQualified() {
        ContextDsl.executeWith((ContextProvider)SqlContexts.createViewAs((String)"SELECT * FROM nation", (QueryExecutor)QueryExecutors.onTrino()), view -> ((QueryAssert)Assertions.assertThat((AssertProvider)QueryExecutors.onTrino().executeQuery(String.format("SELECT %s.n_regionkey FROM %s", view.getName(), view.getName()), new QueryExecutor.QueryParam[0]))).hasRowsCount(25));
    }

    @Test(groups={"create_drop_view"})
    public void createViewWithAggregate() {
        ContextDsl.executeWith((ContextProvider)SqlContexts.createViewAs((String)"SELECT n_regionkey, count(*) countries FROM nation GROUP BY n_regionkey ORDER BY n_regionkey", (QueryExecutor)QueryExecutors.onTrino()), view -> ((QueryAssert)Assertions.assertThat((AssertProvider)QueryExecutors.onTrino().executeQuery(String.format("SELECT * FROM %s", view.getName()), new QueryExecutor.QueryParam[0]))).hasRowsCount(5));
    }

    @Test(groups={"create_drop_view", "smoke"})
    public void createOrReplaceSimpleView() {
        ContextDsl.executeWith((ContextProvider)SqlContexts.createViewAs((String)"SELECT * FROM nation", (QueryExecutor)QueryExecutors.onTrino()), view -> {
            ((QueryAssert)Assertions.assertThat((AssertProvider)QueryExecutors.onTrino().executeQuery(String.format("CREATE OR REPLACE VIEW %s AS SELECT * FROM nation", view.getName()), new QueryExecutor.QueryParam[0]))).hasRowsCount(1);
            ((QueryAssert)Assertions.assertThat((AssertProvider)QueryExecutors.onTrino().executeQuery(String.format("SELECT * FROM %s", view.getName()), new QueryExecutor.QueryParam[0]))).hasRowsCount(25);
        });
    }

    @Test(groups={"create_drop_view"})
    public void createSimpleViewTwiceShouldFail() {
        ContextDsl.executeWith((ContextProvider)SqlContexts.createViewAs((String)"SELECT * FROM nation", (QueryExecutor)QueryExecutors.onTrino()), view -> {
            QueryAssert.assertQueryFailure(() -> QueryExecutors.onTrino().executeQuery(String.format("CREATE VIEW %s AS SELECT * FROM nation", view.getName()), new QueryExecutor.QueryParam[0])).hasMessageContaining("View already exists");
            ((QueryAssert)Assertions.assertThat((AssertProvider)QueryExecutors.onTrino().executeQuery(String.format("SELECT * FROM %s", view.getName()), new QueryExecutor.QueryParam[0]))).hasRowsCount(25);
        });
    }

    @Test(groups={"create_drop_view", "smoke"})
    public void dropViewTest() {
        ContextDsl.executeWith((ContextProvider)SqlContexts.createViewAs((String)"SELECT * FROM nation", (QueryExecutor)QueryExecutors.onTrino()), view -> {
            ((QueryAssert)Assertions.assertThat((AssertProvider)QueryExecutors.onTrino().executeQuery(String.format("SELECT * FROM %s", view.getName()), new QueryExecutor.QueryParam[0]))).hasRowsCount(25);
            ((QueryAssert)Assertions.assertThat((AssertProvider)QueryExecutors.onTrino().executeQuery(String.format("DROP VIEW %s", view.getName()), new QueryExecutor.QueryParam[0]))).hasRowsCount(1);
            QueryAssert.assertQueryFailure(() -> QueryExecutors.onTrino().executeQuery(String.format("SELECT * FROM %s", view.getName()), new QueryExecutor.QueryParam[0])).hasMessageContaining("does not exist");
        });
    }
}

