/*
 * Decompiled with CFR 0.152.
 */
package io.trino.tests.product.deltalake.util;

import com.amazonaws.services.glue.model.ConcurrentModificationException;
import com.amazonaws.services.s3.AmazonS3;
import com.amazonaws.services.s3.model.DeleteObjectsRequest;
import com.amazonaws.services.s3.model.ObjectListing;
import com.amazonaws.services.s3.model.S3ObjectSummary;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.common.collect.MoreCollectors;
import dev.failsafe.Failsafe;
import dev.failsafe.Policy;
import dev.failsafe.RetryPolicy;
import dev.failsafe.RetryPolicyBuilder;
import io.airlift.log.Logger;
import io.trino.tempto.query.QueryExecutionException;
import io.trino.tempto.query.QueryExecutor;
import io.trino.tempto.query.QueryResult;
import io.trino.testing.TestingNames;
import io.trino.tests.product.deltalake.util.DatabricksVersion;
import io.trino.tests.product.utils.QueryExecutors;
import java.time.temporal.ChronoUnit;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.assertj.core.api.Assertions;
import org.intellij.lang.annotations.Language;
import org.testng.SkipException;

public final class DeltaLakeTestUtils {
    private static final Logger log = Logger.get(DeltaLakeTestUtils.class);
    public static final String DATABRICKS_COMMUNICATION_FAILURE_ISSUE = "https://github.com/trinodb/trino/issues/14391";
    @Language(value="RegExp")
    public static final String DATABRICKS_COMMUNICATION_FAILURE_MATCH = "\\Q[Databricks][DatabricksJDBCDriver](500593) Communication link failure. Failed to connect to server. Reason: \\E(HTTP retry after response received with no Retry-After header, error: HTTP Response code: 503|HTTP Response code: 504), Error message: Unknown.";
    private static final RetryPolicy<QueryResult> CONCURRENT_MODIFICATION_EXCEPTION_RETRY_POLICY = ((RetryPolicyBuilder)((RetryPolicyBuilder)RetryPolicy.builder().handleIf(throwable -> Throwables.getRootCause((Throwable)throwable) instanceof ConcurrentModificationException)).handleIf(throwable -> throwable.getMessage() != null && throwable.getMessage().contains("Table being modified concurrently"))).withBackoff(1L, 10L, ChronoUnit.SECONDS).withMaxRetries(3).onRetry(event -> log.warn(event.getLastException(), "Query failed on attempt %d, will retry.", new Object[]{event.getAttemptCount()})).build();

    private DeltaLakeTestUtils() {
    }

    public static Optional<DatabricksVersion> getDatabricksRuntimeVersion() {
        String version = (String)QueryExecutors.onDelta().executeQuery("SELECT java_method('java.lang.System', 'getenv', 'DATABRICKS_RUNTIME_VERSION')", new QueryExecutor.QueryParam[0]).getOnlyValue();
        if (version.equals("null")) {
            return Optional.empty();
        }
        return Optional.of(DatabricksVersion.parse(version));
    }

    public static void skipTestUnlessUnsupportedWriterVersionExists() {
        String tableName = "test_dl_unsupported_writer_version_" + TestingNames.randomNameSuffix();
        try {
            QueryExecutors.onDelta().executeQuery("CREATE TABLE default." + tableName + "(col int) USING DELTA TBLPROPERTIES ('delta.minWriterVersion'='8')", new QueryExecutor.QueryParam[0]);
            DeltaLakeTestUtils.dropDeltaTableWithRetry("default." + tableName);
        }
        catch (QueryExecutionException e) {
            Assertions.assertThat((Throwable)e).hasMessageMatching("(?s).* delta.minWriterVersion needs to be (an integer between \\[1, 7]|one of 1, 2, 3, 4, 5(, 6)?, 7).*");
            throw new SkipException("Cannot test unsupported writer version");
        }
    }

    public static List<String> getColumnNamesOnDelta(String schemaName, String tableName) {
        QueryResult result = QueryExecutors.onDelta().executeQuery("SHOW COLUMNS IN " + schemaName + "." + tableName, new QueryExecutor.QueryParam[0]);
        return result.column(1);
    }

    public static String getColumnCommentOnTrino(String schemaName, String tableName, String columnName) {
        return (String)QueryExecutors.onTrino().executeQuery("SELECT comment FROM delta.information_schema.columns WHERE table_schema = '" + schemaName + "' AND table_name = '" + tableName + "' AND column_name = '" + columnName + "'", new QueryExecutor.QueryParam[0]).getOnlyValue();
    }

    public static String getColumnCommentOnDelta(String schemaName, String tableName, String columnName) {
        QueryResult result = QueryExecutors.onDelta().executeQuery(String.format("DESCRIBE %s.%s %s", schemaName, tableName, columnName), new QueryExecutor.QueryParam[0]);
        return (String)result.row(2).get(1);
    }

    public static String getTableCommentOnTrino(String schemaName, String tableName) {
        return (String)QueryExecutors.onTrino().executeQuery("SELECT comment FROM system.metadata.table_comments WHERE catalog_name = 'delta' AND schema_name = '" + schemaName + "' AND table_name = '" + tableName + "'", new QueryExecutor.QueryParam[0]).getOnlyValue();
    }

    public static String getTableCommentOnDelta(String schemaName, String tableName) {
        QueryResult result = QueryExecutors.onDelta().executeQuery(String.format("DESCRIBE EXTENDED %s.%s", schemaName, tableName), new QueryExecutor.QueryParam[0]);
        return (String)result.rows().stream().filter(row -> row.get(0).equals("Comment")).map(row -> row.get(1)).collect(MoreCollectors.onlyElement());
    }

    public static Map<String, String> getTablePropertiesOnDelta(String schemaName, String tableName) {
        QueryResult result = QueryExecutors.onDelta().executeQuery("SHOW TBLPROPERTIES %s.%s".formatted(schemaName, tableName), new QueryExecutor.QueryParam[0]);
        return (Map)result.rows().stream().map(column -> Map.entry((String)column.get(0), (String)column.get(1))).collect(ImmutableMap.toImmutableMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    public static String getTablePropertyOnDelta(String schemaName, String tableName, String propertyName) {
        QueryResult result = QueryExecutors.onDelta().executeQuery("SHOW TBLPROPERTIES %s.%s(%s)".formatted(schemaName, tableName, propertyName), new QueryExecutor.QueryParam[0]);
        return (String)((List)Iterables.getOnlyElement((Iterable)result.rows())).get(1);
    }

    public static QueryResult dropDeltaTableWithRetry(String tableName) {
        return (QueryResult)Failsafe.with(CONCURRENT_MODIFICATION_EXCEPTION_RETRY_POLICY, (Policy[])new RetryPolicy[0]).get(() -> QueryExecutors.onDelta().executeQuery("DROP TABLE IF EXISTS " + tableName, new QueryExecutor.QueryParam[0]));
    }

    public static void removeS3Directory(AmazonS3 s3, String bucketName, String directoryPrefix) {
        ObjectListing listing = s3.listObjects(bucketName, directoryPrefix);
        do {
            List objectKeys = (List)listing.getObjectSummaries().stream().map(S3ObjectSummary::getKey).collect(ImmutableList.toImmutableList());
            DeleteObjectsRequest deleteObjectsRequest = new DeleteObjectsRequest(bucketName).withKeys(objectKeys.toArray(new String[0]));
            log.info("Deleting keys: %s", new Object[]{objectKeys});
            s3.deleteObjects(deleteObjectsRequest);
        } while ((listing = s3.listNextBatchOfObjects(listing)).isTruncated());
    }
}

