/*
 * Decompiled with CFR 0.152.
 */
package io.trino.tests.product.hive;

import com.google.inject.Inject;
import io.trino.tempto.ProductTest;
import io.trino.tempto.assertions.QueryAssert;
import io.trino.tempto.hadoop.hdfs.HdfsClient;
import io.trino.tempto.query.QueryExecutor;
import io.trino.tests.product.utils.QueryExecutors;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.sql.JDBCType;
import org.assertj.core.api.AssertProvider;
import org.assertj.core.api.Assertions;
import org.testng.annotations.Test;

public class TestAvroSchemaStrictness
extends ProductTest {
    private static final Path ILLEGAL_UNION_DEFAULT_SCHEMA = Path.of("/docker/presto-product-tests/avro/invalid_default.avsc", new String[0]);
    private static final Path ILLEGAL_UNION_DEFAULT_DATA = Path.of("/docker/presto-product-tests/avro/invalid_default.avro", new String[0]);
    @Inject
    private HdfsClient hdfsClient;

    @Test(groups={"avro"})
    public void testInvalidUnionDefaults() throws IOException {
        String tableName = "invalid_union_default";
        String tablePath = String.format("/tmp/%s", tableName);
        String schemaPath = String.format("/tmp/%s.avsc", tableName);
        this.hdfsClient.createDirectory(tablePath);
        this.copyToHdfs(ILLEGAL_UNION_DEFAULT_DATA, Path.of(tablePath, "data.avro").toString());
        this.copyToHdfs(ILLEGAL_UNION_DEFAULT_SCHEMA, schemaPath);
        QueryExecutors.onTrino().executeQuery(String.format("CREATE TABLE %s (x int) with (\nformat = 'AVRO',\navro_schema_url = ?,\nexternal_location = ?\n)", tableName), new QueryExecutor.QueryParam[]{QueryExecutor.param((JDBCType)JDBCType.VARCHAR, (Object)schemaPath), QueryExecutor.param((JDBCType)JDBCType.VARCHAR, (Object)tablePath)});
        ((QueryAssert)Assertions.assertThat((AssertProvider)QueryExecutors.onTrino().executeQuery("SELECT valid, invalid FROM " + tableName, new QueryExecutor.QueryParam[0]))).containsOnly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{"valid", "invalid"}), QueryAssert.Row.row((Object[])new Object[]{null, null})});
    }

    private String getHdfsPath(String firstSubPath, String ... more) {
        return Path.of(firstSubPath, more).toString();
    }

    private void copyToHdfs(Path file, String hdfsPath) throws IOException {
        try (InputStream input = Files.newInputStream(file, new OpenOption[0]);){
            this.hdfsClient.saveFile(hdfsPath, input);
        }
    }
}

