/*
 * Decompiled with CFR 0.152.
 */
package io.trino.tests.product.hive;

import io.trino.tempto.ProductTest;
import io.trino.tempto.assertions.QueryAssert;
import io.trino.tempto.query.QueryExecutor;
import io.trino.tests.product.utils.QueryExecutors;
import org.assertj.core.api.AssertProvider;
import org.assertj.core.api.Assertions;
import org.testng.annotations.Test;

public class TestCsvFileHiveTable
extends ProductTest {
    @Test
    public void testCreateCsvFileTableAsSelectSkipHeaderFooter() {
        QueryExecutors.onHive().executeQuery("DROP TABLE IF EXISTS test_create_csv_skip_header", new QueryExecutor.QueryParam[0]);
        QueryExecutors.onTrino().executeQuery("CREATE TABLE test_create_csv_skip_header WITH (    format = 'CSV',    skip_header_line_count = 1 ) AS SELECT CAST(1 AS VARCHAR)  AS col_name1, CAST(2 AS VARCHAR) AS col_name2;", new QueryExecutor.QueryParam[0]);
        QueryExecutors.onTrino().executeQuery("INSERT INTO test_create_csv_skip_header VALUES ('3', '4')", new QueryExecutor.QueryParam[0]);
        ((QueryAssert)Assertions.assertThat((AssertProvider)QueryExecutors.onTrino().executeQuery("SELECT * FROM test_create_csv_skip_header", new QueryExecutor.QueryParam[0]))).containsOnly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{"1", "2"}), QueryAssert.Row.row((Object[])new Object[]{"3", "4"})});
        ((QueryAssert)Assertions.assertThat((AssertProvider)QueryExecutors.onHive().executeQuery("SELECT * FROM test_create_csv_skip_header", new QueryExecutor.QueryParam[0]))).containsOnly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{"1", "2"}), QueryAssert.Row.row((Object[])new Object[]{"3", "4"})});
        QueryExecutors.onHive().executeQuery("DROP TABLE test_create_csv_skip_header", new QueryExecutor.QueryParam[0]);
        QueryExecutors.onHive().executeQuery("DROP TABLE IF EXISTS test_create_csv_skip_footer", new QueryExecutor.QueryParam[0]);
        Assertions.assertThatThrownBy(() -> QueryExecutors.onTrino().executeQuery("CREATE TABLE test_create_csv_skip_footer WITH (    format = 'CSV',    skip_footer_line_count = 1 ) AS SELECT CAST(1 AS VARCHAR)  AS col_header;", new QueryExecutor.QueryParam[0])).hasMessageMatching(".* Creating Hive table with data with value of skip.footer.line.count property greater than 0 is not supported");
        QueryExecutors.onHive().executeQuery("DROP TABLE test_create_csv_skip_footer", new QueryExecutor.QueryParam[0]);
    }
}

