/*
 * Decompiled with CFR 0.152.
 */
package io.trino.tests.product.hive;

import com.google.common.base.Preconditions;
import com.google.common.io.Closer;
import io.trino.tempto.AfterMethodWithContext;
import io.trino.tempto.BeforeMethodWithContext;
import io.trino.tempto.query.QueryExecutor;
import io.trino.tempto.query.QueryResult;
import io.trino.tests.product.utils.QueryExecutors;
import java.io.IOException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.assertj.core.api.Assertions;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestHiveConnectorKerberosSmokeTest {
    private Closer closer;
    private ExecutorService executor;

    @BeforeMethodWithContext
    public void setUp() {
        this.closer = Closer.create();
        this.executor = Executors.newSingleThreadExecutor();
        this.closer.register(this.executor::shutdownNow);
    }

    @AfterMethodWithContext
    public void cleanUp() throws IOException {
        this.executor = null;
        this.closer.close();
        this.closer = null;
    }

    @Test(groups={"hive_kerberos", "profile_specific_tests"}, timeOut=120000L)
    public void kerberosTicketExpiryTest() throws Exception {
        QueryExecutors.onTrino().executeQuery("SET SESSION scale_writers = false", new QueryExecutor.QueryParam[0]);
        QueryExecutors.onTrino().executeQuery("SET SESSION task_scale_writers_enabled = false", new QueryExecutor.QueryParam[0]);
        String sql = "CREATE TABLE orders AS SELECT * FROM tpch.sf1000.orders";
        Future<QueryResult> queryExecution = this.executor.submit(() -> QueryExecutors.onTrino().executeQuery(sql, new QueryExecutor.QueryParam[0]));
        TimeUnit.SECONDS.sleep(60L);
        this.cancelQueryIfRunning(sql);
        try {
            queryExecution.get(30L, TimeUnit.SECONDS);
            Assert.fail((String)"Expected query to have failed");
        }
        catch (TimeoutException e) {
            queryExecution.cancel(true);
            throw e;
        }
        catch (ExecutionException expected) {
            Assertions.assertThat((Throwable)expected.getCause()).hasMessageEndingWith("Message: explicitly cancelled for test without failure");
        }
    }

    private void cancelQueryIfRunning(String sql) {
        QueryResult queryResult = QueryExecutors.onTrino().executeQuery("SELECT query_id FROM system.runtime.queries WHERE query = '%s' AND state = 'RUNNING' LIMIT 2".formatted(sql), new QueryExecutor.QueryParam[0]);
        Preconditions.checkState((queryResult.getRowsCount() < 2 ? 1 : 0) != 0, (Object)"Found multiple queries");
        if (queryResult.getRowsCount() == 1) {
            String queryId = (String)queryResult.getOnlyValue();
            QueryExecutors.onTrino().executeQuery("CALL system.runtime.kill_query(query_id => '%s', message => 'explicitly cancelled for test without failure')".formatted(queryId), new QueryExecutor.QueryParam[0]);
        }
    }
}

