/*
 * Decompiled with CFR 0.152.
 */
package io.trino.tests.product.hive;

import com.google.inject.Inject;
import io.trino.tempto.ProductTest;
import io.trino.tempto.assertions.QueryAssert;
import io.trino.tempto.hadoop.hdfs.HdfsClient;
import io.trino.tempto.query.QueryExecutor;
import io.trino.testing.TestingNames;
import io.trino.tests.product.hive.util.TableLocationUtils;
import io.trino.tests.product.utils.QueryExecutors;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import org.assertj.core.api.AssertProvider;
import org.assertj.core.api.Assertions;
import org.testng.annotations.Test;

public class TestHiveHiddenFiles
extends ProductTest {
    @Inject
    private HdfsClient hdfsClient;

    @Test
    public void testSelectFromTableContainingHiddenFiles() throws Exception {
        String tableName = "test_table_hidden_files" + TestingNames.randomNameSuffix();
        QueryExecutors.onTrino().executeQuery("CREATE TABLE " + tableName + " (col integer)", new QueryExecutor.QueryParam[0]);
        QueryExecutors.onTrino().executeQuery("INSERT INTO " + tableName + " VALUES 1", new QueryExecutor.QueryParam[0]);
        QueryExecutors.onTrino().executeQuery("INSERT INTO " + tableName + " VALUES 2", new QueryExecutor.QueryParam[0]);
        List<QueryAssert.Row> tableRows = List.of(QueryAssert.Row.row((Object[])new Object[]{1}), QueryAssert.Row.row((Object[])new Object[]{2}));
        ((QueryAssert)Assertions.assertThat((AssertProvider)QueryExecutors.onTrino().executeQuery("SELECT * FROM " + tableName, new QueryExecutor.QueryParam[0]))).containsOnly(tableRows);
        ((QueryAssert)Assertions.assertThat((AssertProvider)QueryExecutors.onHive().executeQuery("SELECT * FROM " + tableName, new QueryExecutor.QueryParam[0]))).containsOnly(tableRows);
        String tableLocation = TableLocationUtils.getTablePath(tableName);
        List tableFiles = this.hdfsClient.listDirectory(tableLocation);
        Assertions.assertThat((List)tableFiles).hasSize(2);
        this.renameFile(tableLocation, (String)tableFiles.get(0), "." + (String)tableFiles.get(0));
        this.renameFile(tableLocation, (String)tableFiles.get(1), "_" + (String)tableFiles.get(1));
        ((QueryAssert)Assertions.assertThat((AssertProvider)QueryExecutors.onTrino().executeQuery("SELECT * FROM " + tableName, new QueryExecutor.QueryParam[0]))).hasNoRows();
        ((QueryAssert)Assertions.assertThat((AssertProvider)QueryExecutors.onHive().executeQuery("SELECT * FROM " + tableName, new QueryExecutor.QueryParam[0]))).hasNoRows();
        QueryExecutors.onTrino().executeQuery("DROP TABLE IF EXISTS " + tableName, new QueryExecutor.QueryParam[0]);
    }

    @Test
    public void testSelectFromTableContainingFilenamesWithUnderscore() throws Exception {
        String tableName = "test_table_visible_underscore_files" + TestingNames.randomNameSuffix();
        QueryExecutors.onTrino().executeQuery("CREATE TABLE " + tableName + " AS SELECT 1 AS col", new QueryExecutor.QueryParam[0]);
        List<QueryAssert.Row> tableRows = List.of(QueryAssert.Row.row((Object[])new Object[]{1}));
        ((QueryAssert)Assertions.assertThat((AssertProvider)QueryExecutors.onTrino().executeQuery("SELECT * FROM " + tableName, new QueryExecutor.QueryParam[0]))).containsOnly(tableRows);
        ((QueryAssert)Assertions.assertThat((AssertProvider)QueryExecutors.onHive().executeQuery("SELECT * FROM " + tableName, new QueryExecutor.QueryParam[0]))).containsOnly(tableRows);
        String tableLocation = TableLocationUtils.getTablePath(tableName);
        for (String filename : this.hdfsClient.listDirectory(tableLocation)) {
            this.renameFile(tableLocation, filename, "f_" + filename);
        }
        ((QueryAssert)Assertions.assertThat((AssertProvider)QueryExecutors.onTrino().executeQuery("SELECT * FROM " + tableName, new QueryExecutor.QueryParam[0]))).containsOnly(tableRows);
        ((QueryAssert)Assertions.assertThat((AssertProvider)QueryExecutors.onHive().executeQuery("SELECT * FROM " + tableName, new QueryExecutor.QueryParam[0]))).containsOnly(tableRows);
        QueryExecutors.onTrino().executeQuery("DROP TABLE " + tableName, new QueryExecutor.QueryParam[0]);
    }

    private void renameFile(String directoryLocation, String filename, String newFilename) throws IOException {
        try (ByteArrayOutputStream bos = new ByteArrayOutputStream();){
            this.hdfsClient.loadFile(directoryLocation + "/" + filename, (OutputStream)bos);
            this.hdfsClient.saveFile(directoryLocation + "/" + newFilename, (InputStream)new ByteArrayInputStream(bos.toByteArray()));
            this.hdfsClient.delete(directoryLocation + "/" + filename);
        }
    }
}

