/*
 * Decompiled with CFR 0.152.
 */
package io.trino.tests.product.hive;

import com.google.common.io.Resources;
import com.google.inject.Inject;
import com.google.inject.name.Named;
import io.trino.tempto.AfterMethodWithContext;
import io.trino.tempto.BeforeMethodWithContext;
import io.trino.tempto.ProductTest;
import io.trino.tempto.assertions.QueryAssert;
import io.trino.tempto.hadoop.hdfs.HdfsClient;
import io.trino.tempto.query.QueryExecutor;
import io.trino.testing.TestingNames;
import io.trino.tests.product.utils.QueryExecutors;
import java.io.InputStream;
import java.net.URL;
import org.assertj.core.api.AssertProvider;
import org.assertj.core.api.Assertions;
import org.testng.annotations.Test;

public class TestParquetFileWithReorderedColumns
extends ProductTest {
    @Inject
    private HdfsClient hdfsClient;
    @Inject
    @Named(value="databases.hive.warehouse_directory_path")
    private String warehouseDirectory;

    @BeforeMethodWithContext
    public void setup() throws Exception {
        this.hdfsClient.createDirectory(this.warehouseDirectory + "/TestParquetFileWithReorderedColumns");
        try (InputStream inputStream = Resources.asByteSource((URL)Resources.getResource((String)"parquet/reordered_columns.parquet")).openStream();){
            this.hdfsClient.saveFile(this.warehouseDirectory + "/TestParquetFileWithReorderedColumns/reordered_columns.parquet", inputStream);
        }
    }

    @AfterMethodWithContext
    public void cleanup() {
        this.hdfsClient.delete(this.warehouseDirectory + "/TestParquetFileWithReorderedColumns");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(groups={"hive_spark", "profile_specific_tests"})
    public void testReadParquetFileWithReorderedColumns() {
        String sourceTableName = "test_reordered_columns_table_" + TestingNames.randomNameSuffix();
        String tableName = "test_read_reordered_columns_table_" + TestingNames.randomNameSuffix();
        try {
            QueryExecutors.onTrino().executeQuery(String.format("CREATE TABLE %s (id bigint, buyplan_style_detail_id bigint, last_modified_on bigint) WITH (    format = 'PARQUET',    external_location = 'hdfs://hadoop-master:9000%s/TestParquetFileWithReorderedColumns/' )", sourceTableName, this.warehouseDirectory), new QueryExecutor.QueryParam[0]);
            QueryExecutors.onTrino().executeQuery(String.format("CREATE TABLE %s WITH (format = 'PARQUET') AS SELECT * FROM %s", tableName, sourceTableName), new QueryExecutor.QueryParam[0]);
            String sql = "SELECT COUNT(*), SUM(id), SUM(buyplan_style_detail_id), SUM(last_modified_on) FROM " + tableName;
            ((QueryAssert)Assertions.assertThat((AssertProvider)QueryExecutors.onTrino().executeQuery(sql, new QueryExecutor.QueryParam[0]))).containsExactlyInOrder(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{50438L, 323043905052L, 67694121262L, 83905381446283000L})});
            ((QueryAssert)Assertions.assertThat((AssertProvider)QueryExecutors.onHive().executeQuery(sql, new QueryExecutor.QueryParam[0]))).containsExactlyInOrder(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{50438L, 323043905052L, 67694121262L, 83905381446283000L})});
            ((QueryAssert)Assertions.assertThat((AssertProvider)QueryExecutors.onSpark().executeQuery(sql, new QueryExecutor.QueryParam[0]))).containsExactlyInOrder(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{50438L, 323043905052L, 67694121262L, 83905381446283000L})});
        }
        finally {
            QueryExecutors.onTrino().executeQuery("DROP TABLE " + tableName, new QueryExecutor.QueryParam[0]);
            QueryExecutors.onTrino().executeQuery("DROP TABLE " + sourceTableName, new QueryExecutor.QueryParam[0]);
        }
    }
}

