/*
 * Decompiled with CFR 0.152.
 */
package io.trino.tests.product.hive;

import io.trino.jdbc.Row;
import io.trino.jdbc.RowField;
import io.trino.tempto.AfterMethodWithContext;
import io.trino.tempto.BeforeMethodWithContext;
import io.trino.tempto.query.QueryExecutor;
import io.trino.tempto.query.QueryResult;
import io.trino.testing.TestingNames;
import io.trino.testng.services.Flaky;
import io.trino.tests.product.hive.HiveProductTest;
import io.trino.tests.product.utils.QueryExecutors;
import java.util.Arrays;
import java.util.List;
import org.assertj.core.api.Assertions;
import org.testng.Assert;
import org.testng.SkipException;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;

public class TestReadUniontype
extends HiveProductTest {
    private static final String TABLE_NAME = "test_read_uniontype";
    private static final String TABLE_NAME_SCHEMA_EVOLUTION = "test_read_uniontype_with_schema_evolution";

    @BeforeMethodWithContext
    @AfterMethodWithContext
    public void cleanup() {
        QueryExecutors.onHive().executeQuery(String.format("DROP TABLE IF EXISTS %s", TABLE_NAME), new QueryExecutor.QueryParam[0]);
        QueryExecutors.onHive().executeQuery(String.format("DROP TABLE IF EXISTS %s", TABLE_NAME_SCHEMA_EVOLUTION), new QueryExecutor.QueryParam[0]);
    }

    @DataProvider(name="storage_formats")
    public static Object[][] storageFormats() {
        return new String[][]{{"ORC"}, {"AVRO"}};
    }

    @DataProvider(name="union_dereference_test_cases")
    public static Object[][] unionDereferenceTestCases() {
        String tableUnionDereference = "test_union_dereference" + TestingNames.randomNameSuffix();
        return new Object[][]{{String.format("CREATE TABLE %s (unionLevel0 UNIONTYPE<INT, STRING>)STORED AS %s", tableUnionDereference, "AVRO"), String.format("INSERT INTO TABLE %s SELECT create_union(0, 321, 'row1') UNION ALL SELECT create_union(1, 55, 'row2') ", tableUnionDereference), String.format("SELECT unionLevel0.field0 FROM %s WHERE unionLevel0.field0 IS NOT NULL", tableUnionDereference), Arrays.asList(321), String.format("SELECT unionLevel0.tag FROM %s", tableUnionDereference), Arrays.asList((byte)0, (byte)1), "DROP TABLE IF EXISTS " + tableUnionDereference}, {String.format("CREATE TABLE %s (unionLevel0 UNIONTYPE<INT, STRING,STRUCT<intLevel1:INT, stringLevel1:STRING, unionLevel1:UNIONTYPE<STRING, INT>>>, intLevel0 INT )STORED AS %s", tableUnionDereference, "AVRO"), String.format("INSERT INTO TABLE %s SELECT create_union(2, 321, 'row1', named_struct('intLevel1', 1, 'stringLevel1', 'structval', 'unionLevel1', create_union(0, 5, 'testString'))), 8 UNION ALL SELECT create_union(2, 321, 'row1', named_struct('intLevel1', 1, 'stringLevel1', 'structval', 'unionLevel1', create_union(1, 5, 'testString'))), 8 ", tableUnionDereference), String.format("SELECT unionLevel0.field2.unionLevel1.field1 FROM %s WHERE  unionLevel0.field2.unionLevel1.field1 IS NOT NULL", tableUnionDereference), Arrays.asList(5), String.format("SELECT unionLevel0.field2.unionLevel1.tag FROM %s", tableUnionDereference), Arrays.asList((byte)0, (byte)1), "DROP TABLE IF EXISTS " + tableUnionDereference}, {String.format("CREATE TABLE %s (unionLevel0 UNIONTYPE<STRUCT<unionLevel1:UNIONTYPE<STRING, INT>>>)STORED AS %s", tableUnionDereference, "ORC"), String.format("INSERT INTO TABLE %s SELECT create_union(0, named_struct('unionLevel1', create_union(0, 'testString1', 23))) UNION ALL SELECT create_union(0, named_struct('unionLevel1', create_union(1, 'testString2', 45))) ", tableUnionDereference), String.format("SELECT unionLevel0.field0.unionLevel1.field0 FROM %s WHERE unionLevel0.field0.unionLevel1.field0 IS NOT NULL", tableUnionDereference), Arrays.asList("testString1"), String.format("SELECT unionLevel0.field0.unionLevel1.tag FROM %s", tableUnionDereference), Arrays.asList((byte)0, (byte)1), "DROP TABLE IF EXISTS " + tableUnionDereference}, {String.format("CREATE TABLE %s (unionLevel0 UNIONTYPE<INT, STRING,STRUCT<intLevel1:INT, stringLevel1:STRING, unionLevel1:UNIONTYPE<STRING, INT>>>, intLevel0 INT )STORED AS %s", tableUnionDereference, "ORC"), String.format("INSERT INTO TABLE %s SELECT create_union(2, 321, 'row1', named_struct('intLevel1', 1, 'stringLevel1', 'structval', 'unionLevel1', create_union(0, 'testString', 5))), 8 UNION ALL SELECT create_union(2, 321, 'row1', named_struct('intLevel1', 1, 'stringLevel1', 'structval', 'unionLevel1', create_union(1, 'testString', 5))), 8 ", tableUnionDereference), String.format("SELECT unionLevel0.field2.unionLevel1.field0 FROM %s WHERE  unionLevel0.field2.unionLevel1.field0 IS NOT NULL", tableUnionDereference), Arrays.asList("testString"), String.format("SELECT unionLevel0.field2.unionLevel1.tag FROM %s", tableUnionDereference), Arrays.asList((byte)0, (byte)1), "DROP TABLE IF EXISTS " + tableUnionDereference}};
    }

    @Test(dataProvider="storage_formats", groups={"smoke", "avro"})
    @Flaky(issue="https://github.com/trinodb/trino/issues?q=is%3Aissue+issue%3A+4936+5427", match="(could only be replicated to 0 nodes instead of minReplication|could only be written to 0 of the 1 minReplication|return code [12] from \\Qorg.apache.hadoop.hive.ql.exec.mr.MapRedTask\\E)")
    public void testReadUniontype(String storageFormat) {
        if (this.getHiveVersionMajor() != 1 || this.getHiveVersionMinor() != 2) {
            throw new SkipException("This test can only be run with Hive 1.2 (default config)");
        }
        QueryExecutors.onHive().executeQuery(String.format("CREATE TABLE %s (id INT,foo UNIONTYPE<INT,DOUBLE,ARRAY<STRING>>)STORED AS %s", TABLE_NAME, storageFormat), new QueryExecutor.QueryParam[0]);
        QueryExecutors.onHive().executeQuery(String.format("INSERT INTO TABLE %s SELECT 0, create_union(0, CAST(36 AS INT), CAST(NULL AS DOUBLE), ARRAY('foo','bar')) UNION ALL SELECT 1, create_union(1, CAST(NULL AS INT), CAST(7.2 AS DOUBLE), ARRAY('foo','bar')) UNION ALL SELECT 2, create_union(2, CAST(NULL AS INT), CAST(NULL AS DOUBLE), ARRAY('foo','bar')) UNION ALL SELECT 3, create_union(1, CAST(NULL AS INT), CAST(10.8 AS DOUBLE), ARRAY('foo','bar')) UNION ALL SELECT 4, create_union(0, CAST(144 AS INT), CAST(NULL AS DOUBLE), ARRAY('foo','bar')) UNION ALL SELECT 5, create_union(2, CAST(NULL AS INT), CAST(NULL AS DOUBLE), ARRAY('hello', 'world'))", TABLE_NAME), new QueryExecutor.QueryParam[0]);
        QueryExecutors.onHive().executeQuery(String.format("INSERT INTO TABLE %s SELECT 6, create_union(0, CAST(180 AS INT), CAST(NULL AS DOUBLE), ARRAY('foo','bar')) UNION ALL SELECT 7, create_union(1, CAST(NULL AS INT), CAST(21.6 AS DOUBLE), ARRAY('foo','bar')) UNION ALL SELECT 8, create_union(0, CAST(252 AS INT), CAST(NULL AS DOUBLE), ARRAY('foo','bar'))", TABLE_NAME), new QueryExecutor.QueryParam[0]);
        QueryResult selectAllResult = QueryExecutors.onTrino().executeQuery(String.format("SELECT * FROM %s", TABLE_NAME), new QueryExecutor.QueryParam[0]);
        Assert.assertEquals((int)selectAllResult.rows().size(), (int)9);
        for (List row : selectAllResult.rows()) {
            int id = (Integer)row.get(0);
            switch (id) {
                case 0: {
                    TestReadUniontype.assertStructEquals(row.get(1), new Object[]{(byte)0, 36, null, null});
                    break;
                }
                case 1: {
                    TestReadUniontype.assertStructEquals(row.get(1), new Object[]{(byte)1, null, 7.2, null});
                    break;
                }
                case 2: {
                    TestReadUniontype.assertStructEquals(row.get(1), new Object[]{(byte)2, null, null, Arrays.asList("foo", "bar")});
                    break;
                }
                case 3: {
                    TestReadUniontype.assertStructEquals(row.get(1), new Object[]{(byte)1, null, 10.8, null});
                    break;
                }
                case 4: {
                    TestReadUniontype.assertStructEquals(row.get(1), new Object[]{(byte)0, 144, null, null});
                    break;
                }
                case 5: {
                    TestReadUniontype.assertStructEquals(row.get(1), new Object[]{(byte)2, null, null, Arrays.asList("hello", "world")});
                    break;
                }
                case 6: {
                    TestReadUniontype.assertStructEquals(row.get(1), new Object[]{(byte)0, 180, null, null});
                    break;
                }
                case 7: {
                    TestReadUniontype.assertStructEquals(row.get(1), new Object[]{(byte)1, null, 21.6, null});
                    break;
                }
                case 8: {
                    TestReadUniontype.assertStructEquals(row.get(1), new Object[]{(byte)0, 252, null, null});
                }
            }
        }
    }

    @Test(dataProvider="union_dereference_test_cases", groups={"smoke", "avro"})
    @Flaky(issue="https://github.com/trinodb/trino/issues?q=is%3Aissue+issue%3A+4936+5427", match="(could only be replicated to 0 nodes instead of minReplication|could only be written to 0 of the 1 minReplication|return code [12] from \\Qorg.apache.hadoop.hive.ql.exec.mr.MapRedTask\\E)")
    public void testReadUniontypeWithDereference(String createTableSql, String insertSql, String selectSql, List<Object> expectedResult, String selectTagSql, List<Object> expectedTagResult, String dropTableSql) {
        if (this.getHiveVersionMajor() != 1 || this.getHiveVersionMinor() != 2) {
            throw new SkipException("This test can only be run with Hive 1.2 (default config)");
        }
        QueryExecutors.onHive().executeQuery(createTableSql, new QueryExecutor.QueryParam[0]);
        QueryExecutors.onHive().executeQuery(insertSql, new QueryExecutor.QueryParam[0]);
        QueryResult result = QueryExecutors.onTrino().executeQuery(selectSql, new QueryExecutor.QueryParam[0]);
        Assertions.assertThat((List)result.column(1)).containsExactlyInAnyOrderElementsOf(expectedResult);
        result = QueryExecutors.onTrino().executeQuery(selectTagSql, new QueryExecutor.QueryParam[0]);
        Assertions.assertThat((List)result.column(1)).containsExactlyInAnyOrderElementsOf(expectedTagResult);
        QueryExecutors.onTrino().executeQuery(dropTableSql, new QueryExecutor.QueryParam[0]);
    }

    @Test(dataProvider="storage_formats", groups={"smoke", "avro"})
    @Flaky(issue="https://github.com/trinodb/trino/issues?q=is%3Aissue+issue%3A+4936+5427", match="(could only be replicated to 0 nodes instead of minReplication|could only be written to 0 of the 1 minReplication|return code [12] from \\Qorg.apache.hadoop.hive.ql.exec.mr.MapRedTask\\E)")
    public void testUnionTypeSchemaEvolution(String storageFormat) {
        if (this.getHiveVersionMajor() != 1 || this.getHiveVersionMinor() != 2) {
            throw new SkipException("This test can only be run with Hive 1.2 (default config)");
        }
        QueryExecutors.onHive().executeQuery(String.format("CREATE TABLE %s (c0 INT,c1 UNIONTYPE<     STRUCT<a:STRING, b:STRING>,      STRUCT<c:STRING>>) PARTITIONED BY (c2 INT) STORED AS %s", TABLE_NAME_SCHEMA_EVOLUTION, storageFormat), new QueryExecutor.QueryParam[0]);
        switch (storageFormat) {
            case "AVRO": {
                this.testAvroSchemaEvolution();
                break;
            }
            case "ORC": {
                this.testORCSchemaEvolution();
                break;
            }
            default: {
                throw new UnsupportedOperationException("Unsupported table format.");
            }
        }
    }

    @Test(groups={"smoke"})
    @Flaky(issue="https://github.com/trinodb/trino/issues?q=is%3Aissue+issue%3A+4936+5427", match="(could only be replicated to 0 nodes instead of minReplication|could only be written to 0 of the 1 minReplication|return code [12] from \\Qorg.apache.hadoop.hive.ql.exec.mr.MapRedTask\\E)")
    public void testORCUnionToStructSchemaEvolution() {
        if (this.getHiveVersionMajor() != 1 || this.getHiveVersionMinor() != 2) {
            throw new SkipException("This test can only be run with Hive 1.2 (default config)");
        }
        String tableReadUnionAsStruct = "test_read_union_as_struct_" + TestingNames.randomNameSuffix();
        QueryExecutors.onHive().executeQuery("SET hive.exec.dynamic.partition.mode = nonstrict", new QueryExecutor.QueryParam[0]);
        QueryExecutors.onHive().executeQuery("SET hive.exec.dynamic.partition=true", new QueryExecutor.QueryParam[0]);
        QueryExecutors.onHive().executeQuery(String.format("CREATE TABLE %s(c1 UNIONTYPE<STRUCT<a:STRING,b:STRING>, STRUCT<c:STRING,d:STRING>>) PARTITIONED BY (p INT) STORED AS %s", tableReadUnionAsStruct, "ORC"), new QueryExecutor.QueryParam[0]);
        QueryExecutors.onHive().executeQuery(String.format("INSERT INTO TABLE %s PARTITION(p) SELECT CREATE_UNION(1, NAMED_STRUCT('a', 'a1', 'b', 'b1'), NAMED_STRUCT('c', 'ignores', 'd', 'ignore')), 999 FROM (SELECT 1) t", tableReadUnionAsStruct), new QueryExecutor.QueryParam[0]);
        QueryExecutors.onHive().executeQuery(String.format("ALTER TABLE %s CHANGE COLUMN c1 c1  STRUCT<tag:INT, field0:STRUCT<a:STRING, b:STRING>, field1:STRUCT<c:STRING, d:STRING>>", tableReadUnionAsStruct), new QueryExecutor.QueryParam[0]);
        QueryExecutors.onHive().executeQuery(String.format("INSERT INTO TABLE %s PARTITION(p) SELECT NAMED_STRUCT('tag', 0, 'field0', NAMED_STRUCT('a', 'a11', 'b', 'b1b'), 'field1', NAMED_STRUCT('c', 'ignores', 'd', 'ignores')), 100 FROM (SELECT 1) t", tableReadUnionAsStruct), new QueryExecutor.QueryParam[0]);
        QueryResult selectAllResult = QueryExecutors.onTrino().executeQuery(String.format("SELECT c1.field0 FROM hive.default.%s", tableReadUnionAsStruct), new QueryExecutor.QueryParam[0]);
        Assertions.assertThat((List)selectAllResult.column(1)).containsExactlyInAnyOrder(new Object[]{null, Row.builder().addField("a", (Object)"a11").addField("b", (Object)"b1b").build()});
    }

    @Test(groups={"smoke"})
    @Flaky(issue="https://github.com/trinodb/trino/issues?q=is%3Aissue+issue%3A+4936+5427", match="(could only be replicated to 0 nodes instead of minReplication|could only be written to 0 of the 1 minReplication|return code [12] from \\Qorg.apache.hadoop.hive.ql.exec.mr.MapRedTask\\E)")
    public void testORCStructToUnionSchemaEvolution() {
        if (this.getHiveVersionMajor() != 1 || this.getHiveVersionMinor() != 2) {
            throw new SkipException("This test can only be run with Hive 1.2 (default config)");
        }
        String tableReadStructAsUnion = "test_read_struct_as_union_" + TestingNames.randomNameSuffix();
        QueryExecutors.onHive().executeQuery("SET hive.exec.dynamic.partition.mode = nonstrict", new QueryExecutor.QueryParam[0]);
        QueryExecutors.onHive().executeQuery("SET hive.exec.dynamic.partition=true", new QueryExecutor.QueryParam[0]);
        QueryExecutors.onHive().executeQuery(String.format("CREATE TABLE %s(c1 STRUCT<tag:TINYINT, field0:STRUCT<a:STRING, b:STRING>, field1:STRUCT<c:STRING, d:STRING>>) PARTITIONED BY (p INT) STORED AS %s", tableReadStructAsUnion, "ORC"), new QueryExecutor.QueryParam[0]);
        QueryExecutors.onHive().executeQuery(String.format("INSERT INTO TABLE %s PARTITION(p) SELECT NAMED_STRUCT('tag', 0Y, 'field0', NAMED_STRUCT('a', 'a11', 'b', 'b1b'), 'field1', NAMED_STRUCT('c', 'ignores', 'd', 'ignores')), 100 FROM (SELECT 1) t", tableReadStructAsUnion), new QueryExecutor.QueryParam[0]);
        QueryExecutors.onHive().executeQuery(String.format("ALTER TABLE %s CHANGE COLUMN c1 c1  UNIONTYPE<STRUCT<a:STRING,b:STRING>, STRUCT<c:STRING,d:STRING>>", tableReadStructAsUnion), new QueryExecutor.QueryParam[0]);
        QueryExecutors.onHive().executeQuery(String.format("INSERT INTO TABLE %s PARTITION(p) SELECT CREATE_UNION(1, NAMED_STRUCT('a', 'a1', 'b', 'b1'), NAMED_STRUCT('c', 'ignores', 'd', 'ignore')), 999 from (SELECT 1) t", tableReadStructAsUnion), new QueryExecutor.QueryParam[0]);
        QueryResult selectAllResult = QueryExecutors.onTrino().executeQuery(String.format("SELECT c1.field0 FROM hive.default.%s", tableReadStructAsUnion), new QueryExecutor.QueryParam[0]);
        Assertions.assertThat((List)selectAllResult.column(1)).containsExactlyInAnyOrder(new Object[]{null, Row.builder().addField("a", (Object)"a11").addField("b", (Object)"b1b").build()});
    }

    @Test(groups={"smoke"})
    @Flaky(issue="https://github.com/trinodb/trino/issues?q=is%3Aissue+issue%3A+4936+5427", match="(could only be replicated to 0 nodes instead of minReplication|could only be written to 0 of the 1 minReplication|return code [12] from \\Qorg.apache.hadoop.hive.ql.exec.mr.MapRedTask\\E)")
    public void testReadOrcUniontypeWithCheckpoint() {
        if (this.getHiveVersionMajor() != 1 || this.getHiveVersionMinor() != 2) {
            throw new SkipException("This test can only be run with Hive 1.2 (default config)");
        }
        QueryExecutors.onHive().executeQuery(String.format("CREATE TABLE %s (id INT,foo UNIONTYPE<INT,DOUBLE,ARRAY<STRING>>)STORED AS ORC TBLPROPERTIES (\"orc.row.index.stride\"=\"1000\")", TABLE_NAME), new QueryExecutor.QueryParam[0]);
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < 1100; ++i) {
            builder.append("SELECT 0, create_union(0, CAST(36 AS INT), CAST(NULL AS DOUBLE), ARRAY('foo','bar')) ");
            if (i >= 1099) continue;
            builder.append("UNION ALL ");
        }
        QueryExecutors.onHive().executeQuery(String.format("INSERT INTO TABLE %s " + builder.toString(), TABLE_NAME), new QueryExecutor.QueryParam[0]);
        QueryResult selectAllResult = QueryExecutors.onTrino().executeQuery(String.format("SELECT * FROM %s", TABLE_NAME), new QueryExecutor.QueryParam[0]);
        Assert.assertEquals((int)selectAllResult.rows().size(), (int)1100);
    }

    private void testORCSchemaEvolution() {
        QueryExecutors.onHive().executeQuery(String.format("INSERT INTO TABLE %s PARTITION (c2 = 5) SELECT 0, create_union(0, named_struct('a', 'a1', 'b', 'b1'), named_struct('c', 'ignore')) UNION ALL SELECT 1, create_union(1, named_struct('a', 'ignore', 'b', 'ignore'), named_struct('c', 'c1'))", TABLE_NAME_SCHEMA_EVOLUTION), new QueryExecutor.QueryParam[0]);
        QueryExecutors.onHive().executeQuery(String.format("ALTER TABLE %S CHANGE COLUMN c1 c1 UNIONTYPE<STRUCT<a:STRING, b:STRING>, STRUCT<c:STRING, d:STRING>>", TABLE_NAME_SCHEMA_EVOLUTION), new QueryExecutor.QueryParam[0]);
        QueryResult selectAllResult = QueryExecutors.onTrino().executeQuery(String.format("SELECT c0, c1 FROM %s", TABLE_NAME_SCHEMA_EVOLUTION), new QueryExecutor.QueryParam[0]);
        Assert.assertEquals((int)selectAllResult.rows().size(), (int)2);
        for (List row : selectAllResult.rows()) {
            int id = (Integer)row.get(0);
            switch (id) {
                case 0: {
                    Row rowValueFirst = TestReadUniontype.rowBuilder().addField("a", (Object)"a1").addField("b", (Object)"b1").build();
                    TestReadUniontype.assertStructEquals(row.get(1), new Object[]{(byte)0, rowValueFirst, null});
                    break;
                }
                case 1: {
                    Row rowValueSecond = TestReadUniontype.rowBuilder().addField("c", (Object)"c1").addField("d", null).build();
                    TestReadUniontype.assertStructEquals(row.get(1), new Object[]{(byte)1, null, rowValueSecond});
                }
            }
        }
    }

    private void testAvroSchemaEvolution() {
        QueryExecutors.onHive().executeQuery(String.format("INSERT INTO TABLE %s PARTITION (c2 = 5) SELECT 0, create_union(0, named_struct('a', 'a1', 'b', 'b1'), named_struct('c', 'ignore')) UNION ALL SELECT 1, create_union(0, named_struct('a', 'a2', 'b', 'b2'), named_struct('c', 'ignore'))", TABLE_NAME_SCHEMA_EVOLUTION), new QueryExecutor.QueryParam[0]);
        QueryExecutors.onHive().executeQuery(String.format("ALTER TABLE %S CHANGE COLUMN c1 c1 UNIONTYPE<STRUCT<a:STRING, b:STRING, d:STRING>, STRUCT<c:STRING>>", TABLE_NAME_SCHEMA_EVOLUTION), new QueryExecutor.QueryParam[0]);
        QueryResult selectAllResult = QueryExecutors.onTrino().executeQuery(String.format("SELECT c0, c1 FROM %s", TABLE_NAME_SCHEMA_EVOLUTION), new QueryExecutor.QueryParam[0]);
        Assert.assertEquals((int)selectAllResult.rows().size(), (int)2);
        for (List row : selectAllResult.rows()) {
            int id = (Integer)row.get(0);
            switch (id) {
                case 0: {
                    Row rowValueFirst = TestReadUniontype.rowBuilder().addField("a", (Object)"a1").addField("b", (Object)"b1").addField("d", null).build();
                    TestReadUniontype.assertStructEquals(row.get(1), new Object[]{(byte)0, rowValueFirst, null});
                    break;
                }
                case 1: {
                    Row rowValueSecond = TestReadUniontype.rowBuilder().addField("a", (Object)"a2").addField("b", (Object)"b2").addField("d", null).build();
                    TestReadUniontype.assertStructEquals(row.get(1), new Object[]{(byte)0, rowValueSecond, null});
                }
            }
        }
    }

    private static void assertStructEquals(Object actual, Object[] expected) {
        Assertions.assertThat((Object)actual).isInstanceOf(Row.class);
        Row actualRow = (Row)actual;
        Assert.assertEquals((int)actualRow.getFields().size(), (int)expected.length);
        for (int i = 0; i < actualRow.getFields().size(); ++i) {
            Assert.assertEquals((Object)((RowField)actualRow.getFields().get(i)).getValue(), (Object)expected[i]);
        }
    }

    private static Row.Builder rowBuilder() {
        return Row.builder();
    }
}

