/*
 * Decompiled with CFR 0.152.
 */
package io.trino.tests.product.hive;

import io.trino.tempto.ProductTest;
import io.trino.tempto.assertions.QueryAssert;
import io.trino.tempto.query.QueryExecutor;
import io.trino.tests.product.utils.QueryExecutors;
import org.assertj.core.api.AssertProvider;
import org.assertj.core.api.Assertions;
import org.testng.annotations.Test;

public class TestWriteToHiveTransactionalTableInTrino
extends ProductTest {
    @Test(groups={"hms_only", "profile_specific_tests"})
    public void testInsertIntoUnpartitionedTable() {
        String tableName = "unpartitioned_transactional_insert";
        QueryExecutors.onTrino().executeQuery(String.format("CREATE TABLE %s (column1 INT) WITH (transactional = true)", tableName), new QueryExecutor.QueryParam[0]);
        QueryExecutors.onTrino().executeQuery(String.format("INSERT INTO %s VALUES (11)", tableName), new QueryExecutor.QueryParam[0]);
        ((QueryAssert)Assertions.assertThat((AssertProvider)QueryExecutors.onTrino().executeQuery(String.format("SELECT * FROM %s", tableName), new QueryExecutor.QueryParam[0]))).containsOnly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{11})});
        QueryExecutors.onTrino().executeQuery(String.format("DROP TABLE %s", tableName), new QueryExecutor.QueryParam[0]);
    }

    @Test(groups={"hms_only", "profile_specific_tests"})
    public void testInsertIntoPartitionedTable() {
        String tableName = "partitioned_transactional_insert";
        QueryExecutors.onTrino().executeQuery(String.format("CREATE TABLE %s (column1 INT, column2 INT) WITH (transactional = true, partitioned_by = ARRAY['column2'])", tableName), new QueryExecutor.QueryParam[0]);
        QueryExecutors.onTrino().executeQuery(String.format("INSERT INTO %s VALUES (11, 12), (111, 121)", tableName), new QueryExecutor.QueryParam[0]);
        ((QueryAssert)Assertions.assertThat((AssertProvider)QueryExecutors.onTrino().executeQuery(String.format("SELECT * FROM %s", tableName), new QueryExecutor.QueryParam[0]))).containsOnly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{11, 12}), QueryAssert.Row.row((Object[])new Object[]{111, 121})});
        QueryExecutors.onTrino().executeQuery(String.format("DROP TABLE %s", tableName), new QueryExecutor.QueryParam[0]);
    }

    @Test(groups={"hms_only", "profile_specific_tests"})
    public void testUpdateOnUnpartitionedTable() {
        String tableName = "unpartitioned_transactional_update";
        QueryExecutors.onTrino().executeQuery(String.format("CREATE TABLE %s (column1 INT) WITH (transactional = true)", tableName), new QueryExecutor.QueryParam[0]);
        QueryExecutors.onTrino().executeQuery(String.format("INSERT INTO %s VALUES (11)", tableName), new QueryExecutor.QueryParam[0]);
        ((QueryAssert)Assertions.assertThat((AssertProvider)QueryExecutors.onTrino().executeQuery(String.format("SELECT * FROM %s", tableName), new QueryExecutor.QueryParam[0]))).containsOnly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{11})});
        QueryExecutors.onTrino().executeQuery(String.format("UPDATE %s SET column1 = 999", tableName), new QueryExecutor.QueryParam[0]);
        ((QueryAssert)Assertions.assertThat((AssertProvider)QueryExecutors.onTrino().executeQuery(String.format("SELECT * FROM %s", tableName), new QueryExecutor.QueryParam[0]))).containsOnly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{999})});
        QueryExecutors.onTrino().executeQuery(String.format("DROP TABLE %s", tableName), new QueryExecutor.QueryParam[0]);
    }

    @Test(groups={"hms_only", "profile_specific_tests"})
    public void testUpdateOnPartitionedTable() {
        String tableName = "partitioned_transactional_update";
        QueryExecutors.onTrino().executeQuery(String.format("CREATE TABLE %s (column1 INT, column2 INT) WITH (transactional = true, partitioned_by = ARRAY['column2'])", tableName), new QueryExecutor.QueryParam[0]);
        QueryExecutors.onTrino().executeQuery(String.format("INSERT INTO %s VALUES (11, 12), (111, 121)", tableName), new QueryExecutor.QueryParam[0]);
        ((QueryAssert)Assertions.assertThat((AssertProvider)QueryExecutors.onTrino().executeQuery(String.format("SELECT * FROM %s", tableName), new QueryExecutor.QueryParam[0]))).containsOnly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{11, 12}), QueryAssert.Row.row((Object[])new Object[]{111, 121})});
        QueryExecutors.onTrino().executeQuery(String.format("UPDATE %s SET column1 = 999", tableName), new QueryExecutor.QueryParam[0]);
        ((QueryAssert)Assertions.assertThat((AssertProvider)QueryExecutors.onTrino().executeQuery(String.format("SELECT * FROM %s", tableName), new QueryExecutor.QueryParam[0]))).containsOnly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{999, 12}), QueryAssert.Row.row((Object[])new Object[]{999, 121})});
        QueryExecutors.onTrino().executeQuery(String.format("UPDATE %s SET column1 = 321 WHERE column2 = 121", tableName), new QueryExecutor.QueryParam[0]);
        ((QueryAssert)Assertions.assertThat((AssertProvider)QueryExecutors.onTrino().executeQuery(String.format("SELECT * FROM %s", tableName), new QueryExecutor.QueryParam[0]))).containsOnly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{999, 12}), QueryAssert.Row.row((Object[])new Object[]{321, 121})});
        QueryExecutors.onTrino().executeQuery(String.format("DROP TABLE %s", tableName), new QueryExecutor.QueryParam[0]);
    }

    @Test(groups={"hms_only", "profile_specific_tests"})
    public void testDeleteOnUnpartitionedTable() {
        String tableName = "unpartitioned_transactional_delete";
        QueryExecutors.onTrino().executeQuery(String.format("CREATE TABLE %s (column1 INT) WITH (transactional = true)", tableName), new QueryExecutor.QueryParam[0]);
        QueryExecutors.onTrino().executeQuery(String.format("INSERT INTO %s VALUES (11)", tableName), new QueryExecutor.QueryParam[0]);
        ((QueryAssert)Assertions.assertThat((AssertProvider)QueryExecutors.onTrino().executeQuery(String.format("SELECT * FROM %s", tableName), new QueryExecutor.QueryParam[0]))).containsOnly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{11})});
        QueryExecutors.onTrino().executeQuery(String.format("DELETE FROM %s", tableName), new QueryExecutor.QueryParam[0]);
        ((QueryAssert)Assertions.assertThat((AssertProvider)QueryExecutors.onTrino().executeQuery(String.format("SELECT * FROM %s", tableName), new QueryExecutor.QueryParam[0]))).hasNoRows();
        QueryExecutors.onTrino().executeQuery(String.format("DROP TABLE %s", tableName), new QueryExecutor.QueryParam[0]);
    }

    @Test(groups={"hms_only", "profile_specific_tests"})
    public void testDeleteOnPartitionedTable() {
        String tableName = "partitioned_transactional_delete";
        QueryExecutors.onTrino().executeQuery(String.format("CREATE TABLE %s (column1 INT, column2 INT) WITH (transactional = true, partitioned_by = ARRAY['column2'])", tableName), new QueryExecutor.QueryParam[0]);
        QueryExecutors.onTrino().executeQuery(String.format("INSERT INTO %s VALUES (11, 12), (111, 121)", tableName), new QueryExecutor.QueryParam[0]);
        ((QueryAssert)Assertions.assertThat((AssertProvider)QueryExecutors.onTrino().executeQuery(String.format("SELECT * FROM %s", tableName), new QueryExecutor.QueryParam[0]))).containsOnly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{11, 12}), QueryAssert.Row.row((Object[])new Object[]{111, 121})});
        QueryExecutors.onTrino().executeQuery(String.format("DELETE FROM %s WHERE column2 = 121", tableName), new QueryExecutor.QueryParam[0]);
        ((QueryAssert)Assertions.assertThat((AssertProvider)QueryExecutors.onTrino().executeQuery(String.format("SELECT * FROM %s", tableName), new QueryExecutor.QueryParam[0]))).containsOnly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{11, 12})});
        QueryExecutors.onTrino().executeQuery(String.format("DROP TABLE %s", tableName), new QueryExecutor.QueryParam[0]);
    }
}

