/*
 * Decompiled with CFR 0.152.
 */
package io.trino.tests.product.iceberg;

import com.google.inject.Inject;
import io.trino.tempto.AfterMethodWithContext;
import io.trino.tempto.BeforeMethodWithContext;
import io.trino.tempto.ProductTest;
import io.trino.tempto.assertions.QueryAssert;
import io.trino.tempto.hadoop.hdfs.HdfsClient;
import io.trino.tempto.query.QueryExecutor;
import io.trino.testing.TestingNames;
import io.trino.tests.product.utils.QueryExecutors;
import org.assertj.core.api.AssertProvider;
import org.assertj.core.api.Assertions;
import org.testng.annotations.Test;

public class TestIcebergCreateTable
extends ProductTest {
    @Inject
    private HdfsClient hdfsClient;

    @BeforeMethodWithContext
    public void setUp() {
        QueryExecutors.onTrino().executeQuery("CREATE SCHEMA IF NOT EXISTS iceberg.iceberg", new QueryExecutor.QueryParam[0]);
    }

    @AfterMethodWithContext
    public void cleanUp() {
        QueryExecutors.onTrino().executeQuery("DROP SCHEMA iceberg.iceberg", new QueryExecutor.QueryParam[0]);
    }

    @Test(groups={"iceberg", "storage_formats", "hms_only"})
    public void testCreateTable() {
        String tableName = "iceberg.iceberg.test_create_table_" + TestingNames.randomNameSuffix();
        QueryExecutors.onTrino().executeQuery("CREATE TABLE " + tableName + "(a bigint, b varchar)", new QueryExecutor.QueryParam[0]);
        try {
            QueryExecutors.onTrino().executeQuery("INSERT INTO " + tableName + "(a, b) VALUES (NULL, NULL), (-42, 'abc'), (9223372036854775807, 'abcdefghijklmnopqrstuvwxyz')", new QueryExecutor.QueryParam[0]);
            ((QueryAssert)Assertions.assertThat((AssertProvider)QueryExecutors.onTrino().executeQuery("SELECT * FROM " + tableName, new QueryExecutor.QueryParam[0]))).containsOnly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{null, null}), QueryAssert.Row.row((Object[])new Object[]{-42, "abc"}), QueryAssert.Row.row((Object[])new Object[]{Long.MAX_VALUE, "abcdefghijklmnopqrstuvwxyz"})});
        }
        finally {
            QueryExecutors.onTrino().executeQuery("DROP TABLE " + tableName, new QueryExecutor.QueryParam[0]);
        }
    }

    @Test(groups={"iceberg", "storage_formats", "hms_only"})
    public void testCreateTableAsSelect() {
        String tableName = "iceberg.iceberg.test_create_table_as_select_" + TestingNames.randomNameSuffix();
        QueryExecutors.onTrino().executeQuery("CREATE TABLE " + tableName + " AS SELECT * FROM (VALUES   (NULL, NULL),   (-42, 'abc'),   (9223372036854775807, 'abcdefghijklmnopqrstuvwxyz')) t(a, b)", new QueryExecutor.QueryParam[0]);
        try {
            ((QueryAssert)Assertions.assertThat((AssertProvider)QueryExecutors.onTrino().executeQuery("SELECT * FROM " + tableName, new QueryExecutor.QueryParam[0]))).containsOnly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{null, null}), QueryAssert.Row.row((Object[])new Object[]{-42, "abc"}), QueryAssert.Row.row((Object[])new Object[]{Long.MAX_VALUE, "abcdefghijklmnopqrstuvwxyz"})});
        }
        finally {
            QueryExecutors.onTrino().executeQuery("DROP TABLE " + tableName, new QueryExecutor.QueryParam[0]);
        }
    }

    @Test(groups={"iceberg", "storage_formats"})
    public void testCreateExternalTableWithInaccessibleSchemaLocation() {
        String schemaName = "schema_without_location";
        String schemaLocation = "/tmp/" + schemaName;
        this.hdfsClient.createDirectory(schemaLocation);
        QueryExecutors.onTrino().executeQuery(String.format("CREATE SCHEMA iceberg.%s WITH (location = '%s')", schemaName, schemaLocation), new QueryExecutor.QueryParam[0]);
        this.hdfsClient.delete(schemaLocation);
        String tableName = "test_create_external";
        String tableLocation = "/tmp/" + tableName;
        String schemaAndTableName = String.format("iceberg.%s.%s", schemaName, tableName);
        QueryExecutors.onTrino().executeQuery(String.format("CREATE TABLE %s (a bigint, b VARCHAR) WITH (location = '%s')", schemaAndTableName, tableLocation), new QueryExecutor.QueryParam[0]);
        QueryExecutors.onTrino().executeQuery("INSERT INTO " + schemaAndTableName + "(a, b) VALUES (NULL, NULL), (-42, 'abc'), (9223372036854775807, 'abcdefghijklmnopqrstuvwxyz')", new QueryExecutor.QueryParam[0]);
        ((QueryAssert)Assertions.assertThat((AssertProvider)QueryExecutors.onTrino().executeQuery("SELECT * FROM " + schemaAndTableName, new QueryExecutor.QueryParam[0]))).containsOnly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{null, null}), QueryAssert.Row.row((Object[])new Object[]{-42, "abc"}), QueryAssert.Row.row((Object[])new Object[]{Long.MAX_VALUE, "abcdefghijklmnopqrstuvwxyz"})});
        QueryExecutors.onTrino().executeQuery(String.format("DROP TABLE %s", schemaAndTableName), new QueryExecutor.QueryParam[0]);
        QueryExecutors.onTrino().executeQuery(String.format("DROP SCHEMA iceberg.%s", schemaName), new QueryExecutor.QueryParam[0]);
    }
}

