/*
 * Decompiled with CFR 0.152.
 */
package io.trino.tests.product.deltalake;

import com.google.common.collect.ImmutableList;
import io.trino.tempto.assertions.QueryAssert;
import io.trino.tempto.query.QueryExecutor;
import io.trino.testing.TestingNames;
import io.trino.testng.services.Flaky;
import io.trino.tests.product.deltalake.BaseTestDeltaLakeS3Storage;
import io.trino.tests.product.deltalake.util.DeltaLakeTestUtils;
import io.trino.tests.product.utils.QueryExecutors;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import org.assertj.core.api.AssertProvider;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.MapAssert;
import org.testng.Assert;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;

public class TestDeltaLakeColumnMappingMode
extends BaseTestDeltaLakeS3Storage {
    @Test(groups={"delta-lake-databricks", "delta-lake-databricks-104", "delta-lake-databricks-113", "delta-lake-databricks-122", "delta-lake-oss", "delta-lake-exclude-91", "profile_specific_tests"})
    @Flaky(issue="https://github.com/trinodb/trino/issues/14391", match="\\Q[Databricks][DatabricksJDBCDriver](500593) Communication link failure. Failed to connect to server. Reason: \\E(HTTP retry after response received with no Retry-After header, error: HTTP Response code: 503|HTTP Response code: 504), Error message: Unknown.")
    public void testColumnMappingModeNone() {
        String tableName = "test_dl_column_mapping_mode_none" + TestingNames.randomNameSuffix();
        QueryExecutors.onDelta().executeQuery("CREATE TABLE default." + tableName + " (a_number INT, nested STRUCT<field1: STRING>) USING delta  LOCATION 's3://" + this.bucketName + "/databricks-compatibility-test-" + tableName + "' TBLPROPERTIES ( 'delta.minReaderVersion'='2', 'delta.minWriterVersion'='5')", new QueryExecutor.QueryParam[0]);
        try {
            QueryExecutors.onDelta().executeQuery("INSERT INTO default." + tableName + " VALUES (1, struct('nested 1'))", new QueryExecutor.QueryParam[0]);
            ImmutableList expectedRows = ImmutableList.of((Object)QueryAssert.Row.row((Object[])new Object[]{1, "nested 1"}));
            ((QueryAssert)Assertions.assertThat((AssertProvider)QueryExecutors.onDelta().executeQuery("SELECT a_number, nested.field1 FROM default." + tableName, new QueryExecutor.QueryParam[0]))).containsOnly((List)expectedRows);
            ((QueryAssert)Assertions.assertThat((AssertProvider)QueryExecutors.onTrino().executeQuery("SELECT a_number, nested.field1 FROM delta.default." + tableName, new QueryExecutor.QueryParam[0]))).containsOnly((List)expectedRows);
        }
        finally {
            DeltaLakeTestUtils.dropDeltaTableWithRetry("default." + tableName);
        }
    }

    @Test(groups={"delta-lake-oss", "profile_specific_tests"}, dataProvider="supportedColumnMappingForDmlDataProvider")
    public void testColumnMappingModeTableFeature(String mode) {
        String tableName = "test_dl_column_mapping_mode_table_feature" + TestingNames.randomNameSuffix();
        QueryExecutors.onDelta().executeQuery("CREATE TABLE default." + tableName + " (col INT)USING delta LOCATION 's3://" + this.bucketName + "/databricks-compatibility-test-" + tableName + "'TBLPROPERTIES ('delta.feature.columnMapping'='supported', 'delta.columnMapping.mode'='" + mode + "')", new QueryExecutor.QueryParam[0]);
        try {
            QueryExecutors.onTrino().executeQuery("INSERT INTO delta.default." + tableName + " VALUES 1", new QueryExecutor.QueryParam[0]);
            ((MapAssert)Assertions.assertThat(DeltaLakeTestUtils.getTablePropertiesOnDelta("default", tableName)).contains(new Map.Entry[]{Assertions.entry((Object)"delta.feature.columnMapping", (Object)"supported")})).contains(new Map.Entry[]{Assertions.entry((Object)"delta.columnMapping.mode", (Object)mode)});
            QueryExecutors.onDelta().executeQuery("ALTER TABLE default." + tableName + " UNSET TBLPROPERTIES ('delta.feature.columnMapping')", new QueryExecutor.QueryParam[0]);
            Assertions.assertThat(DeltaLakeTestUtils.getTablePropertiesOnDelta("default", tableName)).contains(new Map.Entry[]{Assertions.entry((Object)"delta.feature.columnMapping", (Object)"supported")});
            if (mode.equals("none")) {
                QueryExecutors.onDelta().executeQuery("ALTER TABLE default." + tableName + " UNSET TBLPROPERTIES ('delta.columnMapping.mode')", new QueryExecutor.QueryParam[0]);
                ((MapAssert)Assertions.assertThat(DeltaLakeTestUtils.getTablePropertiesOnDelta("default", tableName)).contains(new Map.Entry[]{Assertions.entry((Object)"delta.feature.columnMapping", (Object)"supported")})).doesNotContainKey((Object)"delta.columnMapping.mode");
                Assertions.assertThat((String)((String)QueryExecutors.onTrino().executeQuery("SHOW CREATE TABLE delta.default." + tableName, new QueryExecutor.QueryParam[0]).getOnlyValue())).doesNotContain(new CharSequence[]{"column_mapping_mode ="});
            } else {
                QueryAssert.assertQueryFailure(() -> QueryExecutors.onDelta().executeQuery("ALTER TABLE default." + tableName + " UNSET TBLPROPERTIES ('delta.columnMapping.mode')", new QueryExecutor.QueryParam[0])).hasMessageContaining("Changing column mapping mode from '" + mode + "' to 'none' is not supported");
                Assertions.assertThat((String)((String)QueryExecutors.onTrino().executeQuery("SHOW CREATE TABLE delta.default." + tableName, new QueryExecutor.QueryParam[0]).getOnlyValue())).contains(new CharSequence[]{"column_mapping_mode = '" + mode.toUpperCase(Locale.ENGLISH) + "'"});
            }
        }
        finally {
            DeltaLakeTestUtils.dropDeltaTableWithRetry("default." + tableName);
        }
    }

    @Test(groups={"delta-lake-oss", "profile_specific_tests"}, dataProvider="columnMappingDataProvider")
    public void testTrinoColumnMappingModeReaderAndWriterVersion(String mode) {
        this.testColumnMappingModeReaderAndWriterVersion(tableName -> QueryExecutors.onTrino().executeQuery("CREATE TABLE delta.default." + tableName + "(x INT) WITH ( location = 's3://" + this.bucketName + "/databricks-compatibility-test-" + tableName + "', column_mapping_mode = '" + mode + "')", new QueryExecutor.QueryParam[0]));
    }

    @Test(groups={"delta-lake-oss", "profile_specific_tests"}, dataProvider="columnMappingDataProvider")
    public void testDeltaColumnMappingModeReaderAndWriterVersion(String mode) {
        this.testColumnMappingModeReaderAndWriterVersion(tableName -> QueryExecutors.onDelta().executeQuery("CREATE TABLE default." + tableName + "(x INT) USING delta LOCATION 's3://" + this.bucketName + "/databricks-compatibility-test-" + tableName + "'TBLPROPERTIES ('delta.columnMapping.mode'='" + mode + "')", new QueryExecutor.QueryParam[0]));
    }

    private void testColumnMappingModeReaderAndWriterVersion(Consumer<String> createTable) {
        String tableName = "test_dl_column_mapping_version_" + TestingNames.randomNameSuffix();
        createTable.accept(tableName);
        Assertions.assertThat((String)DeltaLakeTestUtils.getTablePropertyOnDelta("default", tableName, "delta.minReaderVersion")).isEqualTo("2");
        Assertions.assertThat((String)DeltaLakeTestUtils.getTablePropertyOnDelta("default", tableName, "delta.minWriterVersion")).isEqualTo("5");
        QueryExecutors.onTrino().executeQuery("DROP TABLE delta.default." + tableName, new QueryExecutor.QueryParam[0]);
    }

    @Test(groups={"delta-lake-databricks", "delta-lake-databricks-104", "delta-lake-databricks-113", "delta-lake-databricks-122", "delta-lake-oss", "delta-lake-exclude-91", "profile_specific_tests"}, dataProvider="columnMappingDataProvider")
    @Flaky(issue="https://github.com/trinodb/trino/issues/14391", match="\\Q[Databricks][DatabricksJDBCDriver](500593) Communication link failure. Failed to connect to server. Reason: \\E(HTTP retry after response received with no Retry-After header, error: HTTP Response code: 503|HTTP Response code: 504), Error message: Unknown.")
    public void testTrinoColumnMappingMode(String mode) {
        this.testColumnMappingMode(tableName -> QueryExecutors.onTrino().executeQuery("CREATE TABLE delta.default." + tableName + " (a_number INT, array_col ARRAY(ROW(array_struct_element VARCHAR)), nested ROW(field1 VARCHAR), a_string VARCHAR, part VARCHAR) WITH ( partitioned_by = ARRAY['part'], location = 's3://" + this.bucketName + "/databricks-compatibility-test-" + tableName + "', column_mapping_mode = '" + mode + "')", new QueryExecutor.QueryParam[0]));
    }

    @Test(groups={"delta-lake-databricks", "delta-lake-oss", "delta-lake-exclude-91", "profile_specific_tests"}, dataProvider="columnMappingDataProvider")
    @Flaky(issue="https://github.com/trinodb/trino/issues/14391", match="\\Q[Databricks][DatabricksJDBCDriver](500593) Communication link failure. Failed to connect to server. Reason: \\E(HTTP retry after response received with no Retry-After header, error: HTTP Response code: 503|HTTP Response code: 504), Error message: Unknown.")
    public void testDeltaColumnMappingMode(String mode) {
        this.testColumnMappingMode(tableName -> QueryExecutors.onDelta().executeQuery("CREATE TABLE default." + tableName + " (a_number INT, array_col ARRAY<STRUCT<array_struct_element: STRING>>, nested STRUCT<field1: STRING>, a_string STRING, part STRING) USING delta  PARTITIONED BY (part) LOCATION 's3://" + this.bucketName + "/databricks-compatibility-test-" + tableName + "' TBLPROPERTIES ( 'delta.columnMapping.mode'='" + mode + "', 'delta.minReaderVersion'='2', 'delta.minWriterVersion'='5')", new QueryExecutor.QueryParam[0]));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testColumnMappingMode(Consumer<String> createTable) {
        String tableName = "test_dl_column_mapping_mode_name_" + TestingNames.randomNameSuffix();
        createTable.accept(tableName);
        try {
            QueryExecutors.onDelta().executeQuery("INSERT INTO default." + tableName + " VALUES (1, array(struct('nested 1')), struct('databricks 1'),'ala', 'part1')", new QueryExecutor.QueryParam[0]);
            QueryExecutors.onTrino().executeQuery("INSERT INTO delta.default." + tableName + " VALUES (2, ARRAY[ROW('nested 2')], ROW('databricks 2'), 'kota', 'part2')", new QueryExecutor.QueryParam[0]);
            ImmutableList expectedRows = ImmutableList.of((Object)QueryAssert.Row.row((Object[])new Object[]{1, "nested 1", "databricks 1", "ala", "part1"}), (Object)QueryAssert.Row.row((Object[])new Object[]{2, "nested 2", "databricks 2", "kota", "part2"}));
            ((QueryAssert)Assertions.assertThat((AssertProvider)QueryExecutors.onDelta().executeQuery("SELECT a_number, array_col[0].array_struct_element, nested.field1, a_string, part FROM default." + tableName, new QueryExecutor.QueryParam[0]))).containsOnly((List)expectedRows);
            ((QueryAssert)Assertions.assertThat((AssertProvider)QueryExecutors.onTrino().executeQuery("SELECT a_number, array_col[1].array_struct_element, nested.field1, a_string, part FROM delta.default." + tableName, new QueryExecutor.QueryParam[0]))).containsOnly((List)expectedRows);
            ((QueryAssert)Assertions.assertThat((AssertProvider)QueryExecutors.onTrino().executeQuery("SELECT a_string FROM delta.default." + tableName + " WHERE a_number = 1", new QueryExecutor.QueryParam[0]))).containsOnly((List)ImmutableList.of((Object)QueryAssert.Row.row((Object[])new Object[]{"ala"})));
            ((QueryAssert)Assertions.assertThat((AssertProvider)QueryExecutors.onTrino().executeQuery("SELECT a_number FROM delta.default." + tableName + " WHERE nested.field1 = 'databricks 1'", new QueryExecutor.QueryParam[0]))).containsOnly((List)ImmutableList.of((Object)QueryAssert.Row.row((Object[])new Object[]{1})));
            ((QueryAssert)Assertions.assertThat((AssertProvider)QueryExecutors.onTrino().executeQuery("SELECT a_number FROM delta.default." + tableName + " WHERE part = 'part1'", new QueryExecutor.QueryParam[0]))).containsOnly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{1})});
            ((QueryAssert)Assertions.assertThat((AssertProvider)QueryExecutors.onDelta().executeQuery("SELECT a_number FROM default." + tableName + " WHERE part = 'part1'", new QueryExecutor.QueryParam[0]))).containsOnly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{1})});
            QueryExecutors.onDelta().executeQuery("ALTER TABLE default." + tableName + " RENAME COLUMN a_number TO new_a_column", new QueryExecutor.QueryParam[0]);
            QueryExecutors.onDelta().executeQuery("ALTER TABLE default." + tableName + " RENAME COLUMN nested.field1 TO field2", new QueryExecutor.QueryParam[0]);
            QueryExecutors.onDelta().executeQuery("ALTER TABLE default." + tableName + " RENAME COLUMN part TO new_part", new QueryExecutor.QueryParam[0]);
            ((QueryAssert)Assertions.assertThat((AssertProvider)QueryExecutors.onTrino().executeQuery("DESCRIBE delta.default." + tableName, new QueryExecutor.QueryParam[0]))).containsOnly((List)ImmutableList.of((Object)QueryAssert.Row.row((Object[])new Object[]{"new_a_column", "integer", "", ""}), (Object)QueryAssert.Row.row((Object[])new Object[]{"array_col", "array(row(array_struct_element varchar))", "", ""}), (Object)QueryAssert.Row.row((Object[])new Object[]{"nested", "row(field2 varchar)", "", ""}), (Object)QueryAssert.Row.row((Object[])new Object[]{"a_string", "varchar", "", ""}), (Object)QueryAssert.Row.row((Object[])new Object[]{"new_part", "varchar", "", ""})));
            ((QueryAssert)Assertions.assertThat((AssertProvider)QueryExecutors.onDelta().executeQuery("SELECT new_a_column, array_col[0].array_struct_element, nested.field2, a_string, new_part FROM default." + tableName, new QueryExecutor.QueryParam[0]))).containsOnly((List)expectedRows);
            ((QueryAssert)Assertions.assertThat((AssertProvider)QueryExecutors.onTrino().executeQuery("SELECT new_a_column, array_col[1].array_struct_element, nested.field2, a_string, new_part FROM delta.default." + tableName, new QueryExecutor.QueryParam[0]))).containsOnly((List)expectedRows);
        }
        finally {
            DeltaLakeTestUtils.dropDeltaTableWithRetry("default." + tableName);
        }
    }

    @Test(groups={"delta-lake-oss", "profile_specific_tests"})
    public void testColumnMappingModeNameWithNonLowerCaseColumn() {
        String tableName = "test_dl_column_mapping_mode_name_non_loewr_case_" + TestingNames.randomNameSuffix();
        QueryExecutors.onDelta().executeQuery("CREATE TABLE default." + tableName + " (`mIxEd_CaSe` INT) USING delta  LOCATION 's3://" + this.bucketName + "/databricks-compatibility-test-" + tableName + "' TBLPROPERTIES ( 'delta.columnMapping.mode'='name', 'delta.minReaderVersion'='2', 'delta.minWriterVersion'='5')", new QueryExecutor.QueryParam[0]);
        try {
            QueryExecutors.onDelta().executeQuery("INSERT INTO default." + tableName + " VALUES (0), (9)", new QueryExecutor.QueryParam[0]);
            ImmutableList expectedRows = ImmutableList.of((Object)QueryAssert.Row.row((Object[])new Object[]{0}), (Object)QueryAssert.Row.row((Object[])new Object[]{9}));
            ((QueryAssert)Assertions.assertThat((AssertProvider)QueryExecutors.onDelta().executeQuery("SELECT * FROM default." + tableName, new QueryExecutor.QueryParam[0]))).containsOnly((List)expectedRows);
            ((QueryAssert)Assertions.assertThat((AssertProvider)QueryExecutors.onTrino().executeQuery("SELECT * FROM delta.default." + tableName, new QueryExecutor.QueryParam[0]))).containsOnly((List)expectedRows);
            ((QueryAssert)Assertions.assertThat((AssertProvider)QueryExecutors.onTrino().executeQuery("SHOW STATS FOR delta.default." + tableName, new QueryExecutor.QueryParam[0]))).containsOnly((List)ImmutableList.of((Object)QueryAssert.Row.row((Object[])new Object[]{"mixed_case", null, null, 0.0, null, "0", "9"}), (Object)QueryAssert.Row.row((Object[])new Object[]{null, null, null, null, 2.0, null, null})));
            QueryExecutors.onTrino().executeQuery("COMMENT ON COLUMN delta.default." + tableName + ".mixed_case IS 'test column comment'", new QueryExecutor.QueryParam[0]);
            Assert.assertEquals((String)DeltaLakeTestUtils.getColumnCommentOnTrino("default", tableName, "mixed_case"), (String)"test column comment");
            Assert.assertEquals((String)DeltaLakeTestUtils.getColumnCommentOnDelta("default", tableName, "mixed_case"), (String)"test column comment");
        }
        finally {
            DeltaLakeTestUtils.dropDeltaTableWithRetry("default." + tableName);
        }
    }

    @Test(groups={"delta-lake-oss", "profile_specific_tests"})
    public void testColumnMappingModeNameCreatePartitionTableAsSelect() {
        String tableName = "test_dl_create_partition_table_as_select_" + TestingNames.randomNameSuffix();
        QueryExecutors.onTrino().executeQuery("CREATE TABLE delta.default." + tableName + " WITH (location = 's3://" + this.bucketName + "/databricks-compatibility-test-" + tableName + "',column_mapping_mode = 'name')AS SELECT 1 AS id, 'part#1' AS part", new QueryExecutor.QueryParam[0]);
        try {
            QueryAssert.Row expected = QueryAssert.Row.row((Object[])new Object[]{1, "part#1"});
            ((QueryAssert)Assertions.assertThat((AssertProvider)QueryExecutors.onTrino().executeQuery("SELECT * FROM delta.default." + tableName, new QueryExecutor.QueryParam[0]))).containsOnly(new QueryAssert.Row[]{expected});
            ((QueryAssert)Assertions.assertThat((AssertProvider)QueryExecutors.onDelta().executeQuery("SELECT * FROM default." + tableName, new QueryExecutor.QueryParam[0]))).containsOnly(new QueryAssert.Row[]{expected});
        }
        finally {
            QueryExecutors.onTrino().executeQuery("DROP TABLE delta.default." + tableName, new QueryExecutor.QueryParam[0]);
        }
    }

    @Test(groups={"delta-lake-oss", "profile_specific_tests"})
    public void testCreateTableWithCommentsColumnMappingModeName() {
        String tableName = "test_dl_create_table_with_comments_" + TestingNames.randomNameSuffix();
        QueryExecutors.onTrino().executeQuery("CREATE TABLE delta.default." + tableName + "(col INT COMMENT 'test column comment')COMMENT 'test table comment'WITH (  location = 's3://" + this.bucketName + "/databricks-compatibility-test-" + tableName + "', column_mapping_mode = 'name')", new QueryExecutor.QueryParam[0]);
        try {
            Assert.assertEquals((String)DeltaLakeTestUtils.getTableCommentOnTrino("default", tableName), (String)"test table comment");
            Assert.assertEquals((String)DeltaLakeTestUtils.getTableCommentOnDelta("default", tableName), (String)"test table comment");
            Assert.assertEquals((String)DeltaLakeTestUtils.getColumnCommentOnTrino("default", tableName, "col"), (String)"test column comment");
            Assert.assertEquals((String)DeltaLakeTestUtils.getColumnCommentOnDelta("default", tableName, "col"), (String)"test column comment");
        }
        finally {
            QueryExecutors.onTrino().executeQuery("DROP TABLE delta.default." + tableName, new QueryExecutor.QueryParam[0]);
        }
    }

    @Test(groups={"delta-lake-oss", "profile_specific_tests"})
    public void testColumnMappingModeNameCommentOnTable() {
        String tableName = "test_dl_column_mapping_mode_comment_on_table_" + TestingNames.randomNameSuffix();
        QueryExecutors.onDelta().executeQuery("CREATE TABLE default." + tableName + " (a_number INT) USING delta  LOCATION 's3://" + this.bucketName + "/databricks-compatibility-test-" + tableName + "' TBLPROPERTIES ( 'delta.columnMapping.mode' = 'name')", new QueryExecutor.QueryParam[0]);
        try {
            QueryExecutors.onTrino().executeQuery("COMMENT ON TABLE delta.default." + tableName + " IS 'test comment by trino'", new QueryExecutor.QueryParam[0]);
            Assert.assertEquals((String)DeltaLakeTestUtils.getTableCommentOnTrino("default", tableName), (String)"test comment by trino");
            Assert.assertEquals((String)DeltaLakeTestUtils.getTableCommentOnDelta("default", tableName), (String)"test comment by trino");
            QueryExecutors.onDelta().executeQuery("COMMENT ON TABLE default." + tableName + " IS 'test comment by delta'", new QueryExecutor.QueryParam[0]);
            Assert.assertEquals((String)DeltaLakeTestUtils.getTableCommentOnTrino("default", tableName), (String)"test comment by delta");
            Assert.assertEquals((String)DeltaLakeTestUtils.getTableCommentOnDelta("default", tableName), (String)"test comment by delta");
        }
        finally {
            DeltaLakeTestUtils.dropDeltaTableWithRetry("default." + tableName);
        }
    }

    @Test(groups={"delta-lake-oss", "profile_specific_tests"})
    public void testColumnMappingModeNameCommentOnColumn() {
        String tableName = "test_dl_column_mapping_mode_comment_on_column_" + TestingNames.randomNameSuffix();
        QueryExecutors.onTrino().executeQuery("CREATE TABLE delta.default." + tableName + " (col INT) WITH (  location = 's3://" + this.bucketName + "/databricks-compatibility-test-" + tableName + "', column_mapping_mode = 'name')", new QueryExecutor.QueryParam[0]);
        try {
            QueryExecutors.onTrino().executeQuery("COMMENT ON COLUMN delta.default." + tableName + ".col IS 'test column comment by trino'", new QueryExecutor.QueryParam[0]);
            Assert.assertEquals((String)DeltaLakeTestUtils.getColumnCommentOnTrino("default", tableName, "col"), (String)"test column comment by trino");
            Assert.assertEquals((String)DeltaLakeTestUtils.getColumnCommentOnDelta("default", tableName, "col"), (String)"test column comment by trino");
            QueryExecutors.onDelta().executeQuery("ALTER TABLE default." + tableName + " ALTER COLUMN col COMMENT 'test column comment by delta'", new QueryExecutor.QueryParam[0]);
            Assert.assertEquals((String)DeltaLakeTestUtils.getColumnCommentOnTrino("default", tableName, "col"), (String)"test column comment by delta");
            Assert.assertEquals((String)DeltaLakeTestUtils.getColumnCommentOnDelta("default", tableName, "col"), (String)"test column comment by delta");
        }
        finally {
            DeltaLakeTestUtils.dropDeltaTableWithRetry("default." + tableName);
        }
    }

    @Test(groups={"delta-lake-oss", "profile_specific_tests"})
    public void testColumnMappingModeNameAddColumn() {
        this.testColumnMappingModeAddColumn("name", tableName -> {
            QueryExecutors.onTrino().executeQuery("ALTER TABLE delta.default." + tableName + " ADD COLUMN another_varchar VARCHAR", new QueryExecutor.QueryParam[0]);
            QueryExecutors.onDelta().executeQuery("ALTER TABLE default." + tableName + " ADD COLUMN a_array array<integer>", new QueryExecutor.QueryParam[0]);
            QueryExecutors.onTrino().executeQuery("ALTER TABLE delta.default." + tableName + " ADD COLUMN a_map map(varchar, integer)", new QueryExecutor.QueryParam[0]);
            QueryExecutors.onDelta().executeQuery("ALTER TABLE default." + tableName + " ADD COLUMN a_row struct<x integer>", new QueryExecutor.QueryParam[0]);
        });
    }

    @Test(groups={"delta-lake-oss", "profile_specific_tests"})
    public void testColumnMappingModeIdAddColumn() {
        this.testColumnMappingModeAddColumn("id", tableName -> {
            QueryExecutors.onDelta().executeQuery("ALTER TABLE default." + tableName + " ADD COLUMN another_varchar STRING", new QueryExecutor.QueryParam[0]);
            QueryExecutors.onTrino().executeQuery("ALTER TABLE delta.default." + tableName + " ADD COLUMN a_array array(integer)", new QueryExecutor.QueryParam[0]);
            QueryExecutors.onDelta().executeQuery("ALTER TABLE default." + tableName + " ADD COLUMN a_map map<string, integer>", new QueryExecutor.QueryParam[0]);
            QueryExecutors.onTrino().executeQuery("ALTER TABLE delta.default." + tableName + " ADD COLUMN a_row row(x integer)", new QueryExecutor.QueryParam[0]);
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testColumnMappingModeAddColumn(String mode, Consumer<String> addColumn) {
        String tableName = "test_dl_column_mapping_mode_add_column_" + TestingNames.randomNameSuffix();
        QueryExecutors.onDelta().executeQuery("CREATE TABLE default." + tableName + " (a_number INT) USING delta  LOCATION 's3://" + this.bucketName + "/databricks-compatibility-test-" + tableName + "' TBLPROPERTIES ( 'delta.columnMapping.mode' = '" + mode + "')", new QueryExecutor.QueryParam[0]);
        try {
            QueryExecutors.onDelta().executeQuery("INSERT INTO default." + tableName + " VALUES (1), (2)", new QueryExecutor.QueryParam[0]);
            ImmutableList expectedRows = ImmutableList.of((Object)QueryAssert.Row.row((Object[])new Object[]{1}), (Object)QueryAssert.Row.row((Object[])new Object[]{2}));
            ((QueryAssert)Assertions.assertThat((AssertProvider)QueryExecutors.onDelta().executeQuery("SELECT * FROM default." + tableName, new QueryExecutor.QueryParam[0]))).containsOnly((List)expectedRows);
            ((QueryAssert)Assertions.assertThat((AssertProvider)QueryExecutors.onTrino().executeQuery("SELECT * FROM delta.default." + tableName, new QueryExecutor.QueryParam[0]))).containsOnly((List)expectedRows);
            addColumn.accept(tableName);
            ((QueryAssert)Assertions.assertThat((AssertProvider)QueryExecutors.onTrino().executeQuery("DESCRIBE delta.default." + tableName, new QueryExecutor.QueryParam[0]))).containsOnly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{"a_number", "integer", "", ""}), QueryAssert.Row.row((Object[])new Object[]{"another_varchar", "varchar", "", ""}), QueryAssert.Row.row((Object[])new Object[]{"a_array", "array(integer)", "", ""}), QueryAssert.Row.row((Object[])new Object[]{"a_map", "map(varchar, integer)", "", ""}), QueryAssert.Row.row((Object[])new Object[]{"a_row", "row(x integer)", "", ""})});
            QueryExecutors.onDelta().executeQuery("INSERT INTO default." + tableName + " VALUES (3, 'new column', array(3), map('key', 4), named_struct('x', 5))", new QueryExecutor.QueryParam[0]);
            expectedRows = ImmutableList.of((Object)QueryAssert.Row.row((Object[])new Object[]{1, null, null, null, null}), (Object)QueryAssert.Row.row((Object[])new Object[]{2, null, null, null, null}), (Object)QueryAssert.Row.row((Object[])new Object[]{3, "new column", 3, 4, 5}));
            ((QueryAssert)Assertions.assertThat((AssertProvider)QueryExecutors.onDelta().executeQuery("SELECT a_number, another_varchar, a_array[0], a_map['key'], a_row.x FROM default." + tableName, new QueryExecutor.QueryParam[0]))).containsOnly((List)expectedRows);
            ((QueryAssert)Assertions.assertThat((AssertProvider)QueryExecutors.onTrino().executeQuery("SELECT a_number, another_varchar, a_array[1], a_map['key'], a_row.x FROM delta.default." + tableName, new QueryExecutor.QueryParam[0]))).containsOnly((List)expectedRows);
            Assertions.assertThat((String)DeltaLakeTestUtils.getTablePropertyOnDelta("default", tableName, "delta.columnMapping.maxColumnId")).isEqualTo("6");
            QueryExecutors.onDelta().executeQuery("REPLACE TABLE default." + tableName + " USING DELTA PARTITIONED BY (another_varchar) AS SELECT * FROM " + tableName, new QueryExecutor.QueryParam[0]);
            ((QueryAssert)Assertions.assertThat((AssertProvider)QueryExecutors.onTrino().executeQuery("SELECT a_number, another_varchar, a_array[1], a_map['key'], a_row.x FROM delta.default." + tableName, new QueryExecutor.QueryParam[0]))).containsOnly((List)expectedRows);
        }
        finally {
            DeltaLakeTestUtils.dropDeltaTableWithRetry("default." + tableName);
        }
    }

    @Test(groups={"delta-lake-oss", "profile_specific_tests"})
    public void testTrinoColumnMappingModeNameAddColumnWithExistingNonLowerCaseColumn() {
        String tableName = "test_dl_column_mapping_mode_add_column_existing_non_lowercase_" + TestingNames.randomNameSuffix();
        QueryExecutors.onDelta().executeQuery("CREATE TABLE default." + tableName + " (UPPER_CASE INT) USING delta LOCATION 's3://" + this.bucketName + "/databricks-compatibility-test-" + tableName + "' TBLPROPERTIES ( 'delta.columnMapping.mode' = 'name')", new QueryExecutor.QueryParam[0]);
        try {
            QueryExecutors.onDelta().executeQuery("INSERT INTO default." + tableName + " VALUES 1", new QueryExecutor.QueryParam[0]);
            QueryExecutors.onTrino().executeQuery("ALTER TABLE delta.default." + tableName + " ADD COLUMN new_col VARCHAR", new QueryExecutor.QueryParam[0]);
            ((QueryAssert)Assertions.assertThat((AssertProvider)QueryExecutors.onTrino().executeQuery("SELECT * FROM delta.default." + tableName, new QueryExecutor.QueryParam[0]))).containsOnly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{1, null})});
            Assertions.assertThat(DeltaLakeTestUtils.getColumnNamesOnDelta("default", tableName)).containsExactly((Object[])new String[]{"UPPER_CASE", "new_col"});
        }
        finally {
            DeltaLakeTestUtils.dropDeltaTableWithRetry("default." + tableName);
        }
    }

    @Test(groups={"delta-lake-oss", "profile_specific_tests"})
    public void testShowStatsFromJsonForColumnMappingMode() {
        String tableName = "test_dl_show_stats_json_for_column_mapping_mode_" + TestingNames.randomNameSuffix();
        QueryExecutors.onDelta().executeQuery("CREATE TABLE default." + tableName + " (a_number INT) USING delta  LOCATION 's3://" + this.bucketName + "/databricks-compatibility-test-" + tableName + "' TBLPROPERTIES ( 'delta.columnMapping.mode' = 'id')", new QueryExecutor.QueryParam[0]);
        try {
            QueryExecutors.onDelta().executeQuery("INSERT INTO default." + tableName + " VALUES (1), (2), (null)", new QueryExecutor.QueryParam[0]);
            ((QueryAssert)Assertions.assertThat((AssertProvider)QueryExecutors.onTrino().executeQuery("SHOW STATS FOR delta.default." + tableName, new QueryExecutor.QueryParam[0]))).containsOnly((List)ImmutableList.of((Object)QueryAssert.Row.row((Object[])new Object[]{"a_number", null, null, 0.33333333333, null, "1", "2"}), (Object)QueryAssert.Row.row((Object[])new Object[]{null, null, null, null, 3.0, null, null})));
            QueryExecutors.onTrino().executeQuery("ANALYZE delta.default." + tableName, new QueryExecutor.QueryParam[0]);
            ((QueryAssert)Assertions.assertThat((AssertProvider)QueryExecutors.onTrino().executeQuery("SHOW STATS FOR delta.default." + tableName, new QueryExecutor.QueryParam[0]))).containsOnly((List)ImmutableList.of((Object)QueryAssert.Row.row((Object[])new Object[]{"a_number", null, 2.0, 0.33333333333, null, "1", "2"}), (Object)QueryAssert.Row.row((Object[])new Object[]{null, null, null, null, 3.0, null, null})));
        }
        finally {
            DeltaLakeTestUtils.dropDeltaTableWithRetry("default." + tableName);
        }
    }

    @Test(groups={"delta-lake-oss", "profile_specific_tests"})
    public void testShowStatsFromParquetForColumnMappingModeName() {
        String tableName = "test_dl_show_parquet_stats_parquet_for_column_mapping_mode_" + TestingNames.randomNameSuffix();
        QueryExecutors.onDelta().executeQuery("CREATE TABLE default." + tableName + " (a_number INT) USING delta  LOCATION 's3://" + this.bucketName + "/databricks-compatibility-test-" + tableName + "' TBLPROPERTIES ( 'delta.columnMapping.mode' = 'name', 'delta.checkpointInterval' = 3)", new QueryExecutor.QueryParam[0]);
        try {
            QueryExecutors.onDelta().executeQuery("INSERT INTO default." + tableName + " VALUES (0)", new QueryExecutor.QueryParam[0]);
            QueryExecutors.onDelta().executeQuery("INSERT INTO default." + tableName + " VALUES (1)", new QueryExecutor.QueryParam[0]);
            QueryExecutors.onDelta().executeQuery("INSERT INTO default." + tableName + " VALUES (null)", new QueryExecutor.QueryParam[0]);
            ((QueryAssert)Assertions.assertThat((AssertProvider)QueryExecutors.onTrino().executeQuery("SHOW STATS FOR delta.default." + tableName, new QueryExecutor.QueryParam[0]))).containsOnly((List)ImmutableList.of((Object)QueryAssert.Row.row((Object[])new Object[]{"a_number", null, null, 0.33333333333, null, "0", "1"}), (Object)QueryAssert.Row.row((Object[])new Object[]{null, null, null, null, 3.0, null, null})));
            QueryExecutors.onTrino().executeQuery("ANALYZE delta.default." + tableName, new QueryExecutor.QueryParam[0]);
            ((QueryAssert)Assertions.assertThat((AssertProvider)QueryExecutors.onTrino().executeQuery("SHOW STATS FOR delta.default." + tableName, new QueryExecutor.QueryParam[0]))).containsOnly((List)ImmutableList.of((Object)QueryAssert.Row.row((Object[])new Object[]{"a_number", null, 2.0, 0.33333333333, null, "0", "1"}), (Object)QueryAssert.Row.row((Object[])new Object[]{null, null, null, null, 3.0, null, null})));
        }
        finally {
            DeltaLakeTestUtils.dropDeltaTableWithRetry("default." + tableName);
        }
    }

    @Test(groups={"delta-lake-oss", "profile_specific_tests"})
    public void testShowStatsOnPartitionedForColumnMappingModeId() {
        String tableName = "test_dl_show_stats_partitioned_for_column_mapping_mode_" + TestingNames.randomNameSuffix();
        QueryExecutors.onDelta().executeQuery("CREATE TABLE default." + tableName + " (a_number INT, part STRING) USING delta  PARTITIONED BY (part)  LOCATION 's3://" + this.bucketName + "/databricks-compatibility-test-" + tableName + "' TBLPROPERTIES ( 'delta.columnMapping.mode' = 'id', 'delta.checkpointInterval' = 3)", new QueryExecutor.QueryParam[0]);
        try {
            QueryExecutors.onDelta().executeQuery("INSERT INTO default." + tableName + " VALUES (0, 'a')", new QueryExecutor.QueryParam[0]);
            QueryExecutors.onDelta().executeQuery("INSERT INTO default." + tableName + " VALUES (1, 'b')", new QueryExecutor.QueryParam[0]);
            QueryExecutors.onDelta().executeQuery("INSERT INTO default." + tableName + " VALUES (null, null)", new QueryExecutor.QueryParam[0]);
            ((QueryAssert)Assertions.assertThat((AssertProvider)QueryExecutors.onTrino().executeQuery("SHOW STATS FOR delta.default." + tableName, new QueryExecutor.QueryParam[0]))).containsOnly((List)ImmutableList.of((Object)QueryAssert.Row.row((Object[])new Object[]{"a_number", null, null, 0.33333333333, null, "0", "1"}), (Object)QueryAssert.Row.row((Object[])new Object[]{"part", null, 2.0, 0.33333333333, null, null, null}), (Object)QueryAssert.Row.row((Object[])new Object[]{null, null, null, null, 3.0, null, null})));
        }
        finally {
            DeltaLakeTestUtils.dropDeltaTableWithRetry("default." + tableName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(groups={"delta-lake-databricks", "delta-lake-oss", "delta-lake-exclude-91", "profile_specific_tests"}, dataProvider="columnMappingDataProvider")
    @Flaky(issue="https://github.com/trinodb/trino/issues/14391", match="\\Q[Databricks][DatabricksJDBCDriver](500593) Communication link failure. Failed to connect to server. Reason: \\E(HTTP retry after response received with no Retry-After header, error: HTTP Response code: 503|HTTP Response code: 504), Error message: Unknown.")
    public void testProjectionPushdownDmlWithColumnMappingMode(String mode) {
        String sourceTableName = "test_projection_pushdown_source_column_mapping_mode_" + TestingNames.randomNameSuffix();
        String targetTableName = "test_projection_pushdown_target_column_mapping_mode_" + TestingNames.randomNameSuffix();
        QueryExecutors.onDelta().executeQuery("CREATE TABLE default." + targetTableName + " (nation STRUCT<key INT, name STRING>, regionkey INT) USING DELTA LOCATION 's3://" + this.bucketName + "/databricks-compatibility-test-" + targetTableName + "'TBLPROPERTIES ('delta.columnMapping.mode' = '" + mode + "')", new QueryExecutor.QueryParam[0]);
        QueryExecutors.onDelta().executeQuery("CREATE TABLE default." + sourceTableName + "  (nation STRUCT<key INT, name STRING>, regionkey INT) USING DELTA LOCATION 's3://" + this.bucketName + "/databricks-compatibility-test-" + sourceTableName + "'", new QueryExecutor.QueryParam[0]);
        try {
            QueryExecutors.onDelta().executeQuery("INSERT INTO default." + targetTableName + " VALUES (struct(1, 'nation1'), 100), (struct(2, 'nation2'), 200), (struct(3, 'nation3'), 300), (struct(4, 'nation4'), 400)", new QueryExecutor.QueryParam[0]);
            QueryExecutors.onDelta().executeQuery("INSERT INTO default." + sourceTableName + " VALUES (struct(1000, 'nation1000'), 1000), (struct(2, 'nation2'), 20000), (struct(3000, 'nation3000'), 3000), (struct(4, 'nation4'), 40000)", new QueryExecutor.QueryParam[0]);
            QueryExecutors.onDelta().executeQuery("MERGE INTO default." + targetTableName + " target USING default." + sourceTableName + " source ON (target.nation.key = source.nation.key) WHEN MATCHED AND source.nation.name = 'nation4' THEN DELETE WHEN MATCHED THEN UPDATE SET nation.key = (target.nation.key + source.nation.key + source.regionkey) WHEN NOT MATCHED THEN INSERT (nation, regionkey) VALUES (source.nation, source.regionkey)", new QueryExecutor.QueryParam[0]);
            ((QueryAssert)Assertions.assertThat((AssertProvider)QueryExecutors.onTrino().executeQuery("SELECT nation.key, nation.name, regionkey FROM " + targetTableName, new QueryExecutor.QueryParam[0]))).containsOnly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{1000, "nation1000", 1000}), QueryAssert.Row.row((Object[])new Object[]{3000, "nation3000", 3000}), QueryAssert.Row.row((Object[])new Object[]{1, "nation1", 100}), QueryAssert.Row.row((Object[])new Object[]{3, "nation3", 300}), QueryAssert.Row.row((Object[])new Object[]{20004, "nation2", 200})});
            QueryExecutors.onDelta().executeQuery("DELETE FROM " + targetTableName + " WHERE regionkey = 100", new QueryExecutor.QueryParam[0]);
            QueryExecutors.onDelta().executeQuery("UPDATE " + targetTableName + " SET nation.name = 'nation20004' WHERE regionkey = 200", new QueryExecutor.QueryParam[0]);
            ((QueryAssert)Assertions.assertThat((AssertProvider)QueryExecutors.onTrino().executeQuery("SELECT nation.key, nation.name, regionkey FROM " + targetTableName, new QueryExecutor.QueryParam[0]))).containsOnly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{1000, "nation1000", 1000}), QueryAssert.Row.row((Object[])new Object[]{3000, "nation3000", 3000}), QueryAssert.Row.row((Object[])new Object[]{3, "nation3", 300}), QueryAssert.Row.row((Object[])new Object[]{20004, "nation20004", 200})});
        }
        finally {
            DeltaLakeTestUtils.dropDeltaTableWithRetry("default." + targetTableName);
            DeltaLakeTestUtils.dropDeltaTableWithRetry("default." + sourceTableName);
        }
    }

    @Test(groups={"delta-lake-oss", "profile_specific_tests"})
    public void testChangeColumnMappingAndShowStatsForColumnMappingMode() {
        String tableName = "test_dl_change_column_mapping_and_show_stats_for_column_mapping_mode_" + TestingNames.randomNameSuffix();
        QueryExecutors.onDelta().executeQuery("CREATE TABLE default." + tableName + " (a_number INT, b_number INT) USING delta  LOCATION 's3://" + this.bucketName + "/databricks-compatibility-test-" + tableName + "' TBLPROPERTIES ( 'delta.columnMapping.mode'='none', 'delta.minReaderVersion'='2', 'delta.minWriterVersion'='5')", new QueryExecutor.QueryParam[0]);
        try {
            QueryExecutors.onDelta().executeQuery("INSERT INTO default." + tableName + " VALUES (1, 10), (2, 20), (null, null)", new QueryExecutor.QueryParam[0]);
            QueryExecutors.onTrino().executeQuery("ANALYZE delta.default." + tableName, new QueryExecutor.QueryParam[0]);
            ((QueryAssert)Assertions.assertThat((AssertProvider)QueryExecutors.onTrino().executeQuery("SHOW STATS FOR delta.default." + tableName, new QueryExecutor.QueryParam[0]))).containsOnly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{"a_number", null, 2.0, 0.33333333333, null, "1", "2"}), QueryAssert.Row.row((Object[])new Object[]{"b_number", null, 2.0, 0.33333333333, null, "10", "20"}), QueryAssert.Row.row((Object[])new Object[]{null, null, null, null, 3.0, null, null})});
            QueryExecutors.onDelta().executeQuery("ALTER TABLE default." + tableName + " SET TBLPROPERTIES('delta.columnMapping.mode'='name')", new QueryExecutor.QueryParam[0]);
            QueryExecutors.onDelta().executeQuery("ALTER TABLE default." + tableName + " DROP COLUMN b_number", new QueryExecutor.QueryParam[0]);
            QueryExecutors.onDelta().executeQuery("ALTER TABLE default." + tableName + " ADD COLUMN b_number INT", new QueryExecutor.QueryParam[0]);
            ((QueryAssert)Assertions.assertThat((AssertProvider)QueryExecutors.onTrino().executeQuery("SHOW STATS FOR delta.default." + tableName, new QueryExecutor.QueryParam[0]))).containsOnly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{"a_number", null, 2.0, 0.33333333333, null, "1", "2"}), QueryAssert.Row.row((Object[])new Object[]{"b_number", null, null, null, null, null, null}), QueryAssert.Row.row((Object[])new Object[]{null, null, null, null, 3.0, null, null})});
            QueryExecutors.onTrino().executeQuery("ANALYZE delta.default." + tableName, new QueryExecutor.QueryParam[0]);
            ((QueryAssert)Assertions.assertThat((AssertProvider)QueryExecutors.onTrino().executeQuery("SHOW STATS FOR delta.default." + tableName, new QueryExecutor.QueryParam[0]))).containsOnly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{"a_number", null, 2.0, 0.33333333333, null, "1", "2"}), QueryAssert.Row.row((Object[])new Object[]{"b_number", 0.0, 0.0, 1.0, null, null, null}), QueryAssert.Row.row((Object[])new Object[]{null, null, null, null, 3.0, null, null})});
        }
        finally {
            DeltaLakeTestUtils.dropDeltaTableWithRetry("default." + tableName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(groups={"delta-lake-oss", "profile_specific_tests"}, dataProvider="changeColumnMappingDataProvider")
    public void testChangeColumnMappingMode(String sourceMappingMode, String targetMappingMode, boolean supported) {
        String tableName = "test_dl_change_column_mapping_mode_" + TestingNames.randomNameSuffix();
        QueryExecutors.onDelta().executeQuery("CREATE TABLE default." + tableName + " (a_number INT) USING delta  LOCATION 's3://" + this.bucketName + "/databricks-compatibility-test-" + tableName + "' TBLPROPERTIES ( 'delta.columnMapping.mode'='" + sourceMappingMode + "', 'delta.minReaderVersion'='2', 'delta.minWriterVersion'='5')", new QueryExecutor.QueryParam[0]);
        try {
            if (supported) {
                QueryExecutors.onDelta().executeQuery("ALTER TABLE default." + tableName + " SET TBLPROPERTIES('delta.columnMapping.mode'='" + targetMappingMode + "')", new QueryExecutor.QueryParam[0]);
            } else {
                QueryAssert.assertQueryFailure(() -> QueryExecutors.onDelta().executeQuery("ALTER TABLE default." + tableName + " SET TBLPROPERTIES('delta.columnMapping.mode'='" + targetMappingMode + "')", new QueryExecutor.QueryParam[0])).hasMessageContaining("Changing column mapping mode from '%s' to '%s' is not supported".formatted(sourceMappingMode, targetMappingMode));
            }
        }
        finally {
            DeltaLakeTestUtils.dropDeltaTableWithRetry("default." + tableName);
        }
    }

    @Test(groups={"delta-lake-oss", "profile_specific_tests"})
    public void testRecalculateStatsForColumnMappingModeIdAndNoInitialStatistics() {
        String tableName = "test_recalculate_stats_for_column_mapping_mode_" + TestingNames.randomNameSuffix();
        QueryExecutors.onDelta().executeQuery("CREATE TABLE default." + tableName + " (a_number INT, a_string STRING) USING delta  LOCATION 's3://" + this.bucketName + "/databricks-compatibility-test-" + tableName + "' TBLPROPERTIES ( 'delta.columnMapping.mode' = 'id',  'delta.dataSkippingNumIndexedCols' = 0)", new QueryExecutor.QueryParam[0]);
        try {
            ImmutableList expectedRows = ImmutableList.of((Object)QueryAssert.Row.row((Object[])new Object[]{1, "a"}), (Object)QueryAssert.Row.row((Object[])new Object[]{2, "bc"}), (Object)QueryAssert.Row.row((Object[])new Object[]{null, null}));
            QueryExecutors.onDelta().executeQuery("INSERT INTO default." + tableName + " VALUES (1, 'a'), (2, 'bc'), (null, null)", new QueryExecutor.QueryParam[0]);
            ((QueryAssert)Assertions.assertThat((AssertProvider)QueryExecutors.onDelta().executeQuery("SELECT * FROM default." + tableName, new QueryExecutor.QueryParam[0]))).containsOnly((List)expectedRows);
            ((QueryAssert)Assertions.assertThat((AssertProvider)QueryExecutors.onTrino().executeQuery("SELECT * FROM delta.default." + tableName, new QueryExecutor.QueryParam[0]))).containsOnly((List)expectedRows);
            ((QueryAssert)Assertions.assertThat((AssertProvider)QueryExecutors.onTrino().executeQuery("SHOW STATS FOR delta.default." + tableName, new QueryExecutor.QueryParam[0]))).containsOnly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{"a_number", null, null, null, null, null, null}), QueryAssert.Row.row((Object[])new Object[]{"a_string", null, null, null, null, null, null}), QueryAssert.Row.row((Object[])new Object[]{null, null, null, null, 3.0, null, null})});
            QueryExecutors.onTrino().executeQuery("ANALYZE delta.default." + tableName, new QueryExecutor.QueryParam[0]);
            ((QueryAssert)Assertions.assertThat((AssertProvider)QueryExecutors.onTrino().executeQuery("SHOW STATS FOR delta.default." + tableName, new QueryExecutor.QueryParam[0]))).containsOnly((List)ImmutableList.of((Object)QueryAssert.Row.row((Object[])new Object[]{"a_number", null, 2.0, 0.33333333333, null, "1", "2"}), (Object)QueryAssert.Row.row((Object[])new Object[]{"a_string", 3.0, 2.0, 0.33333333333, null, null, null}), (Object)QueryAssert.Row.row((Object[])new Object[]{null, null, null, null, 3.0, null, null})));
            ((QueryAssert)Assertions.assertThat((AssertProvider)QueryExecutors.onDelta().executeQuery("SELECT * FROM default." + tableName, new QueryExecutor.QueryParam[0]))).containsOnly((List)expectedRows);
            ((QueryAssert)Assertions.assertThat((AssertProvider)QueryExecutors.onTrino().executeQuery("SELECT * FROM delta.default." + tableName, new QueryExecutor.QueryParam[0]))).containsOnly((List)expectedRows);
        }
        finally {
            DeltaLakeTestUtils.dropDeltaTableWithRetry("default." + tableName);
        }
    }

    @DataProvider
    public Object[][] changeColumnMappingDataProvider() {
        return new Object[][]{{"none", "id", false}, {"none", "name", true}, {"id", "none", false}, {"id", "name", false}, {"name", "none", false}, {"name", "id", false}};
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(groups={"delta-lake-oss", "profile_specific_tests"}, dataProvider="supportedColumnMappingForDmlDataProvider")
    public void testMergeUpdateWithColumnMapping(String mode) {
        String sourceTableName = "test_merge_update_source_column_mapping_mode_" + TestingNames.randomNameSuffix();
        String targetTableName = "test_merge_update_target_column_mapping_mode_" + TestingNames.randomNameSuffix();
        QueryExecutors.onDelta().executeQuery("CREATE TABLE default." + targetTableName + " (nationkey INT, name STRING, regionkey INT) USING DELTA LOCATION 's3://" + this.bucketName + "/databricks-compatibility-test-" + targetTableName + "'TBLPROPERTIES ('delta.columnMapping.mode' = '" + mode + "')", new QueryExecutor.QueryParam[0]);
        QueryExecutors.onDelta().executeQuery("CREATE TABLE default." + sourceTableName + " (nationkey INT, name STRING, regionkey INT) USING DELTA LOCATION 's3://" + this.bucketName + "/databricks-compatibility-test-" + sourceTableName + "'", new QueryExecutor.QueryParam[0]);
        try {
            QueryExecutors.onDelta().executeQuery("INSERT INTO default." + targetTableName + " VALUES (1, 'nation1', 100), (2, 'nation2', 200), (3, 'nation3', 300)", new QueryExecutor.QueryParam[0]);
            QueryExecutors.onDelta().executeQuery("INSERT INTO default." + sourceTableName + " VALUES (1000, 'nation1000', 1000), (2, 'nation2', 20000), (3000, 'nation3000', 3000)", new QueryExecutor.QueryParam[0]);
            QueryExecutors.onTrino().executeQuery("MERGE INTO delta.default." + targetTableName + " target USING delta.default." + sourceTableName + " source ON (target.nationkey = source.nationkey) WHEN MATCHED THEN UPDATE SET nationkey = (target.nationkey + source.nationkey + source.regionkey) WHEN NOT MATCHED THEN INSERT (nationkey, name, regionkey) VALUES (source.nationkey, source.name, source.regionkey)", new QueryExecutor.QueryParam[0]);
            ((QueryAssert)Assertions.assertThat((AssertProvider)QueryExecutors.onDelta().executeQuery("SELECT * FROM " + targetTableName, new QueryExecutor.QueryParam[0]))).containsOnly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{1000, "nation1000", 1000}), QueryAssert.Row.row((Object[])new Object[]{3000, "nation3000", 3000}), QueryAssert.Row.row((Object[])new Object[]{1, "nation1", 100}), QueryAssert.Row.row((Object[])new Object[]{3, "nation3", 300}), QueryAssert.Row.row((Object[])new Object[]{20004, "nation2", 200})});
        }
        finally {
            DeltaLakeTestUtils.dropDeltaTableWithRetry("default." + targetTableName);
            DeltaLakeTestUtils.dropDeltaTableWithRetry("default." + sourceTableName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(groups={"delta-lake-oss", "profile_specific_tests"}, dataProvider="supportedColumnMappingForDmlDataProvider")
    public void testMergeDeleteWithColumnMapping(String mode) {
        String sourceTableName = "test_dl_merge_delete_source_column_mapping_mode_" + mode + TestingNames.randomNameSuffix();
        String targetTableName = "test_dl_merge_delete_target_column_mapping_mode_" + mode + TestingNames.randomNameSuffix();
        QueryExecutors.onDelta().executeQuery("CREATE TABLE default." + sourceTableName + " (a_number INT, a_string STRING, array_col ARRAY<STRUCT<array_struct_element: STRING>>, nested STRUCT<field1: STRING>) USING delta  PARTITIONED BY (a_string) LOCATION 's3://" + this.bucketName + "/databricks-compatibility-test-" + sourceTableName + "' TBLPROPERTIES ( 'delta.columnMapping.mode' ='" + mode + "')", new QueryExecutor.QueryParam[0]);
        QueryExecutors.onDelta().executeQuery("CREATE TABLE default." + targetTableName + " (a_number INT, a_string STRING, array_col ARRAY<STRUCT<array_struct_element: STRING>>, nested STRUCT<field1: STRING>) USING delta  PARTITIONED BY (a_string) LOCATION 's3://" + this.bucketName + "/databricks-compatibility-test-" + targetTableName + "' TBLPROPERTIES ( 'delta.columnMapping.mode' ='" + mode + "')", new QueryExecutor.QueryParam[0]);
        try {
            QueryExecutors.onTrino().executeQuery("INSERT INTO delta.default." + sourceTableName + " VALUES (1, 'first value', ARRAY[ROW('nested 1')], ROW('databricks 1')),        (2, 'two', ARRAY[ROW('nested 2')], ROW('databricks 2')),        (3, 'third value', ARRAY[ROW('nested 3')], ROW('databricks 3')),        (4, 'four', ARRAY[ROW('nested 4')], ROW('databricks 4'))", new QueryExecutor.QueryParam[0]);
            String trinoColumns = "a_number, a_string, array_col[1].array_struct_element, nested.field1";
            String deltaColumns = "a_number, a_string, array_col[0].array_struct_element, nested.field1";
            this.assertDeltaTrinoTableEquals(sourceTableName, trinoColumns, deltaColumns, (List<QueryAssert.Row>)ImmutableList.of((Object)QueryAssert.Row.row((Object[])new Object[]{1, "first value", "nested 1", "databricks 1"}), (Object)QueryAssert.Row.row((Object[])new Object[]{2, "two", "nested 2", "databricks 2"}), (Object)QueryAssert.Row.row((Object[])new Object[]{3, "third value", "nested 3", "databricks 3"}), (Object)QueryAssert.Row.row((Object[])new Object[]{4, "four", "nested 4", "databricks 4"})));
            QueryExecutors.onTrino().executeQuery("INSERT INTO delta.default." + targetTableName + " VALUES (1000, '1000 value', ARRAY[ROW('nested 1000')], ROW('databricks 1000')),        (2, 'two', ARRAY[ROW('nested 2')], ROW('databricks 2'))", new QueryExecutor.QueryParam[0]);
            QueryExecutors.onDelta().executeQuery("INSERT INTO default." + targetTableName + " VALUES (3000, '3000 value', array(struct('nested 3000')), struct('databricks 3000')),        (4, 'four', array(struct('nested 4')), struct('databricks 4'))", new QueryExecutor.QueryParam[0]);
            this.assertDeltaTrinoTableEquals(targetTableName, trinoColumns, deltaColumns, (List<QueryAssert.Row>)ImmutableList.of((Object)QueryAssert.Row.row((Object[])new Object[]{1000, "1000 value", "nested 1000", "databricks 1000"}), (Object)QueryAssert.Row.row((Object[])new Object[]{2, "two", "nested 2", "databricks 2"}), (Object)QueryAssert.Row.row((Object[])new Object[]{3000, "3000 value", "nested 3000", "databricks 3000"}), (Object)QueryAssert.Row.row((Object[])new Object[]{4, "four", "nested 4", "databricks 4"})));
            QueryExecutors.onTrino().executeQuery("MERGE INTO delta.default." + targetTableName + " t USING delta.default." + sourceTableName + " s ON (t.a_number = s.a_number) WHEN MATCHED THEN DELETE WHEN NOT MATCHED THEN INSERT (a_number, a_string, array_col, nested) VALUES (s.a_number, s.a_string, s.array_col, s.nested)", new QueryExecutor.QueryParam[0]);
            this.assertDeltaTrinoTableEquals(targetTableName, trinoColumns, deltaColumns, (List<QueryAssert.Row>)ImmutableList.of((Object)QueryAssert.Row.row((Object[])new Object[]{1000, "1000 value", "nested 1000", "databricks 1000"}), (Object)QueryAssert.Row.row((Object[])new Object[]{3000, "3000 value", "nested 3000", "databricks 3000"}), (Object)QueryAssert.Row.row((Object[])new Object[]{1, "first value", "nested 1", "databricks 1"}), (Object)QueryAssert.Row.row((Object[])new Object[]{3, "third value", "nested 3", "databricks 3"})));
        }
        finally {
            DeltaLakeTestUtils.dropDeltaTableWithRetry("default." + sourceTableName);
            DeltaLakeTestUtils.dropDeltaTableWithRetry("default." + targetTableName);
        }
    }

    private void assertDeltaTrinoTableEquals(String tableName, String trinoQuery, String deltaQuery, List<QueryAssert.Row> expectedRows) {
        ((QueryAssert)Assertions.assertThat((AssertProvider)QueryExecutors.onDelta().executeQuery("SELECT " + deltaQuery + " FROM default." + tableName, new QueryExecutor.QueryParam[0]))).containsOnly(expectedRows);
        ((QueryAssert)Assertions.assertThat((AssertProvider)QueryExecutors.onTrino().executeQuery("SELECT " + trinoQuery + " FROM delta.default." + tableName, new QueryExecutor.QueryParam[0]))).containsOnly(expectedRows);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(groups={"delta-lake-oss", "profile_specific_tests"}, dataProvider="columnMappingDataProvider")
    public void testDropLastNonPartitionColumnWithColumnMappingMode(String mode) {
        String tableName = "test_drop_column_" + TestingNames.randomNameSuffix();
        String tableLocation = "s3://" + this.bucketName + "/databricks-compatibility-test-" + tableName;
        QueryExecutors.onTrino().executeQuery("CREATE TABLE delta.default." + tableName + " WITH (column_mapping_mode = '" + mode + "', partitioned_by = ARRAY['part'], location = '" + tableLocation + "')AS SELECT 1 data, 'part#1' part", new QueryExecutor.QueryParam[0]);
        try {
            Assertions.assertThatThrownBy(() -> QueryExecutors.onTrino().executeQuery("ALTER TABLE delta.default." + tableName + " DROP COLUMN data", new QueryExecutor.QueryParam[0])).hasMessageContaining("Dropping the last non-partition column is unsupported");
            QueryExecutors.onDelta().executeQuery("ALTER TABLE default." + tableName + " DROP COLUMN data", new QueryExecutor.QueryParam[0]);
            QueryAssert.Row expected = QueryAssert.Row.row((Object[])new Object[]{"part#1"});
            ((QueryAssert)Assertions.assertThat((AssertProvider)QueryExecutors.onTrino().executeQuery("SELECT * FROM delta.default." + tableName, new QueryExecutor.QueryParam[0]))).containsOnly(new QueryAssert.Row[]{expected});
            ((QueryAssert)Assertions.assertThat((AssertProvider)QueryExecutors.onDelta().executeQuery("SELECT * FROM default." + tableName, new QueryExecutor.QueryParam[0]))).containsOnly(new QueryAssert.Row[]{expected});
        }
        finally {
            QueryExecutors.onTrino().executeQuery("DROP TABLE delta.default." + tableName, new QueryExecutor.QueryParam[0]);
        }
    }

    @Test(groups={"delta-lake-oss", "profile_specific_tests"}, dataProvider="columnMappingDataProvider")
    public void testTrinoExtendedStatisticsDropAndAddColumnWithColumnMappingMode(String mode) {
        String tableName = "test_drop_and_add_column_" + TestingNames.randomNameSuffix();
        QueryExecutors.onDelta().executeQuery("CREATE TABLE default." + tableName + " (a INT, b INT) USING delta  LOCATION 's3://" + this.bucketName + "/databricks-compatibility-test-" + tableName + "' TBLPROPERTIES ('delta.columnMapping.mode' = '" + mode + "')", new QueryExecutor.QueryParam[0]);
        try {
            QueryExecutors.onDelta().executeQuery("INSERT INTO default." + tableName + " VALUES (1, 2)", new QueryExecutor.QueryParam[0]);
            QueryExecutors.onTrino().executeQuery("ANALYZE delta.default." + tableName, new QueryExecutor.QueryParam[0]);
            ((QueryAssert)Assertions.assertThat((AssertProvider)QueryExecutors.onTrino().executeQuery("SHOW STATS FOR delta.default." + tableName, new QueryExecutor.QueryParam[0]))).containsOnly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{"a", null, 1.0, 0.0, null, "1", "1"}), QueryAssert.Row.row((Object[])new Object[]{"b", null, 1.0, 0.0, null, "2", "2"}), QueryAssert.Row.row((Object[])new Object[]{null, null, null, null, 1.0, null, null})});
            QueryExecutors.onTrino().executeQuery("ALTER TABLE delta.default." + tableName + " DROP COLUMN b", new QueryExecutor.QueryParam[0]);
            ((QueryAssert)Assertions.assertThat((AssertProvider)QueryExecutors.onTrino().executeQuery("SHOW STATS FOR delta.default." + tableName, new QueryExecutor.QueryParam[0]))).containsOnly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{"a", null, 1.0, 0.0, null, "1", "1"}), QueryAssert.Row.row((Object[])new Object[]{null, null, null, null, 1.0, null, null})});
            QueryExecutors.onDelta().executeQuery("ALTER TABLE default." + tableName + " ADD COLUMN b INTEGER", new QueryExecutor.QueryParam[0]);
            QueryExecutors.onTrino().executeQuery("ANALYZE delta.default." + tableName, new QueryExecutor.QueryParam[0]);
            ((QueryAssert)Assertions.assertThat((AssertProvider)QueryExecutors.onTrino().executeQuery("SHOW STATS FOR delta.default." + tableName, new QueryExecutor.QueryParam[0]))).containsOnly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{"a", null, 1.0, 0.0, null, "1", "1"}), QueryAssert.Row.row((Object[])new Object[]{"b", 0.0, 0.0, 1.0, null, null, null}), QueryAssert.Row.row((Object[])new Object[]{null, null, null, null, 1.0, null, null})});
        }
        finally {
            DeltaLakeTestUtils.dropDeltaTableWithRetry("default." + tableName);
        }
    }

    @Test(groups={"delta-lake-oss", "profile_specific_tests"}, dataProvider="columnMappingDataProvider")
    public void testDropNonLowercaseColumnWithColumnMappingMode(String mode) {
        String tableName = "test_drop_non_lowercase_column_" + TestingNames.randomNameSuffix();
        QueryExecutors.onDelta().executeQuery("CREATE TABLE default." + tableName + " (UPPER_ID INT, UPPER_DATA INT, UPPER_PART STRING) USING delta  PARTITIONED BY (UPPER_PART)  LOCATION 's3://" + this.bucketName + "/databricks-compatibility-test-" + tableName + "' TBLPROPERTIES ('delta.columnMapping.mode' = '" + mode + "')", new QueryExecutor.QueryParam[0]);
        try {
            Assertions.assertThat(DeltaLakeTestUtils.getColumnNamesOnDelta("default", tableName)).containsExactly((Object[])new String[]{"UPPER_ID", "UPPER_DATA", "UPPER_PART"});
            QueryExecutors.onTrino().executeQuery("INSERT INTO delta.default." + tableName + " VALUES (1, 10, 'part#1')", new QueryExecutor.QueryParam[0]);
            ((QueryAssert)Assertions.assertThat((AssertProvider)QueryExecutors.onTrino().executeQuery("SHOW STATS FOR delta.default." + tableName, new QueryExecutor.QueryParam[0]))).containsOnly((List)ImmutableList.of((Object)QueryAssert.Row.row((Object[])new Object[]{"upper_id", null, 1.0, 0.0, null, "1", "1"}), (Object)QueryAssert.Row.row((Object[])new Object[]{"upper_data", null, 1.0, 0.0, null, "10", "10"}), (Object)QueryAssert.Row.row((Object[])new Object[]{"upper_part", null, 1.0, 0.0, null, null, null}), (Object)QueryAssert.Row.row((Object[])new Object[]{null, null, null, null, 1.0, null, null})));
            QueryExecutors.onTrino().executeQuery("ALTER TABLE delta.default." + tableName + " DROP COLUMN upper_data", new QueryExecutor.QueryParam[0]);
            Assertions.assertThat(DeltaLakeTestUtils.getColumnNamesOnDelta("default", tableName)).containsExactly((Object[])new String[]{"UPPER_ID", "UPPER_PART"});
            ((QueryAssert)Assertions.assertThat((AssertProvider)QueryExecutors.onTrino().executeQuery("SELECT * FROM delta.default." + tableName, new QueryExecutor.QueryParam[0]))).containsOnly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{1, "part#1"})});
            ((QueryAssert)Assertions.assertThat((AssertProvider)QueryExecutors.onTrino().executeQuery("SHOW STATS FOR delta.default." + tableName, new QueryExecutor.QueryParam[0]))).containsOnly((List)ImmutableList.of((Object)QueryAssert.Row.row((Object[])new Object[]{"upper_id", null, 1.0, 0.0, null, "1", "1"}), (Object)QueryAssert.Row.row((Object[])new Object[]{"upper_part", null, 1.0, 0.0, null, null, null}), (Object)QueryAssert.Row.row((Object[])new Object[]{null, null, null, null, 1.0, null, null})));
            Assertions.assertThatThrownBy(() -> QueryExecutors.onTrino().executeQuery("ALTER TABLE delta.default." + tableName + " DROP COLUMN upper_part", new QueryExecutor.QueryParam[0])).hasMessageContaining("Cannot drop partition column");
            QueryExecutors.onDelta().executeQuery("ALTER TABLE default." + tableName + " ADD COLUMN UPPER_DATA INT", new QueryExecutor.QueryParam[0]);
            ((QueryAssert)Assertions.assertThat((AssertProvider)QueryExecutors.onTrino().executeQuery("SHOW STATS FOR delta.default." + tableName, new QueryExecutor.QueryParam[0]))).containsOnly((List)ImmutableList.of((Object)QueryAssert.Row.row((Object[])new Object[]{"upper_id", null, 1.0, 0.0, null, "1", "1"}), (Object)QueryAssert.Row.row((Object[])new Object[]{"upper_data", null, null, null, null, null, null}), (Object)QueryAssert.Row.row((Object[])new Object[]{"upper_part", null, 1.0, 0.0, null, null, null}), (Object)QueryAssert.Row.row((Object[])new Object[]{null, null, null, null, 1.0, null, null})));
        }
        finally {
            DeltaLakeTestUtils.dropDeltaTableWithRetry("default." + tableName);
        }
    }

    @Test(groups={"delta-lake-oss", "profile_specific_tests"})
    public void testTrinoRenameColumnWithColumnMappingModeName() {
        this.testRenameColumnWithColumnMappingMode("name", (tableName, column) -> QueryExecutors.onTrino().executeQuery("ALTER TABLE delta.default." + tableName + " RENAME COLUMN " + column.sourceColumn + " TO " + column.newColumn, new QueryExecutor.QueryParam[0]));
    }

    @Test(groups={"delta-lake-oss", "profile_specific_tests"})
    public void testSparkRenameColumnWithColumnMappingModeId() {
        this.testRenameColumnWithColumnMappingMode("id", (tableName, column) -> QueryExecutors.onDelta().executeQuery("ALTER TABLE default." + tableName + " RENAME COLUMN " + column.sourceColumn + " TO " + column.newColumn, new QueryExecutor.QueryParam[0]));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testRenameColumnWithColumnMappingMode(String mode, BiConsumer<String, RenameColumn> renameColumns) {
        String tableName = "test_rename_column_" + TestingNames.randomNameSuffix();
        QueryExecutors.onDelta().executeQuery("CREATE TABLE default." + tableName + " (id INT, data INT, part STRING) USING delta  PARTITIONED BY (part)  LOCATION 's3://" + this.bucketName + "/databricks-compatibility-test-" + tableName + "' TBLPROPERTIES ('delta.columnMapping.mode' = '" + mode + "')", new QueryExecutor.QueryParam[0]);
        try {
            Assertions.assertThat((String)DeltaLakeTestUtils.getTablePropertyOnDelta("default", tableName, "delta.columnMapping.maxColumnId")).isEqualTo("3");
            QueryExecutors.onDelta().executeQuery("INSERT INTO default." + tableName + " VALUES (1, 10, 'part#1')", new QueryExecutor.QueryParam[0]);
            renameColumns.accept(tableName, new RenameColumn("data", "new_data"));
            renameColumns.accept(tableName, new RenameColumn("part", "new_part"));
            Assertions.assertThat((String)DeltaLakeTestUtils.getTablePropertyOnDelta("default", tableName, "delta.columnMapping.maxColumnId")).isEqualTo("3");
            ((QueryAssert)Assertions.assertThat((AssertProvider)QueryExecutors.onTrino().executeQuery("DESCRIBE delta.default." + tableName, new QueryExecutor.QueryParam[0]))).containsOnly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{"id", "integer", "", ""}), QueryAssert.Row.row((Object[])new Object[]{"new_data", "integer", "", ""}), QueryAssert.Row.row((Object[])new Object[]{"new_part", "varchar", "", ""})});
            ((QueryAssert)Assertions.assertThat((AssertProvider)QueryExecutors.onTrino().executeQuery("SELECT * FROM delta.default." + tableName, new QueryExecutor.QueryParam[0]))).containsOnly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{1, 10, "part#1"})});
            ((QueryAssert)Assertions.assertThat((AssertProvider)QueryExecutors.onDelta().executeQuery("SELECT * FROM default." + tableName, new QueryExecutor.QueryParam[0]))).containsOnly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{1, 10, "part#1"})});
            QueryExecutors.onDelta().executeQuery("ALTER TABLE default." + tableName + " DROP COLUMN id", new QueryExecutor.QueryParam[0]);
            renameColumns.accept(tableName, new RenameColumn("new_data", "id"));
            ((QueryAssert)Assertions.assertThat((AssertProvider)QueryExecutors.onTrino().executeQuery("SELECT id, new_part FROM delta.default." + tableName, new QueryExecutor.QueryParam[0]))).containsOnly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{10, "part#1"})});
            ((QueryAssert)Assertions.assertThat((AssertProvider)QueryExecutors.onDelta().executeQuery("SELECT id, new_part FROM default." + tableName, new QueryExecutor.QueryParam[0]))).containsOnly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{10, "part#1"})});
        }
        finally {
            DeltaLakeTestUtils.dropDeltaTableWithRetry(tableName);
        }
    }

    @Test(groups={"delta-lake-oss", "profile_specific_tests"}, dataProvider="columnMappingDataProvider")
    public void testRenameNonLowercaseColumn(String mode) {
        String tableName = "test_rename_non_lowercase_column_" + TestingNames.randomNameSuffix();
        QueryExecutors.onDelta().executeQuery("CREATE TABLE default." + tableName + " (UPPER_COL INT NOT NULL COMMENT 'test comment', UPPER_PART INT) USING delta PARTITIONED BY (UPPER_PART) LOCATION 's3://" + this.bucketName + "/databricks-compatibility-test-" + tableName + "' TBLPROPERTIES ('delta.columnMapping.mode' = '" + mode + "')", new QueryExecutor.QueryParam[0]);
        try {
            QueryExecutors.onTrino().executeQuery("INSERT INTO delta.default." + tableName + " VALUES (1, 2)", new QueryExecutor.QueryParam[0]);
            ((QueryAssert)Assertions.assertThat((AssertProvider)QueryExecutors.onTrino().executeQuery("SHOW STATS FOR delta.default." + tableName, new QueryExecutor.QueryParam[0]))).containsOnly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{"upper_col", null, 1.0, 0.0, null, "1", "1"}), QueryAssert.Row.row((Object[])new Object[]{"upper_part", null, 1.0, 0.0, null, null, null}), QueryAssert.Row.row((Object[])new Object[]{null, null, null, null, 1.0, null, null})});
            Assertions.assertThat(DeltaLakeTestUtils.getColumnNamesOnDelta("default", tableName)).containsExactly((Object[])new String[]{"UPPER_COL", "UPPER_PART"});
            QueryExecutors.onTrino().executeQuery("ALTER TABLE delta.default." + tableName + " RENAME COLUMN upper_col TO new_col", new QueryExecutor.QueryParam[0]);
            Assertions.assertThat(DeltaLakeTestUtils.getColumnNamesOnDelta("default", tableName)).containsExactly((Object[])new String[]{"new_col", "UPPER_PART"});
            Assert.assertEquals((String)DeltaLakeTestUtils.getColumnCommentOnDelta("default", tableName, "new_col"), (String)"test comment");
            QueryAssert.assertQueryFailure(() -> QueryExecutors.onTrino().executeQuery("INSERT INTO delta.default." + tableName + " (new_col) VALUES NULL", new QueryExecutor.QueryParam[0])).hasMessageContaining("NULL value not allowed for NOT NULL column: new_col");
            QueryExecutors.onTrino().executeQuery("ALTER TABLE delta.default." + tableName + " RENAME COLUMN upper_part TO new_part", new QueryExecutor.QueryParam[0]);
            Assertions.assertThat(DeltaLakeTestUtils.getColumnNamesOnDelta("default", tableName)).containsExactly((Object[])new String[]{"new_col", "new_part"});
            ((QueryAssert)Assertions.assertThat((AssertProvider)QueryExecutors.onTrino().executeQuery("SELECT new_col, new_part FROM delta.default." + tableName, new QueryExecutor.QueryParam[0]))).containsOnly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{1, 2})});
            ((QueryAssert)Assertions.assertThat((AssertProvider)QueryExecutors.onTrino().executeQuery("SHOW STATS FOR delta.default." + tableName, new QueryExecutor.QueryParam[0]))).containsOnly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{"new_col", null, 1.0, 0.0, null, "1", "1"}), QueryAssert.Row.row((Object[])new Object[]{"new_part", null, 1.0, 0.0, null, null, null}), QueryAssert.Row.row((Object[])new Object[]{null, null, null, null, 1.0, null, null})});
        }
        finally {
            DeltaLakeTestUtils.dropDeltaTableWithRetry(tableName);
        }
    }

    @DataProvider
    public Object[][] columnMappingDataProvider() {
        return new Object[][]{{"id"}, {"name"}};
    }

    @DataProvider
    public Object[][] supportedColumnMappingForDmlDataProvider() {
        return new Object[][]{{"none"}, {"name"}, {"id"}};
    }

    private record RenameColumn(String sourceColumn, String newColumn) {
        private RenameColumn {
            Objects.requireNonNull(sourceColumn, "sourceColumn is null");
            Objects.requireNonNull(newColumn, "newColumn is null");
        }
    }
}

