/*
 * Decompiled with CFR 0.152.
 */
package io.trino.tests.product.deltalake;

import io.trino.tempto.assertions.QueryAssert;
import io.trino.tempto.query.QueryExecutor;
import io.trino.testing.TestingNames;
import io.trino.testng.services.Flaky;
import io.trino.tests.product.deltalake.BaseTestDeltaLakeS3Storage;
import io.trino.tests.product.deltalake.util.DeltaLakeTestUtils;
import io.trino.tests.product.utils.QueryExecutors;
import org.assertj.core.api.AssertProvider;
import org.assertj.core.api.Assertions;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;

public class TestDeltaLakeIdentityColumnCompatibility
extends BaseTestDeltaLakeS3Storage {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(groups={"delta-lake-databricks", "delta-lake-exclude-91", "profile_specific_tests"})
    @Flaky(issue="https://github.com/trinodb/trino/issues/14391", match="\\Q[Databricks][DatabricksJDBCDriver](500593) Communication link failure. Failed to connect to server. Reason: \\E(HTTP retry after response received with no Retry-After header, error: HTTP Response code: 503|HTTP Response code: 504), Error message: Unknown.")
    public void testIdentityColumn() {
        String tableName = "test_identity_column_" + TestingNames.randomNameSuffix();
        String tableDirectory = "databricks-compatibility-test-" + tableName;
        QueryExecutors.onDelta().executeQuery(String.format("CREATE TABLE default.%s (a INT, b BIGINT GENERATED ALWAYS AS IDENTITY)\nUSING DELTA LOCATION 's3://%s/%s'\n", tableName, this.bucketName, tableDirectory), new QueryExecutor.QueryParam[0]);
        try {
            QueryExecutors.onTrino().executeQuery("COMMENT ON COLUMN delta.default." + tableName + ".b IS 'test column comment'", new QueryExecutor.QueryParam[0]);
            Assertions.assertThat((String)DeltaLakeTestUtils.getColumnCommentOnDelta("default", tableName, "b")).isEqualTo("test column comment");
            QueryExecutors.onTrino().executeQuery("COMMENT ON TABLE delta.default." + tableName + " IS 'test table comment'", new QueryExecutor.QueryParam[0]);
            Assertions.assertThat((String)DeltaLakeTestUtils.getTableCommentOnDelta("default", tableName)).isEqualTo("test table comment");
            QueryExecutors.onTrino().executeQuery("ALTER TABLE delta.default." + tableName + " ADD COLUMN c INT", new QueryExecutor.QueryParam[0]);
            Assertions.assertThat(DeltaLakeTestUtils.getColumnNamesOnDelta("default", tableName)).containsExactly((Object[])new String[]{"a", "b", "c"});
            Assertions.assertThat((String)((String)QueryExecutors.onDelta().executeQuery("SHOW CREATE TABLE default." + tableName, new QueryExecutor.QueryParam[0]).getOnlyValue())).contains(new CharSequence[]{"b BIGINT GENERATED ALWAYS AS IDENTITY"});
            QueryExecutors.onDelta().executeQuery("INSERT INTO default." + tableName + " (a, c) VALUES (0, 2)", new QueryExecutor.QueryParam[0]);
            QueryAssert.Row expected = QueryAssert.Row.row((Object[])new Object[]{0, 1, 2});
            ((QueryAssert)Assertions.assertThat((AssertProvider)QueryExecutors.onTrino().executeQuery("SELECT * FROM delta.default." + tableName, new QueryExecutor.QueryParam[0]))).containsOnly(new QueryAssert.Row[]{expected});
            ((QueryAssert)Assertions.assertThat((AssertProvider)QueryExecutors.onDelta().executeQuery("SELECT * FROM default." + tableName, new QueryExecutor.QueryParam[0]))).containsOnly(new QueryAssert.Row[]{expected});
        }
        finally {
            DeltaLakeTestUtils.dropDeltaTableWithRetry("default." + tableName);
        }
    }

    @Test(groups={"delta-lake-databricks", "delta-lake-exclude-91", "profile_specific_tests"})
    @Flaky(issue="https://github.com/trinodb/trino/issues/14391", match="\\Q[Databricks][DatabricksJDBCDriver](500593) Communication link failure. Failed to connect to server. Reason: \\E(HTTP retry after response received with no Retry-After header, error: HTTP Response code: 503|HTTP Response code: 504), Error message: Unknown.")
    public void testIdentityColumnTableFeature() {
        String tableName = "test_identity_column_feature_" + TestingNames.randomNameSuffix();
        QueryExecutors.onDelta().executeQuery("CREATE TABLE default." + tableName + "(data INT, col_identity BIGINT GENERATED ALWAYS AS IDENTITY)USING DELTA LOCATION 's3://" + this.bucketName + "/databricks-compatibility-test-" + tableName + "'TBLPROPERTIES ('delta.feature.identityColumns'='supported')", new QueryExecutor.QueryParam[0]);
        try {
            QueryAssert.assertQueryFailure(() -> QueryExecutors.onTrino().executeQuery("INSERT INTO delta.default." + tableName + " VALUES (1, 1)", new QueryExecutor.QueryParam[0])).hasMessageMatching(".* Writing to tables with identity columns is not supported");
            QueryAssert.assertQueryFailure(() -> QueryExecutors.onTrino().executeQuery("UPDATE delta.default." + tableName + " SET data = 1", new QueryExecutor.QueryParam[0])).hasMessageMatching(".* Writing to tables with identity columns is not supported");
            QueryAssert.assertQueryFailure(() -> QueryExecutors.onTrino().executeQuery("DELETE FROM delta.default." + tableName, new QueryExecutor.QueryParam[0])).hasMessageMatching(".* Writing to tables with identity columns is not supported");
            QueryAssert.assertQueryFailure(() -> QueryExecutors.onTrino().executeQuery("MERGE INTO delta.default." + tableName + " t USING delta.default." + tableName + " s ON (t.data = s.data) WHEN MATCHED THEN UPDATE SET data = 1", new QueryExecutor.QueryParam[0])).hasMessageMatching(".* Writing to tables with identity columns is not supported");
        }
        finally {
            DeltaLakeTestUtils.dropDeltaTableWithRetry("default." + tableName);
        }
    }

    @Test(groups={"delta-lake-databricks", "delta-lake-exclude-91", "profile_specific_tests"})
    @Flaky(issue="https://github.com/trinodb/trino/issues/14391", match="\\Q[Databricks][DatabricksJDBCDriver](500593) Communication link failure. Failed to connect to server. Reason: \\E(HTTP retry after response received with no Retry-After header, error: HTTP Response code: 503|HTTP Response code: 504), Error message: Unknown.")
    public void testWritesToTableWithIdentityColumnFails() {
        String tableName = "test_writes_into_table_with_identity_column_" + TestingNames.randomNameSuffix();
        QueryExecutors.onDelta().executeQuery("CREATE TABLE default." + tableName + "(data INT, col_identity BIGINT GENERATED ALWAYS AS IDENTITY)USING DELTA LOCATION 's3://" + this.bucketName + "/databricks-compatibility-test-" + tableName + "'", new QueryExecutor.QueryParam[0]);
        try {
            QueryExecutors.onDelta().executeQuery("INSERT INTO default." + tableName + " (data) VALUES (1), (2), (3)", new QueryExecutor.QueryParam[0]);
            ((QueryAssert)Assertions.assertThat((AssertProvider)QueryExecutors.onTrino().executeQuery("SELECT * FROM delta.default." + tableName, new QueryExecutor.QueryParam[0]))).containsOnly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{1, 1}), QueryAssert.Row.row((Object[])new Object[]{2, 2}), QueryAssert.Row.row((Object[])new Object[]{3, 3})});
            QueryAssert.assertQueryFailure(() -> QueryExecutors.onTrino().executeQuery("INSERT INTO delta.default." + tableName + " VALUES (4, 4)", new QueryExecutor.QueryParam[0])).hasMessageContaining("Writing to tables with identity columns is not supported");
            QueryAssert.assertQueryFailure(() -> QueryExecutors.onTrino().executeQuery("UPDATE delta.default." + tableName + " SET data = 3", new QueryExecutor.QueryParam[0])).hasMessageContaining("Writing to tables with identity columns is not supported");
            QueryAssert.assertQueryFailure(() -> QueryExecutors.onTrino().executeQuery("DELETE FROM delta.default." + tableName, new QueryExecutor.QueryParam[0])).hasMessageContaining("Writing to tables with identity columns is not supported");
            QueryAssert.assertQueryFailure(() -> QueryExecutors.onTrino().executeQuery("MERGE INTO delta.default." + tableName + " t USING delta.default." + tableName + " s ON (t.data = s.data) WHEN MATCHED THEN UPDATE SET data = 1", new QueryExecutor.QueryParam[0])).hasMessageContaining("Writing to tables with identity columns is not supported");
        }
        finally {
            DeltaLakeTestUtils.dropDeltaTableWithRetry("default." + tableName);
        }
    }

    @Test(groups={"delta-lake-databricks", "delta-lake-exclude-91", "profile_specific_tests"}, dataProvider="columnMappingDataProvider")
    @Flaky(issue="https://github.com/trinodb/trino/issues/14391", match="\\Q[Databricks][DatabricksJDBCDriver](500593) Communication link failure. Failed to connect to server. Reason: \\E(HTTP retry after response received with no Retry-After header, error: HTTP Response code: 503|HTTP Response code: 504), Error message: Unknown.")
    public void testRenameIdentityColumn(String mode) {
        String tableName = "test_rename_identity_column_" + TestingNames.randomNameSuffix();
        QueryExecutors.onDelta().executeQuery("CREATE TABLE default." + tableName + "(data INT, col_identity BIGINT GENERATED ALWAYS AS IDENTITY)USING DELTA LOCATION 's3://" + this.bucketName + "/databricks-compatibility-test-" + tableName + "'TBLPROPERTIES ('delta.columnMapping.mode'='" + mode + "')", new QueryExecutor.QueryParam[0]);
        try {
            QueryExecutors.onDelta().executeQuery("ALTER TABLE default." + tableName + " RENAME COLUMN col_identity TO delta_col_identity", new QueryExecutor.QueryParam[0]);
            Assertions.assertThat((String)((String)QueryExecutors.onDelta().executeQuery("SHOW CREATE TABLE default." + tableName, new QueryExecutor.QueryParam[0]).getOnlyValue())).contains(new CharSequence[]{"delta_col_identity BIGINT GENERATED ALWAYS AS IDENTITY"});
            QueryExecutors.onDelta().executeQuery("INSERT INTO default." + tableName + " (data) VALUES 10", new QueryExecutor.QueryParam[0]);
            ((QueryAssert)Assertions.assertThat((AssertProvider)QueryExecutors.onTrino().executeQuery("SELECT * FROM delta.default." + tableName, new QueryExecutor.QueryParam[0]))).containsOnly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{10, 1})});
            ((QueryAssert)Assertions.assertThat((AssertProvider)QueryExecutors.onDelta().executeQuery("SELECT * FROM default." + tableName, new QueryExecutor.QueryParam[0]))).containsOnly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{10, 1})});
            QueryExecutors.onTrino().executeQuery("ALTER TABLE delta.default." + tableName + " RENAME COLUMN delta_col_identity TO trino_col_identity", new QueryExecutor.QueryParam[0]);
            Assertions.assertThat((String)((String)QueryExecutors.onDelta().executeQuery("SHOW CREATE TABLE default." + tableName, new QueryExecutor.QueryParam[0]).getOnlyValue())).contains(new CharSequence[]{"trino_col_identity BIGINT GENERATED ALWAYS AS IDENTITY"});
            QueryAssert.assertQueryFailure(() -> QueryExecutors.onTrino().executeQuery("INSERT INTO delta.default." + tableName + " (data) VALUES (1)", new QueryExecutor.QueryParam[0])).hasMessageContaining("Writing to tables with identity columns is not supported");
            QueryExecutors.onDelta().executeQuery("INSERT INTO default." + tableName + " (data) VALUES 20", new QueryExecutor.QueryParam[0]);
            ((QueryAssert)Assertions.assertThat((AssertProvider)QueryExecutors.onTrino().executeQuery("SELECT * FROM delta.default." + tableName, new QueryExecutor.QueryParam[0]))).containsOnly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{10, 1}), QueryAssert.Row.row((Object[])new Object[]{20, 2})});
            ((QueryAssert)Assertions.assertThat((AssertProvider)QueryExecutors.onDelta().executeQuery("SELECT * FROM default." + tableName, new QueryExecutor.QueryParam[0]))).containsOnly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{10, 1}), QueryAssert.Row.row((Object[])new Object[]{20, 2})});
        }
        finally {
            DeltaLakeTestUtils.dropDeltaTableWithRetry("default." + tableName);
        }
    }

    @Test(groups={"delta-lake-databricks", "delta-lake-exclude-91", "profile_specific_tests"}, dataProvider="columnMappingDataProvider")
    @Flaky(issue="https://github.com/trinodb/trino/issues/14391", match="\\Q[Databricks][DatabricksJDBCDriver](500593) Communication link failure. Failed to connect to server. Reason: \\E(HTTP retry after response received with no Retry-After header, error: HTTP Response code: 503|HTTP Response code: 504), Error message: Unknown.")
    public void testDropIdentityColumn(String mode) {
        String tableName = "test_drop_identity_column_" + TestingNames.randomNameSuffix();
        QueryExecutors.onDelta().executeQuery("CREATE TABLE default." + tableName + "(data INT, first_identity BIGINT GENERATED ALWAYS AS IDENTITY, second_identity BIGINT GENERATED ALWAYS AS IDENTITY)USING DELTA LOCATION 's3://" + this.bucketName + "/databricks-compatibility-test-" + tableName + "'TBLPROPERTIES ('delta.columnMapping.mode'='" + mode + "')", new QueryExecutor.QueryParam[0]);
        try {
            QueryAssert.assertQueryFailure(() -> QueryExecutors.onTrino().executeQuery("INSERT INTO delta.default." + tableName + " (data) VALUES (1)", new QueryExecutor.QueryParam[0])).hasMessageContaining("Writing to tables with identity columns is not supported");
            QueryExecutors.onDelta().executeQuery("ALTER TABLE default." + tableName + " DROP COLUMN first_identity", new QueryExecutor.QueryParam[0]);
            Assertions.assertThat(DeltaLakeTestUtils.getColumnNamesOnDelta("default", tableName)).containsExactly((Object[])new String[]{"data", "second_identity"});
            QueryAssert.assertQueryFailure(() -> QueryExecutors.onTrino().executeQuery("INSERT INTO delta.default." + tableName + " (data) VALUES (1)", new QueryExecutor.QueryParam[0])).hasMessageContaining("Writing to tables with identity columns is not supported");
            QueryExecutors.onTrino().executeQuery("ALTER TABLE delta.default." + tableName + " DROP COLUMN second_identity", new QueryExecutor.QueryParam[0]);
            Assertions.assertThat(DeltaLakeTestUtils.getColumnNamesOnDelta("default", tableName)).containsExactly((Object[])new String[]{"data"});
            QueryExecutors.onDelta().executeQuery("INSERT INTO default." + tableName + " VALUES 10", new QueryExecutor.QueryParam[0]);
            QueryExecutors.onTrino().executeQuery("INSERT INTO delta.default." + tableName + " VALUES 20", new QueryExecutor.QueryParam[0]);
            ((QueryAssert)Assertions.assertThat((AssertProvider)QueryExecutors.onTrino().executeQuery("SELECT * FROM delta.default." + tableName, new QueryExecutor.QueryParam[0]))).containsOnly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{10}), QueryAssert.Row.row((Object[])new Object[]{20})});
            ((QueryAssert)Assertions.assertThat((AssertProvider)QueryExecutors.onDelta().executeQuery("SELECT * FROM default." + tableName, new QueryExecutor.QueryParam[0]))).containsOnly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{10}), QueryAssert.Row.row((Object[])new Object[]{20})});
        }
        finally {
            DeltaLakeTestUtils.dropDeltaTableWithRetry("default." + tableName);
        }
    }

    @Test(groups={"delta-lake-databricks", "delta-lake-exclude-91", "profile_specific_tests"})
    @Flaky(issue="https://github.com/trinodb/trino/issues/14391", match="\\Q[Databricks][DatabricksJDBCDriver](500593) Communication link failure. Failed to connect to server. Reason: \\E(HTTP retry after response received with no Retry-After header, error: HTTP Response code: 503|HTTP Response code: 504), Error message: Unknown.")
    public void testVacuumProcedureWithIdentityColumn() {
        String tableName = "test_vacuum_identity_column_" + TestingNames.randomNameSuffix();
        QueryExecutors.onDelta().executeQuery("CREATE TABLE default." + tableName + "(data INT, col_identity BIGINT GENERATED ALWAYS AS IDENTITY)USING DELTA LOCATION 's3://" + this.bucketName + "/databricks-compatibility-test-" + tableName + "'", new QueryExecutor.QueryParam[0]);
        try {
            QueryExecutors.onDelta().executeQuery("INSERT INTO default." + tableName + " (data) VALUES 10", new QueryExecutor.QueryParam[0]);
            QueryExecutors.onDelta().executeQuery("INSERT INTO default." + tableName + " (data) VALUES 20", new QueryExecutor.QueryParam[0]);
            QueryExecutors.onDelta().executeQuery("DELETE FROM default." + tableName + " WHERE data = 20", new QueryExecutor.QueryParam[0]);
            QueryExecutors.onTrino().executeQuery("SET SESSION delta.vacuum_min_retention = '0s'", new QueryExecutor.QueryParam[0]);
            QueryExecutors.onTrino().executeQuery("CALL delta.system.vacuum('default', '" + tableName + "', '0s')", new QueryExecutor.QueryParam[0]);
            Assertions.assertThat((String)((String)QueryExecutors.onDelta().executeQuery("SHOW CREATE TABLE default." + tableName, new QueryExecutor.QueryParam[0]).getOnlyValue())).contains(new CharSequence[]{"col_identity BIGINT GENERATED ALWAYS AS IDENTITY"});
            ((QueryAssert)Assertions.assertThat((AssertProvider)QueryExecutors.onTrino().executeQuery("SELECT * FROM delta.default." + tableName, new QueryExecutor.QueryParam[0]))).containsOnly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{10, 1})});
            ((QueryAssert)Assertions.assertThat((AssertProvider)QueryExecutors.onDelta().executeQuery("SELECT * FROM default." + tableName, new QueryExecutor.QueryParam[0]))).containsOnly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{10, 1})});
        }
        finally {
            DeltaLakeTestUtils.dropDeltaTableWithRetry("default." + tableName);
        }
    }

    @Test(groups={"delta-lake-databricks", "delta-lake-exclude-91", "profile_specific_tests"})
    @Flaky(issue="https://github.com/trinodb/trino/issues/14391", match="\\Q[Databricks][DatabricksJDBCDriver](500593) Communication link failure. Failed to connect to server. Reason: \\E(HTTP retry after response received with no Retry-After header, error: HTTP Response code: 503|HTTP Response code: 504), Error message: Unknown.")
    public void testOptimizeProcedureWithIdentityColumn() {
        String tableName = "test_optimize_identity_column_" + TestingNames.randomNameSuffix();
        QueryExecutors.onDelta().executeQuery("CREATE TABLE default." + tableName + "(data INT, col_identity BIGINT GENERATED ALWAYS AS IDENTITY)USING DELTA LOCATION 's3://" + this.bucketName + "/databricks-compatibility-test-" + tableName + "'", new QueryExecutor.QueryParam[0]);
        try {
            QueryExecutors.onDelta().executeQuery("INSERT INTO default." + tableName + " (data) VALUES 10", new QueryExecutor.QueryParam[0]);
            QueryExecutors.onDelta().executeQuery("INSERT INTO default." + tableName + " (data) VALUES 20", new QueryExecutor.QueryParam[0]);
            QueryExecutors.onTrino().executeQuery("ALTER TABLE delta.default." + tableName + " EXECUTE OPTIMIZE", new QueryExecutor.QueryParam[0]);
            Assertions.assertThat((String)((String)QueryExecutors.onDelta().executeQuery("SHOW CREATE TABLE default." + tableName, new QueryExecutor.QueryParam[0]).getOnlyValue())).contains(new CharSequence[]{"col_identity BIGINT GENERATED ALWAYS AS IDENTITY"});
            ((QueryAssert)Assertions.assertThat((AssertProvider)QueryExecutors.onTrino().executeQuery("SELECT * FROM delta.default." + tableName, new QueryExecutor.QueryParam[0]))).containsOnly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{10, 1}), QueryAssert.Row.row((Object[])new Object[]{20, 2})});
            ((QueryAssert)Assertions.assertThat((AssertProvider)QueryExecutors.onDelta().executeQuery("SELECT * FROM default." + tableName, new QueryExecutor.QueryParam[0]))).containsOnly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{10, 1}), QueryAssert.Row.row((Object[])new Object[]{20, 2})});
        }
        finally {
            DeltaLakeTestUtils.dropDeltaTableWithRetry("default." + tableName);
        }
    }

    @Test(groups={"delta-lake-databricks", "delta-lake-exclude-91", "profile_specific_tests"})
    @Flaky(issue="https://github.com/trinodb/trino/issues/14391", match="\\Q[Databricks][DatabricksJDBCDriver](500593) Communication link failure. Failed to connect to server. Reason: \\E(HTTP retry after response received with no Retry-After header, error: HTTP Response code: 503|HTTP Response code: 504), Error message: Unknown.")
    public void testIdentityColumnCheckpointInterval() {
        String tableName = "test_identity_column_checkpoint_interval_" + TestingNames.randomNameSuffix();
        QueryExecutors.onDelta().executeQuery("CREATE TABLE default." + tableName + "(data INT, col_identity BIGINT GENERATED ALWAYS AS IDENTITY)USING DELTA LOCATION 's3://" + this.bucketName + "/databricks-compatibility-test-" + tableName + "'TBLPROPERTIES ('delta.checkpointInterval' = 1)", new QueryExecutor.QueryParam[0]);
        try {
            QueryExecutors.onTrino().executeQuery("COMMENT ON COLUMN delta.default." + tableName + ".col_identity IS 'test column comment'", new QueryExecutor.QueryParam[0]);
            Assertions.assertThat((String)((String)QueryExecutors.onDelta().executeQuery("SHOW CREATE TABLE default." + tableName, new QueryExecutor.QueryParam[0]).getOnlyValue())).contains(new CharSequence[]{"col_identity BIGINT GENERATED ALWAYS AS IDENTITY"});
        }
        finally {
            DeltaLakeTestUtils.dropDeltaTableWithRetry("default." + tableName);
        }
    }

    @DataProvider
    public Object[][] columnMappingDataProvider() {
        return new Object[][]{{"id"}, {"name"}};
    }
}

