/*
 * Decompiled with CFR 0.152.
 */
package io.trino.tests.product.deltalake;

import io.trino.tempto.ProductTest;
import io.trino.tempto.assertions.QueryAssert;
import io.trino.tempto.query.QueryExecutor;
import io.trino.testing.TestingNames;
import io.trino.tests.product.utils.QueryExecutors;
import org.assertj.core.api.AssertProvider;
import org.assertj.core.api.Assertions;
import org.testng.annotations.Test;

public class TestHiveAndDeltaLakeCompatibility
extends ProductTest {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(groups={"delta-lake-oss", "profile_specific_tests"})
    public void testInformationSchemaColumnsOnPresenceOfHiveView() {
        String schemaName = "test_redirect_to_delta_information_schema_columns_schema_" + TestingNames.randomNameSuffix();
        QueryExecutors.onTrino().executeQuery("CREATE SCHEMA IF NOT EXISTS hive." + schemaName, new QueryExecutor.QueryParam[0]);
        String hiveViewName = "delta_schema_columns_hive_view_" + TestingNames.randomNameSuffix();
        String hiveViewQualifiedName = String.format("hive.%s.%s", schemaName, hiveViewName);
        QueryExecutors.onTrino().executeQuery("CREATE VIEW " + hiveViewQualifiedName + " AS SELECT 1 AS col_one", new QueryExecutor.QueryParam[0]);
        try {
            ((QueryAssert)Assertions.assertThat((AssertProvider)QueryExecutors.onTrino().executeQuery(String.format("SELECT table_name FROM delta.information_schema.columns WHERE table_schema = '%s'", schemaName), new QueryExecutor.QueryParam[0]))).containsOnly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{hiveViewName})});
        }
        finally {
            QueryExecutors.onTrino().executeQuery("DROP VIEW IF EXISTS " + hiveViewQualifiedName, new QueryExecutor.QueryParam[0]);
            QueryExecutors.onTrino().executeQuery("DROP SCHEMA " + schemaName, new QueryExecutor.QueryParam[0]);
        }
    }

    @Test(groups={"delta-lake-oss", "profile_specific_tests"})
    public void testUnregisterNotDeltaLakeTable() {
        String baseTableName = "test_unregister_not_delta_table_" + TestingNames.randomNameSuffix();
        String hiveTableName = "hive.default." + baseTableName;
        QueryExecutors.onTrino().executeQuery("CREATE TABLE " + hiveTableName + " AS SELECT 1 a", new QueryExecutor.QueryParam[0]);
        Assertions.assertThatThrownBy(() -> QueryExecutors.onTrino().executeQuery("CALL delta.system.unregister_table('default', '" + baseTableName + "')", new QueryExecutor.QueryParam[0])).hasMessageContaining("not a Delta Lake table");
        QueryExecutors.onTrino().executeQuery("DROP TABLE " + hiveTableName, new QueryExecutor.QueryParam[0]);
    }
}

