/*
 * Decompiled with CFR 0.152.
 */
package io.trino.tests.product.hive;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import com.google.common.collect.Streams;
import io.trino.jdbc.Row;
import io.trino.jdbc.TrinoArray;
import io.trino.plugin.hive.HiveTimestampPrecision;
import io.trino.tempto.assertions.QueryAssert;
import io.trino.tempto.context.ThreadLocalTestContextHolder;
import io.trino.tempto.fulfillment.table.MutableTablesState;
import io.trino.tempto.fulfillment.table.TableDefinition;
import io.trino.tempto.fulfillment.table.TableHandle;
import io.trino.tempto.fulfillment.table.TableInstance;
import io.trino.tempto.fulfillment.table.hive.HiveTableDefinition;
import io.trino.tempto.query.QueryExecutor;
import io.trino.tempto.query.QueryResult;
import io.trino.tests.product.hive.Engine;
import io.trino.tests.product.hive.HiveProductTest;
import io.trino.tests.product.utils.JdbcDriverUtils;
import io.trino.tests.product.utils.QueryExecutors;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.JDBCType;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.assertj.core.api.AssertProvider;
import org.assertj.core.api.Assertions;
import org.testng.Assert;

public abstract class BaseTestHiveCoercion
extends HiveProductTest {
    protected void doTestHiveCoercion(HiveTableDefinition tableDefinition) {
        String tableName = BaseTestHiveCoercion.mutableTableInstanceOf((TableDefinition)tableDefinition).getNameInDatabase();
        String floatToDoubleType = tableName.toLowerCase(Locale.ENGLISH).contains("parquet") ? "DOUBLE" : "REAL";
        String floatToDecimalVal = tableName.toLowerCase(Locale.ENGLISH).contains("parquet") ? "12345.12345" : "12345.12300";
        String decimalToFloatVal = tableName.toLowerCase(Locale.ENGLISH).contains("parquet") ? "12345.12345" : "12345.124";
        this.insertTableRows(tableName, floatToDoubleType);
        BaseTestHiveCoercion.alterTableColumnTypes(tableName);
        this.assertProperAlteredTableSchema(tableName);
        ImmutableList allColumns = ImmutableList.of((Object)"row_to_row", (Object)"list_to_list", (Object)"map_to_map", (Object)"boolean_to_varchar", (Object)"tinyint_to_smallint", (Object)"tinyint_to_int", (Object)"tinyint_to_bigint", (Object)"tinyint_to_double", (Object)"tinyint_to_shortdecimal", (Object)"tinyint_to_longdecimal", (Object)"smallint_to_int", (Object)"smallint_to_bigint", (Object[])new String[]{"smallint_to_double", "smallint_to_shortdecimal", "smallint_to_longdecimal", "int_to_bigint", "int_to_double", "int_to_shortdecimal", "int_to_longdecimal", "bigint_to_double", "bigint_to_varchar", "bigint_to_shortdecimal", "bigint_to_longdecimal", "float_to_double", "double_to_float", "double_to_string", "double_to_bounded_varchar", "double_infinity_to_string", "shortdecimal_to_shortdecimal", "shortdecimal_to_longdecimal", "longdecimal_to_shortdecimal", "longdecimal_to_longdecimal", "float_to_decimal", "double_to_decimal", "decimal_to_float", "decimal_to_double", "longdecimal_to_tinyint", "shortdecimal_to_tinyint", "longdecimal_to_smallint", "shortdecimal_to_smallint", "too_big_shortdecimal_to_smallint", "longdecimal_to_int", "shortdecimal_to_int", "shortdecimal_with_0_scale_to_int", "longdecimal_to_bigint", "shortdecimal_to_bigint", "short_decimal_to_varchar", "long_decimal_to_varchar", "short_decimal_to_bounded_varchar", "long_decimal_to_bounded_varchar", "varchar_to_bigger_varchar", "varchar_to_smaller_varchar", "varchar_to_date", "varchar_to_distant_date", "varchar_to_double", "string_to_double", "varchar_to_double_infinity", "varchar_to_special_double", "date_to_string", "date_to_bounded_varchar", "char_to_bigger_char", "char_to_smaller_char", "timestamp_millis_to_date", "timestamp_micros_to_date", "timestamp_nanos_to_date", "timestamp_to_string", "timestamp_to_bounded_varchar", "timestamp_to_smaller_varchar", "smaller_varchar_to_timestamp", "varchar_to_timestamp", "id"});
        Function<Engine, Map> expected = engine -> this.expectedValuesForEngineProvider((Engine)((Object)engine), tableName, decimalToFloatVal, floatToDecimalVal);
        List<String> prestoReadColumns = this.removeUnsupportedColumnsForTrino((List<String>)allColumns, tableName);
        Map expectedPrestoResults = expected.apply(Engine.TRINO);
        if (this.expectedExceptionsWithTrinoContext().isEmpty()) {
            Assert.assertEquals((Set)ImmutableSet.copyOf(prestoReadColumns), expectedPrestoResults.keySet());
        }
        String prestoSelectQuery = String.format("SELECT %s FROM %s", String.join((CharSequence)", ", prestoReadColumns), tableName);
        this.assertQueryResults(Engine.TRINO, prestoSelectQuery, expectedPrestoResults, prestoReadColumns, 2, tableName);
        List<String> hiveReadColumns = this.removeUnsupportedColumnsForHive((List<String>)allColumns, tableName);
        Map expectedHiveResults = expected.apply(Engine.HIVE);
        String hiveSelectQuery = String.format("SELECT %s FROM %s", String.join((CharSequence)", ", hiveReadColumns), tableName);
        this.assertQueryResults(Engine.HIVE, hiveSelectQuery, expectedHiveResults, hiveReadColumns, 2, tableName);
        this.assertNestedSubFields(tableName);
    }

    protected void insertTableRows(String tableName, String floatToDoubleType) {
        BaseTestHiveCoercion.setHiveTimestampPrecision(HiveTimestampPrecision.NANOSECONDS);
        QueryExecutors.onTrino().executeQuery(String.format("INSERT INTO %1$s VALUES (  CAST(ROW ('as is', -1, 100, 2323, 12345, 2) AS ROW(keep VARCHAR, ti2si TINYINT, si2int SMALLINT, int2bi INTEGER, bi2vc BIGINT, lower2uppercase BIGINT)),   ARRAY [CAST(ROW (2, -101, 12345, 'removed') AS ROW (ti2int TINYINT, si2bi SMALLINT, bi2vc BIGINT, remove VARCHAR))],   MAP (ARRAY [TINYINT '2'], ARRAY [CAST(ROW (-3, 2323, REAL '0.5') AS ROW (ti2bi TINYINT, int2bi INTEGER, float2double %2$s))]),   TRUE,   TINYINT '-1',   TINYINT '2',   TINYINT '-3',   TINYINT '4',   TINYINT '5',   TINYINT '6',   SMALLINT '100',   SMALLINT '-101',   SMALLINT '1024',   SMALLINT '2048',   SMALLINT '4096',   INTEGER '2323',   INTEGER '16384',   INTEGER '16385',   INTEGER '16386',   1234567890,   12345,   9223372,   9223372036,   REAL '0.5',   DOUBLE '0.5',   DOUBLE '12345.12345',   DOUBLE '12345.12345',   DOUBLE 'Infinity' ,  DECIMAL '12345678.12',   DECIMAL '12345678.12',   DECIMAL '12345678.123456123456',   DECIMAL '12345678.123456123456',   DECIMAL '13.1313',   DECIMAL '11.99',   DECIMAL '140.1323',   DECIMAL '142.99',   DECIMAL '312343.99',   DECIMAL '312345.99',   DECIMAL '312347.13433',   DECIMAL '123',   DECIMAL '123471234567.9989',   DECIMAL '12345678.12',   %2$s '12345.12345',   DOUBLE '12345.12345',   DECIMAL '12345.12345',   DECIMAL '12345.12345',   DECIMAL '12345.12345',   DECIMAL '12345678.123456123456',   DECIMAL '12345.12345',   DECIMAL '12345678.123456123456',   'abc',   'abc',   '2023-09-28',   '8000-04-13',   '1234.567',   '1234.01234',   'Infinity',  'NaN',  DATE '2023-09-28',   DATE '2000-04-13',   'abc',   'abc',   TIMESTAMP '2022-12-31 23:59:59.999',   TIMESTAMP '2023-12-31 23:59:59.999999',   TIMESTAMP '2024-12-31 23:59:59.999999999',   TIMESTAMP '2121-07-15 15:30:12.123',   TIMESTAMP '2121-07-15 15:30:12.123',   TIMESTAMP '2121-07-15 15:30:12.123',   '2121',   '2019-01-29 23:59:59.123',   1), (  CAST(ROW (NULL, 1, -100, -2323, -12345, 2) AS ROW(keep VARCHAR, ti2si TINYINT, si2int SMALLINT, int2bi INTEGER, bi2vc BIGINT, lower2uppercase BIGINT)),   ARRAY [CAST(ROW (-2, 101, -12345, NULL) AS ROW (ti2int TINYINT, si2bi SMALLINT, bi2vc BIGINT, remove VARCHAR))],   MAP (ARRAY [TINYINT '-2'], ARRAY [CAST(ROW (null, -2323, REAL '-1.5') AS ROW (ti2bi TINYINT, int2bi INTEGER, float2double %2$s))]),   FALSE,   TINYINT '1',   TINYINT '-2',   NULL,   TINYINT '-4',   TINYINT '-5',   TINYINT '-6',   SMALLINT '-100',   SMALLINT '101',   SMALLINT '-1024',   SMALLINT '-2048',   SMALLINT '-4096',   INTEGER '-2323',   INTEGER '-16384',   INTEGER '-16385',   INTEGER '-16386',   -1234567890,   -12345,   -9223372,   -9223372036,   REAL '-1.5',   DOUBLE '-1.5',   DOUBLE 'NaN',   DOUBLE '-12345.12345',   DOUBLE '-Infinity' ,  DECIMAL '-12345678.12',   DECIMAL '-12345678.12',   DECIMAL '-12345678.123456123456',   DECIMAL '-12345678.123456123456',   DECIMAL '-12.1313',   DECIMAL '-10.99',   DECIMAL '-141.1323',   DECIMAL '-143.99',   DECIMAL '-312342.99',   DECIMAL '-312346.99',   DECIMAL '-312348.13433',   DECIMAL '-124',   DECIMAL '-123471234577.9989',   DECIMAL '-12345678.12',   %2$s '-12345.12345',   DOUBLE '-12345.12345',   DECIMAL '-12345.12345',   DECIMAL '-12345.12345',   DECIMAL '-12345.12345',   DECIMAL '-12345678.123456123456',   DECIMAL '-12345.12345',   DECIMAL '-12345678.123456123456',   '\ud83d\udcb0\ud83d\udcb0\ud83d\udcb0',   '\ud83d\udcb0\ud83d\udcb0\ud83d\udcb0',   '2023-09-27',   '1900-01-01',   '-12345.6789',   '0',   '-Infinity',  'Invalid Double',  DATE '2123-09-27',   DATE '1900-01-01',   '\ud83d\udcb0\ud83d\udcb0\ud83d\udcb0',   '\ud83d\udcb0\ud83d\udcb0\ud83d\udcb0',   TIMESTAMP '1970-01-01 00:00:00.123',   TIMESTAMP '1970-01-01 00:00:00.123456',   TIMESTAMP '1970-01-01 00:00:00.123456789',   TIMESTAMP '1970-01-01 00:00:00.123',   TIMESTAMP '1970-01-01 00:00:00.123',   TIMESTAMP '1970-01-01 00:00:00.123',   '1970',   '1970-01-01 00:00:00.123',   1)", tableName, floatToDoubleType), new QueryExecutor.QueryParam[0]);
        BaseTestHiveCoercion.resetHiveTimestampPrecision();
    }

    protected Map<String, List<Object>> expectedValuesForEngineProvider(Engine engine, String tableName, String decimalToFloatVal, String floatToDecimalVal) {
        String coercedNaN = "NaN";
        Predicate<String> isFormat = formatName -> tableName.toLowerCase(Locale.ENGLISH).contains((CharSequence)formatName);
        String hiveValueForCaseChangeField = Stream.of("rctext", "textfile", "sequencefile").anyMatch(isFormat) ? "\"lower2uppercase\":2" : (isFormat.test("orc") ? "\"LOWER2UPPERCASE\":null" : "\"LOWER2UPPERCASE\":2");
        if (isFormat.test("orc")) {
            coercedNaN = null;
        }
        return ImmutableMap.builder().put((Object)"row_to_row", (Object)ImmutableList.of((Object)(engine == Engine.TRINO ? this.rowBuilder().addField("keep", (Object)"as is").addField("ti2si", (Object)-1).addField("si2int", (Object)100).addField("int2bi", (Object)2323L).addField("bi2vc", (Object)"12345").addField("lower2uppercase", (Object)2L).build() : String.format("{\"keep\":\"as is\",\"ti2si\":-1,\"si2int\":100,\"int2bi\":2323,\"bi2vc\":\"12345\",%s}", hiveValueForCaseChangeField)), (Object)(engine == Engine.TRINO ? this.rowBuilder().addField("keep", null).addField("ti2si", (Object)1).addField("si2int", (Object)-100).addField("int2bi", (Object)-2323L).addField("bi2vc", (Object)"-12345").addField("lower2uppercase", (Object)2L).build() : String.format("{\"keep\":null,\"ti2si\":1,\"si2int\":-100,\"int2bi\":-2323,\"bi2vc\":\"-12345\",%s}", hiveValueForCaseChangeField)))).put((Object)"list_to_list", (Object)ImmutableList.of((Object)(engine == Engine.TRINO ? ImmutableList.of((Object)this.rowBuilder().addField("ti2int", (Object)2).addField("si2bi", (Object)-101L).addField("bi2vc", (Object)"12345").build()) : "[{\"ti2int\":2,\"si2bi\":-101,\"bi2vc\":\"12345\"}]"), (Object)(engine == Engine.TRINO ? ImmutableList.of((Object)this.rowBuilder().addField("ti2int", (Object)-2).addField("si2bi", (Object)101L).addField("bi2vc", (Object)"-12345").build()) : "[{\"ti2int\":-2,\"si2bi\":101,\"bi2vc\":\"-12345\"}]"))).put((Object)"map_to_map", (Object)ImmutableList.of((Object)(engine == Engine.TRINO ? ImmutableMap.of((Object)2, (Object)this.rowBuilder().addField("ti2bi", (Object)-3L).addField("int2bi", (Object)2323L).addField("float2double", (Object)0.5).addField("add", null).build()) : "{2:{\"ti2bi\":-3,\"int2bi\":2323,\"float2double\":0.5,\"add\":null}}"), (Object)(engine == Engine.TRINO ? ImmutableMap.of((Object)-2, (Object)this.rowBuilder().addField("ti2bi", null).addField("int2bi", (Object)-2323L).addField("float2double", (Object)-1.5).addField("add", null).build()) : "{-2:{\"ti2bi\":null,\"int2bi\":-2323,\"float2double\":-1.5,\"add\":null}}"))).put((Object)"boolean_to_varchar", (Object)ImmutableList.of((Object)"TRUE", (Object)"FALSE")).put((Object)"tinyint_to_smallint", (Object)ImmutableList.of((Object)-1, (Object)1)).put((Object)"tinyint_to_int", (Object)ImmutableList.of((Object)2, (Object)-2)).put((Object)"tinyint_to_bigint", Arrays.asList(-3L, null)).put((Object)"tinyint_to_double", Arrays.asList(-4.0, 4.0)).put((Object)"tinyint_to_shortdecimal", Arrays.asList(new BigDecimal(-5), new BigDecimal(5))).put((Object)"tinyint_to_longdecimal", Arrays.asList(new BigDecimal(-6), new BigDecimal(6))).put((Object)"smallint_to_int", (Object)ImmutableList.of((Object)100, (Object)-100)).put((Object)"smallint_to_bigint", (Object)ImmutableList.of((Object)-101L, (Object)101L)).put((Object)"smallint_to_double", (Object)ImmutableList.of((Object)-1024.0, (Object)1024.0)).put((Object)"smallint_to_shortdecimal", Arrays.asList(new BigDecimal(-2048), new BigDecimal(-2048))).put((Object)"smallint_to_longdecimal", Arrays.asList(new BigDecimal(-4096), new BigDecimal(4096))).put((Object)"int_to_bigint", (Object)ImmutableList.of((Object)2323L, (Object)-2323L)).put((Object)"int_to_double", (Object)ImmutableList.of((Object)-16384.0, (Object)16384.0)).put((Object)"int_to_shortdecimal", Arrays.asList(new BigDecimal(-16385), new BigDecimal(16385))).put((Object)"int_to_longdecimal", Arrays.asList(new BigDecimal(-16386), new BigDecimal(16386))).put((Object)"bigint_to_double", (Object)ImmutableList.of((Object)-1.23456789E9, (Object)1.23456789E9)).put((Object)"bigint_to_varchar", (Object)ImmutableList.of((Object)"12345", (Object)"-12345")).put((Object)"bigint_to_shortdecimal", Arrays.asList(new BigDecimal(-9223372L), new BigDecimal(0x8CBCCCL))).put((Object)"bigint_to_longdecimal", Arrays.asList(new BigDecimal(-9223372036L), new BigDecimal(9223372036L))).put((Object)"float_to_double", (Object)ImmutableList.of((Object)0.5, (Object)-1.5)).put((Object)"double_to_float", (Object)ImmutableList.of((Object)0.5, (Object)-1.5)).put((Object)"double_to_string", Arrays.asList("12345.12345", coercedNaN)).put((Object)"double_to_bounded_varchar", (Object)ImmutableList.of((Object)"12345.12345", (Object)"-12345.12345")).put((Object)"double_infinity_to_string", (Object)ImmutableList.of((Object)"Infinity", (Object)"-Infinity")).put((Object)"shortdecimal_to_shortdecimal", (Object)ImmutableList.of((Object)new BigDecimal("12345678.1200"), (Object)new BigDecimal("-12345678.1200"))).put((Object)"shortdecimal_to_longdecimal", (Object)ImmutableList.of((Object)new BigDecimal("12345678.1200"), (Object)new BigDecimal("-12345678.1200"))).put((Object)"longdecimal_to_shortdecimal", (Object)ImmutableList.of((Object)new BigDecimal("12345678.12"), (Object)new BigDecimal("-12345678.12"))).put((Object)"longdecimal_to_longdecimal", (Object)ImmutableList.of((Object)new BigDecimal("12345678.12345612345600"), (Object)new BigDecimal("-12345678.12345612345600"))).put((Object)"float_to_decimal", (Object)ImmutableList.of((Object)new BigDecimal(floatToDecimalVal), (Object)new BigDecimal("-" + floatToDecimalVal))).put((Object)"double_to_decimal", (Object)ImmutableList.of((Object)new BigDecimal("12345.12345"), (Object)new BigDecimal("-12345.12345"))).put((Object)"decimal_to_float", (Object)ImmutableList.of((Object)Float.valueOf(Float.parseFloat(decimalToFloatVal)), (Object)Float.valueOf(-Float.parseFloat(decimalToFloatVal)))).put((Object)"decimal_to_double", (Object)ImmutableList.of((Object)12345.12345, (Object)-12345.12345)).put((Object)"longdecimal_to_tinyint", (Object)ImmutableList.of((Object)13, (Object)-12)).put((Object)"shortdecimal_to_tinyint", (Object)ImmutableList.of((Object)11, (Object)-10)).put((Object)"longdecimal_to_smallint", (Object)ImmutableList.of((Object)140, (Object)-141)).put((Object)"shortdecimal_to_smallint", (Object)ImmutableList.of((Object)142, (Object)-143)).put((Object)"too_big_shortdecimal_to_smallint", Arrays.asList(null, null)).put((Object)"longdecimal_to_int", (Object)ImmutableList.of((Object)312345, (Object)-312346)).put((Object)"shortdecimal_to_int", (Object)ImmutableList.of((Object)312347, (Object)-312348)).put((Object)"shortdecimal_with_0_scale_to_int", (Object)ImmutableList.of((Object)123, (Object)-124)).put((Object)"longdecimal_to_bigint", (Object)ImmutableList.of((Object)123471234567L, (Object)-123471234577L)).put((Object)"shortdecimal_to_bigint", (Object)ImmutableList.of((Object)12345678, (Object)-12345678)).put((Object)"short_decimal_to_varchar", (Object)ImmutableList.of((Object)"12345.12345", (Object)"-12345.12345")).put((Object)"long_decimal_to_varchar", (Object)ImmutableList.of((Object)"12345678.123456123456", (Object)"-12345678.123456123456")).put((Object)"short_decimal_to_bounded_varchar", (Object)ImmutableList.of((Object)"12345.12345", (Object)"12345.12345")).put((Object)"long_decimal_to_bounded_varchar", (Object)ImmutableList.of((Object)"12345678.123456123456", (Object)"-12345678.123456123456")).put((Object)"varchar_to_bigger_varchar", (Object)ImmutableList.of((Object)"abc", (Object)"\ud83d\udcb0\ud83d\udcb0\ud83d\udcb0")).put((Object)"varchar_to_smaller_varchar", (Object)ImmutableList.of((Object)"ab", (Object)"\ud83d\udcb0\ud83d\udcb0")).put((Object)"varchar_to_date", (Object)ImmutableList.of((Object)Date.valueOf("2023-09-28"), (Object)Date.valueOf("2023-09-27"))).put((Object)"varchar_to_distant_date", (Object)ImmutableList.of((Object)Date.valueOf("8000-04-13"), (Object)Date.valueOf("1900-01-01"))).put((Object)"varchar_to_double", (Object)ImmutableList.of((Object)1234.567, (Object)-12345.6789)).put((Object)"string_to_double", (Object)ImmutableList.of((Object)1234.01234, (Object)0.0)).put((Object)"varchar_to_double_infinity", (Object)ImmutableList.of((Object)Double.POSITIVE_INFINITY, (Object)Double.NEGATIVE_INFINITY)).put((Object)"varchar_to_special_double", Arrays.asList(coercedNaN == null ? null : Double.valueOf(Double.NaN), null)).put((Object)"date_to_string", (Object)ImmutableList.of((Object)"2023-09-28", (Object)"2123-09-27")).put((Object)"date_to_bounded_varchar", (Object)ImmutableList.of((Object)"2000-04-13", (Object)"1900-01-01")).put((Object)"char_to_bigger_char", (Object)ImmutableList.of((Object)"abc ", (Object)"\ud83d\udcb0\ud83d\udcb0\ud83d\udcb0 ")).put((Object)"char_to_smaller_char", (Object)ImmutableList.of((Object)"ab", (Object)"\ud83d\udcb0\ud83d\udcb0")).put((Object)"timestamp_millis_to_date", (Object)ImmutableList.of((Object)Date.valueOf("2022-12-31"), (Object)Date.valueOf("1970-01-01"))).put((Object)"timestamp_micros_to_date", (Object)ImmutableList.of((Object)Date.valueOf("2023-12-31"), (Object)Date.valueOf("1970-01-01"))).put((Object)"timestamp_nanos_to_date", (Object)ImmutableList.of((Object)Date.valueOf("2024-12-31"), (Object)Date.valueOf("1970-01-01"))).put((Object)"timestamp_to_string", (Object)ImmutableList.of((Object)"2121-07-15 15:30:12.123", (Object)"1970-01-01 00:00:00.123")).put((Object)"timestamp_to_bounded_varchar", (Object)ImmutableList.of((Object)"2121-07-15 15:30:12.123", (Object)"1970-01-01 00:00:00.123")).put((Object)"timestamp_to_smaller_varchar", (Object)ImmutableList.of((Object)"2121", (Object)"1970")).put((Object)"smaller_varchar_to_timestamp", Arrays.asList(null, null)).put((Object)"varchar_to_timestamp", Arrays.asList(Timestamp.valueOf("2019-01-29 23:59:59.123"), Timestamp.valueOf("1970-01-01 00:00:00.123"))).put((Object)"id", (Object)ImmutableList.of((Object)1, (Object)1)).buildOrThrow();
    }

    protected void doTestHiveCoercionWithDifferentTimestampPrecision(HiveTableDefinition tableDefinition) {
        String tableName = BaseTestHiveCoercion.mutableTableInstanceOf((TableDefinition)tableDefinition).getNameInDatabase();
        BaseTestHiveCoercion.setHiveTimestampPrecision(HiveTimestampPrecision.NANOSECONDS);
        QueryExecutors.onTrino().executeQuery("INSERT INTO %s\n    SELECT\n        (CAST(ROW (timestamp_value, -1, timestamp_value, CAST(timestamp_value AS VARCHAR), timestamp_value) AS ROW(keep TIMESTAMP(9), si2i SMALLINT, timestamp2string TIMESTAMP(9), string2timestamp VARCHAR, timestamp2date TIMESTAMP(9)))),\n        ARRAY [CAST(ROW (timestamp_value, -1, timestamp_value, CAST(timestamp_value AS VARCHAR), timestamp_value) AS ROW (keep TIMESTAMP(9), si2i SMALLINT, timestamp2string TIMESTAMP(9), string2timestamp VARCHAR, timestamp2date TIMESTAMP(9)))],\n        MAP (ARRAY [2], ARRAY [CAST(ROW (timestamp_value, -1, timestamp_value, CAST(timestamp_value AS VARCHAR), timestamp_value) AS ROW (keep TIMESTAMP(9), si2i SMALLINT, timestamp2string TIMESTAMP(9), string2timestamp VARCHAR, timestamp2date TIMESTAMP(9)))]),\n        timestamp_value,\n        CAST(timestamp_value AS VARCHAR),\n        timestamp_value,\n        1\n    FROM (VALUES\n        (TIMESTAMP '2121-07-15 15:30:12.123499'),\n        (TIMESTAMP '2121-07-15 15:30:12.123500'),\n        (TIMESTAMP '2121-07-15 15:30:12.123501'),\n        (TIMESTAMP '2121-07-15 15:30:12.123499999'),\n        (TIMESTAMP '2121-07-15 15:30:12.123500000'),\n        (TIMESTAMP '2121-07-15 15:30:12.123500001')) AS t (timestamp_value)\n".formatted(tableName), new QueryExecutor.QueryParam[0]);
        QueryExecutors.onHive().executeQuery(String.format("ALTER TABLE %s CHANGE COLUMN timestamp_row_to_row timestamp_row_to_row struct<keep:timestamp, si2i:int, timestamp2string:string, string2timestamp:timestamp, timestamp2date:date>", tableName), new QueryExecutor.QueryParam[0]);
        QueryExecutors.onHive().executeQuery(String.format("ALTER TABLE %s CHANGE COLUMN timestamp_list_to_list timestamp_list_to_list array<struct<keep:timestamp, si2i:int, timestamp2string:string, string2timestamp:timestamp, timestamp2date:date>>", tableName), new QueryExecutor.QueryParam[0]);
        QueryExecutors.onHive().executeQuery(String.format("ALTER TABLE %s CHANGE COLUMN timestamp_map_to_map timestamp_map_to_map map<int,struct<keep:timestamp, si2i:int, timestamp2string:string, string2timestamp:timestamp, timestamp2date:date>>", tableName), new QueryExecutor.QueryParam[0]);
        QueryExecutors.onHive().executeQuery(String.format("ALTER TABLE %s CHANGE COLUMN timestamp_to_string timestamp_to_string string", tableName), new QueryExecutor.QueryParam[0]);
        QueryExecutors.onHive().executeQuery(String.format("ALTER TABLE %s CHANGE COLUMN string_to_timestamp string_to_timestamp TIMESTAMP", tableName), new QueryExecutor.QueryParam[0]);
        QueryExecutors.onHive().executeQuery(String.format("ALTER TABLE %s CHANGE COLUMN timestamp_to_date timestamp_to_date DATE", tableName), new QueryExecutor.QueryParam[0]);
        for (HiveTimestampPrecision hiveTimestampPrecision : HiveTimestampPrecision.values()) {
            String timestampType = "timestamp(%d)".formatted(hiveTimestampPrecision.getPrecision());
            BaseTestHiveCoercion.setHiveTimestampPrecision(hiveTimestampPrecision);
            ((QueryAssert)Assertions.assertThat((AssertProvider)QueryExecutors.onTrino().executeQuery("SHOW COLUMNS FROM " + tableName, new QueryExecutor.QueryParam[0]).project(new int[]{1, 2}))).containsExactlyInOrder(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{"timestamp_row_to_row", "row(keep %1$s, si2i integer, timestamp2string varchar, string2timestamp %1$s, timestamp2date date)".formatted(timestampType)}), QueryAssert.Row.row((Object[])new Object[]{"timestamp_list_to_list", "array(row(keep %1$s, si2i integer, timestamp2string varchar, string2timestamp %1$s, timestamp2date date))".formatted(timestampType)}), QueryAssert.Row.row((Object[])new Object[]{"timestamp_map_to_map", "map(integer, row(keep %1$s, si2i integer, timestamp2string varchar, string2timestamp %1$s, timestamp2date date))".formatted(timestampType)}), QueryAssert.Row.row((Object[])new Object[]{"timestamp_to_string", "varchar"}), QueryAssert.Row.row((Object[])new Object[]{"string_to_timestamp", timestampType}), QueryAssert.Row.row((Object[])new Object[]{"timestamp_to_date", "date"}), QueryAssert.Row.row((Object[])new Object[]{"id", "bigint"})});
            ImmutableList allColumns = ImmutableList.of((Object)"timestamp_row_to_row", (Object)"timestamp_list_to_list", (Object)"timestamp_map_to_map", (Object)"timestamp_to_string", (Object)"string_to_timestamp", (Object)"timestamp_to_date", (Object)"id");
            List<String> trinoReadColumns = this.removeUnsupportedColumnsForTrino((List<String>)allColumns, tableName);
            Map expectedTinoResults = Maps.filterKeys(this.expectedRowsForEngineProvider(Engine.TRINO, hiveTimestampPrecision), trinoReadColumns::contains);
            String trinoReadQuery = String.format("SELECT %s FROM %s", String.join((CharSequence)", ", trinoReadColumns), tableName);
            this.assertQueryResults(Engine.TRINO, trinoReadQuery, expectedTinoResults, trinoReadColumns, 6, tableName);
            List<String> hiveReadColumns = this.removeUnsupportedColumnsForHive((List<String>)allColumns, tableName);
            Map expectedHiveResults = Maps.filterKeys(this.expectedRowsForEngineProvider(Engine.HIVE, hiveTimestampPrecision), hiveReadColumns::contains);
            String hiveSelectQuery = String.format("SELECT %s FROM %s", String.join((CharSequence)", ", hiveReadColumns), tableName);
            this.assertQueryResults(Engine.HIVE, hiveSelectQuery, expectedHiveResults, hiveReadColumns, 6, tableName);
        }
    }

    protected Map<String, List<Object>> expectedRowsForEngineProvider(Engine engine, HiveTimestampPrecision timestampPrecision) {
        ImmutableList timestampAsString = ImmutableList.of((Object)"2121-07-15 15:30:12.123499", (Object)"2121-07-15 15:30:12.1235", (Object)"2121-07-15 15:30:12.123501", (Object)"2121-07-15 15:30:12.123499999", (Object)"2121-07-15 15:30:12.1235", (Object)"2121-07-15 15:30:12.123500001");
        if (engine == Engine.HIVE) {
            ImmutableList baseData = ImmutableList.of((Object)"{\"keep\":\"2121-07-15 15:30:12.123499\",\"si2i\":-1,\"timestamp2string\":\"2121-07-15 15:30:12.123499\",\"string2timestamp\":\"2121-07-15 15:30:12.123499\",\"timestamp2date\":\"2121-07-15\"}", (Object)"{\"keep\":\"2121-07-15 15:30:12.1235\",\"si2i\":-1,\"timestamp2string\":\"2121-07-15 15:30:12.1235\",\"string2timestamp\":\"2121-07-15 15:30:12.1235\",\"timestamp2date\":\"2121-07-15\"}", (Object)"{\"keep\":\"2121-07-15 15:30:12.123501\",\"si2i\":-1,\"timestamp2string\":\"2121-07-15 15:30:12.123501\",\"string2timestamp\":\"2121-07-15 15:30:12.123501\",\"timestamp2date\":\"2121-07-15\"}", (Object)"{\"keep\":\"2121-07-15 15:30:12.123499999\",\"si2i\":-1,\"timestamp2string\":\"2121-07-15 15:30:12.123499999\",\"string2timestamp\":\"2121-07-15 15:30:12.123499999\",\"timestamp2date\":\"2121-07-15\"}", (Object)"{\"keep\":\"2121-07-15 15:30:12.1235\",\"si2i\":-1,\"timestamp2string\":\"2121-07-15 15:30:12.1235\",\"string2timestamp\":\"2121-07-15 15:30:12.1235\",\"timestamp2date\":\"2121-07-15\"}", (Object)"{\"keep\":\"2121-07-15 15:30:12.123500001\",\"si2i\":-1,\"timestamp2string\":\"2121-07-15 15:30:12.123500001\",\"string2timestamp\":\"2121-07-15 15:30:12.123500001\",\"timestamp2date\":\"2121-07-15\"}");
            return ImmutableMap.builder().put((Object)"timestamp_row_to_row", (Object)baseData).put((Object)"timestamp_list_to_list", (Object)((List)baseData.stream().map(ImmutableList::of).map(Objects::toString).collect(ImmutableList.toImmutableList()))).put((Object)"timestamp_map_to_map", (Object)((List)baseData.stream().map(arg_0 -> BaseTestHiveCoercion.lambda$expectedRowsForEngineProvider$2("{2:%s}", arg_0)).collect(ImmutableList.toImmutableList()))).put((Object)"timestamp_to_string", (Object)timestampAsString).put((Object)"string_to_timestamp", (Object)((List)timestampAsString.stream().map(String.class::cast).map(Timestamp::valueOf).collect(ImmutableList.toImmutableList()))).put((Object)"timestamp_to_date", Collections.nCopies(6, Date.valueOf("2121-07-15"))).put((Object)"id", Collections.nCopies(6, 1)).buildOrThrow();
        }
        ImmutableList timestampValue = switch (timestampPrecision) {
            default -> throw new MatchException(null, null);
            case HiveTimestampPrecision.MILLISECONDS -> ImmutableList.of((Object)Timestamp.valueOf("2121-07-15 15:30:12.123"), (Object)Timestamp.valueOf("2121-07-15 15:30:12.124"), (Object)Timestamp.valueOf("2121-07-15 15:30:12.124"), (Object)Timestamp.valueOf("2121-07-15 15:30:12.123"), (Object)Timestamp.valueOf("2121-07-15 15:30:12.124"), (Object)Timestamp.valueOf("2121-07-15 15:30:12.124"));
            case HiveTimestampPrecision.MICROSECONDS -> ImmutableList.of((Object)Timestamp.valueOf("2121-07-15 15:30:12.123499"), (Object)Timestamp.valueOf("2121-07-15 15:30:12.1235"), (Object)Timestamp.valueOf("2121-07-15 15:30:12.123501"), (Object)Timestamp.valueOf("2121-07-15 15:30:12.1235"), (Object)Timestamp.valueOf("2121-07-15 15:30:12.1235"), (Object)Timestamp.valueOf("2121-07-15 15:30:12.1235"));
            case HiveTimestampPrecision.NANOSECONDS -> ImmutableList.of((Object)Timestamp.valueOf("2121-07-15 15:30:12.123499"), (Object)Timestamp.valueOf("2121-07-15 15:30:12.1235"), (Object)Timestamp.valueOf("2121-07-15 15:30:12.123501"), (Object)Timestamp.valueOf("2121-07-15 15:30:12.123499999"), (Object)Timestamp.valueOf("2121-07-15 15:30:12.1235"), (Object)Timestamp.valueOf("2121-07-15 15:30:12.123500001"));
        };
        List baseData = (List)Streams.zip(timestampValue.stream(), timestampAsString.stream(), (timestamp, timestampCoerced) -> this.rowBuilder().addField("keep", timestamp).addField("si2i", (Object)-1).addField("timestamp2string", timestampCoerced).addField("string2timestamp", timestamp).addField("timestamp2date", (Object)Date.valueOf("2121-07-15")).build()).collect(ImmutableList.toImmutableList());
        return ImmutableMap.builder().put((Object)"timestamp_row_to_row", (Object)baseData).put((Object)"timestamp_list_to_list", (Object)((List)baseData.stream().map(ImmutableList::of).collect(ImmutableList.toImmutableList()))).put((Object)"timestamp_map_to_map", (Object)((List)baseData.stream().map(entry -> ImmutableMap.of((Object)2, (Object)entry)).collect(ImmutableList.toImmutableList()))).put((Object)"timestamp_to_string", (Object)timestampAsString).put((Object)"string_to_timestamp", (Object)timestampValue).put((Object)"timestamp_to_date", Collections.nCopies(6, Date.valueOf("2121-07-15"))).put((Object)"id", Collections.nCopies(6, 1)).buildOrThrow();
    }

    protected List<String> removeUnsupportedColumnsForHive(List<String> columns, String tableName) {
        Map<ColumnContext, String> expectedExceptions = this.expectedExceptionsWithHiveContext();
        String hiveVersion = this.getHiveVersionMajor() + "." + this.getHiveVersionMinor();
        Set unsupportedColumns = (Set)expectedExceptions.keySet().stream().filter(context -> context.hiveVersion().orElseThrow().equals(hiveVersion) && tableName.contains(context.format())).map(ColumnContext::column).collect(ImmutableSet.toImmutableSet());
        return (List)columns.stream().filter(column -> !unsupportedColumns.contains(column)).collect(ImmutableList.toImmutableList());
    }

    protected List<String> removeUnsupportedColumnsForTrino(List<String> columns, String tableName) {
        Map<ColumnContext, String> expectedExceptions = this.expectedExceptionsWithTrinoContext();
        Set unsupportedColumns = (Set)expectedExceptions.keySet().stream().filter(context -> tableName.contains(context.format())).map(ColumnContext::column).collect(ImmutableSet.toImmutableSet());
        return (List)columns.stream().filter(column -> !unsupportedColumns.contains(column)).collect(ImmutableList.toImmutableList());
    }

    private void assertNestedSubFields(String tableName) {
        Predicate<String> isFormat = formatName -> tableName.toLowerCase(Locale.ENGLISH).contains((CharSequence)formatName);
        ImmutableMap expectedNestedFieldTrino = ImmutableMap.of((Object)"nested_field", (Object)ImmutableList.of((Object)2L, (Object)2L));
        ImmutableMap expectedNestedFieldHive = isFormat.test("orc") ? ImmutableMap.of((Object)"nested_field", Arrays.asList(null, null)) : expectedNestedFieldTrino;
        String subfieldQueryLowerCase = String.format("SELECT row_to_row.lower2uppercase nested_field FROM %s", tableName);
        String subfieldQueryUpperCase = String.format("SELECT row_to_row.LOWER2UPPERCASE nested_field FROM %s", tableName);
        ImmutableList expectedColumns = ImmutableList.of((Object)"nested_field");
        this.assertQueryResults(Engine.TRINO, subfieldQueryUpperCase, (Map<String, List<Object>>)expectedNestedFieldTrino, (List<String>)expectedColumns, 2, tableName);
        this.assertQueryResults(Engine.TRINO, subfieldQueryLowerCase, (Map<String, List<Object>>)expectedNestedFieldTrino, (List<String>)expectedColumns, 2, tableName);
        if (isFormat.test("rcbinary")) {
            Assertions.assertThatThrownBy(() -> this.lambda$assertNestedSubFields$10(subfieldQueryUpperCase, (Map)expectedNestedFieldTrino, (List)expectedColumns, tableName)).hasMessageContaining("org.apache.hadoop.hive.ql.metadata.HiveException");
            Assertions.assertThatThrownBy(() -> this.lambda$assertNestedSubFields$11(subfieldQueryLowerCase, (Map)expectedNestedFieldTrino, (List)expectedColumns, tableName)).hasMessageContaining("org.apache.hadoop.hive.ql.metadata.HiveException");
        } else if (isFormat.test("parquet")) {
            this.assertQueryResults(Engine.HIVE, subfieldQueryUpperCase, (Map<String, List<Object>>)expectedNestedFieldHive, (List<String>)expectedColumns, 2, tableName);
            this.assertQueryResults(Engine.HIVE, subfieldQueryLowerCase, (Map<String, List<Object>>)expectedNestedFieldHive, (List<String>)expectedColumns, 2, tableName);
        } else {
            this.assertQueryResults(Engine.HIVE, subfieldQueryUpperCase, (Map<String, List<Object>>)expectedNestedFieldHive, (List<String>)expectedColumns, 2, tableName);
            this.assertQueryResults(Engine.HIVE, subfieldQueryLowerCase, (Map<String, List<Object>>)expectedNestedFieldHive, (List<String>)expectedColumns, 2, tableName);
        }
    }

    protected Map<ColumnContext, String> expectedExceptionsWithHiveContext() {
        return ImmutableMap.builder().put((Object)BaseTestHiveCoercion.columnContext("1.1", "parquet", "row_to_row"), (Object)"org.apache.hadoop.io.LongWritable cannot be cast to org.apache.hadoop.io.IntWritable").put((Object)BaseTestHiveCoercion.columnContext("1.1", "parquet", "list_to_list"), (Object)"org.apache.hadoop.io.LongWritable cannot be cast to org.apache.hadoop.hive.serde2.io.ShortWritable").put((Object)BaseTestHiveCoercion.columnContext("1.1", "parquet", "map_to_map"), (Object)"org.apache.hadoop.io.LongWritable cannot be cast to org.apache.hadoop.hive.serde2.io.ByteWritable").put((Object)BaseTestHiveCoercion.columnContext("1.1", "parquet", "tinyint_to_bigint"), (Object)"org.apache.hadoop.io.LongWritable cannot be cast to org.apache.hadoop.hive.serde2.io.ByteWritable").put((Object)BaseTestHiveCoercion.columnContext("1.1", "parquet", "tinyint_to_double"), (Object)"org.apache.hadoop.io.DoubleWritable cannot be cast to org.apache.hadoop.hive.serde2.io.ByteWritable").put((Object)BaseTestHiveCoercion.columnContext("1.1", "parquet", "tinyint_to_shortdecimal"), (Object)"org.apache.hadoop.hive.serde2.io.HiveDecimalWritable cannot be cast to org.apache.hadoop.io.ByteWritable").put((Object)BaseTestHiveCoercion.columnContext("1.1", "parquet", "tinyint_to_longdecimal"), (Object)"org.apache.hadoop.hive.serde2.io.HiveDecimalWritable cannot be cast to org.apache.hadoop.io.ByteWritable").put((Object)BaseTestHiveCoercion.columnContext("1.1", "parquet", "smallint_to_bigint"), (Object)"org.apache.hadoop.io.LongWritable cannot be cast to org.apache.hadoop.hive.serde2.io.ShortWritable").put((Object)BaseTestHiveCoercion.columnContext("1.1", "parquet", "smallint_to_double"), (Object)"org.apache.hadoop.io.DoubleWritable cannot be cast to org.apache.hadoop.hive.serde2.io.ShortWritable").put((Object)BaseTestHiveCoercion.columnContext("1.1", "parquet", "smallint_to_shortdecimal"), (Object)"org.apache.hadoop.hive.serde2.io.HiveDecimalWritable cannot be cast to org.apache.hadoop.io.ShortWritable").put((Object)BaseTestHiveCoercion.columnContext("1.1", "parquet", "smallint_to_longdecimal"), (Object)"org.apache.hadoop.hive.serde2.io.HiveDecimalWritable cannot be cast to org.apache.hadoop.io.ShortWritable").put((Object)BaseTestHiveCoercion.columnContext("1.1", "parquet", "int_to_bigint"), (Object)"org.apache.hadoop.io.LongWritable cannot be cast to org.apache.hadoop.io.IntWritable").put((Object)BaseTestHiveCoercion.columnContext("1.1", "parquet", "int_to_double"), (Object)"org.apache.hadoop.io.DoubleWritable cannot be cast to org.apache.hadoop.io.IntWritable").put((Object)BaseTestHiveCoercion.columnContext("1.1", "parquet", "int_to_shortdecimal"), (Object)"org.apache.hadoop.hive.serde2.io.HiveDecimalWritable cannot be cast to org.apache.hadoop.io.IntWritable").put((Object)BaseTestHiveCoercion.columnContext("1.1", "parquet", "int_to_longdecimal"), (Object)"org.apache.hadoop.hive.serde2.io.HiveDecimalWritable cannot be cast to org.apache.hadoop.io.IntWritable").put((Object)BaseTestHiveCoercion.columnContext("1.1", "parquet", "bigint_to_double"), (Object)"org.apache.hadoop.io.DoubleWritable cannot be cast to org.apache.hadoop.io.LongWritable").put((Object)BaseTestHiveCoercion.columnContext("1.1", "parquet", "bigint_to_shortdecimal"), (Object)"org.apache.hadoop.hive.serde2.io.HiveDecimalWritable cannot be cast to org.apache.hadoop.io.LongWritable").put((Object)BaseTestHiveCoercion.columnContext("1.1", "parquet", "bigint_to_longdecimal"), (Object)"org.apache.hadoop.hive.serde2.io.HiveDecimalWritable cannot be cast to org.apache.hadoop.io.LongWritable").put((Object)BaseTestHiveCoercion.columnContext("1.1", "rcbinary", "row_to_row"), (Object)"java.util.ArrayList cannot be cast to org.apache.hadoop.hive.serde2.lazybinary.LazyBinaryStruct").put((Object)BaseTestHiveCoercion.columnContext("1.1", "rcbinary", "list_to_list"), (Object)"java.util.ArrayList cannot be cast to org.apache.hadoop.hive.serde2.lazybinary.LazyBinaryArray").put((Object)BaseTestHiveCoercion.columnContext("1.1", "rcbinary", "map_to_map"), (Object)"java.util.HashMap cannot be cast to org.apache.hadoop.hive.serde2.lazybinary.LazyBinaryMap").put((Object)BaseTestHiveCoercion.columnContext("1.2", "orc", "map_to_map"), (Object)"Unknown encoding kind: DIRECT_V2").put((Object)BaseTestHiveCoercion.columnContext("1.2", "parquet", "list_to_list"), (Object)"java.lang.UnsupportedOperationException: Cannot inspect java.util.ArrayList").put((Object)BaseTestHiveCoercion.columnContext("1.2", "parquet", "timestamp_row_to_row"), (Object)"Timestamp value coerced to a different value due to zone difference in HiveServer").put((Object)BaseTestHiveCoercion.columnContext("1.2", "parquet", "timestamp_list_to_list"), (Object)"java.lang.UnsupportedOperationException: Cannot inspect java.util.ArrayList").put((Object)BaseTestHiveCoercion.columnContext("1.2", "parquet", "timestamp_map_to_map"), (Object)"java.lang.UnsupportedOperationException: Cannot inspect java.util.ArrayList").put((Object)BaseTestHiveCoercion.columnContext("1.2", "rcbinary", "row_to_row"), (Object)"java.util.ArrayList cannot be cast to org.apache.hadoop.hive.serde2.lazybinary.LazyBinaryStruct").put((Object)BaseTestHiveCoercion.columnContext("1.2", "rcbinary", "list_to_list"), (Object)"java.util.ArrayList cannot be cast to org.apache.hadoop.hive.serde2.lazybinary.LazyBinaryArray").put((Object)BaseTestHiveCoercion.columnContext("1.2", "rcbinary", "map_to_map"), (Object)"java.util.HashMap cannot be cast to org.apache.hadoop.hive.serde2.lazybinary.LazyBinaryMap").put((Object)BaseTestHiveCoercion.columnContext("1.2", "rcbinary", "timestamp_row_to_row"), (Object)"java.util.ArrayList cannot be cast to org.apache.hadoop.hive.serde2.lazybinary.LazyBinaryStruct").put((Object)BaseTestHiveCoercion.columnContext("1.2", "rcbinary", "timestamp_list_to_list"), (Object)"java.util.ArrayList cannot be cast to org.apache.hadoop.hive.serde2.lazybinary.LazyBinaryArray").put((Object)BaseTestHiveCoercion.columnContext("1.2", "rcbinary", "timestamp_map_to_map"), (Object)"java.util.HashMap cannot be cast to org.apache.hadoop.hive.serde2.lazybinary.LazyBinaryMap").put((Object)BaseTestHiveCoercion.columnContext("2.1", "parquet", "row_to_row"), (Object)"org.apache.hadoop.io.LongWritable cannot be cast to org.apache.hadoop.io.IntWritable").put((Object)BaseTestHiveCoercion.columnContext("2.1", "parquet", "list_to_list"), (Object)"org.apache.hadoop.io.LongWritable cannot be cast to org.apache.hadoop.hive.serde2.io.ShortWritable").put((Object)BaseTestHiveCoercion.columnContext("2.1", "parquet", "map_to_map"), (Object)"org.apache.hadoop.io.LongWritable cannot be cast to org.apache.hadoop.hive.serde2.io.ByteWritable").put((Object)BaseTestHiveCoercion.columnContext("2.1", "parquet", "tinyint_to_bigint"), (Object)"org.apache.hadoop.io.LongWritable cannot be cast to org.apache.hadoop.hive.serde2.io.ByteWritable").put((Object)BaseTestHiveCoercion.columnContext("2.1", "parquet", "tinyint_to_double"), (Object)"org.apache.hadoop.io.DoubleWritable cannot be cast to org.apache.hadoop.hive.serde2.io.ByteWritable").put((Object)BaseTestHiveCoercion.columnContext("2.1", "parquet", "tinyint_to_shortdecimal"), (Object)"org.apache.hadoop.hive.serde2.io.HiveDecimalWritable cannot be cast to org.apache.hadoop.io.ByteWritable").put((Object)BaseTestHiveCoercion.columnContext("2.1", "parquet", "tinyint_to_longdecimal"), (Object)"org.apache.hadoop.hive.serde2.io.HiveDecimalWritable cannot be cast to org.apache.hadoop.io.ByteWritable").put((Object)BaseTestHiveCoercion.columnContext("2.1", "parquet", "smallint_to_bigint"), (Object)"org.apache.hadoop.io.LongWritable cannot be cast to org.apache.hadoop.hive.serde2.io.ShortWritable").put((Object)BaseTestHiveCoercion.columnContext("2.1", "parquet", "smallint_to_double"), (Object)"org.apache.hadoop.io.DoubleWritable cannot be cast to org.apache.hadoop.hive.serde2.io.ShortWritable").put((Object)BaseTestHiveCoercion.columnContext("2.1", "parquet", "smallint_to_shortdecimal"), (Object)"org.apache.hadoop.hive.serde2.io.HiveDecimalWritable cannot be cast to org.apache.hadoop.io.ShortWritable").put((Object)BaseTestHiveCoercion.columnContext("2.1", "parquet", "smallint_to_longdecimal"), (Object)"org.apache.hadoop.hive.serde2.io.HiveDecimalWritable cannot be cast to org.apache.hadoop.io.ShortWritable").put((Object)BaseTestHiveCoercion.columnContext("2.1", "parquet", "int_to_bigint"), (Object)"org.apache.hadoop.io.LongWritable cannot be cast to org.apache.hadoop.io.IntWritable").put((Object)BaseTestHiveCoercion.columnContext("2.1", "parquet", "int_to_double"), (Object)"org.apache.hadoop.io.DoubleWritable cannot be cast to org.apache.hadoop.io.IntWritable").put((Object)BaseTestHiveCoercion.columnContext("2.1", "parquet", "int_to_shortdecimal"), (Object)"org.apache.hadoop.hive.serde2.io.HiveDecimalWritable cannot be cast to org.apache.hadoop.io.IntWritable").put((Object)BaseTestHiveCoercion.columnContext("2.1", "parquet", "int_to_longdecimal"), (Object)"org.apache.hadoop.hive.serde2.io.HiveDecimalWritable cannot be cast to org.apache.hadoop.io.IntWritable").put((Object)BaseTestHiveCoercion.columnContext("2.1", "parquet", "bigint_to_double"), (Object)"org.apache.hadoop.io.DoubleWritable cannot be cast to org.apache.hadoop.io.LongWritable").put((Object)BaseTestHiveCoercion.columnContext("2.1", "parquet", "bigint_to_shortdecimal"), (Object)"org.apache.hadoop.hive.serde2.io.HiveDecimalWritable cannot be cast to org.apache.hadoop.io.LongWritable").put((Object)BaseTestHiveCoercion.columnContext("2.1", "parquet", "bigint_to_longdecimal"), (Object)"org.apache.hadoop.hive.serde2.io.HiveDecimalWritable cannot be cast to org.apache.hadoop.io.LongWritable").put((Object)BaseTestHiveCoercion.columnContext("2.1", "rcbinary", "row_to_row"), (Object)"java.util.ArrayList cannot be cast to org.apache.hadoop.hive.serde2.lazybinary.LazyBinaryStruct").put((Object)BaseTestHiveCoercion.columnContext("2.1", "rcbinary", "list_to_list"), (Object)"java.util.ArrayList cannot be cast to org.apache.hadoop.hive.serde2.lazybinary.LazyBinaryArray").put((Object)BaseTestHiveCoercion.columnContext("2.1", "rcbinary", "map_to_map"), (Object)"java.util.HashMap cannot be cast to org.apache.hadoop.hive.serde2.lazybinary.LazyBinaryMap").put((Object)BaseTestHiveCoercion.columnContext("3.1", "parquet", "row_to_row"), (Object)"org.apache.hadoop.io.LongWritable cannot be cast to org.apache.hadoop.io.IntWritable").put((Object)BaseTestHiveCoercion.columnContext("3.1", "parquet", "list_to_list"), (Object)"org.apache.hadoop.io.LongWritable cannot be cast to org.apache.hadoop.hive.serde2.io.ShortWritable").put((Object)BaseTestHiveCoercion.columnContext("3.1", "parquet", "map_to_map"), (Object)"org.apache.hadoop.io.LongWritable cannot be cast to org.apache.hadoop.hive.serde2.io.ByteWritable").put((Object)BaseTestHiveCoercion.columnContext("3.1", "parquet", "tinyint_to_bigint"), (Object)"org.apache.hadoop.io.LongWritable cannot be cast to org.apache.hadoop.hive.serde2.io.ByteWritable").put((Object)BaseTestHiveCoercion.columnContext("3.1", "parquet", "tinyint_to_double"), (Object)"org.apache.hadoop.io.DoubleWritable cannot be cast to org.apache.hadoop.hive.serde2.io.ByteWritable").put((Object)BaseTestHiveCoercion.columnContext("3.1", "parquet", "tinyint_to_shortdecimal"), (Object)"org.apache.hadoop.hive.serde2.io.HiveDecimalWritable cannot be cast to org.apache.hadoop.io.ByteWritable").put((Object)BaseTestHiveCoercion.columnContext("3.1", "parquet", "tinyint_to_longdecimal"), (Object)"org.apache.hadoop.hive.serde2.io.HiveDecimalWritable cannot be cast to org.apache.hadoop.io.ByteWritable").put((Object)BaseTestHiveCoercion.columnContext("3.1", "parquet", "smallint_to_bigint"), (Object)"org.apache.hadoop.io.LongWritable cannot be cast to org.apache.hadoop.hive.serde2.io.ShortWritable").put((Object)BaseTestHiveCoercion.columnContext("3.1", "parquet", "smallint_to_double"), (Object)"org.apache.hadoop.io.DoubleWritable cannot be cast to org.apache.hadoop.hive.serde2.io.ShortWritable").put((Object)BaseTestHiveCoercion.columnContext("3.1", "parquet", "smallint_to_shortdecimal"), (Object)"org.apache.hadoop.hive.serde2.io.HiveDecimalWritable cannot be cast to org.apache.hadoop.io.ShortWritable").put((Object)BaseTestHiveCoercion.columnContext("3.1", "parquet", "smallint_to_longdecimal"), (Object)"org.apache.hadoop.hive.serde2.io.HiveDecimalWritable cannot be cast to org.apache.hadoop.io.ShortWritable").put((Object)BaseTestHiveCoercion.columnContext("3.1", "parquet", "int_to_bigint"), (Object)"org.apache.hadoop.io.LongWritable cannot be cast to org.apache.hadoop.io.IntWritable").put((Object)BaseTestHiveCoercion.columnContext("3.1", "parquet", "int_to_double"), (Object)"org.apache.hadoop.io.DoubleWritable cannot be cast to org.apache.hadoop.io.IntWritable").put((Object)BaseTestHiveCoercion.columnContext("3.1", "parquet", "int_to_shortdecimal"), (Object)"org.apache.hadoop.hive.serde2.io.HiveDecimalWritable cannot be cast to org.apache.hadoop.io.IntWritable").put((Object)BaseTestHiveCoercion.columnContext("3.1", "parquet", "int_to_longdecimal"), (Object)"org.apache.hadoop.hive.serde2.io.HiveDecimalWritable cannot be cast to org.apache.hadoop.io.IntWritable").put((Object)BaseTestHiveCoercion.columnContext("3.1", "parquet", "bigint_to_double"), (Object)"org.apache.hadoop.io.DoubleWritable cannot be cast to org.apache.hadoop.io.LongWritable").put((Object)BaseTestHiveCoercion.columnContext("3.1", "parquet", "bigint_to_shortdecimal"), (Object)"org.apache.hadoop.hive.serde2.io.HiveDecimalWritable cannot be cast to org.apache.hadoop.io.LongWritable").put((Object)BaseTestHiveCoercion.columnContext("3.1", "parquet", "bigint_to_longdecimal"), (Object)"org.apache.hadoop.hive.serde2.io.HiveDecimalWritable cannot be cast to org.apache.hadoop.io.LongWritable").put((Object)BaseTestHiveCoercion.columnContext("3.1", "rcbinary", "row_to_row"), (Object)"java.util.ArrayList cannot be cast to org.apache.hadoop.hive.serde2.lazybinary.LazyBinaryStruct").put((Object)BaseTestHiveCoercion.columnContext("3.1", "rcbinary", "list_to_list"), (Object)"java.util.ArrayList cannot be cast to org.apache.hadoop.hive.serde2.lazybinary.LazyBinaryArray").put((Object)BaseTestHiveCoercion.columnContext("3.1", "rcbinary", "map_to_map"), (Object)"java.util.LinkedHashMap cannot be cast to org.apache.hadoop.hive.serde2.lazybinary.LazyBinaryMap").put((Object)BaseTestHiveCoercion.columnContext("3.1", "rcbinary", "timestamp_row_to_row"), (Object)"java.util.ArrayList cannot be cast to org.apache.hadoop.hive.serde2.lazybinary.LazyBinaryStruct").put((Object)BaseTestHiveCoercion.columnContext("3.1", "rcbinary", "timestamp_list_to_list"), (Object)"java.util.ArrayList cannot be cast to org.apache.hadoop.hive.serde2.lazybinary.LazyBinaryArray").put((Object)BaseTestHiveCoercion.columnContext("3.1", "rcbinary", "timestamp_map_to_map"), (Object)"java.util.LinkedHashMap cannot be cast to org.apache.hadoop.hive.serde2.lazybinary.LazyBinaryMap").buildOrThrow();
    }

    protected Map<ColumnContext, String> expectedExceptionsWithTrinoContext() {
        return ImmutableMap.of();
    }

    private void assertQueryResults(Engine engine, String query, Map<String, List<Object>> expected, List<String> columns, int rowCount, String tableName) {
        QueryResult actual = BaseTestHiveCoercion.execute(engine, query, new QueryExecutor.QueryParam[0]);
        ImmutableList.Builder rowsBuilder = ImmutableList.builder();
        for (int row = 0; row < rowCount; ++row) {
            ArrayList<Object> currentRow = new ArrayList<Object>();
            for (int column = 0; column < columns.size(); ++column) {
                String columnName = columns.get(column);
                Preconditions.checkArgument((boolean)expected.containsKey(columnName), (Object)"columnName should be present in expected results");
                currentRow.add(expected.get(columnName).get(row));
            }
            rowsBuilder.add((Object)new QueryAssert.Row(currentRow));
        }
        ImmutableList expectedRows = rowsBuilder.build();
        this.assertColumnTypes(actual, tableName, engine, columns);
        for (int sqlIndex = 1; sqlIndex <= columns.size(); ++sqlIndex) {
            String column = columns.get(sqlIndex - 1);
            if (column.contains("row_to_row") || column.contains("map_to_map")) {
                io.airlift.testing.Assertions.assertEqualsIgnoreOrder((Iterable)actual.column(sqlIndex), BaseTestHiveCoercion.column((List<QueryAssert.Row>)expectedRows, sqlIndex), (String)String.format("%s field is not equal", column));
                continue;
            }
            if (column.contains("list_to_list")) {
                io.airlift.testing.Assertions.assertEqualsIgnoreOrder(engine == Engine.TRINO ? BaseTestHiveCoercion.extract(actual.column(sqlIndex)) : actual.column(sqlIndex), BaseTestHiveCoercion.column((List<QueryAssert.Row>)expectedRows, sqlIndex), (String)"list_to_list field is not equal");
                continue;
            }
            ((QueryAssert)Assertions.assertThat((AssertProvider)actual.project(new int[]{sqlIndex}))).containsOnly(BaseTestHiveCoercion.project((List<QueryAssert.Row>)expectedRows, sqlIndex));
        }
    }

    private void assertProperAlteredTableSchema(String tableName) {
        String floatType = tableName.toLowerCase(Locale.ENGLISH).contains("parquet") ? "double" : "real";
        ((QueryAssert)Assertions.assertThat((AssertProvider)QueryExecutors.onTrino().executeQuery("SHOW COLUMNS FROM " + tableName, new QueryExecutor.QueryParam[0]).project(new int[]{1, 2}))).containsExactlyInOrder(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{"row_to_row", "row(keep varchar, ti2si smallint, si2int integer, int2bi bigint, bi2vc varchar, lower2uppercase bigint)"}), QueryAssert.Row.row((Object[])new Object[]{"list_to_list", "array(row(ti2int integer, si2bi bigint, bi2vc varchar))"}), QueryAssert.Row.row((Object[])new Object[]{"map_to_map", "map(integer, row(ti2bi bigint, int2bi bigint, float2double double, add tinyint))"}), QueryAssert.Row.row((Object[])new Object[]{"boolean_to_varchar", "varchar(5)"}), QueryAssert.Row.row((Object[])new Object[]{"tinyint_to_smallint", "smallint"}), QueryAssert.Row.row((Object[])new Object[]{"tinyint_to_int", "integer"}), QueryAssert.Row.row((Object[])new Object[]{"tinyint_to_bigint", "bigint"}), QueryAssert.Row.row((Object[])new Object[]{"tinyint_to_double", "double"}), QueryAssert.Row.row((Object[])new Object[]{"tinyint_to_shortdecimal", "decimal(10,2)"}), QueryAssert.Row.row((Object[])new Object[]{"tinyint_to_longdecimal", "decimal(20,2)"}), QueryAssert.Row.row((Object[])new Object[]{"smallint_to_int", "integer"}), QueryAssert.Row.row((Object[])new Object[]{"smallint_to_bigint", "bigint"}), QueryAssert.Row.row((Object[])new Object[]{"smallint_to_double", "double"}), QueryAssert.Row.row((Object[])new Object[]{"smallint_to_shortdecimal", "decimal(10,2)"}), QueryAssert.Row.row((Object[])new Object[]{"smallint_to_longdecimal", "decimal(20,2)"}), QueryAssert.Row.row((Object[])new Object[]{"int_to_bigint", "bigint"}), QueryAssert.Row.row((Object[])new Object[]{"int_to_double", "double"}), QueryAssert.Row.row((Object[])new Object[]{"int_to_shortdecimal", "decimal(10,2)"}), QueryAssert.Row.row((Object[])new Object[]{"int_to_longdecimal", "decimal(20,2)"}), QueryAssert.Row.row((Object[])new Object[]{"bigint_to_double", "double"}), QueryAssert.Row.row((Object[])new Object[]{"bigint_to_varchar", "varchar"}), QueryAssert.Row.row((Object[])new Object[]{"bigint_to_shortdecimal", "decimal(10,2)"}), QueryAssert.Row.row((Object[])new Object[]{"bigint_to_longdecimal", "decimal(20,2)"}), QueryAssert.Row.row((Object[])new Object[]{"float_to_double", "double"}), QueryAssert.Row.row((Object[])new Object[]{"double_to_float", floatType}), QueryAssert.Row.row((Object[])new Object[]{"double_to_string", "varchar"}), QueryAssert.Row.row((Object[])new Object[]{"double_to_bounded_varchar", "varchar(12)"}), QueryAssert.Row.row((Object[])new Object[]{"double_infinity_to_string", "varchar"}), QueryAssert.Row.row((Object[])new Object[]{"shortdecimal_to_shortdecimal", "decimal(18,4)"}), QueryAssert.Row.row((Object[])new Object[]{"shortdecimal_to_longdecimal", "decimal(20,4)"}), QueryAssert.Row.row((Object[])new Object[]{"longdecimal_to_shortdecimal", "decimal(12,2)"}), QueryAssert.Row.row((Object[])new Object[]{"longdecimal_to_longdecimal", "decimal(38,14)"}), QueryAssert.Row.row((Object[])new Object[]{"longdecimal_to_tinyint", "tinyint"}), QueryAssert.Row.row((Object[])new Object[]{"shortdecimal_to_tinyint", "tinyint"}), QueryAssert.Row.row((Object[])new Object[]{"longdecimal_to_smallint", "smallint"}), QueryAssert.Row.row((Object[])new Object[]{"shortdecimal_to_smallint", "smallint"}), QueryAssert.Row.row((Object[])new Object[]{"too_big_shortdecimal_to_smallint", "smallint"}), QueryAssert.Row.row((Object[])new Object[]{"longdecimal_to_int", "integer"}), QueryAssert.Row.row((Object[])new Object[]{"shortdecimal_to_int", "integer"}), QueryAssert.Row.row((Object[])new Object[]{"shortdecimal_with_0_scale_to_int", "integer"}), QueryAssert.Row.row((Object[])new Object[]{"longdecimal_to_bigint", "bigint"}), QueryAssert.Row.row((Object[])new Object[]{"shortdecimal_to_bigint", "bigint"}), QueryAssert.Row.row((Object[])new Object[]{"float_to_decimal", "decimal(10,5)"}), QueryAssert.Row.row((Object[])new Object[]{"double_to_decimal", "decimal(10,5)"}), QueryAssert.Row.row((Object[])new Object[]{"decimal_to_float", floatType}), QueryAssert.Row.row((Object[])new Object[]{"decimal_to_double", "double"}), QueryAssert.Row.row((Object[])new Object[]{"short_decimal_to_varchar", "varchar"}), QueryAssert.Row.row((Object[])new Object[]{"long_decimal_to_varchar", "varchar"}), QueryAssert.Row.row((Object[])new Object[]{"short_decimal_to_bounded_varchar", "varchar(30)"}), QueryAssert.Row.row((Object[])new Object[]{"long_decimal_to_bounded_varchar", "varchar(30)"}), QueryAssert.Row.row((Object[])new Object[]{"varchar_to_bigger_varchar", "varchar(4)"}), QueryAssert.Row.row((Object[])new Object[]{"varchar_to_smaller_varchar", "varchar(2)"}), QueryAssert.Row.row((Object[])new Object[]{"varchar_to_date", "date"}), QueryAssert.Row.row((Object[])new Object[]{"varchar_to_distant_date", "date"}), QueryAssert.Row.row((Object[])new Object[]{"varchar_to_double", "double"}), QueryAssert.Row.row((Object[])new Object[]{"string_to_double", "double"}), QueryAssert.Row.row((Object[])new Object[]{"varchar_to_double_infinity", "double"}), QueryAssert.Row.row((Object[])new Object[]{"varchar_to_special_double", "double"}), QueryAssert.Row.row((Object[])new Object[]{"date_to_string", "varchar"}), QueryAssert.Row.row((Object[])new Object[]{"date_to_bounded_varchar", "varchar(12)"}), QueryAssert.Row.row((Object[])new Object[]{"char_to_bigger_char", "char(4)"}), QueryAssert.Row.row((Object[])new Object[]{"char_to_smaller_char", "char(2)"}), QueryAssert.Row.row((Object[])new Object[]{"timestamp_millis_to_date", "date"}), QueryAssert.Row.row((Object[])new Object[]{"timestamp_micros_to_date", "date"}), QueryAssert.Row.row((Object[])new Object[]{"timestamp_nanos_to_date", "date"}), QueryAssert.Row.row((Object[])new Object[]{"timestamp_to_string", "varchar"}), QueryAssert.Row.row((Object[])new Object[]{"timestamp_to_bounded_varchar", "varchar(30)"}), QueryAssert.Row.row((Object[])new Object[]{"timestamp_to_smaller_varchar", "varchar(4)"}), QueryAssert.Row.row((Object[])new Object[]{"smaller_varchar_to_timestamp", "timestamp(3)"}), QueryAssert.Row.row((Object[])new Object[]{"varchar_to_timestamp", "timestamp(3)"}), QueryAssert.Row.row((Object[])new Object[]{"id", "bigint"})});
    }

    private void assertColumnTypes(QueryResult queryResult, String tableName, Engine engine, List<String> columns) {
        JDBCType floatType = engine == Engine.TRINO ? (tableName.toLowerCase(Locale.ENGLISH).contains("parquet") ? JDBCType.DOUBLE : JDBCType.REAL) : (tableName.toLowerCase(Locale.ENGLISH).contains("parquet") ? JDBCType.DOUBLE : JDBCType.FLOAT);
        ImmutableMap expectedTypes = ImmutableMap.builder().put((Object)"row_to_row", (Object)(engine == Engine.TRINO ? JDBCType.JAVA_OBJECT : JDBCType.STRUCT)).put((Object)"list_to_list", (Object)JDBCType.ARRAY).put((Object)"map_to_map", (Object)JDBCType.JAVA_OBJECT).put((Object)"boolean_to_varchar", (Object)JDBCType.VARCHAR).put((Object)"tinyint_to_smallint", (Object)JDBCType.SMALLINT).put((Object)"tinyint_to_int", (Object)JDBCType.INTEGER).put((Object)"tinyint_to_bigint", (Object)JDBCType.BIGINT).put((Object)"tinyint_to_double", (Object)JDBCType.DOUBLE).put((Object)"tinyint_to_shortdecimal", (Object)JDBCType.DECIMAL).put((Object)"tinyint_to_longdecimal", (Object)JDBCType.DECIMAL).put((Object)"smallint_to_int", (Object)JDBCType.INTEGER).put((Object)"smallint_to_bigint", (Object)JDBCType.BIGINT).put((Object)"smallint_to_double", (Object)JDBCType.DOUBLE).put((Object)"smallint_to_shortdecimal", (Object)JDBCType.DECIMAL).put((Object)"smallint_to_longdecimal", (Object)JDBCType.DECIMAL).put((Object)"int_to_bigint", (Object)JDBCType.BIGINT).put((Object)"int_to_double", (Object)JDBCType.DOUBLE).put((Object)"int_to_shortdecimal", (Object)JDBCType.DECIMAL).put((Object)"int_to_longdecimal", (Object)JDBCType.DECIMAL).put((Object)"bigint_to_double", (Object)JDBCType.DOUBLE).put((Object)"bigint_to_varchar", (Object)JDBCType.VARCHAR).put((Object)"bigint_to_shortdecimal", (Object)JDBCType.DECIMAL).put((Object)"bigint_to_longdecimal", (Object)JDBCType.DECIMAL).put((Object)"float_to_double", (Object)JDBCType.DOUBLE).put((Object)"double_to_float", (Object)floatType).put((Object)"double_to_string", (Object)JDBCType.VARCHAR).put((Object)"double_to_bounded_varchar", (Object)JDBCType.VARCHAR).put((Object)"double_infinity_to_string", (Object)JDBCType.VARCHAR).put((Object)"shortdecimal_to_shortdecimal", (Object)JDBCType.DECIMAL).put((Object)"shortdecimal_to_longdecimal", (Object)JDBCType.DECIMAL).put((Object)"longdecimal_to_shortdecimal", (Object)JDBCType.DECIMAL).put((Object)"longdecimal_to_longdecimal", (Object)JDBCType.DECIMAL).put((Object)"longdecimal_to_tinyint", (Object)JDBCType.TINYINT).put((Object)"shortdecimal_to_tinyint", (Object)JDBCType.TINYINT).put((Object)"longdecimal_to_smallint", (Object)JDBCType.SMALLINT).put((Object)"shortdecimal_to_smallint", (Object)JDBCType.SMALLINT).put((Object)"too_big_shortdecimal_to_smallint", (Object)JDBCType.SMALLINT).put((Object)"longdecimal_to_int", (Object)JDBCType.INTEGER).put((Object)"shortdecimal_to_int", (Object)JDBCType.INTEGER).put((Object)"shortdecimal_with_0_scale_to_int", (Object)JDBCType.INTEGER).put((Object)"longdecimal_to_bigint", (Object)JDBCType.BIGINT).put((Object)"shortdecimal_to_bigint", (Object)JDBCType.BIGINT).put((Object)"float_to_decimal", (Object)JDBCType.DECIMAL).put((Object)"double_to_decimal", (Object)JDBCType.DECIMAL).put((Object)"decimal_to_float", (Object)floatType).put((Object)"decimal_to_double", (Object)JDBCType.DOUBLE).put((Object)"short_decimal_to_varchar", (Object)JDBCType.VARCHAR).put((Object)"long_decimal_to_varchar", (Object)JDBCType.VARCHAR).put((Object)"short_decimal_to_bounded_varchar", (Object)JDBCType.VARCHAR).put((Object)"long_decimal_to_bounded_varchar", (Object)JDBCType.VARCHAR).put((Object)"varchar_to_bigger_varchar", (Object)JDBCType.VARCHAR).put((Object)"varchar_to_smaller_varchar", (Object)JDBCType.VARCHAR).put((Object)"varchar_to_date", (Object)JDBCType.DATE).put((Object)"varchar_to_distant_date", (Object)JDBCType.DATE).put((Object)"varchar_to_double", (Object)JDBCType.DOUBLE).put((Object)"string_to_double", (Object)JDBCType.DOUBLE).put((Object)"varchar_to_double_infinity", (Object)JDBCType.DOUBLE).put((Object)"varchar_to_special_double", (Object)JDBCType.DOUBLE).put((Object)"date_to_string", (Object)JDBCType.VARCHAR).put((Object)"date_to_bounded_varchar", (Object)JDBCType.VARCHAR).put((Object)"char_to_bigger_char", (Object)JDBCType.CHAR).put((Object)"char_to_smaller_char", (Object)JDBCType.CHAR).put((Object)"id", (Object)JDBCType.BIGINT).put((Object)"nested_field", (Object)JDBCType.BIGINT).put((Object)"timestamp_to_string", (Object)JDBCType.VARCHAR).put((Object)"timestamp_to_bounded_varchar", (Object)JDBCType.VARCHAR).put((Object)"timestamp_to_smaller_varchar", (Object)JDBCType.VARCHAR).put((Object)"smaller_varchar_to_timestamp", (Object)JDBCType.TIMESTAMP).put((Object)"varchar_to_timestamp", (Object)JDBCType.TIMESTAMP).put((Object)"timestamp_to_date", (Object)JDBCType.DATE).put((Object)"timestamp_millis_to_date", (Object)JDBCType.DATE).put((Object)"timestamp_micros_to_date", (Object)JDBCType.DATE).put((Object)"timestamp_nanos_to_date", (Object)JDBCType.DATE).put((Object)"timestamp_to_varchar", (Object)JDBCType.VARCHAR).put((Object)"timestamp_row_to_row", (Object)(engine == Engine.TRINO ? JDBCType.JAVA_OBJECT : JDBCType.STRUCT)).put((Object)"timestamp_list_to_list", (Object)JDBCType.ARRAY).put((Object)"timestamp_map_to_map", (Object)JDBCType.JAVA_OBJECT).put((Object)"string_to_timestamp", (Object)JDBCType.TIMESTAMP).buildOrThrow();
        ((QueryAssert)Assertions.assertThat((AssertProvider)queryResult)).hasColumns((List)columns.stream().map(((Map)expectedTypes)::get).collect(ImmutableList.toImmutableList()));
    }

    private static void alterTableColumnTypes(String tableName) {
        String floatType = tableName.toLowerCase(Locale.ENGLISH).contains("parquet") ? "double" : "float";
        QueryExecutors.onHive().executeQuery(String.format("ALTER TABLE %s CHANGE COLUMN row_to_row row_to_row struct<keep:string, ti2si:smallint, si2int:int, int2bi:bigint, bi2vc:string, LOWER2UPPERCASE:bigint>", tableName), new QueryExecutor.QueryParam[0]);
        QueryExecutors.onHive().executeQuery(String.format("ALTER TABLE %s CHANGE COLUMN list_to_list list_to_list array<struct<ti2int:int, si2bi:bigint, bi2vc:string>>", tableName), new QueryExecutor.QueryParam[0]);
        QueryExecutors.onHive().executeQuery(String.format("ALTER TABLE %s CHANGE COLUMN map_to_map map_to_map map<int,struct<ti2bi:bigint, int2bi:bigint, float2double:double, add:tinyint>>", tableName), new QueryExecutor.QueryParam[0]);
        QueryExecutors.onHive().executeQuery(String.format("ALTER TABLE %s CHANGE COLUMN boolean_to_varchar boolean_to_varchar varchar(5)", tableName), new QueryExecutor.QueryParam[0]);
        QueryExecutors.onHive().executeQuery(String.format("ALTER TABLE %s CHANGE COLUMN tinyint_to_smallint tinyint_to_smallint smallint", tableName), new QueryExecutor.QueryParam[0]);
        QueryExecutors.onHive().executeQuery(String.format("ALTER TABLE %s CHANGE COLUMN tinyint_to_int tinyint_to_int int", tableName), new QueryExecutor.QueryParam[0]);
        QueryExecutors.onHive().executeQuery(String.format("ALTER TABLE %s CHANGE COLUMN tinyint_to_bigint tinyint_to_bigint bigint", tableName), new QueryExecutor.QueryParam[0]);
        QueryExecutors.onHive().executeQuery(String.format("ALTER TABLE %s CHANGE COLUMN tinyint_to_double tinyint_to_double double", tableName), new QueryExecutor.QueryParam[0]);
        QueryExecutors.onHive().executeQuery(String.format("ALTER TABLE %s CHANGE COLUMN tinyint_to_shortdecimal tinyint_to_shortdecimal decimal(10,2)", tableName), new QueryExecutor.QueryParam[0]);
        QueryExecutors.onHive().executeQuery(String.format("ALTER TABLE %s CHANGE COLUMN tinyint_to_longdecimal tinyint_to_longdecimal decimal(20,2)", tableName), new QueryExecutor.QueryParam[0]);
        QueryExecutors.onHive().executeQuery(String.format("ALTER TABLE %s CHANGE COLUMN smallint_to_int smallint_to_int int", tableName), new QueryExecutor.QueryParam[0]);
        QueryExecutors.onHive().executeQuery(String.format("ALTER TABLE %s CHANGE COLUMN smallint_to_bigint smallint_to_bigint bigint", tableName), new QueryExecutor.QueryParam[0]);
        QueryExecutors.onHive().executeQuery(String.format("ALTER TABLE %s CHANGE COLUMN smallint_to_double smallint_to_double double", tableName), new QueryExecutor.QueryParam[0]);
        QueryExecutors.onHive().executeQuery(String.format("ALTER TABLE %s CHANGE COLUMN smallint_to_shortdecimal smallint_to_shortdecimal decimal(10,2)", tableName), new QueryExecutor.QueryParam[0]);
        QueryExecutors.onHive().executeQuery(String.format("ALTER TABLE %s CHANGE COLUMN smallint_to_longdecimal smallint_to_longdecimal decimal(20,2)", tableName), new QueryExecutor.QueryParam[0]);
        QueryExecutors.onHive().executeQuery(String.format("ALTER TABLE %s CHANGE COLUMN int_to_bigint int_to_bigint bigint", tableName), new QueryExecutor.QueryParam[0]);
        QueryExecutors.onHive().executeQuery(String.format("ALTER TABLE %s CHANGE COLUMN int_to_double int_to_double double", tableName), new QueryExecutor.QueryParam[0]);
        QueryExecutors.onHive().executeQuery(String.format("ALTER TABLE %s CHANGE COLUMN int_to_shortdecimal int_to_shortdecimal decimal(10,2)", tableName), new QueryExecutor.QueryParam[0]);
        QueryExecutors.onHive().executeQuery(String.format("ALTER TABLE %s CHANGE COLUMN int_to_longdecimal int_to_longdecimal decimal(20,2)", tableName), new QueryExecutor.QueryParam[0]);
        QueryExecutors.onHive().executeQuery(String.format("ALTER TABLE %s CHANGE COLUMN bigint_to_double bigint_to_double double", tableName), new QueryExecutor.QueryParam[0]);
        QueryExecutors.onHive().executeQuery(String.format("ALTER TABLE %s CHANGE COLUMN bigint_to_varchar bigint_to_varchar string", tableName), new QueryExecutor.QueryParam[0]);
        QueryExecutors.onHive().executeQuery(String.format("ALTER TABLE %s CHANGE COLUMN bigint_to_shortdecimal bigint_to_shortdecimal decimal(10,2)", tableName), new QueryExecutor.QueryParam[0]);
        QueryExecutors.onHive().executeQuery(String.format("ALTER TABLE %s CHANGE COLUMN bigint_to_longdecimal bigint_to_longdecimal decimal(20,2)", tableName), new QueryExecutor.QueryParam[0]);
        QueryExecutors.onHive().executeQuery(String.format("ALTER TABLE %s CHANGE COLUMN float_to_double float_to_double double", tableName), new QueryExecutor.QueryParam[0]);
        QueryExecutors.onHive().executeQuery(String.format("ALTER TABLE %s CHANGE COLUMN double_to_float double_to_float %s", tableName, floatType), new QueryExecutor.QueryParam[0]);
        QueryExecutors.onHive().executeQuery(String.format("ALTER TABLE %s CHANGE COLUMN double_to_string double_to_string string", tableName), new QueryExecutor.QueryParam[0]);
        QueryExecutors.onHive().executeQuery(String.format("ALTER TABLE %s CHANGE COLUMN double_to_bounded_varchar double_to_bounded_varchar varchar(12)", tableName), new QueryExecutor.QueryParam[0]);
        QueryExecutors.onHive().executeQuery(String.format("ALTER TABLE %s CHANGE COLUMN double_infinity_to_string double_infinity_to_string string", tableName), new QueryExecutor.QueryParam[0]);
        QueryExecutors.onHive().executeQuery(String.format("ALTER TABLE %s CHANGE COLUMN shortdecimal_to_shortdecimal shortdecimal_to_shortdecimal DECIMAL(18,4)", tableName), new QueryExecutor.QueryParam[0]);
        QueryExecutors.onHive().executeQuery(String.format("ALTER TABLE %s CHANGE COLUMN shortdecimal_to_longdecimal shortdecimal_to_longdecimal DECIMAL(20,4)", tableName), new QueryExecutor.QueryParam[0]);
        QueryExecutors.onHive().executeQuery(String.format("ALTER TABLE %s CHANGE COLUMN longdecimal_to_shortdecimal longdecimal_to_shortdecimal DECIMAL(12,2)", tableName), new QueryExecutor.QueryParam[0]);
        QueryExecutors.onHive().executeQuery(String.format("ALTER TABLE %s CHANGE COLUMN longdecimal_to_longdecimal longdecimal_to_longdecimal DECIMAL(38,14)", tableName), new QueryExecutor.QueryParam[0]);
        QueryExecutors.onHive().executeQuery(String.format("ALTER TABLE %s CHANGE COLUMN longdecimal_to_tinyint longdecimal_to_tinyint TINYINT", tableName), new QueryExecutor.QueryParam[0]);
        QueryExecutors.onHive().executeQuery(String.format("ALTER TABLE %s CHANGE COLUMN shortdecimal_to_tinyint shortdecimal_to_tinyint TINYINT", tableName), new QueryExecutor.QueryParam[0]);
        QueryExecutors.onHive().executeQuery(String.format("ALTER TABLE %s CHANGE COLUMN longdecimal_to_smallint longdecimal_to_smallint SMALLINT", tableName), new QueryExecutor.QueryParam[0]);
        QueryExecutors.onHive().executeQuery(String.format("ALTER TABLE %s CHANGE COLUMN shortdecimal_to_smallint shortdecimal_to_smallint SMALLINT", tableName), new QueryExecutor.QueryParam[0]);
        QueryExecutors.onHive().executeQuery(String.format("ALTER TABLE %s CHANGE COLUMN too_big_shortdecimal_to_smallint too_big_shortdecimal_to_smallint SMALLINT", tableName), new QueryExecutor.QueryParam[0]);
        QueryExecutors.onHive().executeQuery(String.format("ALTER TABLE %s CHANGE COLUMN longdecimal_to_int longdecimal_to_int INTEGER", tableName), new QueryExecutor.QueryParam[0]);
        QueryExecutors.onHive().executeQuery(String.format("ALTER TABLE %s CHANGE COLUMN shortdecimal_to_int shortdecimal_to_int INTEGER", tableName), new QueryExecutor.QueryParam[0]);
        QueryExecutors.onHive().executeQuery(String.format("ALTER TABLE %s CHANGE COLUMN shortdecimal_with_0_scale_to_int shortdecimal_with_0_scale_to_int INTEGER", tableName), new QueryExecutor.QueryParam[0]);
        QueryExecutors.onHive().executeQuery(String.format("ALTER TABLE %s CHANGE COLUMN longdecimal_to_bigint longdecimal_to_bigint BIGINT", tableName), new QueryExecutor.QueryParam[0]);
        QueryExecutors.onHive().executeQuery(String.format("ALTER TABLE %s CHANGE COLUMN shortdecimal_to_bigint shortdecimal_to_bigint BIGINT", tableName), new QueryExecutor.QueryParam[0]);
        QueryExecutors.onHive().executeQuery(String.format("ALTER TABLE %s CHANGE COLUMN float_to_decimal float_to_decimal DECIMAL(10,5)", tableName), new QueryExecutor.QueryParam[0]);
        QueryExecutors.onHive().executeQuery(String.format("ALTER TABLE %s CHANGE COLUMN double_to_decimal double_to_decimal DECIMAL(10,5)", tableName), new QueryExecutor.QueryParam[0]);
        QueryExecutors.onHive().executeQuery(String.format("ALTER TABLE %s CHANGE COLUMN decimal_to_float decimal_to_float %s", tableName, floatType), new QueryExecutor.QueryParam[0]);
        QueryExecutors.onHive().executeQuery(String.format("ALTER TABLE %s CHANGE COLUMN decimal_to_double decimal_to_double double", tableName), new QueryExecutor.QueryParam[0]);
        QueryExecutors.onHive().executeQuery(String.format("ALTER TABLE %s CHANGE COLUMN short_decimal_to_varchar short_decimal_to_varchar string", tableName), new QueryExecutor.QueryParam[0]);
        QueryExecutors.onHive().executeQuery(String.format("ALTER TABLE %s CHANGE COLUMN long_decimal_to_varchar long_decimal_to_varchar string", tableName), new QueryExecutor.QueryParam[0]);
        QueryExecutors.onHive().executeQuery(String.format("ALTER TABLE %s CHANGE COLUMN short_decimal_to_bounded_varchar short_decimal_to_bounded_varchar varchar(30)", tableName), new QueryExecutor.QueryParam[0]);
        QueryExecutors.onHive().executeQuery(String.format("ALTER TABLE %s CHANGE COLUMN long_decimal_to_bounded_varchar long_decimal_to_bounded_varchar varchar(30)", tableName), new QueryExecutor.QueryParam[0]);
        QueryExecutors.onHive().executeQuery(String.format("ALTER TABLE %s CHANGE COLUMN varchar_to_bigger_varchar varchar_to_bigger_varchar varchar(4)", tableName), new QueryExecutor.QueryParam[0]);
        QueryExecutors.onHive().executeQuery(String.format("ALTER TABLE %s CHANGE COLUMN varchar_to_smaller_varchar varchar_to_smaller_varchar varchar(2)", tableName), new QueryExecutor.QueryParam[0]);
        QueryExecutors.onHive().executeQuery(String.format("ALTER TABLE %s CHANGE COLUMN varchar_to_date varchar_to_date date", tableName), new QueryExecutor.QueryParam[0]);
        QueryExecutors.onHive().executeQuery(String.format("ALTER TABLE %s CHANGE COLUMN date_to_string date_to_string string", tableName), new QueryExecutor.QueryParam[0]);
        QueryExecutors.onHive().executeQuery(String.format("ALTER TABLE %s CHANGE COLUMN date_to_bounded_varchar date_to_bounded_varchar varchar(12)", tableName), new QueryExecutor.QueryParam[0]);
        QueryExecutors.onHive().executeQuery(String.format("ALTER TABLE %s CHANGE COLUMN varchar_to_distant_date varchar_to_distant_date date", tableName), new QueryExecutor.QueryParam[0]);
        QueryExecutors.onHive().executeQuery(String.format("ALTER TABLE %s CHANGE COLUMN varchar_to_double varchar_to_double double", tableName), new QueryExecutor.QueryParam[0]);
        QueryExecutors.onHive().executeQuery(String.format("ALTER TABLE %s CHANGE COLUMN string_to_double string_to_double double", tableName), new QueryExecutor.QueryParam[0]);
        QueryExecutors.onHive().executeQuery(String.format("ALTER TABLE %s CHANGE COLUMN varchar_to_double_infinity varchar_to_double_infinity double", tableName), new QueryExecutor.QueryParam[0]);
        QueryExecutors.onHive().executeQuery(String.format("ALTER TABLE %s CHANGE COLUMN varchar_to_special_double varchar_to_special_double double", tableName), new QueryExecutor.QueryParam[0]);
        QueryExecutors.onHive().executeQuery(String.format("ALTER TABLE %s CHANGE COLUMN char_to_bigger_char char_to_bigger_char char(4)", tableName), new QueryExecutor.QueryParam[0]);
        QueryExecutors.onHive().executeQuery(String.format("ALTER TABLE %s CHANGE COLUMN char_to_smaller_char char_to_smaller_char char(2)", tableName), new QueryExecutor.QueryParam[0]);
        QueryExecutors.onHive().executeQuery(String.format("ALTER TABLE %s CHANGE COLUMN timestamp_millis_to_date timestamp_millis_to_date date", tableName), new QueryExecutor.QueryParam[0]);
        QueryExecutors.onHive().executeQuery(String.format("ALTER TABLE %s CHANGE COLUMN timestamp_micros_to_date timestamp_micros_to_date date", tableName), new QueryExecutor.QueryParam[0]);
        QueryExecutors.onHive().executeQuery(String.format("ALTER TABLE %s CHANGE COLUMN timestamp_nanos_to_date timestamp_nanos_to_date date", tableName), new QueryExecutor.QueryParam[0]);
        QueryExecutors.onHive().executeQuery(String.format("ALTER TABLE %s CHANGE COLUMN timestamp_to_string timestamp_to_string string", tableName), new QueryExecutor.QueryParam[0]);
        QueryExecutors.onHive().executeQuery(String.format("ALTER TABLE %s CHANGE COLUMN timestamp_to_bounded_varchar timestamp_to_bounded_varchar varchar(30)", tableName), new QueryExecutor.QueryParam[0]);
        QueryExecutors.onHive().executeQuery(String.format("ALTER TABLE %s CHANGE COLUMN timestamp_to_smaller_varchar timestamp_to_smaller_varchar varchar(4)", tableName), new QueryExecutor.QueryParam[0]);
        QueryExecutors.onHive().executeQuery(String.format("ALTER TABLE %s CHANGE COLUMN smaller_varchar_to_timestamp smaller_varchar_to_timestamp timestamp", tableName), new QueryExecutor.QueryParam[0]);
        QueryExecutors.onHive().executeQuery(String.format("ALTER TABLE %s CHANGE COLUMN varchar_to_timestamp varchar_to_timestamp timestamp", tableName), new QueryExecutor.QueryParam[0]);
    }

    protected static TableInstance<?> mutableTableInstanceOf(TableDefinition tableDefinition) {
        if (tableDefinition.getDatabase().isPresent()) {
            return BaseTestHiveCoercion.mutableTableInstanceOf(tableDefinition, (String)tableDefinition.getDatabase().get());
        }
        return BaseTestHiveCoercion.mutableTableInstanceOf(BaseTestHiveCoercion.tableHandleInSchema(tableDefinition));
    }

    private static TableInstance<?> mutableTableInstanceOf(TableDefinition tableDefinition, String database) {
        return BaseTestHiveCoercion.mutableTableInstanceOf(BaseTestHiveCoercion.tableHandleInSchema(tableDefinition).inDatabase(database));
    }

    private static TableInstance<?> mutableTableInstanceOf(TableHandle tableHandle) {
        return ((MutableTablesState)ThreadLocalTestContextHolder.testContext().getDependency(MutableTablesState.class)).get(tableHandle);
    }

    private static TableHandle tableHandleInSchema(TableDefinition tableDefinition) {
        TableHandle tableHandle = TableHandle.tableHandle((String)tableDefinition.getName());
        if (tableDefinition.getSchema().isPresent()) {
            tableHandle = tableHandle.inSchema((String)tableDefinition.getSchema().get());
        }
        return tableHandle;
    }

    private Row.Builder rowBuilder() {
        return Row.builder();
    }

    private static QueryAssert.Row project(QueryAssert.Row row, int ... columns) {
        return new QueryAssert.Row(Arrays.stream(columns).mapToObj(column -> row.getValues().get(column - 1)).collect(Collectors.toList()));
    }

    private static List<QueryAssert.Row> project(List<QueryAssert.Row> rows, int ... columns) {
        return (List)rows.stream().map(row -> BaseTestHiveCoercion.project(row, columns)).collect(ImmutableList.toImmutableList());
    }

    private static List<?> column(List<QueryAssert.Row> rows, int sqlColumnIndex) {
        return rows.stream().map(row -> BaseTestHiveCoercion.project(row, sqlColumnIndex).getValues().get(0)).collect(Collectors.toList());
    }

    private static List<List<?>> extract(List<TrinoArray> arrays) {
        return (List)arrays.stream().map(trinoArray -> ImmutableList.copyOf((Object[])((Object[])trinoArray.getArray()))).collect(ImmutableList.toImmutableList());
    }

    public static ColumnContext columnContext(String version, String format, String column) {
        return new ColumnContext(Optional.of(version), format, column);
    }

    public static ColumnContext columnContext(String format, String column) {
        return new ColumnContext(Optional.empty(), format, column);
    }

    private static QueryResult execute(Engine engine, String sql, QueryExecutor.QueryParam ... params) {
        return engine.queryExecutor().executeQuery(sql, params);
    }

    private static void setHiveTimestampPrecision(HiveTimestampPrecision hiveTimestampPrecision) {
        try {
            JdbcDriverUtils.setSessionProperty(QueryExecutors.onTrino().getConnection(), "hive.timestamp_precision", hiveTimestampPrecision.name());
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    private static void resetHiveTimestampPrecision() {
        try {
            JdbcDriverUtils.resetSessionProperty(QueryExecutors.onTrino().getConnection(), "hive.timestamp_precision");
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    private /* synthetic */ void lambda$assertNestedSubFields$11(String subfieldQueryLowerCase, Map expectedNestedFieldTrino, List expectedColumns, String tableName) throws Throwable {
        this.assertQueryResults(Engine.HIVE, subfieldQueryLowerCase, expectedNestedFieldTrino, expectedColumns, 2, tableName);
    }

    private /* synthetic */ void lambda$assertNestedSubFields$10(String subfieldQueryUpperCase, Map expectedNestedFieldTrino, List expectedColumns, String tableName) throws Throwable {
        this.assertQueryResults(Engine.HIVE, subfieldQueryUpperCase, expectedNestedFieldTrino, expectedColumns, 2, tableName);
    }

    private static /* synthetic */ String lambda$expectedRowsForEngineProvider$2(String rec$, Object xva$0) {
        return "{2:%s}".formatted(xva$0);
    }

    public record ColumnContext(Optional<String> hiveVersion, String format, String column) {
        public ColumnContext {
            Objects.requireNonNull(hiveVersion, "hiveVersion is null");
            Objects.requireNonNull(format, "format is null");
            Objects.requireNonNull(column, "column is null");
        }
    }
}

