/*
 * Decompiled with CFR 0.152.
 */
package io.trino.tests.product.hive;

import com.google.common.collect.ImmutableMap;
import io.trino.tempto.Requirement;
import io.trino.tempto.Requirements;
import io.trino.tempto.RequirementsProvider;
import io.trino.tempto.Requires;
import io.trino.tempto.configuration.Configuration;
import io.trino.tempto.fulfillment.table.MutableTableRequirement;
import io.trino.tempto.fulfillment.table.TableDefinition;
import io.trino.tempto.fulfillment.table.hive.HiveTableDefinition;
import io.trino.tests.product.hive.BaseTestHiveCoercion;
import java.util.Locale;
import java.util.Map;
import org.testng.annotations.Test;

public class TestHiveCoercionOnUnpartitionedTable
extends BaseTestHiveCoercion {
    public static final HiveTableDefinition HIVE_COERCION_ORC = TestHiveCoercionOnUnpartitionedTable.tableDefinitionBuilder("ORC").setNoData().build();
    public static final HiveTableDefinition HIVE_TIMESTAMP_COERCION_ORC = TestHiveCoercionOnUnpartitionedTable.tableDefinitionForTimestampCoercionBuilder("ORC").setNoData().build();

    private static HiveTableDefinition.HiveTableDefinitionBuilder tableDefinitionBuilder(String fileFormat) {
        String tableName = String.format("%s_hive_coercion_unpartitioned", fileFormat.toLowerCase(Locale.ENGLISH));
        return HiveTableDefinition.builder((String)tableName).setCreateTableDDLTemplate(" CREATE TABLE %NAME%(\n     row_to_row                         STRUCT<keep: STRING, ti2si: TINYINT, si2int: SMALLINT, int2bi: INT, bi2vc: BIGINT, lower2uppercase: BIGINT>,\n     list_to_list                       ARRAY<STRUCT<ti2int: TINYINT, si2bi: SMALLINT, bi2vc: BIGINT, remove: STRING>>,\n     map_to_map                         MAP<TINYINT, STRUCT<ti2bi: TINYINT, int2bi: INT, float2double: FLOAT>>,\n     boolean_to_varchar                 BOOLEAN,\n     tinyint_to_smallint                TINYINT,\n     tinyint_to_int                     TINYINT,\n     tinyint_to_bigint                  TINYINT,\n     tinyint_to_double                  TINYINT,\n     tinyint_to_shortdecimal            TINYINT,\n     tinyint_to_longdecimal             TINYINT,\n     smallint_to_int                    SMALLINT,\n     smallint_to_bigint                 SMALLINT,\n     smallint_to_double                 SMALLINT,\n     smallint_to_shortdecimal           SMALLINT,\n     smallint_to_longdecimal            SMALLINT,\n     int_to_bigint                      INT,\n     int_to_double                      INT,\n     int_to_shortdecimal                INT,\n     int_to_longdecimal                 INT,\n     bigint_to_double                   BIGINT,\n     bigint_to_varchar                  BIGINT,\n     bigint_to_shortdecimal             BIGINT,\n     bigint_to_longdecimal              BIGINT,\n     float_to_double                    FLOAT,\n     double_to_float                    DOUBLE,\n     double_to_string                   DOUBLE,\n     double_to_bounded_varchar          DOUBLE,\n     double_infinity_to_string          DOUBLE,\n     shortdecimal_to_shortdecimal       DECIMAL(10,2),\n     shortdecimal_to_longdecimal        DECIMAL(10,2),\n     longdecimal_to_shortdecimal        DECIMAL(20,12),\n     longdecimal_to_longdecimal         DECIMAL(20,12),\n     longdecimal_to_tinyint             DECIMAL(20,12),\n     shortdecimal_to_tinyint            DECIMAL(10,2),\n     longdecimal_to_smallint            DECIMAL(20,12),\n     shortdecimal_to_smallint           DECIMAL(10,2),\n     too_big_shortdecimal_to_smallint   DECIMAL(10,2),\n     longdecimal_to_int                 DECIMAL(20,12),\n     shortdecimal_to_int                DECIMAL(10,2),\n     shortdecimal_with_0_scale_to_int   DECIMAL(10,0),\n     longdecimal_to_bigint              DECIMAL(20,4),\n     shortdecimal_to_bigint             DECIMAL(10,2),\n     float_to_decimal                   FLOAT,\n     double_to_decimal                  DOUBLE,\n     decimal_to_float                   DECIMAL(10,5),\n     decimal_to_double                  DECIMAL(10,5),\n     short_decimal_to_varchar           DECIMAL(10,5),\n     long_decimal_to_varchar            DECIMAL(20,12),\n     short_decimal_to_bounded_varchar   DECIMAL(10,5),\n     long_decimal_to_bounded_varchar    DECIMAL(20,12),\n     varchar_to_bigger_varchar          VARCHAR(3),\n     varchar_to_smaller_varchar         VARCHAR(3),\n     varchar_to_date                    VARCHAR(10),\n     varchar_to_distant_date            VARCHAR(12),\n     varchar_to_double                  VARCHAR(40),\n     string_to_double                   STRING,\n     varchar_to_double_infinity         VARCHAR(40),\n     varchar_to_special_double          VARCHAR(40),\n     date_to_string                     DATE,\n     date_to_bounded_varchar            DATE,\n     char_to_bigger_char                CHAR(3),\n     char_to_smaller_char               CHAR(3),\n     timestamp_millis_to_date           TIMESTAMP,\n     timestamp_micros_to_date           TIMESTAMP,\n     timestamp_nanos_to_date            TIMESTAMP,\n     timestamp_to_string                TIMESTAMP,\n     timestamp_to_bounded_varchar       TIMESTAMP,\n     timestamp_to_smaller_varchar       TIMESTAMP,\n     smaller_varchar_to_timestamp       VARCHAR(4),\n     varchar_to_timestamp               STRING,\n     id                                 BIGINT)\nSTORED AS " + fileFormat);
    }

    private static HiveTableDefinition.HiveTableDefinitionBuilder tableDefinitionForTimestampCoercionBuilder(String fileFormat) {
        String tableName = String.format("%s_hive_timestamp_coercion_unpartitioned", fileFormat.toLowerCase(Locale.ENGLISH));
        return HiveTableDefinition.builder((String)tableName).setCreateTableDDLTemplate(" CREATE TABLE %NAME%(\n     timestamp_row_to_row       STRUCT<keep: TIMESTAMP, si2i: SMALLINT, timestamp2string: TIMESTAMP, string2timestamp: STRING, timestamp2date: TIMESTAMP>,\n     timestamp_list_to_list     ARRAY<STRUCT<keep: TIMESTAMP, si2i: SMALLINT, timestamp2string: TIMESTAMP, string2timestamp: STRING, timestamp2date: TIMESTAMP>>,\n     timestamp_map_to_map       MAP<SMALLINT, STRUCT<keep: TIMESTAMP, si2i: SMALLINT, timestamp2string: TIMESTAMP, string2timestamp: STRING, timestamp2date: TIMESTAMP>>,\n     timestamp_to_string        TIMESTAMP,\n     string_to_timestamp        STRING,\n     timestamp_to_date          TIMESTAMP,\n     id                         BIGINT)\nSTORED AS " + fileFormat);
    }

    @Requires(value={OrcRequirements.class})
    @Test(groups={"jdbc"})
    public void testHiveCoercionOrc() {
        this.doTestHiveCoercion(HIVE_COERCION_ORC);
    }

    @Requires(value={OrcRequirements.class})
    @Test(groups={"jdbc"})
    public void testHiveCoercionWithDifferentTimestampPrecision() {
        this.doTestHiveCoercionWithDifferentTimestampPrecision(HIVE_TIMESTAMP_COERCION_ORC);
    }

    @Override
    protected Map<BaseTestHiveCoercion.ColumnContext, String> expectedExceptionsWithTrinoContext() {
        return ImmutableMap.builder().put((Object)TestHiveCoercionOnUnpartitionedTable.columnContext("orc", "row_to_row"), (Object)"Cannot read SQL type 'smallint' from ORC stream '.row_to_row.ti2si' of type BYTE").put((Object)TestHiveCoercionOnUnpartitionedTable.columnContext("orc", "list_to_list"), (Object)"Cannot read SQL type 'integer' from ORC stream '.list_to_list.item.ti2int' of type BYTE").put((Object)TestHiveCoercionOnUnpartitionedTable.columnContext("orc", "map_to_map"), (Object)"Cannot read SQL type 'integer' from ORC stream '.map_to_map.key' of type BYTE").put((Object)TestHiveCoercionOnUnpartitionedTable.columnContext("orc", "tinyint_to_smallint"), (Object)"Cannot read SQL type 'smallint' from ORC stream '.tinyint_to_smallint' of type BYTE").put((Object)TestHiveCoercionOnUnpartitionedTable.columnContext("orc", "tinyint_to_int"), (Object)"Cannot read SQL type 'integer' from ORC stream '.tinyint_to_int' of type BYTE").put((Object)TestHiveCoercionOnUnpartitionedTable.columnContext("orc", "tinyint_to_bigint"), (Object)"Cannot read SQL type 'bigint' from ORC stream '.tinyint_to_bigint' of type BYTE").put((Object)TestHiveCoercionOnUnpartitionedTable.columnContext("orc", "bigint_to_varchar"), (Object)"Cannot read SQL type 'varchar' from ORC stream '.bigint_to_varchar' of type LONG").put((Object)TestHiveCoercionOnUnpartitionedTable.columnContext("orc", "double_to_float"), (Object)"Cannot read SQL type 'real' from ORC stream '.double_to_float' of type DOUBLE").put((Object)TestHiveCoercionOnUnpartitionedTable.columnContext("orc", "longdecimal_to_shortdecimal"), (Object)"Decimal does not fit long (invalid table schema?)").put((Object)TestHiveCoercionOnUnpartitionedTable.columnContext("orc", "float_to_decimal"), (Object)"Cannot read SQL type 'decimal(10,5)' from ORC stream '.float_to_decimal' of type FLOAT").put((Object)TestHiveCoercionOnUnpartitionedTable.columnContext("orc", "double_to_decimal"), (Object)"Cannot read SQL type 'decimal(10,5)' from ORC stream '.double_to_decimal' of type DOUBLE").put((Object)TestHiveCoercionOnUnpartitionedTable.columnContext("orc", "decimal_to_float"), (Object)"Cannot read SQL type 'real' from ORC stream '.decimal_to_float' of type DECIMAL").put((Object)TestHiveCoercionOnUnpartitionedTable.columnContext("orc", "decimal_to_double"), (Object)"Cannot read SQL type 'double' from ORC stream '.decimal_to_double' of type DECIMAL").put((Object)TestHiveCoercionOnUnpartitionedTable.columnContext("orc", "short_decimal_to_varchar"), (Object)"Cannot read SQL type 'varchar' from ORC stream '.short_decimal_to_varchar' of type DECIMAL").put((Object)TestHiveCoercionOnUnpartitionedTable.columnContext("orc", "long_decimal_to_varchar"), (Object)"Cannot read SQL type 'varchar' from ORC stream '.long_decimal_to_varchar' of type DECIMAL").put((Object)TestHiveCoercionOnUnpartitionedTable.columnContext("orc", "longdecimal_to_tinyint"), (Object)"Cannot read SQL type 'tinyint' from ORC stream '.longdecimal_to_tinyint' of type DECIMAL").put((Object)TestHiveCoercionOnUnpartitionedTable.columnContext("orc", "shortdecimal_to_tinyint"), (Object)"Cannot read SQL type 'tinyint' from ORC stream '.shortdecimal_to_tinyint' of type DECIMAL").put((Object)TestHiveCoercionOnUnpartitionedTable.columnContext("orc", "longdecimal_to_smallint"), (Object)"Cannot read SQL type 'smallint' from ORC stream '.longdecimal_to_smallint' of type DECIMAL").put((Object)TestHiveCoercionOnUnpartitionedTable.columnContext("orc", "shortdecimal_to_smallint"), (Object)"Cannot read SQL type 'smallint' from ORC stream '.shortdecimal_to_smallint' of type DECIMAL").put((Object)TestHiveCoercionOnUnpartitionedTable.columnContext("orc", "too_big_shortdecimal_to_smallint"), (Object)"Cannot read SQL type 'smallint' from ORC stream '.too_big_shortdecimal_to_smallint' of type DECIMAL").put((Object)TestHiveCoercionOnUnpartitionedTable.columnContext("orc", "longdecimal_to_int"), (Object)"Cannot read SQL type 'integer' from ORC stream '.longdecimal_to_int' of type DECIMAL").put((Object)TestHiveCoercionOnUnpartitionedTable.columnContext("orc", "shortdecimal_to_int"), (Object)"Cannot read SQL type 'integer' from ORC stream '.shortdecimal_to_int' of type DECIMAL").put((Object)TestHiveCoercionOnUnpartitionedTable.columnContext("orc", "shortdecimal_with_0_scale_to_int"), (Object)"Cannot read SQL type 'integer' from ORC stream '.shortdecimal_with_0_scale_to_int' of type DECIMAL").put((Object)TestHiveCoercionOnUnpartitionedTable.columnContext("orc", "longdecimal_to_bigint"), (Object)"Cannot read SQL type 'bigint' from ORC stream '.longdecimal_to_bigint' of type DECIMAL").put((Object)TestHiveCoercionOnUnpartitionedTable.columnContext("orc", "shortdecimal_to_bigint"), (Object)"Cannot read SQL type 'bigint' from ORC stream '.shortdecimal_to_bigint' of type DECIMAL").put((Object)TestHiveCoercionOnUnpartitionedTable.columnContext("orc", "short_decimal_to_bounded_varchar"), (Object)"Cannot read SQL type 'varchar(30)' from ORC stream '.short_decimal_to_bounded_varchar' of type DECIMAL").put((Object)TestHiveCoercionOnUnpartitionedTable.columnContext("orc", "long_decimal_to_bounded_varchar"), (Object)"Cannot read SQL type 'varchar(30)' from ORC stream '.long_decimal_to_bounded_varchar' of type DECIMAL").put((Object)TestHiveCoercionOnUnpartitionedTable.columnContext("orc", "timestamp_row_to_row"), (Object)"Cannot read SQL type 'varchar' from ORC stream '.timestamp_row_to_row.timestamp2string' of type TIMESTAMP with attributes {}").put((Object)TestHiveCoercionOnUnpartitionedTable.columnContext("orc", "timestamp_list_to_list"), (Object)"Cannot read SQL type 'varchar' from ORC stream '.timestamp_row_to_row.timestamp2string' of type TIMESTAMP with attributes {}").put((Object)TestHiveCoercionOnUnpartitionedTable.columnContext("orc", "timestamp_map_to_map"), (Object)"Cannot read SQL type 'varchar' from ORC stream '.timestamp_row_to_row.timestamp2string' of type TIMESTAMP with attributes {}").buildOrThrow();
    }

    public static final class OrcRequirements
    implements RequirementsProvider {
        public Requirement getRequirements(Configuration configuration) {
            return Requirements.compose((Requirement[])new Requirement[]{MutableTableRequirement.builder((TableDefinition)HIVE_COERCION_ORC).withState(MutableTableRequirement.State.CREATED).build(), MutableTableRequirement.builder((TableDefinition)HIVE_TIMESTAMP_COERCION_ORC).withState(MutableTableRequirement.State.CREATED).build()});
        }
    }
}

