/*
 * Decompiled with CFR 0.152.
 */
package io.trino.tests.product.hive;

import com.google.common.collect.ImmutableList;
import io.trino.tempto.BeforeMethodWithContext;
import io.trino.tempto.ProductTest;
import io.trino.tempto.assertions.QueryAssert;
import io.trino.tempto.query.QueryExecutor;
import io.trino.tempto.query.QueryResult;
import io.trino.testing.TestingNames;
import io.trino.tests.product.utils.QueryExecutors;
import java.util.List;
import org.assertj.core.api.AssertProvider;
import org.assertj.core.api.Assertions;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;

public class TestHiveRedirectionToHudi
extends ProductTest {
    private String bucketName;
    private static final String HUDI_TABLE_TYPE_COPY_ON_WRITE = "cow";
    private static final String HUDI_TABLE_TYPE_MERGE_ON_READ = "mor";

    @BeforeMethodWithContext
    public void setUp() {
        this.bucketName = System.getenv().getOrDefault("S3_BUCKET", "test-bucket");
    }

    @DataProvider
    public Object[][] testHudiTableTypesDataDataProvider() {
        return new Object[][]{{HUDI_TABLE_TYPE_COPY_ON_WRITE}, {HUDI_TABLE_TYPE_MERGE_ON_READ}};
    }

    @Test(groups={"hive_hudi_redirections", "profile_specific_tests"}, dataProvider="testHudiTableTypesDataDataProvider")
    public void testRedirect(String hudiTableType) {
        String tableName = "redirect_" + TestingNames.randomNameSuffix();
        String schemaTableName = TestHiveRedirectionToHudi.schemaTableName("default", tableName);
        String hudiTableName = TestHiveRedirectionToHudi.trinoTableName("hudi", schemaTableName);
        String hiveTableName = TestHiveRedirectionToHudi.trinoTableName("hive", schemaTableName);
        this.createHudiTable(schemaTableName, hudiTableType, false);
        TestHiveRedirectionToHudi.assertResultsEqual(QueryExecutors.onTrino().executeQuery("TABLE " + hudiTableName, new QueryExecutor.QueryParam[0]), QueryExecutors.onTrino().executeQuery("TABLE " + hiveTableName, new QueryExecutor.QueryParam[0]));
        QueryExecutors.onHudi().executeQuery("DROP TABLE " + schemaTableName, new QueryExecutor.QueryParam[0]);
        if (HUDI_TABLE_TYPE_MERGE_ON_READ.equals(hudiTableType)) {
            QueryExecutors.onHudi().executeQuery("DROP TABLE " + schemaTableName + "_ro", new QueryExecutor.QueryParam[0]);
            QueryExecutors.onHudi().executeQuery("DROP TABLE " + schemaTableName + "_rt", new QueryExecutor.QueryParam[0]);
        }
    }

    @Test(groups={"hive_hudi_redirections", "profile_specific_tests"})
    public void testRedirectWithNonDefaultSchema() {
        String tableName = "redirect_non_default_schema_" + TestingNames.randomNameSuffix();
        String nonDefaultSchemaName = "nondefaultschema";
        String schemaTableName = TestHiveRedirectionToHudi.schemaTableName(nonDefaultSchemaName, tableName);
        String hudiTableName = TestHiveRedirectionToHudi.trinoTableName("hudi", schemaTableName);
        String hiveTableName = TestHiveRedirectionToHudi.trinoTableName("hive", schemaTableName);
        QueryExecutors.onHudi().executeQuery("CREATE DATABASE IF NOT EXISTS " + nonDefaultSchemaName, new QueryExecutor.QueryParam[0]);
        this.createHudiCowTable(schemaTableName, false);
        TestHiveRedirectionToHudi.assertResultsEqual(QueryExecutors.onTrino().executeQuery("TABLE " + hudiTableName, new QueryExecutor.QueryParam[0]), QueryExecutors.onTrino().executeQuery("TABLE " + hiveTableName, new QueryExecutor.QueryParam[0]));
        QueryExecutors.onHudi().executeQuery("DROP TABLE " + schemaTableName, new QueryExecutor.QueryParam[0]);
    }

    @Test(groups={"hive_hudi_redirections", "profile_specific_tests"})
    public void testRedirectToNonexistentCatalog() {
        String tableName = "redirect_to_nonexistent_hudi_" + TestingNames.randomNameSuffix();
        String schemaTableName = TestHiveRedirectionToHudi.schemaTableName("default", tableName);
        String hudiTableName = TestHiveRedirectionToHudi.trinoTableName("hudi", schemaTableName);
        String hiveTableName = TestHiveRedirectionToHudi.trinoTableName("hive", schemaTableName);
        this.createHudiCowTable(schemaTableName, false);
        TestHiveRedirectionToHudi.assertResultsEqual(QueryExecutors.onTrino().executeQuery("TABLE " + hudiTableName, new QueryExecutor.QueryParam[0]), QueryExecutors.onTrino().executeQuery("TABLE " + hiveTableName, new QueryExecutor.QueryParam[0]));
        QueryExecutors.onTrino().executeQuery("SET SESSION hive.hudi_catalog_name = 'someweirdcatalog'", new QueryExecutor.QueryParam[0]);
        QueryAssert.assertQueryFailure(() -> QueryExecutors.onTrino().executeQuery("TABLE " + hiveTableName, new QueryExecutor.QueryParam[0])).hasMessageMatching(".*Table 'hive.default.redirect_to_nonexistent_hudi_.*' redirected to 'someweirdcatalog.default.redirect_to_nonexistent_hudi_.*', but the target catalog 'someweirdcatalog' does not exist");
        QueryExecutors.onHudi().executeQuery("DROP TABLE " + schemaTableName, new QueryExecutor.QueryParam[0]);
    }

    @Test(groups={"hive_hudi_redirections", "profile_specific_tests"})
    public void testRedirectWithDefaultSchemaInSession() {
        String tableName = "redirect_with_use_" + TestingNames.randomNameSuffix();
        String schemaTableName = TestHiveRedirectionToHudi.schemaTableName("default", tableName);
        String hudiTableName = TestHiveRedirectionToHudi.trinoTableName("hudi", schemaTableName);
        String hiveTableName = TestHiveRedirectionToHudi.trinoTableName("hive", schemaTableName);
        this.createHudiCowTable(schemaTableName, false);
        QueryExecutors.onTrino().executeQuery("USE hudi.default", new QueryExecutor.QueryParam[0]);
        TestHiveRedirectionToHudi.assertResultsEqual(QueryExecutors.onTrino().executeQuery("TABLE " + tableName, new QueryExecutor.QueryParam[0]), QueryExecutors.onTrino().executeQuery("TABLE " + hiveTableName, new QueryExecutor.QueryParam[0]));
        QueryExecutors.onTrino().executeQuery("USE hive.default", new QueryExecutor.QueryParam[0]);
        TestHiveRedirectionToHudi.assertResultsEqual(QueryExecutors.onTrino().executeQuery("TABLE " + hudiTableName, new QueryExecutor.QueryParam[0]), QueryExecutors.onTrino().executeQuery("TABLE " + tableName, new QueryExecutor.QueryParam[0]));
        QueryExecutors.onHudi().executeQuery("DROP TABLE " + schemaTableName, new QueryExecutor.QueryParam[0]);
    }

    @Test(groups={"hive_hudi_redirections", "profile_specific_tests"})
    public void testRedirectPartitionsToUnpartitioned() {
        String tableName = "hudi_unpartitioned_table_" + TestingNames.randomNameSuffix();
        String schemaTableName = TestHiveRedirectionToHudi.schemaTableName("default", tableName);
        String hiveTableName = TestHiveRedirectionToHudi.trinoTableName("hive", schemaTableName);
        this.createHudiCowTable(schemaTableName, false);
        ((QueryAssert)Assertions.assertThat((AssertProvider)QueryExecutors.onTrino().executeQuery("SELECT _hoodie_record_key, _hoodie_partition_path, id, name, ts FROM " + hiveTableName + " ORDER BY id", new QueryExecutor.QueryParam[0]))).containsOnly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{"1", "", 1, "a1", 1000}), QueryAssert.Row.row((Object[])new Object[]{"2", "", 2, "a2", 2000})});
        QueryExecutors.onHudi().executeQuery("DROP TABLE " + schemaTableName, new QueryExecutor.QueryParam[0]);
    }

    @Test(groups={"hive_hudi_redirections", "profile_specific_tests"}, dataProvider="testHudiTableTypesDataDataProvider")
    public void testRedirectPartitionsToPartitioned(String hudiTableType) {
        String tableName = "hudi_partitioned_table_" + TestingNames.randomNameSuffix();
        String schemaTableName = TestHiveRedirectionToHudi.schemaTableName("default", tableName);
        String hiveTableName = TestHiveRedirectionToHudi.trinoTableName("hive", schemaTableName);
        this.createHudiTable(schemaTableName, hudiTableType, true);
        ((QueryAssert)Assertions.assertThat((AssertProvider)QueryExecutors.onTrino().executeQuery("SELECT _hoodie_record_key, _hoodie_partition_path, id, name, ts, dt, hh FROM " + hiveTableName + (HUDI_TABLE_TYPE_MERGE_ON_READ.equals(hudiTableType) ? "_rt" : "") + " ORDER BY id", new QueryExecutor.QueryParam[0]))).containsOnly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{"id:1", "dt=2021-12-09/hh=10", 1, "a1", 1000, "2021-12-09", "10"}), QueryAssert.Row.row((Object[])new Object[]{"id:2", "dt=2021-12-09/hh=11", 2, "a2", 1000, "2021-12-09", "11"})});
        QueryExecutors.onHudi().executeQuery("DROP TABLE " + schemaTableName, new QueryExecutor.QueryParam[0]);
        if (HUDI_TABLE_TYPE_MERGE_ON_READ.equals(hudiTableType)) {
            QueryExecutors.onHudi().executeQuery("DROP TABLE " + schemaTableName + "_ro", new QueryExecutor.QueryParam[0]);
            QueryExecutors.onHudi().executeQuery("DROP TABLE " + schemaTableName + "_rt", new QueryExecutor.QueryParam[0]);
        }
    }

    @Test(groups={"hive_hudi_redirections", "profile_specific_tests"})
    public void testInsert() {
        String tableName = "hudi_insert_" + TestingNames.randomNameSuffix();
        String schemaTableName = TestHiveRedirectionToHudi.schemaTableName("default", tableName);
        String hiveTableName = TestHiveRedirectionToHudi.trinoTableName("hive", schemaTableName);
        this.createHudiCowTable(schemaTableName, false);
        QueryAssert.assertQueryFailure(() -> QueryExecutors.onTrino().executeQuery("INSERT INTO " + hiveTableName + " VALUES (3, 'a3', 60, 3000)", new QueryExecutor.QueryParam[0])).hasMessageMatching("\\QQuery failed (#\\E\\S+\\Q): Insert query has mismatched column types: Table: [varchar, varchar, varchar, varchar, varchar, bigint, varchar, integer, bigint], Query: [integer, varchar(2), integer, integer]");
        QueryExecutors.onHudi().executeQuery("DROP TABLE " + schemaTableName, new QueryExecutor.QueryParam[0]);
    }

    @Test(groups={"hive_hudi_redirections", "profile_specific_tests"})
    public void testDelete() {
        String tableName = "hudi_delete_" + TestingNames.randomNameSuffix();
        String schemaTableName = TestHiveRedirectionToHudi.schemaTableName("default", tableName);
        String hiveTableName = TestHiveRedirectionToHudi.trinoTableName("hive", schemaTableName);
        this.createHudiCowTable(schemaTableName, false);
        QueryAssert.assertQueryFailure(() -> QueryExecutors.onTrino().executeQuery("DELETE FROM " + hiveTableName + " WHERE id = 1", new QueryExecutor.QueryParam[0])).hasMessageMatching("\\QQuery failed (#\\E\\S+\\Q): This connector does not support modifying table rows");
        QueryExecutors.onHudi().executeQuery("DROP TABLE " + schemaTableName, new QueryExecutor.QueryParam[0]);
    }

    @Test(groups={"hive_hudi_redirections", "profile_specific_tests"})
    public void testUpdate() {
        String tableName = "hudi_update_" + TestingNames.randomNameSuffix();
        String schemaTableName = TestHiveRedirectionToHudi.schemaTableName("default", tableName);
        String hiveTableName = TestHiveRedirectionToHudi.trinoTableName("hive", schemaTableName);
        this.createHudiCowTable(schemaTableName, false);
        QueryAssert.assertQueryFailure(() -> QueryExecutors.onTrino().executeQuery("UPDATE " + hiveTableName + " SET price = price + 100 WHERE id = 2", new QueryExecutor.QueryParam[0])).hasMessageMatching("\\QQuery failed (#\\E\\S+\\Q): This connector does not support modifying table rows");
        QueryExecutors.onHudi().executeQuery("DROP TABLE " + schemaTableName, new QueryExecutor.QueryParam[0]);
    }

    @Test(groups={"hive_hudi_redirections", "profile_specific_tests"})
    public void testMerge() {
        String sourceTableName = "hudi_merge_source_" + TestingNames.randomNameSuffix();
        String sourceSchemaTableName = TestHiveRedirectionToHudi.schemaTableName("default", sourceTableName);
        String hiveSourceTableName = TestHiveRedirectionToHudi.trinoTableName("hive", sourceSchemaTableName);
        String targetTableName = "hudi_merge_target_" + TestingNames.randomNameSuffix();
        String targetSchemaTableName = TestHiveRedirectionToHudi.schemaTableName("default", targetTableName);
        String hiveTargetTableName = TestHiveRedirectionToHudi.trinoTableName("hive", targetSchemaTableName);
        this.createHudiCowTable(sourceSchemaTableName, false);
        this.createHudiMorTable(targetSchemaTableName, false);
        QueryAssert.assertQueryFailure(() -> QueryExecutors.onTrino().executeQuery("MERGE INTO " + hiveTargetTableName + " t USING " + hiveSourceTableName + " s ON t.id = s.id WHEN NOT MATCHED     THEN INSERT (id, name, price, ts)             VALUES (s.id, s.name, s.price, s.ts)", new QueryExecutor.QueryParam[0])).hasMessageMatching("\\QQuery failed (#\\E\\S+\\Q): This connector does not support modifying table rows");
        QueryExecutors.onHudi().executeQuery("DROP TABLE " + sourceSchemaTableName, new QueryExecutor.QueryParam[0]);
        QueryExecutors.onHudi().executeQuery("DROP TABLE " + targetSchemaTableName, new QueryExecutor.QueryParam[0]);
        QueryExecutors.onHudi().executeQuery("DROP TABLE " + targetSchemaTableName + "_ro", new QueryExecutor.QueryParam[0]);
        QueryExecutors.onHudi().executeQuery("DROP TABLE " + targetSchemaTableName + "_rt", new QueryExecutor.QueryParam[0]);
    }

    @Test(groups={"hive_hudi_redirections", "profile_specific_tests"})
    public void testDropTable() {
        String tableName = "hudi_drop_" + TestingNames.randomNameSuffix();
        String schemaTableName = TestHiveRedirectionToHudi.schemaTableName("default", tableName);
        String hiveTableName = TestHiveRedirectionToHudi.trinoTableName("hive", schemaTableName);
        this.createHudiCowTable(schemaTableName, false);
        QueryAssert.assertQueryFailure(() -> QueryExecutors.onTrino().executeQuery("DROP TABLE  " + hiveTableName, new QueryExecutor.QueryParam[0])).hasMessageMatching("\\QQuery failed (#\\E\\S+\\Q): This connector does not support dropping tables");
        QueryExecutors.onHudi().executeQuery("DROP TABLE " + schemaTableName, new QueryExecutor.QueryParam[0]);
    }

    @Test(groups={"hive_hudi_redirections", "profile_specific_tests"})
    public void testDescribe() {
        String tableName = "hudi_describe_" + TestingNames.randomNameSuffix();
        String schemaTableName = TestHiveRedirectionToHudi.schemaTableName("default", tableName);
        String hudiTableName = TestHiveRedirectionToHudi.trinoTableName("hudi", schemaTableName);
        String hiveTableName = TestHiveRedirectionToHudi.trinoTableName("hive", schemaTableName);
        this.createHudiCowTable(schemaTableName, true);
        TestHiveRedirectionToHudi.assertResultsEqual(QueryExecutors.onTrino().executeQuery("DESCRIBE " + hudiTableName, new QueryExecutor.QueryParam[0]), QueryExecutors.onTrino().executeQuery("DESCRIBE " + hiveTableName, new QueryExecutor.QueryParam[0]));
        QueryExecutors.onHudi().executeQuery("DROP TABLE " + schemaTableName, new QueryExecutor.QueryParam[0]);
    }

    @Test(groups={"hive_hudi_redirections", "profile_specific_tests"})
    public void testShowGrants() {
        String tableName = "hudi_show_grants_" + TestingNames.randomNameSuffix();
        String schemaTableName = TestHiveRedirectionToHudi.schemaTableName("default", tableName);
        String hudiTableName = TestHiveRedirectionToHudi.trinoTableName("hudi", schemaTableName);
        String hiveTableName = TestHiveRedirectionToHudi.trinoTableName("hive", schemaTableName);
        this.createHudiCowTable(schemaTableName, false);
        QueryAssert.assertQueryFailure(() -> QueryExecutors.onTrino().executeQuery(String.format("SHOW GRANTS ON %s", hiveTableName), new QueryExecutor.QueryParam[0])).hasMessageMatching("\\QQuery failed (#\\E\\S+\\Q): line 1:1: Table " + hiveTableName + " is redirected to " + hudiTableName + " and SHOW GRANTS is not supported with table redirections");
        QueryExecutors.onHudi().executeQuery("DROP TABLE " + schemaTableName, new QueryExecutor.QueryParam[0]);
    }

    @Test(groups={"hive_hudi_redirections", "profile_specific_tests"})
    public void testGrant() {
        String tableName = "hudi_grant_" + TestingNames.randomNameSuffix();
        String schemaTableName = TestHiveRedirectionToHudi.schemaTableName("default", tableName);
        String hudiTableName = TestHiveRedirectionToHudi.trinoTableName("hudi", schemaTableName);
        String hiveTableName = TestHiveRedirectionToHudi.trinoTableName("hive", schemaTableName);
        this.createHudiCowTable(schemaTableName, false);
        QueryAssert.assertQueryFailure(() -> QueryExecutors.onTrino().executeQuery("GRANT SELECT ON " + hiveTableName + " TO ROLE PUBLIC", new QueryExecutor.QueryParam[0])).hasMessageMatching("\\QQuery failed (#\\E\\S+\\Q): line 1:1: Table " + hiveTableName + " is redirected to " + hudiTableName + " and GRANT is not supported with table redirections");
        QueryExecutors.onHudi().executeQuery("DROP TABLE " + schemaTableName, new QueryExecutor.QueryParam[0]);
    }

    @Test(groups={"hive_hudi_redirections", "profile_specific_tests"})
    public void testRevoke() {
        String tableName = "hudi_revoke_" + TestingNames.randomNameSuffix();
        String schemaTableName = TestHiveRedirectionToHudi.schemaTableName("default", tableName);
        String hudiTableName = TestHiveRedirectionToHudi.trinoTableName("hudi", schemaTableName);
        String hiveTableName = TestHiveRedirectionToHudi.trinoTableName("hive", schemaTableName);
        this.createHudiCowTable(schemaTableName, false);
        QueryAssert.assertQueryFailure(() -> QueryExecutors.onTrino().executeQuery("REVOKE SELECT ON " + hiveTableName + " FROM ROLE PUBLIC", new QueryExecutor.QueryParam[0])).hasMessageMatching("\\QQuery failed (#\\E\\S+\\Q): line 1:1: Table " + hiveTableName + " is redirected to " + hudiTableName + " and REVOKE is not supported with table redirections");
        QueryExecutors.onHudi().executeQuery("DROP TABLE " + schemaTableName, new QueryExecutor.QueryParam[0]);
    }

    @Test(groups={"hive_hudi_redirections", "profile_specific_tests"})
    public void testSetTableAuthorization() {
        String tableName = "hudi_set_table_authorization_" + TestingNames.randomNameSuffix();
        String schemaTableName = TestHiveRedirectionToHudi.schemaTableName("default", tableName);
        String hudiTableName = TestHiveRedirectionToHudi.trinoTableName("hudi", schemaTableName);
        String hiveTableName = TestHiveRedirectionToHudi.trinoTableName("hive", schemaTableName);
        this.createHudiCowTable(schemaTableName, false);
        QueryAssert.assertQueryFailure(() -> QueryExecutors.onTrino().executeQuery("ALTER TABLE " + hiveTableName + " SET AUTHORIZATION ROLE PUBLIC", new QueryExecutor.QueryParam[0])).hasMessageMatching("\\QQuery failed (#\\E\\S+\\Q): line 1:1: Table " + hiveTableName + " is redirected to " + hudiTableName + " and SET TABLE AUTHORIZATION is not supported with table redirections");
        QueryExecutors.onHudi().executeQuery("DROP TABLE " + schemaTableName, new QueryExecutor.QueryParam[0]);
    }

    @Test(groups={"hive_hudi_redirections", "profile_specific_tests"})
    public void testDeny() {
        String tableName = "hudi_deny_" + TestingNames.randomNameSuffix();
        String schemaTableName = TestHiveRedirectionToHudi.schemaTableName("default", tableName);
        String hudiTableName = TestHiveRedirectionToHudi.trinoTableName("hudi", schemaTableName);
        String hiveTableName = TestHiveRedirectionToHudi.trinoTableName("hive", schemaTableName);
        this.createHudiCowTable(schemaTableName, false);
        QueryAssert.assertQueryFailure(() -> QueryExecutors.onTrino().executeQuery("DENY DELETE ON " + hiveTableName + " TO ROLE PUBLIC", new QueryExecutor.QueryParam[0])).hasMessageMatching("\\QQuery failed (#\\E\\S+\\Q): line 1:1: Table " + hiveTableName + " is redirected to " + hudiTableName + " and DENY is not supported with table redirections");
        QueryExecutors.onHudi().executeQuery("DROP TABLE " + schemaTableName, new QueryExecutor.QueryParam[0]);
    }

    private static String schemaTableName(String schema, String tableName) {
        return "%s.%s".formatted(schema, tableName);
    }

    private static String trinoTableName(String catalog, String schemaTableName) {
        return "%s.%s".formatted(catalog, schemaTableName);
    }

    private static void assertResultsEqual(QueryResult first, QueryResult second) {
        ((QueryAssert)Assertions.assertThat((AssertProvider)first)).containsOnly((List)second.rows().stream().map(QueryAssert.Row::new).collect(ImmutableList.toImmutableList()));
        ((QueryAssert)Assertions.assertThat((AssertProvider)second)).containsOnly((List)first.rows().stream().map(QueryAssert.Row::new).collect(ImmutableList.toImmutableList()));
    }

    private void createHudiCowTable(String tableName, boolean partitioned) {
        this.createHudiTable(tableName, HUDI_TABLE_TYPE_COPY_ON_WRITE, partitioned);
    }

    private void createHudiMorTable(String tableName, boolean partitioned) {
        this.createHudiTable(tableName, HUDI_TABLE_TYPE_MERGE_ON_READ, partitioned);
    }

    private void createHudiTable(String tableName, String tableType, boolean partitioned) {
        if (partitioned) {
            TestHiveRedirectionToHudi.createHudiPartitionedTable(tableName, this.bucketName, tableType);
            return;
        }
        TestHiveRedirectionToHudi.createHudiNonPartitionedTable(tableName, this.bucketName, tableType);
    }

    private static void createHudiNonPartitionedTable(String tableName, String bucketName, String tableType) {
        QueryExecutors.onHudi().executeQuery(String.format("CREATE TABLE %s (\n  id bigint,\n  name string,\n  price int,\n  ts bigint)\nUSING hudi\nTBLPROPERTIES (\n  type = '%s',\n  primaryKey = 'id',\n  preCombineField = 'ts')\nLOCATION 's3://%s/%s'", tableName, tableType, bucketName, tableName), new QueryExecutor.QueryParam[0]);
        QueryExecutors.onHudi().executeQuery("INSERT INTO " + tableName + " VALUES (1, 'a1', 20, 1000), (2, 'a2', 40, 2000)", new QueryExecutor.QueryParam[0]);
    }

    private static void createHudiPartitionedTable(String tableName, String bucketName, String tableType) {
        QueryExecutors.onHudi().executeQuery(String.format("CREATE TABLE %s (\n  id bigint,\n  name string,\n  ts bigint,\n  dt string,\n  hh string)\nUSING hudi\nTBLPROPERTIES (\n  type = '%s',\n  primaryKey = 'id',\n  preCombineField = 'ts')\nPARTITIONED BY (dt, hh)\nLOCATION 's3://%s/%s'", tableName, tableType, bucketName, tableName), new QueryExecutor.QueryParam[0]);
        QueryExecutors.onHudi().executeQuery("INSERT INTO " + tableName + " PARTITION (dt, hh) SELECT 1 AS id, 'a1' AS name, 1000 AS ts, '2021-12-09' AS dt, '10' AS hh", new QueryExecutor.QueryParam[0]);
        QueryExecutors.onHudi().executeQuery("INSERT INTO " + tableName + " PARTITION (dt = '2021-12-09', hh='11') SELECT 2, 'a2', 1000", new QueryExecutor.QueryParam[0]);
    }
}

