/*
 * Decompiled with CFR 0.152.
 */
package io.trino.tests.product.kafka;

import com.google.common.collect.ImmutableList;
import io.trino.tempto.ProductTest;
import io.trino.tempto.assertions.QueryAssert;
import io.trino.tempto.context.ThreadLocalTestContextHolder;
import io.trino.tempto.fulfillment.table.TableHandle;
import io.trino.tempto.fulfillment.table.TableManager;
import io.trino.tempto.fulfillment.table.kafka.KafkaDataSource;
import io.trino.tempto.fulfillment.table.kafka.KafkaTableDefinition;
import io.trino.tempto.fulfillment.table.kafka.KafkaTableManager;
import io.trino.tempto.fulfillment.table.kafka.ListKafkaDataSource;
import io.trino.tempto.query.QueryExecutor;
import io.trino.tests.product.utils.QueryExecutors;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.List;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.AssertProvider;
import org.assertj.core.api.Assertions;
import org.testng.annotations.Test;

public class TestKafkaProtobufWritesSmokeTest
extends ProductTest {
    private static final String KAFKA_CATALOG = "kafka";
    private static final String KAFKA_SCHEMA = "product_tests";
    private static final String ALL_DATATYPES_PROTOBUF_TABLE_NAME = "all_datatypes_protobuf";
    private static final String ALL_DATATYPES_PROTOBUF_TOPIC_NAME = "write_all_datatypes_protobuf";
    private static final String STRUCTURAL_PROTOBUF_TABLE_NAME = "structural_datatype_protobuf";
    private static final String STRUCTURAL_PROTOBUF_TOPIC_NAME = "structural_datatype_protobuf";

    private static void createProtobufTable(String tableName, String topicName) {
        KafkaTableDefinition tableDefinition = new KafkaTableDefinition(tableName, topicName, (KafkaDataSource)new ListKafkaDataSource((List)ImmutableList.of()), 1, 1);
        KafkaTableManager kafkaTableManager = (KafkaTableManager)ThreadLocalTestContextHolder.testContext().getDependency(TableManager.class, KAFKA_CATALOG);
        kafkaTableManager.createImmutable(tableDefinition, TableHandle.tableHandle((String)tableName).inSchema(KAFKA_SCHEMA));
    }

    @Test(groups={"kafka", "profile_specific_tests"})
    public void testInsertAllDataType() {
        TestKafkaProtobufWritesSmokeTest.createProtobufTable(ALL_DATATYPES_PROTOBUF_TABLE_NAME, ALL_DATATYPES_PROTOBUF_TOPIC_NAME);
        ((QueryAssert)Assertions.assertThat((AssertProvider)QueryExecutors.onTrino().executeQuery(String.format("INSERT INTO %s.%s.%s VALUES ('Chennai', 314, 9223372036854775807, 1234567890.123456789, 3.14, true, 'ZERO', TIMESTAMP '2020-12-21 15:45:00.012345'),('TamilNadu', -314, -9223372036854775808, -1234567890.123456789, -3.14, false, 'ONE', TIMESTAMP '1970-01-01 15:45:00.012345'), ('India', 314, 9223372036854775807, 1234567890.123456789, 3.14, false, 'TWO', TIMESTAMP '0001-01-01 00:00:00.000001')", KAFKA_CATALOG, KAFKA_SCHEMA, ALL_DATATYPES_PROTOBUF_TABLE_NAME), new QueryExecutor.QueryParam[0]))).updatedRowsCountIsEqualTo(3);
        ((QueryAssert)Assertions.assertThat((AssertProvider)QueryExecutors.onTrino().executeQuery(String.format("SELECT * FROM %s.%s.%s", KAFKA_CATALOG, KAFKA_SCHEMA, ALL_DATATYPES_PROTOBUF_TABLE_NAME), new QueryExecutor.QueryParam[0]))).containsOnly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{"Chennai", 314, Long.MAX_VALUE, 1.2345678901234567E9, Float.valueOf(3.14f), true, "ZERO", Timestamp.valueOf("2020-12-21 15:45:00.012345")}), QueryAssert.Row.row((Object[])new Object[]{"TamilNadu", -314, Long.MIN_VALUE, -1.2345678901234567E9, Float.valueOf(-3.14f), false, "ONE", Timestamp.valueOf("1970-01-01 15:45:00.012345")}), QueryAssert.Row.row((Object[])new Object[]{"India", 314, Long.MAX_VALUE, 1.2345678901234567E9, Float.valueOf(3.14f), false, "TWO", Timestamp.valueOf("0001-01-01 00:00:00.000001")})});
        ((AbstractThrowableAssert)QueryAssert.assertQueryFailure(() -> QueryExecutors.onTrino().executeQuery(String.format("INSERT INTO %s.%s.%s (h_varchar) VALUES ('Chennai')", KAFKA_CATALOG, KAFKA_SCHEMA, ALL_DATATYPES_PROTOBUF_TABLE_NAME), new QueryExecutor.QueryParam[0])).isInstanceOf(SQLException.class)).hasMessageMatching("Query failed \\(.+\\): Protobuf doesn't support serializing null values");
    }

    @Test(groups={"kafka", "profile_specific_tests"})
    public void testInsertStructuralDataType() {
        TestKafkaProtobufWritesSmokeTest.createProtobufTable("structural_datatype_protobuf", "structural_datatype_protobuf");
        ((QueryAssert)Assertions.assertThat((AssertProvider)QueryExecutors.onTrino().executeQuery(String.format("INSERT INTO %s.%s.%s VALUES (ARRAY[CAST(ROW('Entry1') AS ROW(simple_string VARCHAR))], map_from_entries(ARRAY[('key1', CAST(ROW('value1') AS ROW(simple_string VARCHAR)))]), CAST(ROW(1234567890.123456789, 3.14, 'ONE') AS ROW(d_double DOUBLE, e_float REAL, g_enum VARCHAR)), 'Chennai', 314, 9223372036854775807, CAST(ROW('Entry2') AS ROW(simple_string VARCHAR)), TIMESTAMP '2020-12-21 15:45:00.012345')", KAFKA_CATALOG, KAFKA_SCHEMA, "structural_datatype_protobuf"), new QueryExecutor.QueryParam[0]))).updatedRowsCountIsEqualTo(1);
        ((QueryAssert)Assertions.assertThat((AssertProvider)QueryExecutors.onTrino().executeQuery(String.format("SELECT c_array[1].simple_string, b_map['key1'].simple_string, a_row.d_double, a_row.e_float, a_row.g_enum, a_string, c_integer, c_bigint, d_row.simple_string, e_timestamp FROM %s.%s.%s", KAFKA_CATALOG, KAFKA_SCHEMA, "structural_datatype_protobuf"), new QueryExecutor.QueryParam[0]))).containsOnly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{"Entry1", "value1", 1.2345678901234567E9, Float.valueOf(3.14f), "ONE", "Chennai", 314, Long.MAX_VALUE, "Entry2", Timestamp.valueOf("2020-12-21 15:45:00.012345")})});
    }
}

