/*
 * Decompiled with CFR 0.152.
 */
package io.trino.tests.product;

import io.trino.tempto.ProductTest;
import io.trino.tempto.Requires;
import io.trino.tempto.assertions.QueryAssert;
import io.trino.tempto.fulfillment.table.hive.tpch.ImmutableTpchTablesRequirements;
import io.trino.tempto.query.QueryExecutor;
import io.trino.testing.TestingNames;
import io.trino.tests.product.utils.QueryExecutors;
import org.assertj.core.api.AssertProvider;
import org.assertj.core.api.Assertions;
import org.testng.annotations.Test;

@Requires(value={ImmutableTpchTablesRequirements.ImmutableNationTable.class})
public class TestCreateTable
extends ProductTest {
    @Test
    public void shouldCreateTableAsSelect() {
        String tableName = "create_table_as_select";
        QueryExecutors.onTrino().executeQuery(String.format("DROP TABLE IF EXISTS %s", tableName), new QueryExecutor.QueryParam[0]);
        QueryExecutors.onTrino().executeQuery(String.format("CREATE TABLE %s(nationkey, name) AS SELECT n_nationkey, n_name FROM nation", tableName), new QueryExecutor.QueryParam[0]);
        ((QueryAssert)Assertions.assertThat((AssertProvider)QueryExecutors.onTrino().executeQuery(String.format("SELECT * FROM %s", tableName), new QueryExecutor.QueryParam[0]))).hasRowsCount(25);
    }

    @Test
    public void shouldCreateTableAsEmptySelect() {
        String tableName = "create_table_as_empty_select";
        QueryExecutors.onTrino().executeQuery(String.format("DROP TABLE IF EXISTS %s", tableName), new QueryExecutor.QueryParam[0]);
        QueryExecutors.onTrino().executeQuery(String.format("CREATE TABLE %s(nationkey, name) AS SELECT n_nationkey, n_name FROM nation WHERE 0 is NULL", tableName), new QueryExecutor.QueryParam[0]);
        ((QueryAssert)Assertions.assertThat((AssertProvider)QueryExecutors.onTrino().executeQuery(String.format("SELECT nationkey, name FROM %s", tableName), new QueryExecutor.QueryParam[0]))).hasRowsCount(0);
    }

    @Test
    public void shouldNotCreateTableInNonExistentSchema() {
        String schemaName = "test_schema_" + TestingNames.randomNameSuffix();
        String table = schemaName + ".test_create_no_schema_" + TestingNames.randomNameSuffix();
        QueryAssert.assertQueryFailure(() -> QueryExecutors.onTrino().executeQuery("CREATE TABLE " + table + " (a bigint)", new QueryExecutor.QueryParam[0])).hasMessageMatching("\\QQuery failed (#\\E\\S+\\Q): Schema " + schemaName + " not found");
        QueryAssert.assertQueryFailure(() -> QueryExecutors.onTrino().executeQuery("TABLE " + table, new QueryExecutor.QueryParam[0])).hasMessageMatching("\\QQuery failed (#\\E\\S+\\Q): line 1:1: Schema '" + schemaName + "' does not exist");
    }

    @Test
    public void shouldNotCreateExternalTableInNonExistentSchema() {
        String schemaName = "test_schema_" + TestingNames.randomNameSuffix();
        String table = schemaName + ".test_create_no_schema_" + TestingNames.randomNameSuffix();
        QueryAssert.assertQueryFailure(() -> QueryExecutors.onTrino().executeQuery("CREATE TABLE " + table + " (a bigint) WITH (external_location = '/tmp')", new QueryExecutor.QueryParam[0])).hasMessageMatching("\\QQuery failed (#\\E\\S+\\Q): Schema " + schemaName + " not found");
        QueryAssert.assertQueryFailure(() -> QueryExecutors.onTrino().executeQuery("TABLE " + table, new QueryExecutor.QueryParam[0])).hasMessageMatching("\\QQuery failed (#\\E\\S+\\Q): line 1:1: Schema '" + schemaName + "' does not exist");
    }
}

