/*
 * Decompiled with CFR 0.152.
 */
package io.trino.tests.product;

import io.trino.tempto.AfterMethodWithContext;
import io.trino.tempto.BeforeMethodWithContext;
import io.trino.tempto.ProductTest;
import io.trino.tempto.Requirement;
import io.trino.tempto.RequirementsProvider;
import io.trino.tempto.Requires;
import io.trino.tempto.assertions.QueryAssert;
import io.trino.tempto.configuration.Configuration;
import io.trino.tempto.context.ThreadLocalTestContextHolder;
import io.trino.tempto.fulfillment.table.ImmutableTableRequirement;
import io.trino.tempto.fulfillment.table.TableDefinition;
import io.trino.tempto.fulfillment.table.hive.tpch.TpchTableDefinitions;
import io.trino.tempto.query.QueryExecutor;
import io.trino.tests.product.utils.QueryExecutors;
import org.assertj.core.api.AssertProvider;
import org.assertj.core.api.Assertions;
import org.testng.annotations.Test;

public class TestSimpleQuery
extends ProductTest {
    @BeforeMethodWithContext
    public void beforeTest() {
        Assertions.assertThat((boolean)ThreadLocalTestContextHolder.testContextIfSet().isPresent()).isTrue();
    }

    @AfterMethodWithContext
    public void afterTest() {
        Assertions.assertThat((boolean)ThreadLocalTestContextHolder.testContextIfSet().isPresent()).isTrue();
    }

    @Test(groups={"smoke"})
    @Requires(value={SimpleTestRequirements.class})
    public void selectAllFromNation() {
        ((QueryAssert)Assertions.assertThat((AssertProvider)QueryExecutors.onTrino().executeQuery("select * from nation", new QueryExecutor.QueryParam[0]))).hasRowsCount(25);
    }

    @Test(groups={"smoke"})
    @Requires(value={SimpleTestRequirements.class})
    public void selectCountFromNation() {
        ((QueryAssert)Assertions.assertThat((AssertProvider)QueryExecutors.onTrino().executeQuery("select count(*) from nation", new QueryExecutor.QueryParam[0]))).hasRowsCount(1).contains(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{25})});
    }

    private static class SimpleTestRequirements
    implements RequirementsProvider {
        private SimpleTestRequirements() {
        }

        public Requirement getRequirements(Configuration configuration) {
            return new ImmutableTableRequirement((TableDefinition)TpchTableDefinitions.NATION);
        }
    }
}

