/*
 * Decompiled with CFR 0.152.
 */
package io.trino.tests.product.deltalake;

import com.amazonaws.services.s3.AmazonS3;
import com.google.common.collect.ImmutableList;
import com.google.inject.Inject;
import com.google.inject.name.Named;
import io.trino.tempto.BeforeMethodWithContext;
import io.trino.tempto.assertions.QueryAssert;
import io.trino.tempto.query.QueryExecutor;
import io.trino.testing.TestingNames;
import io.trino.testng.services.Flaky;
import io.trino.tests.product.deltalake.BaseTestDeltaLakeS3Storage;
import io.trino.tests.product.deltalake.S3ClientFactory;
import io.trino.tests.product.deltalake.util.DeltaLakeTestUtils;
import io.trino.tests.product.utils.QueryExecutors;
import java.util.List;
import org.assertj.core.api.AssertProvider;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ListAssert;
import org.testng.annotations.Test;

public class TestDeltaLakeCloneTableCompatibility
extends BaseTestDeltaLakeS3Storage {
    @Inject
    @Named(value="s3.server_type")
    private String s3ServerType;
    private AmazonS3 s3;

    @BeforeMethodWithContext
    public void setup() {
        super.setUp();
        this.s3 = new S3ClientFactory().createS3Client(this.s3ServerType);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(groups={"delta-lake-oss", "profile_specific_tests"})
    public void testTableChangesOnShallowCloneTable() {
        String baseTable = "test_dl_base_table_" + TestingNames.randomNameSuffix();
        String clonedTable = "test_dl_clone_tableV1_" + TestingNames.randomNameSuffix();
        String directoryName = "databricks-tablechanges-compatibility-test-";
        String changeDataPrefix = "/_change_data";
        try {
            QueryExecutors.onDelta().executeQuery("CREATE TABLE default." + baseTable + " (a_int INT, b_string STRING) USING delta LOCATION 's3://" + this.bucketName + "/" + directoryName + baseTable + "'", new QueryExecutor.QueryParam[0]);
            QueryExecutors.onDelta().executeQuery("INSERT INTO default." + baseTable + " VALUES (1, 'a')", new QueryExecutor.QueryParam[0]);
            QueryExecutors.onDelta().executeQuery("CREATE TABLE default." + clonedTable + " SHALLOW CLONE default." + baseTable + " TBLPROPERTIES (delta.enableChangeDataFeed = true) LOCATION 's3://" + this.bucketName + "/" + directoryName + clonedTable + "'", new QueryExecutor.QueryParam[0]);
            QueryExecutors.onDelta().executeQuery("INSERT INTO default." + clonedTable + " VALUES (2, 'b')", new QueryExecutor.QueryParam[0]);
            List<String> cdfFilesPostOnlyInsert = this.getFilesFromTableDirectory(directoryName + clonedTable + changeDataPrefix);
            Assertions.assertThat(cdfFilesPostOnlyInsert).isEmpty();
            QueryExecutors.onDelta().executeQuery("UPDATE default." + clonedTable + " SET a_int = a_int + 1", new QueryExecutor.QueryParam[0]);
            List<String> cdfFilesPostOnlyInsertAndUpdate = this.getFilesFromTableDirectory(directoryName + clonedTable + changeDataPrefix);
            Assertions.assertThat(cdfFilesPostOnlyInsertAndUpdate).hasSize(2);
            ImmutableList expectedRowsClonedTableOnTrino = ImmutableList.of((Object)QueryAssert.Row.row((Object[])new Object[]{2, "b", "insert", 1L}), (Object)QueryAssert.Row.row((Object[])new Object[]{1, "a", "update_preimage", 2L}), (Object)QueryAssert.Row.row((Object[])new Object[]{2, "a", "update_postimage", 2L}), (Object)QueryAssert.Row.row((Object[])new Object[]{2, "b", "update_preimage", 2L}), (Object)QueryAssert.Row.row((Object[])new Object[]{3, "b", "update_postimage", 2L}));
            ((QueryAssert)Assertions.assertThat((AssertProvider)QueryExecutors.onTrino().executeQuery("SELECT a_int, b_string, _change_type, _commit_version FROM TABLE(delta.system.table_changes('default', '" + clonedTable + "', 0))", new QueryExecutor.QueryParam[0]))).containsOnly((List)expectedRowsClonedTableOnTrino);
            ImmutableList expectedRowsClonedTableOnSpark = ImmutableList.of((Object)QueryAssert.Row.row((Object[])new Object[]{1, "a", "insert", 0L}), (Object)QueryAssert.Row.row((Object[])new Object[]{2, "b", "insert", 1L}), (Object)QueryAssert.Row.row((Object[])new Object[]{1, "a", "update_preimage", 2L}), (Object)QueryAssert.Row.row((Object[])new Object[]{2, "a", "update_postimage", 2L}), (Object)QueryAssert.Row.row((Object[])new Object[]{2, "b", "update_preimage", 2L}), (Object)QueryAssert.Row.row((Object[])new Object[]{3, "b", "update_postimage", 2L}));
            ((QueryAssert)Assertions.assertThat((AssertProvider)QueryExecutors.onDelta().executeQuery("SELECT a_int, b_string, _change_type, _commit_version FROM table_changes('default." + clonedTable + "', 0)", new QueryExecutor.QueryParam[0]))).containsOnly((List)expectedRowsClonedTableOnSpark);
            ImmutableList expectedRows = ImmutableList.of((Object)QueryAssert.Row.row((Object[])new Object[]{2, "a"}), (Object)QueryAssert.Row.row((Object[])new Object[]{3, "b"}));
            ((QueryAssert)Assertions.assertThat((AssertProvider)QueryExecutors.onDelta().executeQuery("SELECT * FROM default." + clonedTable, new QueryExecutor.QueryParam[0]))).containsOnly((List)expectedRows);
            ((QueryAssert)Assertions.assertThat((AssertProvider)QueryExecutors.onTrino().executeQuery("SELECT * FROM delta.default." + clonedTable, new QueryExecutor.QueryParam[0]))).containsOnly((List)expectedRows);
        }
        finally {
            QueryExecutors.onTrino().executeQuery("DROP TABLE IF EXISTS delta.default." + baseTable, new QueryExecutor.QueryParam[0]);
            QueryExecutors.onTrino().executeQuery("DROP TABLE IF EXISTS delta.default." + clonedTable, new QueryExecutor.QueryParam[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(groups={"delta-lake-oss", "profile_specific_tests"})
    public void testShallowCloneTableDrop() {
        String baseTable = "test_dl_base_table_" + TestingNames.randomNameSuffix();
        String clonedTable = "test_dl_clone_tableV1_" + TestingNames.randomNameSuffix();
        String directoryName = "databricks-shallowclone-drop-compatibility-test-";
        try {
            QueryExecutors.onDelta().executeQuery("CREATE TABLE default." + baseTable + " (a_int INT, b_string STRING) USING delta LOCATION 's3://" + this.bucketName + "/" + directoryName + baseTable + "'", new QueryExecutor.QueryParam[0]);
            QueryExecutors.onDelta().executeQuery("INSERT INTO default." + baseTable + " VALUES (1, 'a')", new QueryExecutor.QueryParam[0]);
            QueryExecutors.onDelta().executeQuery("CREATE TABLE default." + clonedTable + " SHALLOW CLONE default." + baseTable + " LOCATION 's3://" + this.bucketName + "/" + directoryName + clonedTable + "'", new QueryExecutor.QueryParam[0]);
            QueryAssert.Row expectedRow = QueryAssert.Row.row((Object[])new Object[]{1, "a"});
            ((QueryAssert)Assertions.assertThat((AssertProvider)QueryExecutors.onDelta().executeQuery("SELECT * FROM default." + baseTable, new QueryExecutor.QueryParam[0]))).containsOnly(new QueryAssert.Row[]{expectedRow});
            ((QueryAssert)Assertions.assertThat((AssertProvider)QueryExecutors.onTrino().executeQuery("SELECT * FROM delta.default." + baseTable, new QueryExecutor.QueryParam[0]))).containsOnly(new QueryAssert.Row[]{expectedRow});
            ((QueryAssert)Assertions.assertThat((AssertProvider)QueryExecutors.onDelta().executeQuery("SELECT * FROM default." + clonedTable, new QueryExecutor.QueryParam[0]))).containsOnly(new QueryAssert.Row[]{expectedRow});
            ((QueryAssert)Assertions.assertThat((AssertProvider)QueryExecutors.onTrino().executeQuery("SELECT * FROM delta.default." + clonedTable, new QueryExecutor.QueryParam[0]))).containsOnly(new QueryAssert.Row[]{expectedRow});
            QueryExecutors.onTrino().executeQuery("DROP TABLE IF EXISTS delta.default." + clonedTable, new QueryExecutor.QueryParam[0]);
            ((QueryAssert)Assertions.assertThat((AssertProvider)QueryExecutors.onDelta().executeQuery("SELECT * FROM default." + baseTable, new QueryExecutor.QueryParam[0]))).containsOnly(new QueryAssert.Row[]{expectedRow});
            ((QueryAssert)Assertions.assertThat((AssertProvider)QueryExecutors.onTrino().executeQuery("SELECT * FROM delta.default." + baseTable, new QueryExecutor.QueryParam[0]))).containsOnly(new QueryAssert.Row[]{expectedRow});
        }
        finally {
            QueryExecutors.onTrino().executeQuery("DROP TABLE IF EXISTS delta.default." + baseTable, new QueryExecutor.QueryParam[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(groups={"delta-lake-oss", "profile_specific_tests"})
    public void testVacuumOnShallowCloneTable() {
        String baseTable = "test_dl_base_table_" + TestingNames.randomNameSuffix();
        String clonedTable = "test_dl_clone_tableV1_" + TestingNames.randomNameSuffix();
        String directoryName = "databricks-vacuum-compatibility-test-";
        try {
            QueryExecutors.onDelta().executeQuery("CREATE TABLE default." + baseTable + " (a_int INT, b_string STRING) USING delta LOCATION 's3://" + this.bucketName + "/" + directoryName + baseTable + "' TBLPROPERTIES ( 'delta.columnMapping.mode'='name' )", new QueryExecutor.QueryParam[0]);
            QueryExecutors.onDelta().executeQuery("INSERT INTO default." + baseTable + " VALUES (1, 'a')", new QueryExecutor.QueryParam[0]);
            List<String> baseTableActiveDataFiles = this.getActiveDataFiles(baseTable);
            List<String> baseTableAllDataFiles = this.getFilesFromTableDirectory(directoryName + baseTable);
            ((ListAssert)Assertions.assertThat(baseTableActiveDataFiles).hasSize(1)).isEqualTo(baseTableAllDataFiles);
            QueryExecutors.onDelta().executeQuery("CREATE TABLE default." + clonedTable + " SHALLOW CLONE default." + baseTable + " LOCATION 's3://" + this.bucketName + "/" + directoryName + clonedTable + "'", new QueryExecutor.QueryParam[0]);
            QueryExecutors.onDelta().executeQuery("INSERT INTO default." + clonedTable + " VALUES (2, 'b')", new QueryExecutor.QueryParam[0]);
            List<String> clonedTableV1ActiveDataFiles = this.getActiveDataFiles(clonedTable);
            Assertions.assertThat(clonedTableV1ActiveDataFiles).hasSize(2);
            List<String> clonedTableV1AllDataFiles = this.getFilesFromTableDirectory(directoryName + clonedTable);
            Assertions.assertThat(clonedTableV1AllDataFiles).hasSize(1);
            QueryExecutors.onDelta().executeQuery("UPDATE default." + clonedTable + " SET a_int = a_int + 1", new QueryExecutor.QueryParam[0]);
            List<String> clonedTableV2ActiveDataFiles = this.getActiveDataFiles(clonedTable);
            Assertions.assertThat(clonedTableV2ActiveDataFiles).hasSize(2);
            List<String> clonedTableV2AllDataFiles = this.getFilesFromTableDirectory(directoryName + clonedTable);
            Assertions.assertThat(clonedTableV2AllDataFiles).hasSize(3);
            QueryExecutors.onDelta().executeQuery("SET spark.databricks.delta.retentionDurationCheck.enabled = false", new QueryExecutor.QueryParam[0]);
            List<String> toBeVacuumedDataFilesFromDryRun = this.getToBeVacuumedDataFilesFromDryRun(clonedTable);
            ((ListAssert)((ListAssert)Assertions.assertThat(toBeVacuumedDataFilesFromDryRun).hasSize(1)).hasSameElementsAs(clonedTableV1AllDataFiles)).doesNotContainAnyElementsOf(baseTableAllDataFiles);
            QueryExecutors.onTrino().executeQuery("SET SESSION delta.vacuum_min_retention = '0s'", new QueryExecutor.QueryParam[0]);
            QueryExecutors.onTrino().executeQuery("CALL delta.system.vacuum('default', '" + clonedTable + "', '0s')", new QueryExecutor.QueryParam[0]);
            List<String> clonedTableV4ActiveDataFiles = this.getActiveDataFiles(clonedTable);
            ((ListAssert)Assertions.assertThat(clonedTableV4ActiveDataFiles).hasSize(2)).containsExactlyInAnyOrderElementsOf(clonedTableV2ActiveDataFiles);
            List<String> clonedTableV4AllDataFiles = this.getFilesFromTableDirectory(directoryName + clonedTable);
            ((ListAssert)Assertions.assertThat(clonedTableV4ActiveDataFiles).hasSize(2)).hasSameElementsAs(clonedTableV4AllDataFiles);
            ImmutableList expectedRowsClonedTable = ImmutableList.of((Object)QueryAssert.Row.row((Object[])new Object[]{2, "a"}), (Object)QueryAssert.Row.row((Object[])new Object[]{3, "b"}));
            ((QueryAssert)Assertions.assertThat((AssertProvider)QueryExecutors.onDelta().executeQuery("SELECT * FROM default." + clonedTable, new QueryExecutor.QueryParam[0]))).containsOnly((List)expectedRowsClonedTable);
            ((QueryAssert)Assertions.assertThat((AssertProvider)QueryExecutors.onTrino().executeQuery("SELECT * FROM delta.default." + clonedTable, new QueryExecutor.QueryParam[0]))).containsOnly((List)expectedRowsClonedTable);
            Assertions.assertThat((List)QueryExecutors.onTrino().executeQuery("SELECT DISTINCT \"$path\" FROM default." + clonedTable, new QueryExecutor.QueryParam[0]).rows()).hasSameElementsAs((Iterable)QueryExecutors.onDelta().executeQuery("SELECT distinct _metadata.file_path FROM default." + clonedTable, new QueryExecutor.QueryParam[0]).rows());
            QueryAssert.Row expectedRow = QueryAssert.Row.row((Object[])new Object[]{1, "a"});
            ((QueryAssert)Assertions.assertThat((AssertProvider)QueryExecutors.onDelta().executeQuery("SELECT * FROM default." + baseTable, new QueryExecutor.QueryParam[0]))).containsOnly(new QueryAssert.Row[]{expectedRow});
            ((QueryAssert)Assertions.assertThat((AssertProvider)QueryExecutors.onTrino().executeQuery("SELECT * FROM delta.default." + baseTable, new QueryExecutor.QueryParam[0]))).containsOnly(new QueryAssert.Row[]{expectedRow});
            Assertions.assertThat((List)QueryExecutors.onTrino().executeQuery("SELECT DISTINCT \"$path\" FROM default." + clonedTable, new QueryExecutor.QueryParam[0]).rows()).hasSameElementsAs((Iterable)QueryExecutors.onDelta().executeQuery("SELECT distinct _metadata.file_path FROM default." + clonedTable, new QueryExecutor.QueryParam[0]).rows());
            List<String> baseTableActiveDataFilesPostVacuumOnShallowClonedTable = this.getActiveDataFiles(baseTable);
            List<String> baseTableAllDataFilesPostVacuumOnShallowClonedTable = this.getFilesFromTableDirectory(directoryName + baseTable);
            ((ListAssert)((ListAssert)Assertions.assertThat(baseTableActiveDataFilesPostVacuumOnShallowClonedTable).hasSameElementsAs(baseTableAllDataFilesPostVacuumOnShallowClonedTable)).hasSameElementsAs(baseTableActiveDataFiles)).hasSameElementsAs(baseTableAllDataFiles);
        }
        finally {
            QueryExecutors.onTrino().executeQuery("DROP TABLE IF EXISTS delta.default." + baseTable, new QueryExecutor.QueryParam[0]);
            QueryExecutors.onTrino().executeQuery("DROP TABLE IF EXISTS delta.default." + clonedTable, new QueryExecutor.QueryParam[0]);
        }
    }

    @Test(groups={"delta-lake-oss", "profile_specific_tests"})
    public void testReadFromSchemaChangedShallowCloneTable() {
        this.testReadSchemaChangedCloneTable("SHALLOW", true);
        this.testReadSchemaChangedCloneTable("SHALLOW", false);
    }

    @Test(groups={"delta-lake-databricks", "delta-lake-exclude-91", "profile_specific_tests"})
    @Flaky(issue="https://github.com/trinodb/trino/issues/14391", match="\\Q[Databricks][\\E(DatabricksJDBCDriver|JDBCDriver)\\Q](500593) Communication link failure. Failed to connect to server. Reason: \\E((HTTP retry after response received with no Retry-After header, error: HTTP Response code: 503|HTTP Response code: 504), Error message: Unknown.|java.net.SocketTimeoutException: Read timed out.)")
    public void testReadFromSchemaChangedDeepCloneTable() {
        this.testReadSchemaChangedCloneTable("DEEP", true);
        this.testReadSchemaChangedCloneTable("DEEP", false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testReadSchemaChangedCloneTable(String cloneType, boolean partitioned) {
        String directoryName = "/databricks-compatibility-test-";
        String baseTable = "test_dl_base_table_" + TestingNames.randomNameSuffix();
        String clonedTableV1 = "test_dl_clone_tableV1_" + TestingNames.randomNameSuffix();
        String clonedTableV2 = "test_dl_clone_tableV2_" + TestingNames.randomNameSuffix();
        String clonedTableV3 = "test_dl_clone_tableV3_" + TestingNames.randomNameSuffix();
        String clonedTableV4 = "test_dl_clone_tableV4_" + TestingNames.randomNameSuffix();
        try {
            QueryExecutors.onDelta().executeQuery("CREATE TABLE default." + baseTable + " (a_int INT, b_string STRING) USING delta " + (partitioned ? "PARTITIONED BY (b_string) " : "") + "LOCATION 's3://" + this.bucketName + directoryName + baseTable + "' TBLPROPERTIES ( 'delta.columnMapping.mode'='name' )", new QueryExecutor.QueryParam[0]);
            QueryExecutors.onDelta().executeQuery("INSERT INTO default." + baseTable + " VALUES (1, 'a')", new QueryExecutor.QueryParam[0]);
            QueryAssert.Row expectedRow = QueryAssert.Row.row((Object[])new Object[]{1, "a"});
            ((QueryAssert)Assertions.assertThat((AssertProvider)QueryExecutors.onDelta().executeQuery("SELECT * FROM default." + baseTable, new QueryExecutor.QueryParam[0]))).containsOnly(new QueryAssert.Row[]{expectedRow});
            ((QueryAssert)Assertions.assertThat((AssertProvider)QueryExecutors.onTrino().executeQuery("SELECT * FROM delta.default." + baseTable, new QueryExecutor.QueryParam[0]))).containsOnly(new QueryAssert.Row[]{expectedRow});
            QueryExecutors.onDelta().executeQuery("ALTER TABLE default." + baseTable + " add columns (c_string string, d_int int)", new QueryExecutor.QueryParam[0]);
            QueryExecutors.onDelta().executeQuery("INSERT INTO default." + baseTable + " VALUES (2, 'b', 'c', 3)", new QueryExecutor.QueryParam[0]);
            QueryExecutors.onDelta().executeQuery("CREATE TABLE default." + clonedTableV1 + " " + cloneType + " CLONE default." + baseTable + " VERSION AS OF 1 LOCATION 's3://" + this.bucketName + directoryName + clonedTableV1 + "'", new QueryExecutor.QueryParam[0]);
            QueryAssert.Row expectedRowV1 = QueryAssert.Row.row((Object[])new Object[]{1, "a"});
            ((QueryAssert)Assertions.assertThat((AssertProvider)QueryExecutors.onDelta().executeQuery("SELECT * FROM default." + baseTable + " VERSION AS OF 1", new QueryExecutor.QueryParam[0]))).containsOnly(new QueryAssert.Row[]{expectedRowV1});
            ((QueryAssert)Assertions.assertThat((AssertProvider)QueryExecutors.onDelta().executeQuery("SELECT * FROM default." + clonedTableV1, new QueryExecutor.QueryParam[0]))).containsOnly(new QueryAssert.Row[]{expectedRowV1});
            ((QueryAssert)Assertions.assertThat((AssertProvider)QueryExecutors.onTrino().executeQuery("SELECT * FROM delta.default." + clonedTableV1, new QueryExecutor.QueryParam[0]))).containsOnly(new QueryAssert.Row[]{expectedRowV1});
            QueryExecutors.onDelta().executeQuery("CREATE TABLE default." + clonedTableV2 + " " + cloneType + " CLONE default." + baseTable + " VERSION AS OF 2 LOCATION 's3://" + this.bucketName + directoryName + clonedTableV2 + "'", new QueryExecutor.QueryParam[0]);
            QueryAssert.Row expectedRowV2 = QueryAssert.Row.row((Object[])new Object[]{1, "a", null, null});
            ((QueryAssert)Assertions.assertThat((AssertProvider)QueryExecutors.onDelta().executeQuery("SELECT * FROM default." + baseTable + " VERSION AS OF 2", new QueryExecutor.QueryParam[0]))).containsOnly(new QueryAssert.Row[]{expectedRowV2});
            ((QueryAssert)Assertions.assertThat((AssertProvider)QueryExecutors.onDelta().executeQuery("SELECT * FROM default." + clonedTableV2, new QueryExecutor.QueryParam[0]))).containsOnly(new QueryAssert.Row[]{expectedRowV2});
            ((QueryAssert)Assertions.assertThat((AssertProvider)QueryExecutors.onTrino().executeQuery("SELECT * FROM delta.default." + clonedTableV2, new QueryExecutor.QueryParam[0]))).containsOnly(new QueryAssert.Row[]{expectedRowV2});
            QueryExecutors.onDelta().executeQuery("CREATE TABLE default." + clonedTableV3 + " " + cloneType + " CLONE default." + baseTable + " VERSION AS OF 3 LOCATION 's3://" + this.bucketName + directoryName + clonedTableV3 + "'", new QueryExecutor.QueryParam[0]);
            ImmutableList expectedRowsV3 = ImmutableList.of((Object)QueryAssert.Row.row((Object[])new Object[]{1, "a", null, null}), (Object)QueryAssert.Row.row((Object[])new Object[]{2, "b", "c", 3}));
            ((QueryAssert)Assertions.assertThat((AssertProvider)QueryExecutors.onDelta().executeQuery("SELECT * FROM default." + baseTable, new QueryExecutor.QueryParam[0]))).containsOnly((List)expectedRowsV3);
            ((QueryAssert)Assertions.assertThat((AssertProvider)QueryExecutors.onTrino().executeQuery("SELECT * FROM delta.default." + baseTable, new QueryExecutor.QueryParam[0]))).containsOnly((List)expectedRowsV3);
            ((QueryAssert)Assertions.assertThat((AssertProvider)QueryExecutors.onDelta().executeQuery("SELECT * FROM default." + baseTable + " VERSION AS OF 3", new QueryExecutor.QueryParam[0]))).containsOnly((List)expectedRowsV3);
            ((QueryAssert)Assertions.assertThat((AssertProvider)QueryExecutors.onDelta().executeQuery("SELECT * FROM default." + clonedTableV3, new QueryExecutor.QueryParam[0]))).containsOnly((List)expectedRowsV3);
            ((QueryAssert)Assertions.assertThat((AssertProvider)QueryExecutors.onTrino().executeQuery("SELECT * FROM delta.default." + clonedTableV3, new QueryExecutor.QueryParam[0]))).containsOnly((List)expectedRowsV3);
            QueryExecutors.onDelta().executeQuery("ALTER TABLE default." + baseTable + " DROP COLUMN c_string", new QueryExecutor.QueryParam[0]);
            QueryExecutors.onDelta().executeQuery("CREATE TABLE default." + clonedTableV4 + " " + cloneType + " CLONE default." + baseTable + " VERSION AS OF 4 LOCATION 's3://" + this.bucketName + directoryName + clonedTableV4 + "'", new QueryExecutor.QueryParam[0]);
            ImmutableList expectedRowsV4 = ImmutableList.of((Object)QueryAssert.Row.row((Object[])new Object[]{1, "a", null}), (Object)QueryAssert.Row.row((Object[])new Object[]{2, "b", 3}));
            ((QueryAssert)Assertions.assertThat((AssertProvider)QueryExecutors.onDelta().executeQuery("SELECT * FROM default." + baseTable, new QueryExecutor.QueryParam[0]))).containsOnly((List)expectedRowsV4);
            ((QueryAssert)Assertions.assertThat((AssertProvider)QueryExecutors.onTrino().executeQuery("SELECT * FROM delta.default." + baseTable, new QueryExecutor.QueryParam[0]))).containsOnly((List)expectedRowsV4);
            ((QueryAssert)Assertions.assertThat((AssertProvider)QueryExecutors.onDelta().executeQuery("SELECT * FROM default." + baseTable + " VERSION AS OF 4", new QueryExecutor.QueryParam[0]))).containsOnly((List)expectedRowsV4);
            ((QueryAssert)Assertions.assertThat((AssertProvider)QueryExecutors.onDelta().executeQuery("SELECT * FROM default." + clonedTableV4, new QueryExecutor.QueryParam[0]))).containsOnly((List)expectedRowsV4);
            ((QueryAssert)Assertions.assertThat((AssertProvider)QueryExecutors.onTrino().executeQuery("SELECT * FROM delta.default." + clonedTableV4, new QueryExecutor.QueryParam[0]))).containsOnly((List)expectedRowsV4);
            if (partitioned) {
                ImmutableList expectedPartitionRows = ImmutableList.of((Object)QueryAssert.Row.row((Object[])new Object[]{"a"}), (Object)QueryAssert.Row.row((Object[])new Object[]{"b"}));
                ((QueryAssert)Assertions.assertThat((AssertProvider)QueryExecutors.onDelta().executeQuery("SELECT b_string FROM default." + baseTable, new QueryExecutor.QueryParam[0]))).containsOnly((List)expectedPartitionRows);
                ((QueryAssert)Assertions.assertThat((AssertProvider)QueryExecutors.onTrino().executeQuery("SELECT b_string FROM delta.default." + baseTable, new QueryExecutor.QueryParam[0]))).containsOnly((List)expectedPartitionRows);
                ((QueryAssert)Assertions.assertThat((AssertProvider)QueryExecutors.onDelta().executeQuery("SELECT b_string FROM default." + baseTable + " VERSION AS OF 3", new QueryExecutor.QueryParam[0]))).containsOnly((List)expectedPartitionRows);
                ((QueryAssert)Assertions.assertThat((AssertProvider)QueryExecutors.onDelta().executeQuery("SELECT b_string FROM default." + clonedTableV3, new QueryExecutor.QueryParam[0]))).containsOnly((List)expectedPartitionRows);
                ((QueryAssert)Assertions.assertThat((AssertProvider)QueryExecutors.onTrino().executeQuery("SELECT b_string FROM delta.default." + clonedTableV3, new QueryExecutor.QueryParam[0]))).containsOnly((List)expectedPartitionRows);
            }
            QueryExecutors.onDelta().executeQuery("INSERT INTO default." + clonedTableV4 + " VALUES (3, 'c', 3)", new QueryExecutor.QueryParam[0]);
            QueryExecutors.onTrino().executeQuery("INSERT INTO delta.default." + clonedTableV4 + " VALUES (4, 'd', 4)", new QueryExecutor.QueryParam[0]);
            ImmutableList expectedRowsV5 = ImmutableList.of((Object)QueryAssert.Row.row((Object[])new Object[]{1, "a", null}), (Object)QueryAssert.Row.row((Object[])new Object[]{2, "b", 3}), (Object)QueryAssert.Row.row((Object[])new Object[]{3, "c", 3}), (Object)QueryAssert.Row.row((Object[])new Object[]{4, "d", 4}));
            ((QueryAssert)Assertions.assertThat((AssertProvider)QueryExecutors.onTrino().executeQuery("SELECT * FROM delta.default." + clonedTableV4, new QueryExecutor.QueryParam[0]))).containsOnly((List)expectedRowsV5);
            ((QueryAssert)Assertions.assertThat((AssertProvider)QueryExecutors.onDelta().executeQuery("SELECT * FROM default." + clonedTableV4, new QueryExecutor.QueryParam[0]))).containsOnly((List)expectedRowsV5);
            Assertions.assertThat((List)QueryExecutors.onTrino().executeQuery("SELECT DISTINCT \"$path\" FROM default." + clonedTableV4, new QueryExecutor.QueryParam[0]).rows()).hasSameElementsAs((Iterable)QueryExecutors.onDelta().executeQuery("SELECT distinct _metadata.file_path FROM default." + clonedTableV4, new QueryExecutor.QueryParam[0]).rows());
            QueryExecutors.onDelta().executeQuery("DELETE FROM default." + clonedTableV4 + " WHERE a_int in (1, 2)", new QueryExecutor.QueryParam[0]);
            ImmutableList expectedRowsV6 = ImmutableList.of((Object)QueryAssert.Row.row((Object[])new Object[]{3, "c", 3}), (Object)QueryAssert.Row.row((Object[])new Object[]{4, "d", 4}));
            ((QueryAssert)Assertions.assertThat((AssertProvider)QueryExecutors.onTrino().executeQuery("SELECT * FROM delta.default." + clonedTableV4, new QueryExecutor.QueryParam[0]))).containsOnly((List)expectedRowsV6);
            ((QueryAssert)Assertions.assertThat((AssertProvider)QueryExecutors.onDelta().executeQuery("SELECT * FROM default." + clonedTableV4, new QueryExecutor.QueryParam[0]))).containsOnly((List)expectedRowsV6);
            Assertions.assertThat((List)QueryExecutors.onTrino().executeQuery("SELECT DISTINCT \"$path\" FROM default." + clonedTableV4, new QueryExecutor.QueryParam[0]).rows()).hasSameElementsAs((Iterable)QueryExecutors.onDelta().executeQuery("SELECT distinct _metadata.file_path FROM default." + clonedTableV4, new QueryExecutor.QueryParam[0]).rows());
        }
        finally {
            this.dropTable(cloneType, baseTable);
            this.dropTable(cloneType, clonedTableV1);
            this.dropTable(cloneType, clonedTableV2);
            this.dropTable(cloneType, clonedTableV3);
            this.dropTable(cloneType, clonedTableV4);
        }
    }

    private List<String> getActiveDataFiles(String tableName) {
        return QueryExecutors.onTrino().executeQuery("SELECT DISTINCT \"$path\" FROM default." + tableName, new QueryExecutor.QueryParam[0]).column(1);
    }

    private List<String> getToBeVacuumedDataFilesFromDryRun(String tableName) {
        return QueryExecutors.onDelta().executeQuery("VACUUM default." + tableName + " RETAIN 0 HOURS DRY RUN", new QueryExecutor.QueryParam[0]).column(1);
    }

    private List<String> getFilesFromTableDirectory(String directory) {
        return (List)this.s3.listObjectsV2(this.bucketName, directory).getObjectSummaries().stream().filter(s3ObjectSummary -> !s3ObjectSummary.getKey().contains("/_delta_log")).map(s3ObjectSummary -> String.format("s3://%s/%s", this.bucketName, s3ObjectSummary.getKey())).collect(ImmutableList.toImmutableList());
    }

    private void dropTable(String cloneType, String tableName) {
        if (cloneType.equals("DEEP")) {
            DeltaLakeTestUtils.dropDeltaTableWithRetry("default." + tableName);
        } else {
            QueryExecutors.onTrino().executeQuery("DROP TABLE IF EXISTS delta.default." + tableName, new QueryExecutor.QueryParam[0]);
        }
    }
}

