/*
 * Decompiled with CFR 0.152.
 */
package io.trino.tests.product.deltalake;

import com.google.common.collect.ImmutableList;
import io.trino.tempto.AfterMethodWithContext;
import io.trino.tempto.BeforeMethodWithContext;
import io.trino.tempto.ProductTest;
import io.trino.tempto.assertions.QueryAssert;
import io.trino.tempto.query.QueryExecutor;
import io.trino.testing.TestingNames;
import io.trino.testng.services.Flaky;
import io.trino.tests.product.utils.QueryExecutors;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import org.assertj.core.api.AssertProvider;
import org.assertj.core.api.Assertions;
import org.testng.annotations.Test;

public class TestDeltaLakeDatabricksUnityCompatibility
extends ProductTest {
    private final String schemaName = "test_delta_basic_" + TestingNames.randomNameSuffix();
    private String unityCatalogName;
    private String externalLocationPath;

    @BeforeMethodWithContext
    public void setUp() {
        this.unityCatalogName = Objects.requireNonNull(System.getenv("DATABRICKS_UNITY_CATALOG_NAME"), "Environment variable not set: DATABRICKS_UNITY_CATALOG_NAME");
        this.externalLocationPath = Objects.requireNonNull(System.getenv("DATABRICKS_UNITY_EXTERNAL_LOCATION"), "Environment variable not set: DATABRICKS_UNITY_EXTERNAL_LOCATION");
        QueryExecutors.onDelta().executeQuery(String.format("CREATE SCHEMA %s.%s", this.unityCatalogName, this.schemaName), new QueryExecutor.QueryParam[0]);
    }

    @AfterMethodWithContext
    public void cleanUp() {
        QueryExecutors.onDelta().executeQuery(String.format("DROP SCHEMA IF EXISTS %s.%s CASCADE", this.unityCatalogName, this.schemaName), new QueryExecutor.QueryParam[0]);
    }

    @Test(groups={"databricks-unity-http-hms", "profile_specific_tests"})
    @Flaky(issue="https://github.com/trinodb/trino/issues/14391", match="\\Q[Databricks][\\E(DatabricksJDBCDriver|JDBCDriver)\\Q](500593) Communication link failure. Failed to connect to server. Reason: \\E((HTTP retry after response received with no Retry-After header, error: HTTP Response code: 503|HTTP Response code: 504), Error message: Unknown.|java.net.SocketTimeoutException: Read timed out.)")
    public void testBasicTableReadWrite() {
        String tableName = "test_read_write_" + TestingNames.randomNameSuffix();
        String deltaTableName = "delta.%s.%s".formatted(this.schemaName, tableName);
        String unityTableName = "%s.%s.%s".formatted(this.unityCatalogName, this.schemaName, tableName);
        String tableLocation = String.format("%s/%s/%s", this.externalLocationPath, this.schemaName, tableName);
        QueryExecutors.onDelta().executeQuery("CREATE TABLE " + unityTableName + " (c1 int, c2 string) USING delta LOCATION '" + tableLocation + "'", new QueryExecutor.QueryParam[0]);
        QueryExecutors.onDelta().executeQuery("INSERT INTO " + unityTableName + " VALUES (1, 'one')", new QueryExecutor.QueryParam[0]);
        ((QueryAssert)Assertions.assertThat((AssertProvider)QueryExecutors.onTrino().executeQuery("SHOW SCHEMAS FROM delta", new QueryExecutor.QueryParam[0]))).contains(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{this.schemaName.toLowerCase(Locale.ENGLISH)})});
        ((QueryAssert)Assertions.assertThat((AssertProvider)QueryExecutors.onTrino().executeQuery("SHOW TABLES IN delta." + this.schemaName, new QueryExecutor.QueryParam[0]))).containsOnly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{tableName.toLowerCase(Locale.ENGLISH)})});
        ((QueryAssert)Assertions.assertThat((AssertProvider)QueryExecutors.onTrino().executeQuery("SELECT * FROM " + deltaTableName, new QueryExecutor.QueryParam[0]))).containsOnly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{1, "one"})});
        ImmutableList expectedRowsForInsert = ImmutableList.of((Object)QueryAssert.Row.row((Object[])new Object[]{1, "one"}), (Object)QueryAssert.Row.row((Object[])new Object[]{2, "two"}));
        QueryExecutors.onTrino().executeQuery("INSERT INTO " + deltaTableName + " VALUES (2, 'two')", new QueryExecutor.QueryParam[0]);
        ((QueryAssert)Assertions.assertThat((AssertProvider)QueryExecutors.onTrino().executeQuery("SELECT * FROM " + deltaTableName, new QueryExecutor.QueryParam[0]))).containsOnly((List)expectedRowsForInsert);
        ((QueryAssert)Assertions.assertThat((AssertProvider)QueryExecutors.onDelta().executeQuery("SELECT * FROM " + unityTableName, new QueryExecutor.QueryParam[0]))).containsOnly((List)expectedRowsForInsert);
        ImmutableList expectedRowsForUpdate = ImmutableList.of((Object)QueryAssert.Row.row((Object[])new Object[]{1, "one"}), (Object)QueryAssert.Row.row((Object[])new Object[]{2, "two hundred"}));
        QueryExecutors.onTrino().executeQuery("UPDATE " + deltaTableName + " SET c2 = 'two hundred' WHERE c1 = 2", new QueryExecutor.QueryParam[0]);
        ((QueryAssert)Assertions.assertThat((AssertProvider)QueryExecutors.onTrino().executeQuery("SELECT * FROM " + deltaTableName, new QueryExecutor.QueryParam[0]))).containsOnly((List)expectedRowsForUpdate);
        ((QueryAssert)Assertions.assertThat((AssertProvider)QueryExecutors.onDelta().executeQuery("SELECT * FROM " + unityTableName, new QueryExecutor.QueryParam[0]))).containsOnly((List)expectedRowsForUpdate);
        ImmutableList expectedRowsForDelete = ImmutableList.of((Object)QueryAssert.Row.row((Object[])new Object[]{2, "two hundred"}));
        QueryExecutors.onTrino().executeQuery("DELETE FROM " + deltaTableName + " WHERE c2 = 'one'", new QueryExecutor.QueryParam[0]);
        ((QueryAssert)Assertions.assertThat((AssertProvider)QueryExecutors.onTrino().executeQuery("SELECT * FROM " + deltaTableName, new QueryExecutor.QueryParam[0]))).containsOnly((List)expectedRowsForDelete);
        ((QueryAssert)Assertions.assertThat((AssertProvider)QueryExecutors.onDelta().executeQuery("SELECT * FROM " + unityTableName, new QueryExecutor.QueryParam[0]))).containsOnly((List)expectedRowsForDelete);
        ImmutableList expectedRowsForMerge = ImmutableList.of((Object)QueryAssert.Row.row((Object[])new Object[]{1, "one"}), (Object)QueryAssert.Row.row((Object[])new Object[]{2, "two"}), (Object)QueryAssert.Row.row((Object[])new Object[]{3, "three"}));
        String sourceTableName = "test_source_" + TestingNames.randomNameSuffix();
        String tableLocation2 = String.format("%s/%s/%s", this.externalLocationPath, this.schemaName, sourceTableName);
        QueryExecutors.onDelta().executeQuery(String.format("CREATE TABLE %s.%s.%s (c1 int, c2 string) using delta location '%s'", this.unityCatalogName, this.schemaName, sourceTableName, tableLocation2), new QueryExecutor.QueryParam[0]);
        QueryExecutors.onDelta().executeQuery(String.format("INSERT INTO %s.%s.%s values (1, 'one'), (2, 'two'), (3, 'three')", this.unityCatalogName, this.schemaName, sourceTableName), new QueryExecutor.QueryParam[0]);
        QueryExecutors.onTrino().executeQuery(String.format("MERGE INTO delta.%s.%s t USING delta.%s.%s s on t.c1 = s.c1 WHEN MATCHED THEN UPDATE SET c2 = s.c2 WHEN NOT MATCHED THEN INSERT (c1, c2) VALUES (s.c1, s.c2)", this.schemaName, tableName, this.schemaName, sourceTableName), new QueryExecutor.QueryParam[0]);
        ((QueryAssert)Assertions.assertThat((AssertProvider)QueryExecutors.onTrino().executeQuery("SELECT * FROM " + deltaTableName, new QueryExecutor.QueryParam[0]))).containsOnly((List)expectedRowsForMerge);
        ((QueryAssert)Assertions.assertThat((AssertProvider)QueryExecutors.onDelta().executeQuery("SELECT * FROM " + unityTableName, new QueryExecutor.QueryParam[0]))).containsOnly((List)expectedRowsForMerge);
    }

    @Test(groups={"databricks-unity-http-hms", "profile_specific_tests"})
    @Flaky(issue="https://github.com/trinodb/trino/issues/14391", match="\\Q[Databricks][\\E(DatabricksJDBCDriver|JDBCDriver)\\Q](500593) Communication link failure. Failed to connect to server. Reason: \\E((HTTP retry after response received with no Retry-After header, error: HTTP Response code: 503|HTTP Response code: 504), Error message: Unknown.|java.net.SocketTimeoutException: Read timed out.)")
    public void testManagedTable() {
        String tableName = "test_managed_table_" + TestingNames.randomNameSuffix();
        String unityTableName = "%s.%s.%s".formatted(this.unityCatalogName, this.schemaName, tableName);
        QueryExecutors.onDelta().executeQuery("CREATE TABLE " + unityTableName + " (c1 int, c2 string)", new QueryExecutor.QueryParam[0]);
        ((QueryAssert)Assertions.assertThat((AssertProvider)QueryExecutors.onTrino().executeQuery("SHOW CREATE SCHEMA delta." + this.schemaName, new QueryExecutor.QueryParam[0]))).containsOnly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{"CREATE SCHEMA delta." + this.schemaName})});
        ((QueryAssert)Assertions.assertThat((AssertProvider)QueryExecutors.onTrino().executeQuery("SHOW TABLES IN delta." + this.schemaName, new QueryExecutor.QueryParam[0]))).hasNoRows();
    }

    @Test(groups={"databricks-unity-http-hms", "profile_specific_tests"})
    @Flaky(issue="https://github.com/trinodb/trino/issues/14391", match="\\Q[Databricks][\\E(DatabricksJDBCDriver|JDBCDriver)\\Q](500593) Communication link failure. Failed to connect to server. Reason: \\E((HTTP retry after response received with no Retry-After header, error: HTTP Response code: 503|HTTP Response code: 504), Error message: Unknown.|java.net.SocketTimeoutException: Read timed out.)")
    public void testColumnTypes() {
        String tableName = "test_column_types" + TestingNames.randomNameSuffix();
        String deltaTableName = "delta.%s.%s".formatted(this.schemaName, tableName);
        String unityTableName = "%s.%s.%s".formatted(this.unityCatalogName, this.schemaName, tableName);
        String tableLocation = String.format("%s/%s/%s", this.externalLocationPath, this.schemaName, tableName);
        QueryExecutors.onDelta().executeQuery(String.format("CREATE TABLE %s (int_col INT,string_col STRING,tinyint_col TINYINT,smallint_col SMALLINT,bigint_col BIGINT,decimal_col DECIMAL,float_col FLOAT,double_col DOUBLE,date_col DATE,timestamp_col TIMESTAMP,binary_col BINARY,bool_col BOOLEAN,array_int_col ARRAY<int>,map_col MAP<TIMESTAMP,INT>,struct_col struct<a: LONG, b: String NOT NULL>) USING DELTA LOCATION '%s'", unityTableName, tableLocation), new QueryExecutor.QueryParam[0]);
        ((QueryAssert)Assertions.assertThat((AssertProvider)QueryExecutors.onTrino().executeQuery("SHOW TABLES IN delta." + this.schemaName, new QueryExecutor.QueryParam[0]))).containsOnly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{tableName})});
        ((QueryAssert)Assertions.assertThat((AssertProvider)QueryExecutors.onTrino().executeQuery("SHOW COLUMNS IN " + deltaTableName, new QueryExecutor.QueryParam[0]))).containsOnly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{"int_col", "integer", "", ""}), QueryAssert.Row.row((Object[])new Object[]{"string_col", "varchar", "", ""}), QueryAssert.Row.row((Object[])new Object[]{"tinyint_col", "tinyint", "", ""}), QueryAssert.Row.row((Object[])new Object[]{"smallint_col", "smallint", "", ""}), QueryAssert.Row.row((Object[])new Object[]{"bigint_col", "bigint", "", ""}), QueryAssert.Row.row((Object[])new Object[]{"decimal_col", "decimal(10,0)", "", ""}), QueryAssert.Row.row((Object[])new Object[]{"float_col", "real", "", ""}), QueryAssert.Row.row((Object[])new Object[]{"double_col", "double", "", ""}), QueryAssert.Row.row((Object[])new Object[]{"date_col", "date", "", ""}), QueryAssert.Row.row((Object[])new Object[]{"timestamp_col", "timestamp(3) with time zone", "", ""}), QueryAssert.Row.row((Object[])new Object[]{"binary_col", "varbinary", "", ""}), QueryAssert.Row.row((Object[])new Object[]{"bool_col", "boolean", "", ""}), QueryAssert.Row.row((Object[])new Object[]{"array_int_col", "array(integer)", "", ""}), QueryAssert.Row.row((Object[])new Object[]{"map_col", "map(timestamp(3) with time zone, integer)", "", ""}), QueryAssert.Row.row((Object[])new Object[]{"struct_col", "row(a bigint, b varchar)", "", ""})});
    }

    @Test(groups={"databricks-unity-http-hms", "profile_specific_tests"})
    @Flaky(issue="https://github.com/trinodb/trino/issues/14391", match="\\Q[Databricks][\\E(DatabricksJDBCDriver|JDBCDriver)\\Q](500593) Communication link failure. Failed to connect to server. Reason: \\E((HTTP retry after response received with no Retry-After header, error: HTTP Response code: 503|HTTP Response code: 504), Error message: Unknown.|java.net.SocketTimeoutException: Read timed out.)")
    public void testUnsupportedStatements() {
        String tableName = "test_unsupported_" + TestingNames.randomNameSuffix();
        String tableLocation = String.format("%s/%s/%s", this.externalLocationPath, this.schemaName, tableName);
        String trinoLocation = String.format("%s/%s", this.externalLocationPath, "trino_test_" + TestingNames.randomNameSuffix());
        QueryExecutors.onDelta().executeQuery(String.format("CREATE TABLE %s.%s.%s (c1 int, c2 string) USING delta LOCATION '%s'", this.unityCatalogName, this.schemaName, tableName, tableLocation), new QueryExecutor.QueryParam[0]);
        QueryAssert.assertQueryFailure(() -> QueryExecutors.onTrino().executeQuery(String.format("CREATE TABLE delta.%s.new_table (c1 int) WITH (location = '%s')", this.schemaName, trinoLocation), new QueryExecutor.QueryParam[0])).hasMessageContaining("DDL not enabled in Hive metastore interface.");
        QueryAssert.assertQueryFailure(() -> QueryExecutors.onTrino().executeQuery(String.format("CREATE TABLE delta.%s.new_table (c1) WITH (location = '%s') AS SELECT 1", this.schemaName, trinoLocation), new QueryExecutor.QueryParam[0])).hasRootCauseMessage("DDL not enabled in Hive metastore interface.");
        QueryAssert.assertQueryFailure(() -> QueryExecutors.onTrino().executeQuery(String.format("ALTER TABLE delta.%s.%s RENAME TO delta.%s.new_t1", this.schemaName, tableName, this.schemaName), new QueryExecutor.QueryParam[0])).hasMessageContaining("DDL not enabled in Hive metastore interface.");
        QueryAssert.assertQueryFailure(() -> QueryExecutors.onTrino().executeQuery(String.format("DROP TABLE delta.%s.%s", this.schemaName, tableName), new QueryExecutor.QueryParam[0])).hasMessageContaining("DDL not enabled in Hive metastore interface.");
        QueryAssert.assertQueryFailure(() -> QueryExecutors.onTrino().executeQuery(String.format("DROP SCHEMA delta.%s CASCADE", this.schemaName), new QueryExecutor.QueryParam[0])).hasMessageContaining("DDL not enabled in Hive metastore interface.");
    }
}

