/*
 * Decompiled with CFR 0.152.
 */
package io.trino.tests.product.deltalake;

import com.google.common.collect.ImmutableList;
import io.trino.tempto.BeforeMethodWithContext;
import io.trino.tempto.assertions.QueryAssert;
import io.trino.tempto.query.QueryExecutor;
import io.trino.testing.DataProviders;
import io.trino.testing.TestingNames;
import io.trino.testng.services.Flaky;
import io.trino.tests.product.deltalake.BaseTestDeltaLakeS3Storage;
import io.trino.tests.product.deltalake.util.DatabricksVersion;
import io.trino.tests.product.deltalake.util.DeltaLakeTestUtils;
import io.trino.tests.product.utils.QueryExecutors;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import org.assertj.core.api.AssertProvider;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.MapAssert;
import org.testng.SkipException;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;

public class TestDeltaLakeDeleteCompatibility
extends BaseTestDeltaLakeS3Storage {
    private Optional<DatabricksVersion> databricksRuntimeVersion;

    @BeforeMethodWithContext
    public void determineDatabricksVersion() {
        this.databricksRuntimeVersion = DeltaLakeTestUtils.getDatabricksRuntimeVersion();
    }

    @Test(groups={"delta-lake-oss", "profile_specific_tests"}, dataProviderClass=DataProviders.class, dataProvider="trueFalse")
    public void testDeleteOnEnforcedConstraintsReturnsRowsCount(boolean partitioned) {
        String tableName = "test_delete_push_down_" + TestingNames.randomNameSuffix();
        QueryExecutors.onDelta().executeQuery("CREATE TABLE default." + tableName + "(v INT, p INT)USING delta " + (partitioned ? "PARTITIONED BY (p)" : "") + "LOCATION 's3://" + this.bucketName + "/databricks-compatibility-test-" + tableName + "'", new QueryExecutor.QueryParam[0]);
        try {
            QueryExecutors.onDelta().executeQuery("INSERT INTO default." + tableName + " VALUES (1, 10), (2, 10), (11, 20), (21, 30), (22, 30)", new QueryExecutor.QueryParam[0]);
            QueryExecutors.onDelta().executeQuery("INSERT INTO default." + tableName + " VALUES (3, 10), (12, 20)", new QueryExecutor.QueryParam[0]);
            if (partitioned) {
                ((QueryAssert)Assertions.assertThat((AssertProvider)QueryExecutors.onTrino().executeQuery("DELETE FROM default." + tableName + " WHERE p = 10", new QueryExecutor.QueryParam[0]))).containsOnly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{3})});
                ((QueryAssert)Assertions.assertThat((AssertProvider)QueryExecutors.onTrino().executeQuery("DELETE FROM default." + tableName, new QueryExecutor.QueryParam[0]))).containsOnly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{4})});
            } else {
                ((QueryAssert)Assertions.assertThat((AssertProvider)QueryExecutors.onTrino().executeQuery("DELETE FROM default." + tableName, new QueryExecutor.QueryParam[0]))).containsOnly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{7})});
            }
            ((QueryAssert)Assertions.assertThat((AssertProvider)QueryExecutors.onDelta().executeQuery("SELECT * FROM default." + tableName, new QueryExecutor.QueryParam[0]))).hasNoRows();
        }
        finally {
            DeltaLakeTestUtils.dropDeltaTableWithRetry("default." + tableName);
        }
    }

    @Test(groups={"delta-lake-databricks", "profile_specific_tests"})
    @Flaky(issue="https://github.com/trinodb/trino/issues/14391", match="\\Q[Databricks][\\E(DatabricksJDBCDriver|JDBCDriver)\\Q](500593) Communication link failure. Failed to connect to server. Reason: \\E((HTTP retry after response received with no Retry-After header, error: HTTP Response code: 503|HTTP Response code: 504), Error message: Unknown.|java.net.SocketTimeoutException: Read timed out.)")
    public void testDeleteCompatibility() {
        String tableName = "test_delete_compatibility_" + TestingNames.randomNameSuffix();
        QueryExecutors.onDelta().executeQuery("CREATE TABLE default." + tableName + " (a int, b int) USING DELTA LOCATION 's3://" + this.bucketName + "/databricks-compatibility-test-" + tableName + "'", new QueryExecutor.QueryParam[0]);
        try {
            QueryExecutors.onDelta().executeQuery("INSERT INTO default." + tableName + " VALUES (1, 2), (2, 3), (3, 4), (4, 5), (5, 6)", new QueryExecutor.QueryParam[0]);
            QueryExecutors.onTrino().executeQuery("DELETE FROM delta.default." + tableName + " WHERE a % 2 = 0", new QueryExecutor.QueryParam[0]);
            ImmutableList expectedRows = ImmutableList.of((Object)QueryAssert.Row.row((Object[])new Object[]{1, 2}), (Object)QueryAssert.Row.row((Object[])new Object[]{3, 4}), (Object)QueryAssert.Row.row((Object[])new Object[]{5, 6}));
            ((QueryAssert)Assertions.assertThat((AssertProvider)QueryExecutors.onDelta().executeQuery("SELECT * FROM default." + tableName, new QueryExecutor.QueryParam[0]))).containsOnly((List)expectedRows);
            ((QueryAssert)Assertions.assertThat((AssertProvider)QueryExecutors.onTrino().executeQuery("SELECT * FROM delta.default." + tableName, new QueryExecutor.QueryParam[0]))).containsOnly((List)expectedRows);
        }
        finally {
            DeltaLakeTestUtils.dropDeltaTableWithRetry("default." + tableName);
        }
    }

    @Test(groups={"delta-lake-oss", "profile_specific_tests"})
    public void testDeleteOnAppendOnlyTableFails() {
        String tableName = "test_delete_on_append_only_table_fails_" + TestingNames.randomNameSuffix();
        QueryExecutors.onDelta().executeQuery("CREATE TABLE default." + tableName + "         (a INT, b INT)         USING delta          LOCATION 's3://" + this.bucketName + "/databricks-compatibility-test-" + tableName + "'          TBLPROPERTIES ('delta.appendOnly' = true)", new QueryExecutor.QueryParam[0]);
        QueryExecutors.onDelta().executeQuery("INSERT INTO default." + tableName + " VALUES (1,11), (2, 12)", new QueryExecutor.QueryParam[0]);
        QueryAssert.assertQueryFailure(() -> QueryExecutors.onDelta().executeQuery("DELETE FROM default." + tableName + " WHERE a = 1", new QueryExecutor.QueryParam[0])).hasMessageContaining("This table is configured to only allow appends");
        QueryAssert.assertQueryFailure(() -> QueryExecutors.onTrino().executeQuery("DELETE FROM default." + tableName + " WHERE a = 1", new QueryExecutor.QueryParam[0])).hasMessageContaining("Cannot modify rows from a table with 'delta.appendOnly' set to true");
        QueryAssert.assertQueryFailure(() -> QueryExecutors.onTrino().executeQuery("DELETE FROM default." + tableName, new QueryExecutor.QueryParam[0])).hasMessageContaining("Cannot modify rows from a table with 'delta.appendOnly' set to true");
        QueryAssert.assertQueryFailure(() -> QueryExecutors.onTrino().executeQuery("TRUNCATE TABLE delta.default." + tableName, new QueryExecutor.QueryParam[0])).hasMessageContaining("Cannot modify rows from a table with 'delta.appendOnly' set to true");
        ((QueryAssert)Assertions.assertThat((AssertProvider)QueryExecutors.onDelta().executeQuery("SELECT * FROM default." + tableName, new QueryExecutor.QueryParam[0]))).containsOnly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{1, 11}), QueryAssert.Row.row((Object[])new Object[]{2, 12})});
        QueryExecutors.onTrino().executeQuery("DROP TABLE " + tableName, new QueryExecutor.QueryParam[0]);
    }

    @Test(groups={"delta-lake-oss", "profile_specific_tests"})
    public void testDeleteOnAppendOnlyWriterFeature() {
        String tableName = "test_delete_on_append_only_feature_" + TestingNames.randomNameSuffix();
        QueryExecutors.onDelta().executeQuery("CREATE TABLE default." + tableName + "(a INT, b INT)USING delta LOCATION 's3://" + this.bucketName + "/databricks-compatibility-test-" + tableName + "'TBLPROPERTIES ('delta.minWriterVersion'='7', 'delta.appendOnly' = true)", new QueryExecutor.QueryParam[0]);
        try {
            QueryExecutors.onDelta().executeQuery("INSERT INTO default." + tableName + " VALUES (1,11), (2, 12)", new QueryExecutor.QueryParam[0]);
            ((MapAssert)Assertions.assertThat(DeltaLakeTestUtils.getTablePropertiesOnDelta("default", tableName)).contains(new Map.Entry[]{Assertions.entry((Object)"delta.feature.appendOnly", (Object)"supported")})).contains(new Map.Entry[]{Assertions.entry((Object)"delta.appendOnly", (Object)"true")});
            QueryAssert.assertQueryFailure(() -> QueryExecutors.onDelta().executeQuery("DELETE FROM default." + tableName + " WHERE a = 1", new QueryExecutor.QueryParam[0])).hasMessageContaining("This table is configured to only allow appends");
            QueryAssert.assertQueryFailure(() -> QueryExecutors.onTrino().executeQuery("DELETE FROM delta.default." + tableName + " WHERE a = 1", new QueryExecutor.QueryParam[0])).hasMessageContaining("Cannot modify rows from a table with 'delta.appendOnly' set to true");
            ((QueryAssert)Assertions.assertThat((AssertProvider)QueryExecutors.onDelta().executeQuery("SELECT * FROM default." + tableName, new QueryExecutor.QueryParam[0]))).containsOnly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{1, 11}), QueryAssert.Row.row((Object[])new Object[]{2, 12})});
            QueryExecutors.onDelta().executeQuery("ALTER TABLE default." + tableName + " UNSET TBLPROPERTIES ('delta.feature.appendOnly')", new QueryExecutor.QueryParam[0]);
            ((MapAssert)Assertions.assertThat(DeltaLakeTestUtils.getTablePropertiesOnDelta("default", tableName)).contains(new Map.Entry[]{Assertions.entry((Object)"delta.feature.appendOnly", (Object)"supported")})).contains(new Map.Entry[]{Assertions.entry((Object)"delta.appendOnly", (Object)"true")});
            QueryExecutors.onDelta().executeQuery("ALTER TABLE default." + tableName + " SET TBLPROPERTIES ('delta.appendOnly'=false)", new QueryExecutor.QueryParam[0]);
            ((MapAssert)Assertions.assertThat(DeltaLakeTestUtils.getTablePropertiesOnDelta("default", tableName)).contains(new Map.Entry[]{Assertions.entry((Object)"delta.feature.appendOnly", (Object)"supported")})).contains(new Map.Entry[]{Assertions.entry((Object)"delta.appendOnly", (Object)"false")});
            QueryExecutors.onDelta().executeQuery("DELETE FROM default." + tableName + " WHERE a = 1", new QueryExecutor.QueryParam[0]);
            QueryExecutors.onTrino().executeQuery("DELETE FROM delta.default." + tableName + " WHERE a = 2", new QueryExecutor.QueryParam[0]);
            ((QueryAssert)Assertions.assertThat((AssertProvider)QueryExecutors.onTrino().executeQuery("SELECT * FROM delta.default." + tableName, new QueryExecutor.QueryParam[0]))).hasNoRows();
        }
        finally {
            DeltaLakeTestUtils.dropDeltaTableWithRetry("default." + tableName);
        }
    }

    @Test(groups={"delta-lake-databricks", "profile_specific_tests"})
    @Flaky(issue="https://github.com/trinodb/trino/issues/14391", match="\\Q[Databricks][\\E(DatabricksJDBCDriver|JDBCDriver)\\Q](500593) Communication link failure. Failed to connect to server. Reason: \\E((HTTP retry after response received with no Retry-After header, error: HTTP Response code: 503|HTTP Response code: 504), Error message: Unknown.|java.net.SocketTimeoutException: Read timed out.)")
    public void testTruncateTable() {
        String tableName = "test_truncate_table_" + TestingNames.randomNameSuffix();
        QueryExecutors.onTrino().executeQuery("CREATE TABLE delta.default." + tableName + "(a INT)WITH (location = 's3://" + this.bucketName + "/databricks-compatibility-test-" + tableName + "')", new QueryExecutor.QueryParam[0]);
        try {
            QueryExecutors.onTrino().executeQuery("INSERT INTO delta.default." + tableName + " VALUES 1, 2, 3", new QueryExecutor.QueryParam[0]);
            QueryExecutors.onTrino().executeQuery("TRUNCATE TABLE delta.default." + tableName, new QueryExecutor.QueryParam[0]);
            ((QueryAssert)Assertions.assertThat((AssertProvider)QueryExecutors.onDelta().executeQuery("SELECT * FROM default." + tableName, new QueryExecutor.QueryParam[0]))).hasNoRows();
            QueryExecutors.onDelta().executeQuery("INSERT INTO default." + tableName + " VALUES 4, 5, 6", new QueryExecutor.QueryParam[0]);
            QueryExecutors.onDelta().executeQuery("TRUNCATE TABLE default." + tableName, new QueryExecutor.QueryParam[0]);
            ((QueryAssert)Assertions.assertThat((AssertProvider)QueryExecutors.onTrino().executeQuery("SELECT * FROM delta.default." + tableName, new QueryExecutor.QueryParam[0]))).hasNoRows();
        }
        finally {
            QueryExecutors.onTrino().executeQuery("DROP TABLE delta.default." + tableName, new QueryExecutor.QueryParam[0]);
        }
    }

    @Test(groups={"delta-lake-databricks", "delta-lake-oss", "delta-lake-exclude-91", "profile_specific_tests"}, dataProvider="columnMappingModeDataProvider")
    @Flaky(issue="https://github.com/trinodb/trino/issues/14391", match="\\Q[Databricks][\\E(DatabricksJDBCDriver|JDBCDriver)\\Q](500593) Communication link failure. Failed to connect to server. Reason: \\E((HTTP retry after response received with no Retry-After header, error: HTTP Response code: 503|HTTP Response code: 504), Error message: Unknown.|java.net.SocketTimeoutException: Read timed out.)")
    public void testDeletionVectors(String mode) {
        String tableName = "test_deletion_vectors_" + TestingNames.randomNameSuffix();
        QueryExecutors.onDelta().executeQuery("CREATE TABLE default." + tableName + "         (a INT, b INT)         USING delta          LOCATION 's3://" + this.bucketName + "/databricks-compatibility-test-" + tableName + "'          TBLPROPERTIES ('delta.enableDeletionVectors' = true, 'delta.columnMapping.mode' = '" + mode + "')", new QueryExecutor.QueryParam[0]);
        try {
            QueryExecutors.onDelta().executeQuery("INSERT INTO default." + tableName + " VALUES (1,11), (2, 22)", new QueryExecutor.QueryParam[0]);
            QueryExecutors.onDelta().executeQuery("DELETE FROM default." + tableName + " WHERE a = 2", new QueryExecutor.QueryParam[0]);
            ((QueryAssert)Assertions.assertThat((AssertProvider)QueryExecutors.onDelta().executeQuery("SELECT * FROM default." + tableName, new QueryExecutor.QueryParam[0]))).containsOnly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{1, 11})});
            ((QueryAssert)Assertions.assertThat((AssertProvider)QueryExecutors.onTrino().executeQuery("SELECT * FROM delta.default." + tableName, new QueryExecutor.QueryParam[0]))).containsOnly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{1, 11})});
            QueryExecutors.onDelta().executeQuery("INSERT INTO default." + tableName + " VALUES (2, 22)", new QueryExecutor.QueryParam[0]);
            ((QueryAssert)Assertions.assertThat((AssertProvider)QueryExecutors.onDelta().executeQuery("SELECT * FROM default." + tableName, new QueryExecutor.QueryParam[0]))).containsOnly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{1, 11}), QueryAssert.Row.row((Object[])new Object[]{2, 22})});
            ((QueryAssert)Assertions.assertThat((AssertProvider)QueryExecutors.onTrino().executeQuery("SELECT * FROM delta.default." + tableName, new QueryExecutor.QueryParam[0]))).containsOnly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{1, 11}), QueryAssert.Row.row((Object[])new Object[]{2, 22})});
            QueryExecutors.onDelta().executeQuery("DELETE FROM default." + tableName + " WHERE a = -1", new QueryExecutor.QueryParam[0]);
            ((QueryAssert)Assertions.assertThat((AssertProvider)QueryExecutors.onDelta().executeQuery("SELECT * FROM default." + tableName, new QueryExecutor.QueryParam[0]))).containsOnly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{1, 11}), QueryAssert.Row.row((Object[])new Object[]{2, 22})});
            ((QueryAssert)Assertions.assertThat((AssertProvider)QueryExecutors.onTrino().executeQuery("SELECT * FROM delta.default." + tableName, new QueryExecutor.QueryParam[0]))).containsOnly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{1, 11}), QueryAssert.Row.row((Object[])new Object[]{2, 22})});
            ((QueryAssert)Assertions.assertThat((AssertProvider)QueryExecutors.onTrino().executeQuery("SHOW TABLES FROM delta.default", new QueryExecutor.QueryParam[0]))).contains(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{tableName})});
            ((QueryAssert)Assertions.assertThat((AssertProvider)QueryExecutors.onTrino().executeQuery("SELECT version, operation FROM delta.default.\"" + tableName + "$history\"", new QueryExecutor.QueryParam[0]))).contains(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{0, "CREATE TABLE"}), QueryAssert.Row.row((Object[])new Object[]{1, "WRITE"}), QueryAssert.Row.row((Object[])new Object[]{2, "DELETE"})});
            ((QueryAssert)Assertions.assertThat((AssertProvider)QueryExecutors.onTrino().executeQuery("SELECT column_name FROM delta.information_schema.columns WHERE table_schema = 'default' AND table_name = '" + tableName + "'", new QueryExecutor.QueryParam[0]))).contains(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{"a"}), QueryAssert.Row.row((Object[])new Object[]{"b"})});
            ((QueryAssert)Assertions.assertThat((AssertProvider)QueryExecutors.onTrino().executeQuery("SHOW COLUMNS FROM delta.default." + tableName, new QueryExecutor.QueryParam[0]))).contains(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{"a", "integer", "", ""}), QueryAssert.Row.row((Object[])new Object[]{"b", "integer", "", ""})});
            ((QueryAssert)Assertions.assertThat((AssertProvider)QueryExecutors.onTrino().executeQuery("DESCRIBE delta.default." + tableName, new QueryExecutor.QueryParam[0]))).contains(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{"a", "integer", "", ""}), QueryAssert.Row.row((Object[])new Object[]{"b", "integer", "", ""})});
            QueryAssert.assertQueryFailure(() -> QueryExecutors.onTrino().executeQuery("INSERT INTO delta.default." + tableName + " VALUES (3, 33)", new QueryExecutor.QueryParam[0])).hasMessageContaining("Unsupported writer features: [deletionVectors]");
            QueryAssert.assertQueryFailure(() -> QueryExecutors.onTrino().executeQuery("DELETE FROM delta.default." + tableName, new QueryExecutor.QueryParam[0])).hasMessageContaining("Unsupported writer features: [deletionVectors]");
            QueryAssert.assertQueryFailure(() -> QueryExecutors.onTrino().executeQuery("UPDATE delta.default." + tableName + " SET a = 3", new QueryExecutor.QueryParam[0])).hasMessageContaining("Unsupported writer features: [deletionVectors]");
            QueryAssert.assertQueryFailure(() -> QueryExecutors.onTrino().executeQuery("MERGE INTO delta.default." + tableName + " t USING delta.default." + tableName + " s ON (t.a = s.a) WHEN MATCHED THEN UPDATE SET b = -1", new QueryExecutor.QueryParam[0])).hasMessageContaining("Unsupported writer features: [deletionVectors]");
        }
        finally {
            DeltaLakeTestUtils.dropDeltaTableWithRetry("default." + tableName);
        }
    }

    @Test(groups={"delta-lake-oss", "profile_specific_tests"})
    public void testDeletionVectorsWithRandomPrefix() {
        String tableName = "test_deletion_vectors_random_prefix_" + TestingNames.randomNameSuffix();
        QueryExecutors.onDelta().executeQuery("CREATE TABLE default." + tableName + "(a INT, b INT)USING delta LOCATION 's3://" + this.bucketName + "/databricks-compatibility-test-" + tableName + "' TBLPROPERTIES ('delta.enableDeletionVectors' = true, 'delta.randomizeFilePrefixes' = true)", new QueryExecutor.QueryParam[0]);
        try {
            QueryExecutors.onDelta().executeQuery("INSERT INTO default." + tableName + " VALUES (1, 11), (2, 22)", new QueryExecutor.QueryParam[0]);
            QueryExecutors.onDelta().executeQuery("DELETE FROM default." + tableName + " WHERE a = 2", new QueryExecutor.QueryParam[0]);
            ((QueryAssert)Assertions.assertThat((AssertProvider)QueryExecutors.onDelta().executeQuery("SELECT * FROM default." + tableName, new QueryExecutor.QueryParam[0]))).containsOnly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{1, 11})});
            ((QueryAssert)Assertions.assertThat((AssertProvider)QueryExecutors.onTrino().executeQuery("SELECT * FROM delta.default." + tableName, new QueryExecutor.QueryParam[0]))).containsOnly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{1, 11})});
        }
        finally {
            DeltaLakeTestUtils.dropDeltaTableWithRetry("default." + tableName);
        }
    }

    @Test(groups={"delta-lake-oss", "profile_specific_tests"})
    public void testDisableDeletionVectors() {
        String tableName = "test_deletion_vectors_random_prefix_" + TestingNames.randomNameSuffix();
        QueryExecutors.onDelta().executeQuery("CREATE TABLE default." + tableName + "(a INT, b INT)USING delta LOCATION 's3://" + this.bucketName + "/databricks-compatibility-test-" + tableName + "' TBLPROPERTIES ('delta.enableDeletionVectors' = true)", new QueryExecutor.QueryParam[0]);
        try {
            QueryExecutors.onDelta().executeQuery("INSERT INTO default." + tableName + " VALUES (1, 11), (2, 22), (3, 33)", new QueryExecutor.QueryParam[0]);
            QueryExecutors.onDelta().executeQuery("DELETE FROM default." + tableName + " WHERE a = 2", new QueryExecutor.QueryParam[0]);
            QueryExecutors.onDelta().executeQuery("ALTER TABLE default." + tableName + " SET TBLPROPERTIES ('delta.enableDeletionVectors' = false)", new QueryExecutor.QueryParam[0]);
            ((QueryAssert)Assertions.assertThat((AssertProvider)QueryExecutors.onDelta().executeQuery("SELECT * FROM default." + tableName, new QueryExecutor.QueryParam[0]))).containsOnly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{1, 11}), QueryAssert.Row.row((Object[])new Object[]{3, 33})});
            ((QueryAssert)Assertions.assertThat((AssertProvider)QueryExecutors.onTrino().executeQuery("SELECT * FROM delta.default." + tableName, new QueryExecutor.QueryParam[0]))).containsOnly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{1, 11}), QueryAssert.Row.row((Object[])new Object[]{3, 33})});
            QueryExecutors.onDelta().executeQuery("DELETE FROM default." + tableName, new QueryExecutor.QueryParam[0]);
            ((QueryAssert)Assertions.assertThat((AssertProvider)QueryExecutors.onDelta().executeQuery("SELECT * FROM default." + tableName, new QueryExecutor.QueryParam[0]))).hasNoRows();
            ((QueryAssert)Assertions.assertThat((AssertProvider)QueryExecutors.onTrino().executeQuery("SELECT * FROM delta.default." + tableName, new QueryExecutor.QueryParam[0]))).hasNoRows();
            QueryExecutors.onDelta().executeQuery("INSERT INTO default." + tableName + " VALUES (4, 44), (5, 55)", new QueryExecutor.QueryParam[0]);
            QueryExecutors.onDelta().executeQuery("DELETE FROM default." + tableName + " WHERE a = 4", new QueryExecutor.QueryParam[0]);
            ((QueryAssert)Assertions.assertThat((AssertProvider)QueryExecutors.onDelta().executeQuery("SELECT * FROM default." + tableName, new QueryExecutor.QueryParam[0]))).containsOnly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{5, 55})});
            ((QueryAssert)Assertions.assertThat((AssertProvider)QueryExecutors.onTrino().executeQuery("SELECT * FROM delta.default." + tableName, new QueryExecutor.QueryParam[0]))).containsOnly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{5, 55})});
        }
        finally {
            DeltaLakeTestUtils.dropDeltaTableWithRetry("default." + tableName);
        }
    }

    @Test(groups={"delta-lake-oss", "profile_specific_tests"})
    public void testDeletionVectorsWithCheckpointInterval() {
        String tableName = "test_deletion_vectors_random_prefix_" + TestingNames.randomNameSuffix();
        QueryExecutors.onDelta().executeQuery("CREATE TABLE default." + tableName + "(a INT, b INT)USING delta LOCATION 's3://" + this.bucketName + "/databricks-compatibility-test-" + tableName + "' TBLPROPERTIES ('delta.enableDeletionVectors' = true, 'delta.checkpointInterval' = 1)", new QueryExecutor.QueryParam[0]);
        try {
            QueryExecutors.onDelta().executeQuery("INSERT INTO default." + tableName + " VALUES (1, 11), (2, 22)", new QueryExecutor.QueryParam[0]);
            QueryExecutors.onDelta().executeQuery("DELETE FROM default." + tableName + " WHERE a = 2", new QueryExecutor.QueryParam[0]);
            ((QueryAssert)Assertions.assertThat((AssertProvider)QueryExecutors.onDelta().executeQuery("SELECT * FROM default." + tableName, new QueryExecutor.QueryParam[0]))).containsOnly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{1, 11})});
            ((QueryAssert)Assertions.assertThat((AssertProvider)QueryExecutors.onTrino().executeQuery("SELECT * FROM delta.default." + tableName, new QueryExecutor.QueryParam[0]))).containsOnly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{1, 11})});
        }
        finally {
            DeltaLakeTestUtils.dropDeltaTableWithRetry("default." + tableName);
        }
    }

    @Test(groups={"delta-lake-oss", "profile_specific_tests"})
    public void testDeletionVectorsMergeDelete() {
        String tableName = "test_deletion_vectors_merge_delete_" + TestingNames.randomNameSuffix();
        QueryExecutors.onDelta().executeQuery("CREATE TABLE default." + tableName + "(a INT)USING delta LOCATION 's3://" + this.bucketName + "/databricks-compatibility-test-" + tableName + "' TBLPROPERTIES ('delta.enableDeletionVectors' = true)", new QueryExecutor.QueryParam[0]);
        try {
            QueryExecutors.onDelta().executeQuery("INSERT INTO default." + tableName + " SELECT explode(sequence(1, 10))", new QueryExecutor.QueryParam[0]);
            QueryExecutors.onDelta().executeQuery("MERGE INTO default." + tableName + " t USING default." + tableName + " s ON (t.a = s.a) WHEN MATCHED AND t.a > 5 THEN DELETE", new QueryExecutor.QueryParam[0]);
            ImmutableList expected = ImmutableList.of((Object)QueryAssert.Row.row((Object[])new Object[]{1}), (Object)QueryAssert.Row.row((Object[])new Object[]{2}), (Object)QueryAssert.Row.row((Object[])new Object[]{3}), (Object)QueryAssert.Row.row((Object[])new Object[]{4}), (Object)QueryAssert.Row.row((Object[])new Object[]{5}));
            ((QueryAssert)Assertions.assertThat((AssertProvider)QueryExecutors.onDelta().executeQuery("SELECT * FROM default." + tableName, new QueryExecutor.QueryParam[0]))).contains((List)expected);
            ((QueryAssert)Assertions.assertThat((AssertProvider)QueryExecutors.onTrino().executeQuery("SELECT * FROM delta.default." + tableName, new QueryExecutor.QueryParam[0]))).contains((List)expected);
        }
        finally {
            DeltaLakeTestUtils.dropDeltaTableWithRetry("default." + tableName);
        }
    }

    @Test(groups={"delta-lake-oss", "profile_specific_tests"})
    public void testDeletionVectorsLargeNumbers() {
        String tableName = "test_deletion_vectors_large_numbers_" + TestingNames.randomNameSuffix();
        QueryExecutors.onDelta().executeQuery("CREATE TABLE default." + tableName + "(a INT)USING delta LOCATION 's3://" + this.bucketName + "/databricks-compatibility-test-" + tableName + "' TBLPROPERTIES ('delta.enableDeletionVectors' = true)", new QueryExecutor.QueryParam[0]);
        try {
            QueryExecutors.onDelta().executeQuery("INSERT INTO default." + tableName + " SELECT explode(sequence(1, 10000))", new QueryExecutor.QueryParam[0]);
            QueryExecutors.onDelta().executeQuery("DELETE FROM default." + tableName + " WHERE a > 1", new QueryExecutor.QueryParam[0]);
            ImmutableList expected = ImmutableList.of((Object)QueryAssert.Row.row((Object[])new Object[]{1}));
            ((QueryAssert)Assertions.assertThat((AssertProvider)QueryExecutors.onDelta().executeQuery("SELECT * FROM default." + tableName, new QueryExecutor.QueryParam[0]))).contains((List)expected);
            ((QueryAssert)Assertions.assertThat((AssertProvider)QueryExecutors.onTrino().executeQuery("SELECT * FROM delta.default." + tableName, new QueryExecutor.QueryParam[0]))).contains((List)expected);
        }
        finally {
            DeltaLakeTestUtils.dropDeltaTableWithRetry("default." + tableName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(groups={"delta-lake-oss", "profile_specific_tests"}, dataProviderClass=DataProviders.class, dataProvider="trueFalse")
    public void testDeletionVectorsAcrossAddFile(boolean partitioned) {
        String tableName = "test_deletion_vectors_accross_add_file_" + TestingNames.randomNameSuffix();
        QueryExecutors.onDelta().executeQuery("CREATE TABLE default." + tableName + "(a INT, b INT)USING delta " + (partitioned ? "PARTITIONED BY (a)" : "") + "LOCATION 's3://" + this.bucketName + "/databricks-compatibility-test-" + tableName + "' TBLPROPERTIES ('delta.enableDeletionVectors' = true)", new QueryExecutor.QueryParam[0]);
        try {
            QueryExecutors.onDelta().executeQuery("INSERT INTO default." + tableName + " VALUES (1,11), (2,22)", new QueryExecutor.QueryParam[0]);
            QueryExecutors.onDelta().executeQuery("INSERT INTO default." + tableName + " VALUES (3,33), (4,44)", new QueryExecutor.QueryParam[0]);
            QueryExecutors.onDelta().executeQuery("DELETE FROM default." + tableName + " WHERE a = 2 OR a = 4", new QueryExecutor.QueryParam[0]);
            ImmutableList expected = ImmutableList.of((Object)QueryAssert.Row.row((Object[])new Object[]{1, 11}), (Object)QueryAssert.Row.row((Object[])new Object[]{3, 33}));
            ((QueryAssert)Assertions.assertThat((AssertProvider)QueryExecutors.onDelta().executeQuery("SELECT * FROM default." + tableName, new QueryExecutor.QueryParam[0]))).containsOnly((List)expected);
            ((QueryAssert)Assertions.assertThat((AssertProvider)QueryExecutors.onTrino().executeQuery("SELECT * FROM delta.default." + tableName, new QueryExecutor.QueryParam[0]))).containsOnly((List)expected);
            ((QueryAssert)Assertions.assertThat((AssertProvider)QueryExecutors.onTrino().executeQuery("SELECT count(*) FROM delta.default." + tableName, new QueryExecutor.QueryParam[0]))).containsOnly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{2})});
        }
        finally {
            DeltaLakeTestUtils.dropDeltaTableWithRetry("default." + tableName);
        }
    }

    @Test(groups={"delta-lake-databricks", "delta-lake-oss", "delta-lake-exclude-91", "profile_specific_tests"})
    @Flaky(issue="https://github.com/trinodb/trino/issues/14391", match="\\Q[Databricks][\\E(DatabricksJDBCDriver|JDBCDriver)\\Q](500593) Communication link failure. Failed to connect to server. Reason: \\E((HTTP retry after response received with no Retry-After header, error: HTTP Response code: 503|HTTP Response code: 504), Error message: Unknown.|java.net.SocketTimeoutException: Read timed out.)")
    public void testDeletionVectorsTruncateTable() {
        this.testDeletionVectorsDeleteAll(tableName -> {
            if (!this.databricksRuntimeVersion.isPresent()) {
                Assertions.assertThatThrownBy(() -> QueryExecutors.onDelta().executeQuery("TRUNCATE TABLE default." + tableName, new QueryExecutor.QueryParam[0])).hasMessageContaining("Table does not support truncates");
                throw new SkipException("OSS Delta Lake doesn't support truncating tables with deletion vector");
            }
            QueryExecutors.onDelta().executeQuery("TRUNCATE TABLE default." + tableName, new QueryExecutor.QueryParam[0]);
        });
    }

    @Test(groups={"delta-lake-oss", "profile_specific_tests"})
    public void testDeletionVectorsDeleteFrom() {
        this.testDeletionVectorsDeleteAll(tableName -> QueryExecutors.onDelta().executeQuery("DELETE FROM default." + tableName, new QueryExecutor.QueryParam[0]));
    }

    private void testDeletionVectorsDeleteAll(Consumer<String> deleteRow) {
        String tableName = "test_deletion_vectors_delete_all_" + TestingNames.randomNameSuffix();
        QueryExecutors.onDelta().executeQuery("CREATE TABLE default." + tableName + "(a INT)USING delta LOCATION 's3://" + this.bucketName + "/databricks-compatibility-test-" + tableName + "' TBLPROPERTIES ('delta.enableDeletionVectors' = true)", new QueryExecutor.QueryParam[0]);
        try {
            QueryExecutors.onDelta().executeQuery("INSERT INTO default." + tableName + " SELECT explode(sequence(1, 1000))", new QueryExecutor.QueryParam[0]);
            ((QueryAssert)Assertions.assertThat((AssertProvider)QueryExecutors.onTrino().executeQuery("SELECT * FROM delta.default." + tableName, new QueryExecutor.QueryParam[0]))).hasRowsCount(1000);
            deleteRow.accept(tableName);
            ((QueryAssert)Assertions.assertThat((AssertProvider)QueryExecutors.onDelta().executeQuery("SELECT * FROM default." + tableName, new QueryExecutor.QueryParam[0]))).hasNoRows();
            ((QueryAssert)Assertions.assertThat((AssertProvider)QueryExecutors.onTrino().executeQuery("SELECT * FROM delta.default." + tableName, new QueryExecutor.QueryParam[0]))).hasNoRows();
        }
        finally {
            DeltaLakeTestUtils.dropDeltaTableWithRetry("default." + tableName);
        }
    }

    @Test(groups={"delta-lake-oss", "profile_specific_tests"})
    public void testDeletionVectorsOptimize() {
        String tableName = "test_deletion_vectors_optimize_" + TestingNames.randomNameSuffix();
        QueryExecutors.onDelta().executeQuery("CREATE TABLE default." + tableName + "(a INT, b INT)USING delta LOCATION 's3://" + this.bucketName + "/databricks-compatibility-test-" + tableName + "' TBLPROPERTIES ('delta.enableDeletionVectors' = true)", new QueryExecutor.QueryParam[0]);
        try {
            QueryExecutors.onDelta().executeQuery("INSERT INTO default." + tableName + " VALUES (1,11), (2,22)", new QueryExecutor.QueryParam[0]);
            QueryExecutors.onDelta().executeQuery("INSERT INTO default." + tableName + " VALUES (3,33), (4,44)", new QueryExecutor.QueryParam[0]);
            QueryExecutors.onDelta().executeQuery("DELETE FROM default." + tableName + " WHERE a = 1 OR a = 3", new QueryExecutor.QueryParam[0]);
            ImmutableList expected = ImmutableList.of((Object)QueryAssert.Row.row((Object[])new Object[]{2, 22}), (Object)QueryAssert.Row.row((Object[])new Object[]{4, 44}));
            ((QueryAssert)Assertions.assertThat((AssertProvider)QueryExecutors.onTrino().executeQuery("SELECT * FROM delta.default." + tableName, new QueryExecutor.QueryParam[0]))).contains((List)expected);
            QueryExecutors.onDelta().executeQuery("OPTIMIZE default." + tableName, new QueryExecutor.QueryParam[0]);
            ((QueryAssert)Assertions.assertThat((AssertProvider)QueryExecutors.onDelta().executeQuery("SELECT * FROM default." + tableName, new QueryExecutor.QueryParam[0]))).contains((List)expected);
            ((QueryAssert)Assertions.assertThat((AssertProvider)QueryExecutors.onTrino().executeQuery("SELECT * FROM delta.default." + tableName, new QueryExecutor.QueryParam[0]))).contains((List)expected);
        }
        finally {
            DeltaLakeTestUtils.dropDeltaTableWithRetry("default." + tableName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(groups={"delta-lake-oss", "profile_specific_tests"})
    public void testDeletionVectorsAbsolutePath() {
        String baseTableName = "test_deletion_vectors_base_absolute_" + TestingNames.randomNameSuffix();
        String tableName = "test_deletion_vectors_absolute_" + TestingNames.randomNameSuffix();
        QueryExecutors.onDelta().executeQuery("CREATE TABLE default." + baseTableName + "(a INT, b INT)USING delta LOCATION 's3://" + this.bucketName + "/databricks-compatibility-test-" + baseTableName + "' TBLPROPERTIES ('delta.enableDeletionVectors' = true)", new QueryExecutor.QueryParam[0]);
        try {
            QueryExecutors.onDelta().executeQuery("INSERT INTO default." + baseTableName + " VALUES (1,11), (2,22), (3,33), (4,44)", new QueryExecutor.QueryParam[0]);
            QueryExecutors.onDelta().executeQuery("DELETE FROM default." + baseTableName + " WHERE a = 1 OR a = 3", new QueryExecutor.QueryParam[0]);
            QueryExecutors.onDelta().executeQuery("CREATE TABLE default." + tableName + " SHALLOW CLONE " + baseTableName, new QueryExecutor.QueryParam[0]);
            ImmutableList expected = ImmutableList.of((Object)QueryAssert.Row.row((Object[])new Object[]{2, 22}), (Object)QueryAssert.Row.row((Object[])new Object[]{4, 44}));
            ((QueryAssert)Assertions.assertThat((AssertProvider)QueryExecutors.onDelta().executeQuery("SELECT * FROM default." + tableName, new QueryExecutor.QueryParam[0]))).contains((List)expected);
            ((QueryAssert)Assertions.assertThat((AssertProvider)QueryExecutors.onTrino().executeQuery("SELECT * FROM delta.default." + tableName, new QueryExecutor.QueryParam[0]))).contains((List)expected);
        }
        finally {
            DeltaLakeTestUtils.dropDeltaTableWithRetry("default." + baseTableName);
            DeltaLakeTestUtils.dropDeltaTableWithRetry("default." + tableName);
        }
    }

    @Test(groups={"delta-lake-oss", "profile_specific_tests"})
    public void testDeletionVectorsWithChangeDataFeed() {
        String tableName = "test_deletion_vectors_cdf_" + TestingNames.randomNameSuffix();
        QueryExecutors.onDelta().executeQuery("CREATE TABLE default." + tableName + "(a INT, b INT)USING delta LOCATION 's3://" + this.bucketName + "/databricks-compatibility-test-" + tableName + "' TBLPROPERTIES ('delta.enableDeletionVectors' = true, 'delta.enableChangeDataFeed' = true)", new QueryExecutor.QueryParam[0]);
        try {
            QueryExecutors.onDelta().executeQuery("INSERT INTO default." + tableName + " VALUES (1,11), (2,22), (3,33), (4,44)", new QueryExecutor.QueryParam[0]);
            QueryExecutors.onDelta().executeQuery("DELETE FROM default." + tableName + " WHERE a = 1 OR a = 3", new QueryExecutor.QueryParam[0]);
            ((QueryAssert)Assertions.assertThat((AssertProvider)QueryExecutors.onDelta().executeQuery("SELECT a, b, _change_type, _commit_version FROM table_changes('default." + tableName + "', 0)", new QueryExecutor.QueryParam[0]))).containsOnly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{1, 11, "insert", 1L}), QueryAssert.Row.row((Object[])new Object[]{2, 22, "insert", 1L}), QueryAssert.Row.row((Object[])new Object[]{3, 33, "insert", 1L}), QueryAssert.Row.row((Object[])new Object[]{4, 44, "insert", 1L}), QueryAssert.Row.row((Object[])new Object[]{1, 11, "delete", 2L}), QueryAssert.Row.row((Object[])new Object[]{3, 33, "delete", 2L})});
            QueryAssert.assertQueryFailure(() -> QueryExecutors.onTrino().executeQuery("SELECT a, b, _change_type, _commit_version FROM TABLE(delta.system.table_changes('default', '" + tableName + "', 0))", new QueryExecutor.QueryParam[0])).hasMessageContaining("Change Data Feed is not enabled at version 2. Version contains 'remove' entries without 'cdc' entries");
        }
        finally {
            DeltaLakeTestUtils.dropDeltaTableWithRetry("default." + tableName);
        }
    }

    @DataProvider
    public Object[][] columnMappingModeDataProvider() {
        return new Object[][]{{"none"}, {"name"}, {"id"}};
    }
}

