/*
 * Decompiled with CFR 0.152.
 */
package io.trino.tests.product.deltalake;

import com.amazonaws.services.s3.AmazonS3;
import com.amazonaws.services.s3.model.ObjectListing;
import com.google.inject.Inject;
import com.google.inject.name.Named;
import io.trino.tempto.BeforeMethodWithContext;
import io.trino.tempto.query.QueryExecutor;
import io.trino.testing.TestingNames;
import io.trino.testng.services.Flaky;
import io.trino.tests.product.deltalake.BaseTestDeltaLakeS3Storage;
import io.trino.tests.product.deltalake.S3ClientFactory;
import io.trino.tests.product.deltalake.util.DeltaLakeTestUtils;
import io.trino.tests.product.hive.Engine;
import io.trino.tests.product.utils.QueryExecutors;
import java.util.List;
import java.util.Optional;
import org.assertj.core.api.Assertions;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;

public class TestDeltaLakeDropTableCompatibility
extends BaseTestDeltaLakeS3Storage {
    @Inject
    @Named(value="s3.server_type")
    private String s3ServerType;
    private AmazonS3 s3;

    @BeforeMethodWithContext
    public void setup() {
        this.s3 = new S3ClientFactory().createS3Client(this.s3ServerType);
    }

    @DataProvider
    public static Object[][] engineConfigurations() {
        return new Object[][]{{Engine.TRINO, Engine.TRINO, true}, {Engine.TRINO, Engine.TRINO, false}, {Engine.TRINO, Engine.DELTA, true}, {Engine.TRINO, Engine.DELTA, false}, {Engine.DELTA, Engine.TRINO, true}, {Engine.DELTA, Engine.TRINO, false}, {Engine.DELTA, Engine.DELTA, true}, {Engine.DELTA, Engine.DELTA, false}};
    }

    @Test(groups={"delta-lake-databricks", "delta-lake-oss", "profile_specific_tests"}, dataProvider="engineConfigurations")
    @Flaky(issue="https://github.com/trinodb/trino/issues/14391", match="\\Q[Databricks][\\E(DatabricksJDBCDriver|JDBCDriver)\\Q](500593) Communication link failure. Failed to connect to server. Reason: \\E((HTTP retry after response received with no Retry-After header, error: HTTP Response code: 503|HTTP Response code: 504), Error message: Unknown.|java.net.SocketTimeoutException: Read timed out.)")
    public void testDropTable(Engine creator, Engine dropper, boolean explicitLocation) {
        this.testDropTableAccuracy(creator, dropper, explicitLocation);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testDropTableAccuracy(Engine creator, Engine dropper, boolean explicitLocation) {
        String schemaName = "test_schema_with_location_" + TestingNames.randomNameSuffix();
        String schemaLocation = String.format("s3://%s/databricks-compatibility-test-%s", this.bucketName, schemaName);
        String tableName = explicitLocation ? "test_external_table" : "test_managed_table";
        Optional<String> tableLocation = explicitLocation ? Optional.of(String.format("s3://" + this.bucketName + "/databricks-compatibility-test-%s/%s", schemaName, tableName)) : Optional.empty();
        switch (creator) {
            case TRINO: {
                QueryExecutors.onTrino().executeQuery(String.format("CREATE SCHEMA delta.%s WITH (location = '%s')", schemaName, schemaLocation), new QueryExecutor.QueryParam[0]);
                break;
            }
            case DELTA: {
                QueryExecutors.onDelta().executeQuery(String.format("CREATE SCHEMA %s LOCATION \"%s\"", schemaName, schemaLocation), new QueryExecutor.QueryParam[0]);
                break;
            }
            default: {
                throw new UnsupportedOperationException("Unsupported engine: " + String.valueOf((Object)creator));
            }
        }
        try {
            QueryExecutors.onTrino().executeQuery("USE delta." + schemaName, new QueryExecutor.QueryParam[0]);
            switch (creator) {
                case TRINO: {
                    QueryExecutors.onTrino().executeQuery(String.format("CREATE TABLE %s.%s (a, b) %s AS VALUES (1, 2), (2, 3), (3, 4)", schemaName, tableName, tableLocation.map(location -> "WITH (location = '" + location + "')").orElse("")), new QueryExecutor.QueryParam[0]);
                    break;
                }
                case DELTA: {
                    QueryExecutors.onDelta().executeQuery(String.format("CREATE TABLE %s.%s USING DELTA %s AS VALUES (1, 2), (2, 3), (3, 4)", schemaName, tableName, tableLocation.map(location -> "LOCATION \"" + location + "\"").orElse("")), new QueryExecutor.QueryParam[0]);
                    break;
                }
                default: {
                    throw new UnsupportedOperationException("Unsupported engine: " + String.valueOf((Object)creator));
                }
            }
            ObjectListing tableFiles = this.s3.listObjects(this.bucketName, "databricks-compatibility-test-" + schemaName + "/" + tableName);
            Assertions.assertThat((List)tableFiles.getObjectSummaries()).isNotEmpty();
            switch (dropper) {
                case DELTA: {
                    DeltaLakeTestUtils.dropDeltaTableWithRetry(schemaName + "." + tableName);
                    break;
                }
                case TRINO: {
                    QueryExecutors.onTrino().executeQuery("DROP TABLE " + schemaName + "." + tableName, new QueryExecutor.QueryParam[0]);
                    break;
                }
                default: {
                    throw new UnsupportedOperationException("Unsupported engine: " + String.valueOf((Object)dropper));
                }
            }
            tableFiles = this.s3.listObjects(this.bucketName, "databricks-compatibility-test-" + schemaName + "/" + tableName);
            if (explicitLocation) {
                Assertions.assertThat((List)tableFiles.getObjectSummaries()).isNotEmpty();
            } else {
                Assertions.assertThat((List)tableFiles.getObjectSummaries()).isEmpty();
            }
        }
        finally {
            DeltaLakeTestUtils.dropDeltaTableWithRetry(schemaName + "." + tableName);
            QueryExecutors.onDelta().executeQuery("DROP SCHEMA " + schemaName, new QueryExecutor.QueryParam[0]);
        }
    }
}

