/*
 * Decompiled with CFR 0.152.
 */
package io.trino.tests.product.deltalake;

import com.google.common.collect.ImmutableList;
import io.trino.tempto.assertions.QueryAssert;
import io.trino.tempto.query.QueryExecutor;
import io.trino.tempto.query.QueryResult;
import io.trino.testing.TestingNames;
import io.trino.testng.services.Flaky;
import io.trino.tests.product.deltalake.BaseTestDeltaLakeS3Storage;
import io.trino.tests.product.deltalake.util.DeltaLakeTestUtils;
import io.trino.tests.product.utils.QueryExecutors;
import java.util.List;
import org.assertj.core.api.AssertProvider;
import org.assertj.core.api.Assertions;
import org.testng.annotations.Test;

public class TestDeltaLakeSystemTableCompatibility
extends BaseTestDeltaLakeS3Storage {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(groups={"delta-lake-databricks", "delta-lake-exclude-91", "delta-lake-oss", "profile_specific_tests"})
    @Flaky(issue="https://github.com/trinodb/trino/issues/14391", match="\\Q[Databricks][\\E(DatabricksJDBCDriver|JDBCDriver)\\Q](500593) Communication link failure. Failed to connect to server. Reason: \\E((HTTP retry after response received with no Retry-After header, error: HTTP Response code: 503|HTTP Response code: 504), Error message: Unknown.|java.net.SocketTimeoutException: Read timed out.)")
    public void testTablePropertiesCaseSensitivity() {
        String tableName = "test_dl_table_properties_case_sensitivity_" + TestingNames.randomNameSuffix();
        String tableDirectory = "databricks-compatibility-test-" + tableName;
        QueryExecutors.onDelta().executeQuery(String.format("CREATE TABLE default.%s (col INT) USING DELTA LOCATION 's3://%s/%s' TBLPROPERTIES ('test_key'='test_value', 'Test_Key'='Test_Mixed_Case')", tableName, this.bucketName, tableDirectory), new QueryExecutor.QueryParam[0]);
        ImmutableList expectedRows = ImmutableList.of((Object)QueryAssert.Row.row((Object[])new Object[]{"test_key", "test_value"}), (Object)QueryAssert.Row.row((Object[])new Object[]{"Test_Key", "Test_Mixed_Case"}));
        try {
            QueryResult deltaResult = QueryExecutors.onDelta().executeQuery("SHOW TBLPROPERTIES default." + tableName, new QueryExecutor.QueryParam[0]);
            QueryResult trinoResult = QueryExecutors.onTrino().executeQuery("SELECT * FROM default.\"" + tableName + "$properties\"", new QueryExecutor.QueryParam[0]);
            ((QueryAssert)Assertions.assertThat((AssertProvider)deltaResult)).contains((List)expectedRows);
            ((QueryAssert)Assertions.assertThat((AssertProvider)trinoResult)).contains((List)expectedRows);
            Assertions.assertThat((List)trinoResult.rows()).containsExactlyInAnyOrderElementsOf((Iterable)deltaResult.rows());
        }
        finally {
            DeltaLakeTestUtils.dropDeltaTableWithRetry("default." + tableName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(groups={"delta-lake-oss", "profile_specific_tests"})
    public void testTablePropertiesWithTableFeatures() {
        String tableName = "test_dl_table_properties_with_features_" + TestingNames.randomNameSuffix();
        String tableDirectory = "databricks-compatibility-test-" + tableName;
        QueryExecutors.onDelta().executeQuery(String.format("CREATE TABLE default.%s (col INT) USING DELTA LOCATION 's3://%s/%s' TBLPROPERTIES ('delta.minReaderVersion'='3', 'delta.minWriterVersion'='7', 'delta.columnMapping.mode'='id')", tableName, this.bucketName, tableDirectory), new QueryExecutor.QueryParam[0]);
        ImmutableList expectedRows = ImmutableList.of((Object)QueryAssert.Row.row((Object[])new Object[]{"delta.columnMapping.mode", "id"}), (Object)QueryAssert.Row.row((Object[])new Object[]{"delta.feature.columnMapping", "supported"}), (Object)QueryAssert.Row.row((Object[])new Object[]{"delta.minReaderVersion", "3"}), (Object)QueryAssert.Row.row((Object[])new Object[]{"delta.minWriterVersion", "7"}));
        try {
            QueryResult deltaResult = QueryExecutors.onDelta().executeQuery("SHOW TBLPROPERTIES default." + tableName, new QueryExecutor.QueryParam[0]);
            QueryResult trinoResult = QueryExecutors.onTrino().executeQuery("SELECT * FROM default.\"" + tableName + "$properties\"", new QueryExecutor.QueryParam[0]);
            ((QueryAssert)Assertions.assertThat((AssertProvider)deltaResult)).contains((List)expectedRows);
            ((QueryAssert)Assertions.assertThat((AssertProvider)trinoResult)).contains((List)expectedRows);
            Assertions.assertThat((List)trinoResult.rows()).containsExactlyInAnyOrderElementsOf((Iterable)deltaResult.rows());
        }
        finally {
            DeltaLakeTestUtils.dropDeltaTableWithRetry("default." + tableName);
        }
    }
}

