/*
 * Decompiled with CFR 0.152.
 */
package io.trino.tests.product.functions.operators;

import io.trino.tempto.ProductTest;
import io.trino.tempto.assertions.QueryAssert;
import io.trino.tempto.query.QueryExecutor;
import io.trino.tests.product.utils.QueryExecutors;
import org.assertj.core.api.AssertProvider;
import org.assertj.core.api.Assertions;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;

public class TestComparison
extends ProductTest {
    @DataProvider(name="operands")
    public static Object[][] operandsProvider() {
        return new Object[][]{{"false", "true", "boolean"}, {"0", "1", "double"}, {"0", "1", "bigint"}, {"date '1991-01-01'", "date '1991-01-02'", "date"}, {"time '01:02:03.456'", "time '01:02:03.457'", "time"}, {"time '01:02:03.456-08:00'", "time '01:02:03.457-08:00'", "TIME WITH TIME ZONE"}, {"TIMESTAMP '2001-08-22 03:04:05.321'", "TIMESTAMP '2001-08-22 03:04:05.322'", "TIMESTAMP"}, {"TIMESTAMP '2001-08-22 03:04:05.321 America/Los_Angeles'", "TIMESTAMP '2001-08-22 03:04:05.322 America/Los_Angeles'", "TIMESTAMP WITH TIME ZONE"}};
    }

    @Test(dataProvider="operands")
    public void testLessThanOperatorExists(String leftOperand, String rightOperand, String typeName) {
        ((QueryAssert)Assertions.assertThat((AssertProvider)QueryExecutors.onTrino().executeQuery(String.format("select cast(%s as %s) < cast(%s as %s)", leftOperand, typeName, rightOperand, typeName), new QueryExecutor.QueryParam[0]))).containsExactlyInOrder(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{true})});
    }

    @Test(dataProvider="operands")
    public void testGreaterThanOperatorExists(String leftOperand, String rightOperand, String typeName) {
        ((QueryAssert)Assertions.assertThat((AssertProvider)QueryExecutors.onTrino().executeQuery(String.format("select cast(%s as %s) > cast(%s as %s)", leftOperand, typeName, rightOperand, typeName), new QueryExecutor.QueryParam[0]))).containsExactlyInOrder(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{false})});
    }

    @Test(dataProvider="operands")
    public void testLessThanOrEqualOperatorExists(String leftOperand, String rightOperand, String typeName) {
        ((QueryAssert)Assertions.assertThat((AssertProvider)QueryExecutors.onTrino().executeQuery(String.format("select cast(%s as %s) <= cast(%s as %s)", leftOperand, typeName, rightOperand, typeName), new QueryExecutor.QueryParam[0]))).containsExactlyInOrder(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{true})});
    }

    @Test(dataProvider="operands")
    public void testGreaterThanOrEqualOperatorExists(String leftOperand, String rightOperand, String typeName) {
        ((QueryAssert)Assertions.assertThat((AssertProvider)QueryExecutors.onTrino().executeQuery(String.format("select cast(%s as %s) >= cast(%s as %s)", leftOperand, typeName, rightOperand, typeName), new QueryExecutor.QueryParam[0]))).containsExactlyInOrder(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{false})});
    }

    @Test(dataProvider="operands")
    public void testEqualOperatorExists(String leftOperand, String rightOperand, String typeName) {
        ((QueryAssert)Assertions.assertThat((AssertProvider)QueryExecutors.onTrino().executeQuery(String.format("select cast(%s as %s) = cast(%s as %s)", leftOperand, typeName, rightOperand, typeName), new QueryExecutor.QueryParam[0]))).containsExactlyInOrder(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{false})});
    }

    @Test(dataProvider="operands")
    public void testBetweenOperatorExists(String leftOperand, String rightOperand, String typeName) {
        ((QueryAssert)Assertions.assertThat((AssertProvider)QueryExecutors.onTrino().executeQuery(String.format("select cast(%s as %s) BETWEEN cast(%s as %s) AND cast(%s as %s)", leftOperand, typeName, leftOperand, typeName, rightOperand, typeName), new QueryExecutor.QueryParam[0]))).containsExactlyInOrder(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{true})});
    }
}

