/*
 * Decompiled with CFR 0.152.
 */
package io.trino.tests.product.hive;

import io.trino.tempto.assertions.QueryAssert;
import io.trino.tempto.query.QueryExecutor;
import io.trino.tests.product.hive.HiveProductTest;
import io.trino.tests.product.utils.QueryExecutors;
import org.assertj.core.api.AssertProvider;
import org.assertj.core.api.Assertions;
import org.intellij.lang.annotations.Language;
import org.testng.annotations.Test;

public class TestAvroSchemaLiteral
extends HiveProductTest {
    @Language(value="JSON")
    private static final String SCHEMA_LITERAL = "{\n  \"namespace\": \"io.trino.test\",\n  \"name\": \"product_tests_avro_table\",\n  \"type\": \"record\",\n  \"fields\": [\n    { \"name\":\"string_col\", \"type\":\"string\"},\n    { \"name\":\"int_col\", \"type\":\"int\" }\n  ]\n}\n";

    @Test
    public void testHiveCreatedTable() {
        QueryExecutors.onHive().executeQuery("DROP TABLE IF EXISTS test_avro_schema_literal_hive", new QueryExecutor.QueryParam[0]);
        QueryExecutors.onHive().executeQuery(String.format("CREATE TABLE test_avro_schema_literal_hive ROW FORMAT SERDE 'org.apache.hadoop.hive.serde2.avro.AvroSerDe' STORED AS INPUTFORMAT 'org.apache.hadoop.hive.ql.io.avro.AvroContainerInputFormat' OUTPUTFORMAT 'org.apache.hadoop.hive.ql.io.avro.AvroContainerOutputFormat' TBLPROPERTIES ('avro.schema.literal'='%s')", SCHEMA_LITERAL), new QueryExecutor.QueryParam[0]);
        QueryExecutors.onHive().executeQuery("INSERT INTO test_avro_schema_literal_hive VALUES ('some text', 123042)", new QueryExecutor.QueryParam[0]);
        ((QueryAssert)Assertions.assertThat((AssertProvider)QueryExecutors.onHive().executeQuery("SELECT * FROM test_avro_schema_literal_hive", new QueryExecutor.QueryParam[0]))).containsExactlyInOrder(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{"some text", 123042})});
        ((QueryAssert)Assertions.assertThat((AssertProvider)QueryExecutors.onTrino().executeQuery("SELECT * FROM test_avro_schema_literal_hive", new QueryExecutor.QueryParam[0]))).containsExactlyInOrder(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{"some text", 123042})});
        QueryExecutors.onHive().executeQuery("DROP TABLE test_avro_schema_literal_hive", new QueryExecutor.QueryParam[0]);
    }

    @Test
    public void testTrinoCreatedTable() {
        QueryExecutors.onTrino().executeQuery("DROP TABLE IF EXISTS test_avro_schema_literal_trino", new QueryExecutor.QueryParam[0]);
        QueryExecutors.onTrino().executeQuery(String.format("CREATE TABLE test_avro_schema_literal_trino (dummy_col VARCHAR) WITH (format='AVRO', avro_schema_literal='%s')", SCHEMA_LITERAL), new QueryExecutor.QueryParam[0]);
        QueryExecutors.onTrino().executeQuery("INSERT INTO test_avro_schema_literal_trino VALUES ('some text', 123042)", new QueryExecutor.QueryParam[0]);
        ((QueryAssert)Assertions.assertThat((AssertProvider)QueryExecutors.onHive().executeQuery("SELECT * FROM test_avro_schema_literal_trino", new QueryExecutor.QueryParam[0]))).containsExactlyInOrder(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{"some text", 123042})});
        ((QueryAssert)Assertions.assertThat((AssertProvider)QueryExecutors.onTrino().executeQuery("SELECT * FROM test_avro_schema_literal_trino", new QueryExecutor.QueryParam[0]))).containsExactlyInOrder(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{"some text", 123042})});
        QueryExecutors.onTrino().executeQuery("DROP TABLE test_avro_schema_literal_trino", new QueryExecutor.QueryParam[0]);
    }
}

