/*
 * Decompiled with CFR 0.152.
 */
package io.trino.tests.product.hive;

import io.airlift.units.Duration;
import io.trino.tempto.ProductTest;
import io.trino.tempto.assertions.QueryAssert;
import io.trino.tempto.query.QueryExecutor;
import io.trino.tests.product.utils.CachingTestUtils;
import io.trino.tests.product.utils.QueryAssertions;
import io.trino.tests.product.utils.QueryExecutors;
import java.util.concurrent.TimeUnit;
import org.assertj.core.api.AssertProvider;
import org.assertj.core.api.Assertions;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestHiveAlluxioCaching
extends ProductTest {
    @Test(groups={"hive_alluxio_caching", "profile_specific_tests"})
    public void testReadFromCache() {
        this.testReadFromTable("table1");
        this.testReadFromTable("table2");
    }

    private void testReadFromTable(String tableNameSuffix) {
        String cachedTableName = "hive.default.test_cache_read" + tableNameSuffix;
        String nonCachedTableName = "hivenoncached.default.test_cache_read" + tableNameSuffix;
        this.createTestTable(nonCachedTableName);
        CachingTestUtils.CacheStats beforeCacheStats = CachingTestUtils.getCacheStats("hive");
        long tableSize = (Long)QueryExecutors.onTrino().executeQuery("SELECT SUM(size) as size FROM (SELECT \"$path\", \"$file_size\" AS size FROM " + nonCachedTableName + " GROUP BY 1, 2)", new QueryExecutor.QueryParam[0]).getOnlyValue();
        ((QueryAssert)Assertions.assertThat((AssertProvider)QueryExecutors.onTrino().executeQuery("SELECT * FROM " + cachedTableName, new QueryExecutor.QueryParam[0]))).hasRowsCount(150000);
        QueryAssertions.assertEventually(new Duration(20.0, TimeUnit.SECONDS), () -> {
            CachingTestUtils.CacheStats afterQueryCacheStats = CachingTestUtils.getCacheStats("hive");
            io.airlift.testing.Assertions.assertGreaterThanOrEqual((Comparable)Long.valueOf(afterQueryCacheStats.cacheSpaceUsed()), (Comparable)Long.valueOf(beforeCacheStats.cacheSpaceUsed() + tableSize));
            io.airlift.testing.Assertions.assertGreaterThan((Comparable)Double.valueOf(afterQueryCacheStats.externalReads()), (Comparable)Double.valueOf(beforeCacheStats.externalReads()));
            io.airlift.testing.Assertions.assertGreaterThanOrEqual((Comparable)Double.valueOf(afterQueryCacheStats.cacheReads()), (Comparable)Double.valueOf(beforeCacheStats.cacheReads()));
        });
        QueryAssertions.assertEventually(new Duration(10.0, TimeUnit.SECONDS), () -> {
            CachingTestUtils.CacheStats beforeQueryCacheStats = CachingTestUtils.getCacheStats("hive");
            ((QueryAssert)Assertions.assertThat((AssertProvider)QueryExecutors.onTrino().executeQuery("SELECT * FROM " + cachedTableName, new QueryExecutor.QueryParam[0]))).hasAnyRows();
            CachingTestUtils.CacheStats afterQueryCacheStats = CachingTestUtils.getCacheStats("hive");
            io.airlift.testing.Assertions.assertGreaterThan((Comparable)Double.valueOf(afterQueryCacheStats.cacheReads()), (Comparable)Double.valueOf(beforeQueryCacheStats.cacheReads()));
            Assert.assertEquals((Object)afterQueryCacheStats.externalReads(), (Object)beforeQueryCacheStats.externalReads());
            Assert.assertEquals((long)afterQueryCacheStats.cacheSpaceUsed(), (long)beforeQueryCacheStats.cacheSpaceUsed());
        });
        QueryExecutors.onTrino().executeQuery("DROP TABLE " + nonCachedTableName, new QueryExecutor.QueryParam[0]);
    }

    private void createTestTable(String tableName) {
        QueryExecutors.onTrino().executeQuery("DROP TABLE IF EXISTS " + tableName, new QueryExecutor.QueryParam[0]);
        QueryExecutors.onTrino().executeQuery("SET SESSION hive.target_max_file_size = '4MB'", new QueryExecutor.QueryParam[0]);
        QueryExecutors.onTrino().executeQuery("CREATE TABLE " + tableName + " AS SELECT * FROM tpch.sf1.customer", new QueryExecutor.QueryParam[0]);
    }
}

