/*
 * Decompiled with CFR 0.152.
 */
package io.trino.tests.product.hive;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import io.airlift.log.Logger;
import io.trino.tempto.Requirement;
import io.trino.tempto.Requirements;
import io.trino.tempto.RequirementsProvider;
import io.trino.tempto.assertions.QueryAssert;
import io.trino.tempto.configuration.Configuration;
import io.trino.tempto.fulfillment.table.MutableTableRequirement;
import io.trino.tempto.fulfillment.table.MutableTablesState;
import io.trino.tempto.fulfillment.table.TableDefinition;
import io.trino.tempto.fulfillment.table.TableRequirements;
import io.trino.tempto.fulfillment.table.hive.HiveTableDefinition;
import io.trino.tempto.fulfillment.table.hive.tpch.TpchTableDefinitions;
import io.trino.tempto.query.QueryExecutor;
import io.trino.tempto.query.QueryResult;
import io.trino.testing.TestingNames;
import io.trino.testng.services.Flaky;
import io.trino.tests.product.TpchTableResults;
import io.trino.tests.product.hive.BucketingType;
import io.trino.tests.product.hive.HiveProductTest;
import io.trino.tests.product.hive.util.TemporaryHiveTable;
import io.trino.tests.product.utils.QueryExecutors;
import io.trino.tests.product.utils.TableDefinitionUtils;
import java.sql.JDBCType;
import java.util.List;
import java.util.Optional;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.assertj.core.api.AssertProvider;
import org.assertj.core.api.Assertions;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;

public class TestHiveBucketedTables
extends HiveProductTest
implements RequirementsProvider {
    private static final Logger log = Logger.get(TestHiveBucketedTables.class);
    public static final HiveTableDefinition BUCKETED_NATION = TestHiveBucketedTables.bucketTableDefinition("bucket_nation", false, false);
    public static final HiveTableDefinition BUCKETED_NATION_PREPARED = HiveTableDefinition.builder((String)"bucket_nation_prepared").setCreateTableDDLTemplate("Table %NAME% should be only used with CTAS queries").setNoData().build();
    public static final HiveTableDefinition BUCKETED_SORTED_NATION = TestHiveBucketedTables.bucketTableDefinition("bucketed_sorted_nation", true, false);
    public static final HiveTableDefinition BUCKETED_PARTITIONED_NATION = TestHiveBucketedTables.bucketTableDefinition("bucketed_partitioned_nation", false, true);

    private static HiveTableDefinition bucketTableDefinition(String tableName, boolean sorted, boolean partitioned) {
        return HiveTableDefinition.builder((String)tableName).setCreateTableDDLTemplate("CREATE TABLE %NAME%(n_nationkey     BIGINT,n_name          STRING,n_regionkey     BIGINT,n_comment       STRING) " + (partitioned ? "PARTITIONED BY (part_key STRING) " : " ") + "CLUSTERED BY (n_regionkey) " + (sorted ? "SORTED BY (n_regionkey) " : " ") + "INTO 2 BUCKETS ROW FORMAT DELIMITED FIELDS TERMINATED BY '|' TBLPROPERTIES ('bucketing_version'='1')").setNoData().build();
    }

    public Requirement getRequirements(Configuration configuration) {
        return Requirements.compose((Requirement[])new Requirement[]{MutableTableRequirement.builder((TableDefinition)BUCKETED_PARTITIONED_NATION).withState(MutableTableRequirement.State.CREATED).build(), MutableTableRequirement.builder((TableDefinition)BUCKETED_NATION).withState(MutableTableRequirement.State.CREATED).build(), MutableTableRequirement.builder((TableDefinition)BUCKETED_NATION_PREPARED).withState(MutableTableRequirement.State.PREPARED).build(), MutableTableRequirement.builder((TableDefinition)BUCKETED_SORTED_NATION).withState(MutableTableRequirement.State.CREATED).build(), TableRequirements.immutableTable((TableDefinition)TpchTableDefinitions.NATION)});
    }

    @Test
    @Flaky(issue="https://github.com/trinodb/trino/issues?q=is%3Aissue+issue%3A+4936+5427", match="(could only be replicated to 0 nodes instead of minReplication|could only be written to 0 of the 1 minReplication|return code [12] from \\Qorg.apache.hadoop.hive.ql.exec.mr.MapRedTask\\E)")
    public void testSelectStar() {
        String tableName = TableDefinitionUtils.mutableTableInstanceOf((TableDefinition)BUCKETED_NATION).getNameInDatabase();
        TestHiveBucketedTables.populateHiveTable(tableName, TpchTableDefinitions.NATION.getName());
        ((QueryAssert)Assertions.assertThat((AssertProvider)QueryExecutors.onTrino().executeQuery("SELECT * FROM " + tableName, new QueryExecutor.QueryParam[0]))).matches(TpchTableResults.PRESTO_NATION_RESULT);
    }

    @Test(groups={"large_query"})
    @Flaky(issue="https://github.com/trinodb/trino/issues?q=is%3Aissue+issue%3A+4936+5427", match="(could only be replicated to 0 nodes instead of minReplication|could only be written to 0 of the 1 minReplication|return code [12] from \\Qorg.apache.hadoop.hive.ql.exec.mr.MapRedTask\\E)")
    public void testIgnorePartitionBucketingIfNotBucketed() {
        String tableName = MutableTablesState.mutableTablesState().get((TableDefinition)BUCKETED_PARTITIONED_NATION).getNameInDatabase();
        TestHiveBucketedTables.populateHivePartitionedTable(tableName, TpchTableDefinitions.NATION.getName(), "part_key = 'insert_1'");
        TestHiveBucketedTables.populateHivePartitionedTable(tableName, TpchTableDefinitions.NATION.getName(), "part_key = 'insert_2'");
        QueryExecutors.onHive().executeQuery(String.format("ALTER TABLE %s NOT CLUSTERED", tableName), new QueryExecutor.QueryParam[0]);
        ((QueryAssert)Assertions.assertThat((AssertProvider)QueryExecutors.onTrino().executeQuery(String.format("SELECT count(DISTINCT n_nationkey), count(*) FROM %s", tableName), new QueryExecutor.QueryParam[0]))).hasRowsCount(1).contains(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{25, 50})});
        ((QueryAssert)Assertions.assertThat((AssertProvider)QueryExecutors.onTrino().executeQuery(String.format("SELECT count(*) FROM %s WHERE n_nationkey = 1", tableName), new QueryExecutor.QueryParam[0]))).containsExactlyInOrder(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{2})});
    }

    @Test(groups={"large_query"})
    @Flaky(issue="https://github.com/trinodb/trino/issues?q=is%3Aissue+issue%3A+4936+5427", match="(could only be replicated to 0 nodes instead of minReplication|could only be written to 0 of the 1 minReplication|return code [12] from \\Qorg.apache.hadoop.hive.ql.exec.mr.MapRedTask\\E)")
    public void testAllowMultipleFilesPerBucket() {
        String tableName = MutableTablesState.mutableTablesState().get((TableDefinition)BUCKETED_PARTITIONED_NATION).getNameInDatabase();
        for (int i = 0; i < 3; ++i) {
            TestHiveBucketedTables.populateHivePartitionedTable(tableName, TpchTableDefinitions.NATION.getName(), "part_key = 'insert'");
        }
        ((QueryAssert)Assertions.assertThat((AssertProvider)QueryExecutors.onTrino().executeQuery(String.format("SELECT count(DISTINCT n_nationkey), count(*) FROM %s", tableName), new QueryExecutor.QueryParam[0]))).hasRowsCount(1).contains(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{25, 75})});
        ((QueryAssert)Assertions.assertThat((AssertProvider)QueryExecutors.onTrino().executeQuery(String.format("SELECT count(*) FROM %s WHERE n_nationkey = 1", tableName), new QueryExecutor.QueryParam[0]))).containsExactlyInOrder(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{3})});
    }

    @Test
    @Flaky(issue="https://github.com/trinodb/trino/issues?q=is%3Aissue+issue%3A+4936+5427", match="(could only be replicated to 0 nodes instead of minReplication|could only be written to 0 of the 1 minReplication|return code [12] from \\Qorg.apache.hadoop.hive.ql.exec.mr.MapRedTask\\E)")
    public void testSelectAfterMultipleInserts() {
        String tableName = TableDefinitionUtils.mutableTableInstanceOf((TableDefinition)BUCKETED_NATION).getNameInDatabase();
        TestHiveBucketedTables.populateHiveTable(tableName, TpchTableDefinitions.NATION.getName());
        TestHiveBucketedTables.populateHiveTable(tableName, TpchTableDefinitions.NATION.getName());
        ((QueryAssert)Assertions.assertThat((AssertProvider)QueryExecutors.onTrino().executeQuery(String.format("SELECT count(*) FROM %s WHERE n_nationkey = 1", tableName), new QueryExecutor.QueryParam[0]))).containsExactlyInOrder(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{2})});
        ((QueryAssert)Assertions.assertThat((AssertProvider)QueryExecutors.onTrino().executeQuery(String.format("SELECT count(*) FROM %s WHERE n_regionkey = 1", tableName), new QueryExecutor.QueryParam[0]))).containsExactlyInOrder(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{10})});
        ((QueryAssert)Assertions.assertThat((AssertProvider)QueryExecutors.onTrino().executeQuery(String.format("SELECT n_regionkey, count(*) FROM %s GROUP BY n_regionkey", tableName), new QueryExecutor.QueryParam[0]))).containsOnly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{0, 10}), QueryAssert.Row.row((Object[])new Object[]{1, 10}), QueryAssert.Row.row((Object[])new Object[]{2, 10}), QueryAssert.Row.row((Object[])new Object[]{3, 10}), QueryAssert.Row.row((Object[])new Object[]{4, 10})});
        ((QueryAssert)Assertions.assertThat((AssertProvider)QueryExecutors.onTrino().executeQuery(String.format("SELECT count(*) FROM %s n JOIN %s n1 ON n.n_regionkey = n1.n_regionkey", tableName, tableName), new QueryExecutor.QueryParam[0]))).containsExactlyInOrder(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{500})});
    }

    @Test
    @Flaky(issue="https://github.com/trinodb/trino/issues?q=is%3Aissue+issue%3A+4936+5427", match="(could only be replicated to 0 nodes instead of minReplication|could only be written to 0 of the 1 minReplication|return code [12] from \\Qorg.apache.hadoop.hive.ql.exec.mr.MapRedTask\\E)")
    public void testSelectAfterMultipleInsertsForSortedTable() {
        String tableName = TableDefinitionUtils.mutableTableInstanceOf((TableDefinition)BUCKETED_SORTED_NATION).getNameInDatabase();
        TestHiveBucketedTables.populateHiveTable(tableName, TpchTableDefinitions.NATION.getName());
        TestHiveBucketedTables.populateHiveTable(tableName, TpchTableDefinitions.NATION.getName());
        ((QueryAssert)Assertions.assertThat((AssertProvider)QueryExecutors.onTrino().executeQuery(String.format("SELECT count(*) FROM %s WHERE n_nationkey = 1", tableName), new QueryExecutor.QueryParam[0]))).containsExactlyInOrder(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{2})});
        ((QueryAssert)Assertions.assertThat((AssertProvider)QueryExecutors.onTrino().executeQuery(String.format("SELECT count(*) FROM %s WHERE n_regionkey = 1", tableName), new QueryExecutor.QueryParam[0]))).containsExactlyInOrder(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{10})});
        ((QueryAssert)Assertions.assertThat((AssertProvider)QueryExecutors.onTrino().executeQuery(String.format("SELECT n_regionkey, count(*) FROM %s GROUP BY n_regionkey", tableName), new QueryExecutor.QueryParam[0]))).containsOnly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{0, 10}), QueryAssert.Row.row((Object[])new Object[]{1, 10}), QueryAssert.Row.row((Object[])new Object[]{2, 10}), QueryAssert.Row.row((Object[])new Object[]{3, 10}), QueryAssert.Row.row((Object[])new Object[]{4, 10})});
        ((QueryAssert)Assertions.assertThat((AssertProvider)QueryExecutors.onTrino().executeQuery(String.format("SELECT count(*) FROM %s n JOIN %s n1 ON n.n_regionkey = n1.n_regionkey", tableName, tableName), new QueryExecutor.QueryParam[0]))).containsExactlyInOrder(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{500})});
    }

    @Test
    @Flaky(issue="https://github.com/trinodb/trino/issues?q=is%3Aissue+issue%3A+4936+5427", match="(could only be replicated to 0 nodes instead of minReplication|could only be written to 0 of the 1 minReplication|return code [12] from \\Qorg.apache.hadoop.hive.ql.exec.mr.MapRedTask\\E)")
    public void testSelectAfterMultipleInsertsForPartitionedTable() {
        String tableName = TableDefinitionUtils.mutableTableInstanceOf((TableDefinition)BUCKETED_PARTITIONED_NATION).getNameInDatabase();
        TestHiveBucketedTables.populateHivePartitionedTable(tableName, TpchTableDefinitions.NATION.getName(), "part_key = 'insert_1'");
        TestHiveBucketedTables.populateHivePartitionedTable(tableName, TpchTableDefinitions.NATION.getName(), "part_key = 'insert_2'");
        TestHiveBucketedTables.populateHivePartitionedTable(tableName, TpchTableDefinitions.NATION.getName(), "part_key = 'insert_1'");
        TestHiveBucketedTables.populateHivePartitionedTable(tableName, TpchTableDefinitions.NATION.getName(), "part_key = 'insert_2'");
        ((QueryAssert)Assertions.assertThat((AssertProvider)QueryExecutors.onTrino().executeQuery(String.format("SELECT count(*) FROM %s WHERE n_nationkey = 1", tableName), new QueryExecutor.QueryParam[0]))).containsExactlyInOrder(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{4})});
        ((QueryAssert)Assertions.assertThat((AssertProvider)QueryExecutors.onTrino().executeQuery(String.format("SELECT count(*) FROM %s WHERE n_regionkey = 1", tableName), new QueryExecutor.QueryParam[0]))).containsExactlyInOrder(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{20})});
        ((QueryAssert)Assertions.assertThat((AssertProvider)QueryExecutors.onTrino().executeQuery(String.format("SELECT count(*) FROM %s WHERE n_regionkey = 1 AND part_key = 'insert_1'", tableName), new QueryExecutor.QueryParam[0]))).hasRowsCount(1).containsExactlyInOrder(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{10})});
        ((QueryAssert)Assertions.assertThat((AssertProvider)QueryExecutors.onTrino().executeQuery(String.format("SELECT n_regionkey, count(*) FROM %s WHERE part_key = 'insert_2' GROUP BY n_regionkey", tableName), new QueryExecutor.QueryParam[0]))).containsOnly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{0, 10}), QueryAssert.Row.row((Object[])new Object[]{1, 10}), QueryAssert.Row.row((Object[])new Object[]{2, 10}), QueryAssert.Row.row((Object[])new Object[]{3, 10}), QueryAssert.Row.row((Object[])new Object[]{4, 10})});
        ((QueryAssert)Assertions.assertThat((AssertProvider)QueryExecutors.onTrino().executeQuery(String.format("SELECT count(*) FROM %s n JOIN %s n1 ON n.n_regionkey = n1.n_regionkey", tableName, tableName), new QueryExecutor.QueryParam[0]))).containsExactlyInOrder(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{2000})});
        ((QueryAssert)Assertions.assertThat((AssertProvider)QueryExecutors.onTrino().executeQuery(String.format("SELECT count(*) FROM %s n JOIN %s n1 ON n.n_regionkey = n1.n_regionkey WHERE n.part_key = 'insert_1'", tableName, tableName), new QueryExecutor.QueryParam[0]))).containsExactlyInOrder(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{1000})});
    }

    @Test
    @Flaky(issue="https://github.com/trinodb/trino/issues?q=is%3Aissue+issue%3A+4936+5427", match="(could only be replicated to 0 nodes instead of minReplication|could only be written to 0 of the 1 minReplication|return code [12] from \\Qorg.apache.hadoop.hive.ql.exec.mr.MapRedTask\\E)")
    public void testSelectFromEmptyBucketedTableEmptyTablesAllowed() {
        String tableName = TableDefinitionUtils.mutableTableInstanceOf((TableDefinition)BUCKETED_NATION).getNameInDatabase();
        ((QueryAssert)Assertions.assertThat((AssertProvider)QueryExecutors.onTrino().executeQuery(String.format("SELECT count(*) FROM %s", tableName), new QueryExecutor.QueryParam[0]))).containsExactlyInOrder(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{0})});
    }

    @Test
    @Flaky(issue="https://github.com/trinodb/trino/issues?q=is%3Aissue+issue%3A+4936+5427", match="(could only be replicated to 0 nodes instead of minReplication|could only be written to 0 of the 1 minReplication|return code [12] from \\Qorg.apache.hadoop.hive.ql.exec.mr.MapRedTask\\E)")
    public void testSelectFromIncompleteBucketedTableEmptyTablesAllowed() {
        String tableName = TableDefinitionUtils.mutableTableInstanceOf((TableDefinition)BUCKETED_NATION).getNameInDatabase();
        TestHiveBucketedTables.populateRowToHiveTable(tableName, (List<String>)ImmutableList.of((Object)"2", (Object)"'name'", (Object)"2", (Object)"'comment'"), Optional.empty());
        ((QueryAssert)Assertions.assertThat((AssertProvider)QueryExecutors.onTrino().executeQuery(String.format("SELECT count(*) from %s", tableName), new QueryExecutor.QueryParam[0]))).containsExactlyInOrder(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{1})});
        ((QueryAssert)Assertions.assertThat((AssertProvider)QueryExecutors.onTrino().executeQuery(String.format("select n_nationkey from %s where n_regionkey = 2", tableName), new QueryExecutor.QueryParam[0]))).containsExactlyInOrder(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{2})});
    }

    @Test
    @Flaky(issue="https://github.com/trinodb/trino/issues?q=is%3Aissue+issue%3A+4936+5427", match="(could only be replicated to 0 nodes instead of minReplication|could only be written to 0 of the 1 minReplication|return code [12] from \\Qorg.apache.hadoop.hive.ql.exec.mr.MapRedTask\\E)")
    public void testInsertPartitionedBucketed() {
        String tableName = MutableTablesState.mutableTablesState().get((TableDefinition)BUCKETED_NATION_PREPARED).getNameInDatabase();
        String ctasQuery = "CREATE TABLE %s WITH (bucket_count = 4, bucketed_by = ARRAY['n_regionkey'], partitioned_by = ARRAY['part_key']) AS SELECT n_nationkey, n_name, n_regionkey, n_comment, n_name as part_key FROM %s";
        QueryExecutors.onTrino().executeQuery(String.format(ctasQuery, tableName, TpchTableDefinitions.NATION.getName()), new QueryExecutor.QueryParam[0]);
        ((QueryAssert)Assertions.assertThat((AssertProvider)QueryExecutors.onTrino().executeQuery(String.format("SELECT count(*) FROM %s", tableName), new QueryExecutor.QueryParam[0]))).containsExactlyInOrder(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{25})});
        ((QueryAssert)Assertions.assertThat((AssertProvider)QueryExecutors.onTrino().executeQuery(String.format("SELECT count(*) FROM %s WHERE n_regionkey=0", tableName), new QueryExecutor.QueryParam[0]))).containsExactlyInOrder(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{5})});
        ((QueryAssert)Assertions.assertThat((AssertProvider)QueryExecutors.onTrino().executeQuery(String.format("SELECT count(*) FROM %s WHERE part_key='ALGERIA'", tableName), new QueryExecutor.QueryParam[0]))).containsExactlyInOrder(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{1})});
        ((QueryAssert)Assertions.assertThat((AssertProvider)QueryExecutors.onTrino().executeQuery(String.format("SELECT count(*) FROM %s WHERE n_regionkey=0 AND part_key='ALGERIA'", tableName), new QueryExecutor.QueryParam[0]))).containsExactlyInOrder(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{1})});
    }

    @Test
    @Flaky(issue="https://github.com/trinodb/trino/issues?q=is%3Aissue+issue%3A+4936+5427", match="(could only be replicated to 0 nodes instead of minReplication|could only be written to 0 of the 1 minReplication|return code [12] from \\Qorg.apache.hadoop.hive.ql.exec.mr.MapRedTask\\E)")
    public void testCreatePartitionedBucketedTableAsSelect() {
        String tableName = MutableTablesState.mutableTablesState().get((TableDefinition)BUCKETED_PARTITIONED_NATION).getNameInDatabase();
        QueryExecutors.onTrino().executeQuery(String.format("INSERT INTO %s SELECT n_nationkey, n_name, n_regionkey, n_comment, n_name FROM %s", tableName, TpchTableDefinitions.NATION.getName()), new QueryExecutor.QueryParam[0]);
        ((QueryAssert)Assertions.assertThat((AssertProvider)QueryExecutors.onTrino().executeQuery(String.format("SELECT count(*) FROM %s", tableName), new QueryExecutor.QueryParam[0]))).containsExactlyInOrder(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{25})});
        ((QueryAssert)Assertions.assertThat((AssertProvider)QueryExecutors.onTrino().executeQuery(String.format("SELECT count(*) FROM %s WHERE n_regionkey=0", tableName), new QueryExecutor.QueryParam[0]))).containsExactlyInOrder(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{5})});
        ((QueryAssert)Assertions.assertThat((AssertProvider)QueryExecutors.onTrino().executeQuery(String.format("SELECT count(*) FROM %s WHERE part_key='ALGERIA'", tableName), new QueryExecutor.QueryParam[0]))).containsExactlyInOrder(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{1})});
        ((QueryAssert)Assertions.assertThat((AssertProvider)QueryExecutors.onTrino().executeQuery(String.format("SELECT count(*) FROM %s WHERE n_regionkey=0 AND part_key='ALGERIA'", tableName), new QueryExecutor.QueryParam[0]))).containsExactlyInOrder(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{1})});
    }

    @Test
    @Flaky(issue="https://github.com/trinodb/trino/issues?q=is%3Aissue+issue%3A+4936+5427", match="(could only be replicated to 0 nodes instead of minReplication|could only be written to 0 of the 1 minReplication|return code [12] from \\Qorg.apache.hadoop.hive.ql.exec.mr.MapRedTask\\E)")
    public void testInsertIntoBucketedTables() {
        String tableName = MutableTablesState.mutableTablesState().get((TableDefinition)BUCKETED_NATION).getNameInDatabase();
        QueryExecutors.onTrino().executeQuery(String.format("INSERT INTO %s SELECT * FROM %s", tableName, TpchTableDefinitions.NATION.getName()), new QueryExecutor.QueryParam[0]);
        QueryExecutors.onTrino().executeQuery(String.format("INSERT INTO %s SELECT * FROM %s", tableName, TpchTableDefinitions.NATION.getName()), new QueryExecutor.QueryParam[0]);
        ((QueryAssert)Assertions.assertThat((AssertProvider)QueryExecutors.onTrino().executeQuery(String.format("SELECT count(*) FROM %s", tableName), new QueryExecutor.QueryParam[0]))).containsExactlyInOrder(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{50})});
        ((QueryAssert)Assertions.assertThat((AssertProvider)QueryExecutors.onTrino().executeQuery(String.format("SELECT count(*) FROM %s WHERE n_regionkey=0", tableName), new QueryExecutor.QueryParam[0]))).containsExactlyInOrder(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{10})});
    }

    @Test
    @Flaky(issue="https://github.com/trinodb/trino/issues?q=is%3Aissue+issue%3A+4936+5427", match="(could only be replicated to 0 nodes instead of minReplication|could only be written to 0 of the 1 minReplication|return code [12] from \\Qorg.apache.hadoop.hive.ql.exec.mr.MapRedTask\\E)")
    public void testCreateBucketedTableAsSelect() {
        String tableName = MutableTablesState.mutableTablesState().get((TableDefinition)BUCKETED_NATION_PREPARED).getNameInDatabase();
        QueryExecutors.onTrino().executeQuery(String.format("CREATE TABLE %s WITH (bucket_count = 10, bucketed_by = ARRAY['n_regionkey']) AS SELECT * FROM %s", tableName, TpchTableDefinitions.NATION.getName()), new QueryExecutor.QueryParam[0]);
        ((QueryAssert)Assertions.assertThat((AssertProvider)QueryExecutors.onTrino().executeQuery(String.format("SELECT * FROM %s", tableName), new QueryExecutor.QueryParam[0]))).matches(TpchTableResults.PRESTO_NATION_RESULT);
        ((QueryAssert)Assertions.assertThat((AssertProvider)QueryExecutors.onTrino().executeQuery(String.format("SELECT count(*) FROM %s WHERE n_regionkey=0", tableName), new QueryExecutor.QueryParam[0]))).containsExactlyInOrder(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{5})});
    }

    @Test
    @Flaky(issue="https://github.com/trinodb/trino/issues?q=is%3Aissue+issue%3A+4936+5427", match="(could only be replicated to 0 nodes instead of minReplication|could only be written to 0 of the 1 minReplication|return code [12] from \\Qorg.apache.hadoop.hive.ql.exec.mr.MapRedTask\\E)")
    public void testBucketingVersion() {
        String value = "Trino rocks";
        String bucketV1 = "000002_0";
        String bucketV2Standard = "000001_0";
        String bucketV2DirectInsert = "bucket_00001";
        ImmutableList bucketV1NameOptions = ImmutableList.of((Object)bucketV1);
        ImmutableList bucketV2NameOptions = ImmutableList.of((Object)bucketV2Standard, (Object)bucketV2DirectInsert);
        this.testBucketingVersion(BucketingType.BUCKETED_DEFAULT, value, false, (List<String>)bucketV2NameOptions);
        this.testBucketingVersion(BucketingType.BUCKETED_DEFAULT, value, true, (List<String>)bucketV2NameOptions);
        this.testBucketingVersion(BucketingType.BUCKETED_V1, value, false, (List<String>)bucketV1NameOptions);
        this.testBucketingVersion(BucketingType.BUCKETED_V1, value, true, (List<String>)bucketV1NameOptions);
        this.testBucketingVersion(BucketingType.BUCKETED_V2, value, false, (List<String>)bucketV2NameOptions);
        this.testBucketingVersion(BucketingType.BUCKETED_V2, value, true, (List<String>)bucketV2NameOptions);
    }

    @Test(dataProvider="testBucketingWithUnsupportedDataTypesDataProvider")
    @Flaky(issue="https://github.com/trinodb/trino/issues?q=is%3Aissue+issue%3A+4936+5427", match="(could only be replicated to 0 nodes instead of minReplication|could only be written to 0 of the 1 minReplication|return code [12] from \\Qorg.apache.hadoop.hive.ql.exec.mr.MapRedTask\\E)")
    public void testBucketingWithUnsupportedDataTypes(BucketingType bucketingType, String columnToBeBucketed) {
        try (TemporaryHiveTable table = TemporaryHiveTable.temporaryHiveTable("table_with_unsupported_bucketing_types_" + TestingNames.randomNameSuffix());){
            String tableName = table.getName();
            QueryExecutors.onHive().executeQuery(String.format("CREATE TABLE %s (n_integer       INT,n_decimal       DECIMAL(9, 2),n_timestamp     TIMESTAMP,n_char          CHAR(10),n_binary        BINARY,n_union         UNIONTYPE<INT,STRING>,n_struct        STRUCT<field1:INT,field2:STRING>) CLUSTERED BY (%s) INTO 2 BUCKETS STORED AS ORC %s", tableName, columnToBeBucketed, this.hiveTableProperties(bucketingType)), new QueryExecutor.QueryParam[0]);
            QueryResult showCreateTableResult = QueryExecutors.onTrino().executeQuery("SHOW CREATE TABLE " + tableName, new QueryExecutor.QueryParam[0]);
            ((QueryAssert)Assertions.assertThat((AssertProvider)showCreateTableResult)).hasRowsCount(1);
            Assertions.assertThat((String)((String)showCreateTableResult.getOnlyValue())).matches(Pattern.compile(String.format("\\QCREATE TABLE hive.default.%s (\n   n_integer integer,\n   n_decimal decimal(9, 2),\n   n_timestamp timestamp(3),\n   n_char char(10),\n   n_binary varbinary,\n   n_union ROW(tag tinyint, field0 integer, field1 varchar),\n   n_struct ROW(field1 integer, field2 varchar)\n)\nWITH (\\E(?s:.*)bucket_count = 2,\n(?s:.*)bucketed_by = ARRAY\\['%s'\\],\n(?s:.*)bucketing_version = %s,(?s:.*)", tableName, Pattern.quote(columnToBeBucketed), this.getExpectedBucketVersion(bucketingType))));
            TestHiveBucketedTables.populateRowToHiveTable(tableName, (List<String>)ImmutableList.builder().add((Object)"1").add((Object)"CAST(1 AS DECIMAL(9, 2))").add((Object)"CAST('2015-01-01T00:01:00.15' AS TIMESTAMP)").add((Object)"'char value'").add((Object)"unhex('00010203')").add((Object)"create_union(0, 1, 'union value')").add((Object)"named_struct('field1', 1, 'field2', 'Field2')").build(), Optional.empty());
            ((QueryAssert)Assertions.assertThat((AssertProvider)QueryExecutors.onTrino().executeQuery(String.format("SELECT * FROM %s", tableName), new QueryExecutor.QueryParam[0]))).hasRowsCount(1);
            QueryAssert.assertQueryFailure(() -> QueryExecutors.onTrino().executeQuery("SELECT \"$bucket\" FROM " + tableName, new QueryExecutor.QueryParam[0])).hasMessageMatching("Query failed \\(#\\w+\\):\\Q line 1:8: Column '$bucket' cannot be resolved");
            QueryAssert.assertQueryFailure(() -> QueryExecutors.onTrino().executeQuery(String.format("INSERT INTO %s(n_integer) VALUES (1)", tableName), new QueryExecutor.QueryParam[0])).hasMessageMatching("Query failed \\(#\\w+\\): Cannot write to a table bucketed on an unsupported type");
            String newTableName = "new_" + tableName;
            QueryAssert.assertQueryFailure(() -> QueryExecutors.onTrino().executeQuery(String.format("CREATE TABLE %s (LIKE %s INCLUDING PROPERTIES)", newTableName, tableName), new QueryExecutor.QueryParam[0])).hasMessageMatching("Query failed \\(#\\w+\\): Cannot create a table bucketed on an unsupported type");
            QueryAssert.assertQueryFailure(() -> QueryExecutors.onTrino().executeQuery(String.format("CREATE TABLE %s (n_integer       integer,n_decimal       decimal(9, 2),n_timestamp     timestamp(3),n_char          char(10),n_binary        varbinary,n_union         ROW(tag tinyint, field0 integer, field1 varchar),n_struct        ROW(field1 integer, field2 varchar)) WITH (   bucketed_by = ARRAY['%s'],   bucket_count = 2)", newTableName, columnToBeBucketed), new QueryExecutor.QueryParam[0])).hasMessageMatching("Query failed \\(#\\w+\\): Cannot create a table bucketed on an unsupported type");
            QueryAssert.assertQueryFailure(() -> QueryExecutors.onTrino().executeQuery(String.format("CREATE TABLE %s WITH (%s) AS SELECT * FROM %s", newTableName, bucketingType.getTrinoTableProperties(columnToBeBucketed, 2).stream().collect(Collectors.joining(",")), tableName), new QueryExecutor.QueryParam[0])).hasMessageMatching("Query failed \\(#\\w+\\): Cannot create a table bucketed on an unsupported type");
        }
    }

    @DataProvider
    public static Object[][] testBucketingWithUnsupportedDataTypesDataProvider() {
        return (Object[][])Lists.cartesianProduct((List[])new List[]{ImmutableList.of((Object)((Object)BucketingType.BUCKETED_DEFAULT), (Object)((Object)BucketingType.BUCKETED_V1), (Object)((Object)BucketingType.BUCKETED_V2)), ImmutableList.builder().add((Object)"n_decimal").add((Object)"n_timestamp").add((Object)"n_char").add((Object)"n_binary").add((Object)"n_union").add((Object)"n_struct").build()}).stream().map(List::toArray).toArray(x$0 -> new Object[x$0][]);
    }

    private void testBucketingVersion(BucketingType bucketingType, String value, boolean insertWithTrino, List<String> expectedFileNameOptions) {
        log.info("Testing with bucketingType=%s, value='%s', insertWithTrino=%s, expectedFileNamePossibilites=%s", new Object[]{bucketingType, value, insertWithTrino, expectedFileNameOptions});
        QueryExecutors.onHive().executeQuery("DROP TABLE IF EXISTS test_bucketing_version", new QueryExecutor.QueryParam[0]);
        QueryExecutors.onHive().executeQuery("CREATE TABLE test_bucketing_version(a string) " + bucketingType.getHiveClustering("a", 4) + " STORED AS ORC " + this.hiveTableProperties(bucketingType), new QueryExecutor.QueryParam[0]);
        if (insertWithTrino) {
            QueryExecutors.onTrino().executeQuery("INSERT INTO test_bucketing_version(a) VALUES (?)", new QueryExecutor.QueryParam[]{QueryExecutor.param((JDBCType)JDBCType.VARCHAR, (Object)value)});
        } else {
            QueryExecutors.onHive().executeQuery("SET hive.enforce.bucketing = true", new QueryExecutor.QueryParam[0]);
            QueryExecutors.onHive().executeQuery("INSERT INTO test_bucketing_version(a) VALUES ('" + value + "')", new QueryExecutor.QueryParam[0]);
        }
        ((QueryAssert)Assertions.assertThat((AssertProvider)QueryExecutors.onTrino().executeQuery("SELECT a, regexp_extract(\"$path\", '^.*/([^_/]+_[^_/]+)(_[^/]+)?$', 1) FROM test_bucketing_version", new QueryExecutor.QueryParam[0]))).containsOnly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{value, QueryAssert.anyOf((Object[])expectedFileNameOptions.toArray())})});
    }

    private String hiveTableProperties(BucketingType bucketingType) {
        ImmutableList.Builder tableProperties = ImmutableList.builder();
        tableProperties.add((Object)"'transactional'='false'");
        tableProperties.addAll(bucketingType.getHiveTableProperties());
        return "TBLPROPERTIES(" + String.join((CharSequence)",", (Iterable<? extends CharSequence>)tableProperties.build()) + ")";
    }

    private String getExpectedBucketVersion(BucketingType bucketingType) {
        switch (bucketingType) {
            case BUCKETED_DEFAULT: {
                return "2";
            }
            case BUCKETED_V1: {
                return "1";
            }
            case BUCKETED_V2: {
                return "2";
            }
        }
        throw new UnsupportedOperationException("Not supported for " + String.valueOf((Object)bucketingType));
    }

    private static void populateRowToHiveTable(String destination, List<String> values, Optional<String> partition) {
        String queryStatement = "INSERT INTO TABLE " + destination + (partition.isPresent() ? String.format(" PARTITION (%s) ", partition.get()) : " ") + "SELECT " + String.join((CharSequence)",", values) + " FROM (SELECT 'foo') x";
        QueryExecutors.onHive().executeQuery("set hive.enforce.bucketing = true", new QueryExecutor.QueryParam[0]);
        QueryExecutors.onHive().executeQuery("set hive.enforce.sorting = true", new QueryExecutor.QueryParam[0]);
        QueryExecutors.onHive().executeQuery(queryStatement, new QueryExecutor.QueryParam[0]);
    }

    private static void populateHivePartitionedTable(String destination, String source, String partition) {
        String queryStatement = String.format("INSERT INTO TABLE %s PARTITION (%s) SELECT * FROM %s", destination, partition, source);
        QueryExecutors.onHive().executeQuery("set hive.enforce.bucketing = true", new QueryExecutor.QueryParam[0]);
        QueryExecutors.onHive().executeQuery("set hive.enforce.sorting = true", new QueryExecutor.QueryParam[0]);
        QueryExecutors.onHive().executeQuery(queryStatement, new QueryExecutor.QueryParam[0]);
    }

    private static void populateHiveTable(String destination, String source) {
        QueryExecutors.onHive().executeQuery("set hive.enforce.bucketing = true", new QueryExecutor.QueryParam[0]);
        QueryExecutors.onHive().executeQuery("set hive.enforce.sorting = true", new QueryExecutor.QueryParam[0]);
        QueryExecutors.onHive().executeQuery(String.format("INSERT INTO TABLE %s SELECT * FROM %s", destination, source), new QueryExecutor.QueryParam[0]);
    }
}

