/*
 * Decompiled with CFR 0.152.
 */
package io.trino.tests.product.hive;

import io.trino.tempto.AfterMethodWithContext;
import io.trino.tempto.BeforeMethodWithContext;
import io.trino.tempto.ProductTest;
import io.trino.tempto.assertions.QueryAssert;
import io.trino.tempto.query.QueryExecutor;
import io.trino.testing.TestingNames;
import io.trino.testng.services.Flaky;
import io.trino.tests.product.utils.QueryExecutors;
import java.util.Objects;
import org.assertj.core.api.AssertProvider;
import org.assertj.core.api.Assertions;
import org.testng.annotations.Test;

public class TestHiveDatabricksUnityCompatibility
extends ProductTest {
    private String unityCatalogName;
    private String externalLocationPath;
    private final String schemaName = "test_basic_hive_" + TestingNames.randomNameSuffix();

    @BeforeMethodWithContext
    public void setUp() {
        this.unityCatalogName = Objects.requireNonNull(System.getenv("DATABRICKS_UNITY_CATALOG_NAME"), "Environment variable not set: DATABRICKS_UNITY_CATALOG_NAME");
        this.externalLocationPath = Objects.requireNonNull(System.getenv("DATABRICKS_UNITY_EXTERNAL_LOCATION"), "Environment variable not set: DATABRICKS_UNITY_EXTERNAL_LOCATION");
        String schemaLocation = String.format("%s/%s", this.externalLocationPath, this.schemaName);
        QueryExecutors.onDelta().executeQuery("CREATE SCHEMA " + this.unityCatalogName + "." + this.schemaName + " MANAGED LOCATION '" + schemaLocation + "'", new QueryExecutor.QueryParam[0]);
    }

    @AfterMethodWithContext
    public void cleanUp() {
        QueryExecutors.onDelta().executeQuery("DROP SCHEMA IF EXISTS " + this.unityCatalogName + "." + this.schemaName + " CASCADE", new QueryExecutor.QueryParam[0]);
    }

    @Test(groups={"databricks-unity-http-hms", "profile_specific_tests"})
    @Flaky(issue="https://github.com/trinodb/trino/issues/14391", match="\\Q[Databricks][\\E(DatabricksJDBCDriver|JDBCDriver)\\Q](500593) Communication link failure. Failed to connect to server. Reason: \\E((HTTP retry after response received with no Retry-After header, error: HTTP Response code: 503|HTTP Response code: 504), Error message: Unknown.|java.net.SocketTimeoutException: Read timed out.)")
    public void testBasicHiveOperations() {
        String tableName = "test_table_" + TestingNames.randomNameSuffix();
        String hiveTableName = "hive.%s.%s".formatted(this.schemaName, tableName);
        String unityTableName = "%s.%s.%s".formatted(this.unityCatalogName, this.schemaName, tableName);
        String tableLocation = String.format("%s/%s/%s", this.externalLocationPath, this.schemaName, tableName);
        QueryExecutors.onDelta().executeQuery("CREATE TABLE " + unityTableName + "(c1 int, c2 string) USING PARQUET LOCATION '" + tableLocation + "'", new QueryExecutor.QueryParam[0]);
        QueryExecutors.onDelta().executeQuery("INSERT INTO " + unityTableName + " VALUES (1, 'one')", new QueryExecutor.QueryParam[0]);
        ((QueryAssert)Assertions.assertThat((AssertProvider)QueryExecutors.onTrino().executeQuery("SHOW SCHEMAS FROM hive", new QueryExecutor.QueryParam[0]))).contains(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{this.schemaName})});
        ((QueryAssert)Assertions.assertThat((AssertProvider)QueryExecutors.onTrino().executeQuery("SHOW TABLES IN hive." + this.schemaName, new QueryExecutor.QueryParam[0]))).containsOnly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{tableName})});
        ((QueryAssert)Assertions.assertThat((AssertProvider)QueryExecutors.onTrino().executeQuery("SELECT * FROM " + hiveTableName, new QueryExecutor.QueryParam[0]))).containsOnly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{1, "one"})});
    }
}

