/*
 * Decompiled with CFR 0.152.
 */
package io.trino.tests.product.hive;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.inject.Inject;
import com.google.inject.name.Named;
import io.trino.tempto.AfterMethodWithContext;
import io.trino.tempto.BeforeMethodWithContext;
import io.trino.tempto.assertions.QueryAssert;
import io.trino.tempto.query.QueryExecutor;
import io.trino.tempto.query.QueryResult;
import io.trino.tests.product.hive.HiveProductTest;
import io.trino.tests.product.utils.QueryExecutors;
import java.util.List;
import java.util.Set;
import org.assertj.core.api.AssertProvider;
import org.assertj.core.api.Assertions;
import org.testng.annotations.Test;

public class TestRoles
extends HiveProductTest {
    private static final String ROLE1 = "role1";
    private static final String ROLE2 = "role2";
    private static final String ROLE3 = "role3";
    private static final Set<String> TEST_ROLES = ImmutableSet.of((Object)"role1", (Object)"role2", (Object)"role3");
    @Inject
    @Named(value="databases.presto.jdbc_user")
    private String userName;

    @BeforeMethodWithContext
    public void setUp() {
        QueryExecutors.onTrino().executeQuery("SET ROLE admin IN hive", new QueryExecutor.QueryParam[0]);
        QueryExecutors.onHive().executeQuery("SET ROLE admin", new QueryExecutor.QueryParam[0]);
        this.cleanup();
    }

    @AfterMethodWithContext
    public void tearDown() {
        this.cleanup();
    }

    private void cleanup() {
        Set<String> existentRoles = this.listRoles();
        for (String role : TEST_ROLES) {
            if (!existentRoles.contains(role)) continue;
            QueryExecutors.onHive().executeQuery(String.format("DROP ROLE %s", role), new QueryExecutor.QueryParam[0]);
        }
    }

    private Set<String> listRoles() {
        return (Set)QueryExecutors.onHive().executeQuery("SHOW ROLES", new QueryExecutor.QueryParam[0]).rows().stream().map(Iterables::getOnlyElement).map(String.class::cast).collect(ImmutableSet.toImmutableSet());
    }

    @Test(groups={"authorization", "profile_specific_tests"})
    public void testCreateRole() {
        QueryExecutors.onTrino().executeQuery(String.format("CREATE ROLE %s IN hive", ROLE1), new QueryExecutor.QueryParam[0]);
        Assertions.assertThat(this.listRoles()).contains((Object[])new String[]{ROLE1});
    }

    @Test(groups={"authorization", "profile_specific_tests"})
    public void testDropRole() {
        QueryExecutors.onHive().executeQuery(String.format("CREATE ROLE %s", ROLE1), new QueryExecutor.QueryParam[0]);
        Assertions.assertThat(this.listRoles()).contains((Object[])new String[]{ROLE1});
        QueryExecutors.onTrino().executeQuery(String.format("DROP ROLE %s IN hive", ROLE1), new QueryExecutor.QueryParam[0]);
        Assertions.assertThat(this.listRoles()).doesNotContain((Object[])new String[]{ROLE1});
    }

    @Test(groups={"authorization", "profile_specific_tests"})
    public void testListRoles() {
        QueryExecutors.onTrino().executeQuery(String.format("CREATE ROLE %s IN hive", ROLE1), new QueryExecutor.QueryParam[0]);
        QueryResult expected = QueryExecutors.onHive().executeQuery("SHOW ROLES", new QueryExecutor.QueryParam[0]);
        QueryResult actual = QueryExecutors.onTrino().executeQuery("SELECT * FROM hive.information_schema.roles", new QueryExecutor.QueryParam[0]);
        Assertions.assertThat((List)actual.rows()).containsOnly((Object[])expected.rows().toArray(new List[0]));
    }

    @Test(groups={"authorization", "profile_specific_tests"})
    public void testCreateDuplicateRole() {
        QueryExecutors.onTrino().executeQuery(String.format("CREATE ROLE %s IN hive", ROLE1), new QueryExecutor.QueryParam[0]);
        QueryAssert.assertQueryFailure(() -> QueryExecutors.onTrino().executeQuery(String.format("CREATE ROLE %s IN hive", ROLE1), new QueryExecutor.QueryParam[0])).hasMessageContaining("Role '%s' already exists", new Object[]{ROLE1});
    }

    @Test(groups={"authorization", "profile_specific_tests"})
    public void testDropNonExistentRole() {
        QueryAssert.assertQueryFailure(() -> QueryExecutors.onTrino().executeQuery(String.format("DROP ROLE %s IN hive", ROLE3), new QueryExecutor.QueryParam[0])).hasMessageContaining("Role '%s' does not exist", new Object[]{ROLE3});
    }

    @Test(groups={"authorization", "profile_specific_tests"})
    public void testCreateDropRoleAccessControl() {
        QueryAssert.assertQueryFailure(() -> TestRoles.onPrestoAlice().executeQuery(String.format("CREATE ROLE %s IN hive", ROLE3), new QueryExecutor.QueryParam[0])).hasMessageContaining("Cannot create role %s", new Object[]{ROLE3});
        QueryAssert.assertQueryFailure(() -> TestRoles.onPrestoAlice().executeQuery(String.format("DROP ROLE %s IN hive", ROLE3), new QueryExecutor.QueryParam[0])).hasMessageContaining("Cannot drop role %s", new Object[]{ROLE3});
        QueryAssert.assertQueryFailure(() -> TestRoles.onPrestoAlice().executeQuery("SELECT * FROM hive.information_schema.roles", new QueryExecutor.QueryParam[0])).hasMessageContaining("Cannot select from table information_schema.roles");
    }

    @Test(groups={"authorization", "profile_specific_tests"})
    public void testPublicRoleIsGrantedToEveryone() {
        ((QueryAssert)Assertions.assertThat((AssertProvider)TestRoles.onPrestoAlice().executeQuery("SELECT * FROM hive.information_schema.applicable_roles", new QueryExecutor.QueryParam[0]))).contains(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{"alice", "USER", "public", "NO"})});
        ((QueryAssert)Assertions.assertThat((AssertProvider)TestRoles.onPrestoBob().executeQuery("SELECT * FROM hive.information_schema.applicable_roles", new QueryExecutor.QueryParam[0]))).contains(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{"bob", "USER", "public", "NO"})});
    }

    @Test(groups={"authorization", "profile_specific_tests"})
    public void testAdminRoleIsGrantedToHdfs() {
        ((QueryAssert)Assertions.assertThat((AssertProvider)QueryExecutors.onTrino().executeQuery("SELECT * FROM hive.information_schema.applicable_roles", new QueryExecutor.QueryParam[0]))).contains(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{this.userName, "USER", "admin", QueryAssert.anyOf((Object[])new Object[]{"YES", "NO"})})});
    }

    @Test(groups={"authorization", "profile_specific_tests"})
    public void testGrantRoleToUser() {
        QueryExecutors.onTrino().executeQuery("CREATE ROLE role1 IN hive", new QueryExecutor.QueryParam[0]);
        QueryExecutors.onTrino().executeQuery("GRANT role1 TO USER alice IN hive", new QueryExecutor.QueryParam[0]);
        ((QueryAssert)Assertions.assertThat((AssertProvider)TestRoles.onPrestoAlice().executeQuery("SELECT * FROM hive.information_schema.applicable_roles", new QueryExecutor.QueryParam[0]))).containsOnly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{"alice", "USER", "public", "NO"}), QueryAssert.Row.row((Object[])new Object[]{"alice", "USER", ROLE1, "NO"})});
    }

    @Test(groups={"authorization", "profile_specific_tests"})
    public void testGrantRoleToRole() {
        QueryExecutors.onTrino().executeQuery("CREATE ROLE role1 IN hive", new QueryExecutor.QueryParam[0]);
        QueryExecutors.onTrino().executeQuery("CREATE ROLE role2 IN hive", new QueryExecutor.QueryParam[0]);
        QueryExecutors.onTrino().executeQuery("GRANT role1 TO USER alice IN hive", new QueryExecutor.QueryParam[0]);
        QueryExecutors.onTrino().executeQuery("GRANT role2 TO ROLE role1 IN hive", new QueryExecutor.QueryParam[0]);
        ((QueryAssert)Assertions.assertThat((AssertProvider)TestRoles.onPrestoAlice().executeQuery("SELECT * FROM hive.information_schema.applicable_roles", new QueryExecutor.QueryParam[0]))).containsOnly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{"alice", "USER", "public", "NO"}), QueryAssert.Row.row((Object[])new Object[]{"alice", "USER", ROLE1, "NO"}), QueryAssert.Row.row((Object[])new Object[]{ROLE1, "ROLE", ROLE2, "NO"})});
    }

    @Test(groups={"authorization", "profile_specific_tests"})
    public void testGrantRoleWithAdminOption() {
        QueryExecutors.onTrino().executeQuery("CREATE ROLE role1 IN hive", new QueryExecutor.QueryParam[0]);
        QueryExecutors.onTrino().executeQuery("CREATE ROLE role2 IN hive", new QueryExecutor.QueryParam[0]);
        QueryExecutors.onTrino().executeQuery("GRANT role1 TO USER alice WITH ADMIN OPTION IN hive", new QueryExecutor.QueryParam[0]);
        QueryExecutors.onTrino().executeQuery("GRANT role2 TO ROLE role1 WITH ADMIN OPTION IN hive", new QueryExecutor.QueryParam[0]);
        ((QueryAssert)Assertions.assertThat((AssertProvider)TestRoles.onPrestoAlice().executeQuery("SELECT * FROM hive.information_schema.applicable_roles", new QueryExecutor.QueryParam[0]))).containsOnly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{"alice", "USER", "public", "NO"}), QueryAssert.Row.row((Object[])new Object[]{"alice", "USER", ROLE1, "YES"}), QueryAssert.Row.row((Object[])new Object[]{ROLE1, "ROLE", ROLE2, "YES"})});
    }

    @Test(groups={"authorization", "profile_specific_tests"})
    public void testGrantRoleMultipleTimes() {
        QueryExecutors.onTrino().executeQuery("CREATE ROLE role1 IN hive", new QueryExecutor.QueryParam[0]);
        QueryExecutors.onTrino().executeQuery("CREATE ROLE role2 IN hive", new QueryExecutor.QueryParam[0]);
        QueryExecutors.onTrino().executeQuery("GRANT role1 TO USER alice IN hive", new QueryExecutor.QueryParam[0]);
        QueryExecutors.onTrino().executeQuery("GRANT role2 TO ROLE role1 IN hive", new QueryExecutor.QueryParam[0]);
        QueryExecutors.onTrino().executeQuery("GRANT role1 TO USER alice IN hive", new QueryExecutor.QueryParam[0]);
        QueryExecutors.onTrino().executeQuery("GRANT role2 TO ROLE role1 IN hive", new QueryExecutor.QueryParam[0]);
        QueryExecutors.onTrino().executeQuery("GRANT role1 TO USER alice WITH ADMIN OPTION IN hive", new QueryExecutor.QueryParam[0]);
        QueryExecutors.onTrino().executeQuery("GRANT role2 TO ROLE role1 WITH ADMIN OPTION IN hive", new QueryExecutor.QueryParam[0]);
        QueryExecutors.onTrino().executeQuery("GRANT role1 TO USER alice WITH ADMIN OPTION IN hive", new QueryExecutor.QueryParam[0]);
        QueryExecutors.onTrino().executeQuery("GRANT role2 TO ROLE role1 WITH ADMIN OPTION IN hive", new QueryExecutor.QueryParam[0]);
        ((QueryAssert)Assertions.assertThat((AssertProvider)TestRoles.onPrestoAlice().executeQuery("SELECT * FROM hive.information_schema.applicable_roles", new QueryExecutor.QueryParam[0]))).containsOnly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{"alice", "USER", "public", "NO"}), QueryAssert.Row.row((Object[])new Object[]{"alice", "USER", ROLE1, "YES"}), QueryAssert.Row.row((Object[])new Object[]{ROLE1, "ROLE", ROLE2, "YES"})});
    }

    @Test(groups={"authorization", "profile_specific_tests"})
    public void testRevokeRoleFromUser() {
        QueryExecutors.onTrino().executeQuery("CREATE ROLE role1 IN hive", new QueryExecutor.QueryParam[0]);
        QueryExecutors.onTrino().executeQuery("GRANT role1 TO USER alice IN hive", new QueryExecutor.QueryParam[0]);
        ((QueryAssert)Assertions.assertThat((AssertProvider)TestRoles.onPrestoAlice().executeQuery("SELECT * FROM hive.information_schema.applicable_roles", new QueryExecutor.QueryParam[0]))).containsOnly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{"alice", "USER", "public", "NO"}), QueryAssert.Row.row((Object[])new Object[]{"alice", "USER", ROLE1, "NO"})});
        QueryExecutors.onTrino().executeQuery("REVOKE role1 FROM USER alice IN hive", new QueryExecutor.QueryParam[0]);
        ((QueryAssert)Assertions.assertThat((AssertProvider)TestRoles.onPrestoAlice().executeQuery("SELECT * FROM hive.information_schema.applicable_roles", new QueryExecutor.QueryParam[0]))).containsOnly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{"alice", "USER", "public", "NO"})});
    }

    @Test(groups={"authorization", "profile_specific_tests"})
    public void testRevokeRoleFromRole() {
        QueryExecutors.onTrino().executeQuery("CREATE ROLE role1 IN hive", new QueryExecutor.QueryParam[0]);
        QueryExecutors.onTrino().executeQuery("CREATE ROLE role2 IN hive", new QueryExecutor.QueryParam[0]);
        QueryExecutors.onTrino().executeQuery("GRANT role1 TO USER alice IN hive", new QueryExecutor.QueryParam[0]);
        QueryExecutors.onTrino().executeQuery("GRANT role2 TO ROLE role1 IN hive", new QueryExecutor.QueryParam[0]);
        ((QueryAssert)Assertions.assertThat((AssertProvider)TestRoles.onPrestoAlice().executeQuery("SELECT * FROM hive.information_schema.applicable_roles", new QueryExecutor.QueryParam[0]))).containsOnly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{"alice", "USER", "public", "NO"}), QueryAssert.Row.row((Object[])new Object[]{"alice", "USER", ROLE1, "NO"}), QueryAssert.Row.row((Object[])new Object[]{ROLE1, "ROLE", ROLE2, "NO"})});
        QueryExecutors.onTrino().executeQuery("REVOKE role2 FROM ROLE role1 IN hive", new QueryExecutor.QueryParam[0]);
        ((QueryAssert)Assertions.assertThat((AssertProvider)TestRoles.onPrestoAlice().executeQuery("SELECT * FROM hive.information_schema.applicable_roles", new QueryExecutor.QueryParam[0]))).containsOnly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{"alice", "USER", "public", "NO"}), QueryAssert.Row.row((Object[])new Object[]{"alice", "USER", ROLE1, "NO"})});
    }

    @Test(groups={"authorization", "profile_specific_tests"})
    public void testRevokeRoleFromOwner() {
        try {
            TestRoles.onPrestoAlice().executeQuery("CREATE TABLE hive.default.test_table (foo BIGINT)", new QueryExecutor.QueryParam[0]);
            ((QueryAssert)Assertions.assertThat((AssertProvider)TestRoles.onPrestoAlice().executeQuery("SHOW GRANTS ON hive.default.test_table", new QueryExecutor.QueryParam[0]))).containsOnly((List)ImmutableList.of((Object)QueryAssert.Row.row((Object[])new Object[]{"alice", "USER", "alice", "USER", "hive", "default", "test_table", "SELECT", "YES", null}), (Object)QueryAssert.Row.row((Object[])new Object[]{"alice", "USER", "alice", "USER", "hive", "default", "test_table", "DELETE", "YES", null}), (Object)QueryAssert.Row.row((Object[])new Object[]{"alice", "USER", "alice", "USER", "hive", "default", "test_table", "UPDATE", "YES", null}), (Object)QueryAssert.Row.row((Object[])new Object[]{"alice", "USER", "alice", "USER", "hive", "default", "test_table", "INSERT", "YES", null})));
            QueryExecutors.onTrino().executeQuery("REVOKE SELECT ON hive.default.test_table FROM USER alice", new QueryExecutor.QueryParam[0]);
            ((QueryAssert)Assertions.assertThat((AssertProvider)TestRoles.onPrestoAlice().executeQuery("SHOW GRANTS ON hive.default.test_table", new QueryExecutor.QueryParam[0]))).containsOnly((List)ImmutableList.of((Object)QueryAssert.Row.row((Object[])new Object[]{"alice", "USER", "alice", "USER", "hive", "default", "test_table", "DELETE", "YES", null}), (Object)QueryAssert.Row.row((Object[])new Object[]{"alice", "USER", "alice", "USER", "hive", "default", "test_table", "UPDATE", "YES", null}), (Object)QueryAssert.Row.row((Object[])new Object[]{"alice", "USER", "alice", "USER", "hive", "default", "test_table", "INSERT", "YES", null})));
        }
        finally {
            TestRoles.onPrestoAlice().executeQuery("DROP TABLE IF EXISTS hive.default.test_table", new QueryExecutor.QueryParam[0]);
        }
    }

    @Test(groups={"authorization", "profile_specific_tests"})
    public void testDropGrantedRole() {
        QueryExecutors.onTrino().executeQuery("CREATE ROLE role1 IN hive", new QueryExecutor.QueryParam[0]);
        QueryExecutors.onTrino().executeQuery("GRANT role1 TO USER alice IN hive", new QueryExecutor.QueryParam[0]);
        ((QueryAssert)Assertions.assertThat((AssertProvider)TestRoles.onPrestoAlice().executeQuery("SELECT * FROM hive.information_schema.applicable_roles", new QueryExecutor.QueryParam[0]))).containsOnly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{"alice", "USER", "public", "NO"}), QueryAssert.Row.row((Object[])new Object[]{"alice", "USER", ROLE1, "NO"})});
        QueryExecutors.onTrino().executeQuery("DROP ROLE role1 IN hive", new QueryExecutor.QueryParam[0]);
        ((QueryAssert)Assertions.assertThat((AssertProvider)TestRoles.onPrestoAlice().executeQuery("SELECT * FROM hive.information_schema.applicable_roles", new QueryExecutor.QueryParam[0]))).containsOnly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{"alice", "USER", "public", "NO"})});
    }

    @Test(groups={"authorization", "profile_specific_tests"})
    public void testRevokeTransitiveRoleFromUser() {
        QueryExecutors.onTrino().executeQuery("CREATE ROLE role1 IN hive", new QueryExecutor.QueryParam[0]);
        QueryExecutors.onTrino().executeQuery("CREATE ROLE role2 IN hive", new QueryExecutor.QueryParam[0]);
        QueryExecutors.onTrino().executeQuery("GRANT role1 TO USER alice IN hive", new QueryExecutor.QueryParam[0]);
        QueryExecutors.onTrino().executeQuery("GRANT role2 TO ROLE role1 IN hive", new QueryExecutor.QueryParam[0]);
        ((QueryAssert)Assertions.assertThat((AssertProvider)TestRoles.onPrestoAlice().executeQuery("SELECT * FROM hive.information_schema.applicable_roles", new QueryExecutor.QueryParam[0]))).containsOnly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{"alice", "USER", "public", "NO"}), QueryAssert.Row.row((Object[])new Object[]{"alice", "USER", ROLE1, "NO"}), QueryAssert.Row.row((Object[])new Object[]{ROLE1, "ROLE", ROLE2, "NO"})});
        QueryExecutors.onTrino().executeQuery("REVOKE role1 FROM USER alice IN hive", new QueryExecutor.QueryParam[0]);
        ((QueryAssert)Assertions.assertThat((AssertProvider)TestRoles.onPrestoAlice().executeQuery("SELECT * FROM hive.information_schema.applicable_roles", new QueryExecutor.QueryParam[0]))).containsOnly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{"alice", "USER", "public", "NO"})});
    }

    @Test(groups={"authorization", "profile_specific_tests"})
    public void testRevokeTransitiveRoleFromRole() {
        QueryExecutors.onTrino().executeQuery("CREATE ROLE role1 IN hive", new QueryExecutor.QueryParam[0]);
        QueryExecutors.onTrino().executeQuery("CREATE ROLE role2 IN hive", new QueryExecutor.QueryParam[0]);
        QueryExecutors.onTrino().executeQuery("CREATE ROLE role3 IN hive", new QueryExecutor.QueryParam[0]);
        QueryExecutors.onTrino().executeQuery("GRANT role1 TO USER alice IN hive", new QueryExecutor.QueryParam[0]);
        QueryExecutors.onTrino().executeQuery("GRANT role2 TO ROLE role1 IN hive", new QueryExecutor.QueryParam[0]);
        QueryExecutors.onTrino().executeQuery("GRANT role3 TO ROLE role2 IN hive", new QueryExecutor.QueryParam[0]);
        ((QueryAssert)Assertions.assertThat((AssertProvider)TestRoles.onPrestoAlice().executeQuery("SELECT * FROM hive.information_schema.applicable_roles", new QueryExecutor.QueryParam[0]))).containsOnly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{"alice", "USER", "public", "NO"}), QueryAssert.Row.row((Object[])new Object[]{"alice", "USER", ROLE1, "NO"}), QueryAssert.Row.row((Object[])new Object[]{ROLE1, "ROLE", ROLE2, "NO"}), QueryAssert.Row.row((Object[])new Object[]{ROLE2, "ROLE", ROLE3, "NO"})});
        QueryExecutors.onTrino().executeQuery("REVOKE role2 FROM ROLE role1 IN hive", new QueryExecutor.QueryParam[0]);
        ((QueryAssert)Assertions.assertThat((AssertProvider)TestRoles.onPrestoAlice().executeQuery("SELECT * FROM hive.information_schema.applicable_roles", new QueryExecutor.QueryParam[0]))).containsOnly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{"alice", "USER", "public", "NO"}), QueryAssert.Row.row((Object[])new Object[]{"alice", "USER", ROLE1, "NO"})});
    }

    @Test(groups={"authorization", "profile_specific_tests"})
    public void testDropTransitiveRole() {
        QueryExecutors.onTrino().executeQuery("CREATE ROLE role1 IN hive", new QueryExecutor.QueryParam[0]);
        QueryExecutors.onTrino().executeQuery("CREATE ROLE role2 IN hive", new QueryExecutor.QueryParam[0]);
        QueryExecutors.onTrino().executeQuery("CREATE ROLE role3 IN hive", new QueryExecutor.QueryParam[0]);
        QueryExecutors.onTrino().executeQuery("GRANT role1 TO USER alice IN hive", new QueryExecutor.QueryParam[0]);
        QueryExecutors.onTrino().executeQuery("GRANT role2 TO ROLE role1 IN hive", new QueryExecutor.QueryParam[0]);
        QueryExecutors.onTrino().executeQuery("GRANT role3 TO ROLE role2 IN hive", new QueryExecutor.QueryParam[0]);
        ((QueryAssert)Assertions.assertThat((AssertProvider)TestRoles.onPrestoAlice().executeQuery("SELECT * FROM hive.information_schema.applicable_roles", new QueryExecutor.QueryParam[0]))).containsOnly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{"alice", "USER", "public", "NO"}), QueryAssert.Row.row((Object[])new Object[]{"alice", "USER", ROLE1, "NO"}), QueryAssert.Row.row((Object[])new Object[]{ROLE1, "ROLE", ROLE2, "NO"}), QueryAssert.Row.row((Object[])new Object[]{ROLE2, "ROLE", ROLE3, "NO"})});
        QueryExecutors.onTrino().executeQuery("DROP ROLE role2 IN hive", new QueryExecutor.QueryParam[0]);
        ((QueryAssert)Assertions.assertThat((AssertProvider)TestRoles.onPrestoAlice().executeQuery("SELECT * FROM hive.information_schema.applicable_roles", new QueryExecutor.QueryParam[0]))).containsOnly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{"alice", "USER", "public", "NO"}), QueryAssert.Row.row((Object[])new Object[]{"alice", "USER", ROLE1, "NO"})});
    }

    @Test(groups={"authorization", "profile_specific_tests"})
    public void testRevokeAdminOption() {
        QueryExecutors.onTrino().executeQuery("CREATE ROLE role1 IN hive", new QueryExecutor.QueryParam[0]);
        QueryExecutors.onTrino().executeQuery("CREATE ROLE role2 IN hive", new QueryExecutor.QueryParam[0]);
        QueryExecutors.onTrino().executeQuery("GRANT role1 TO USER alice WITH ADMIN OPTION IN hive", new QueryExecutor.QueryParam[0]);
        QueryExecutors.onTrino().executeQuery("GRANT role2 TO ROLE role1 WITH ADMIN OPTION IN hive", new QueryExecutor.QueryParam[0]);
        ((QueryAssert)Assertions.assertThat((AssertProvider)TestRoles.onPrestoAlice().executeQuery("SELECT * FROM hive.information_schema.applicable_roles", new QueryExecutor.QueryParam[0]))).containsOnly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{"alice", "USER", "public", "NO"}), QueryAssert.Row.row((Object[])new Object[]{"alice", "USER", ROLE1, "YES"}), QueryAssert.Row.row((Object[])new Object[]{ROLE1, "ROLE", ROLE2, "YES"})});
        QueryExecutors.onTrino().executeQuery("REVOKE ADMIN OPTION FOR role1 FROM USER alice IN hive", new QueryExecutor.QueryParam[0]);
        QueryExecutors.onTrino().executeQuery("REVOKE ADMIN OPTION FOR role2 FROM ROLE role1 IN hive", new QueryExecutor.QueryParam[0]);
        ((QueryAssert)Assertions.assertThat((AssertProvider)TestRoles.onPrestoAlice().executeQuery("SELECT * FROM hive.information_schema.applicable_roles", new QueryExecutor.QueryParam[0]))).containsOnly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{"alice", "USER", "public", "NO"}), QueryAssert.Row.row((Object[])new Object[]{"alice", "USER", ROLE1, "NO"}), QueryAssert.Row.row((Object[])new Object[]{ROLE1, "ROLE", ROLE2, "NO"})});
    }

    @Test(groups={"authorization", "profile_specific_tests"})
    public void testRevokeMultipleTimes() {
        QueryExecutors.onTrino().executeQuery("CREATE ROLE role1 IN hive", new QueryExecutor.QueryParam[0]);
        QueryExecutors.onTrino().executeQuery("CREATE ROLE role2 IN hive", new QueryExecutor.QueryParam[0]);
        QueryExecutors.onTrino().executeQuery("GRANT role1 TO USER alice WITH ADMIN OPTION IN hive", new QueryExecutor.QueryParam[0]);
        QueryExecutors.onTrino().executeQuery("GRANT role2 TO ROLE role1 WITH ADMIN OPTION IN hive", new QueryExecutor.QueryParam[0]);
        ((QueryAssert)Assertions.assertThat((AssertProvider)TestRoles.onPrestoAlice().executeQuery("SELECT * FROM hive.information_schema.applicable_roles", new QueryExecutor.QueryParam[0]))).containsOnly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{"alice", "USER", "public", "NO"}), QueryAssert.Row.row((Object[])new Object[]{"alice", "USER", ROLE1, "YES"}), QueryAssert.Row.row((Object[])new Object[]{ROLE1, "ROLE", ROLE2, "YES"})});
        QueryExecutors.onTrino().executeQuery("REVOKE ADMIN OPTION FOR role1 FROM USER alice IN hive", new QueryExecutor.QueryParam[0]);
        QueryExecutors.onTrino().executeQuery("REVOKE ADMIN OPTION FOR role1 FROM USER alice IN hive", new QueryExecutor.QueryParam[0]);
        QueryExecutors.onTrino().executeQuery("REVOKE ADMIN OPTION FOR role2 FROM ROLE role1 IN hive", new QueryExecutor.QueryParam[0]);
        QueryExecutors.onTrino().executeQuery("REVOKE ADMIN OPTION FOR role2 FROM ROLE role1 IN hive", new QueryExecutor.QueryParam[0]);
        ((QueryAssert)Assertions.assertThat((AssertProvider)TestRoles.onPrestoAlice().executeQuery("SELECT * FROM hive.information_schema.applicable_roles", new QueryExecutor.QueryParam[0]))).containsOnly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{"alice", "USER", "public", "NO"}), QueryAssert.Row.row((Object[])new Object[]{"alice", "USER", ROLE1, "NO"}), QueryAssert.Row.row((Object[])new Object[]{ROLE1, "ROLE", ROLE2, "NO"})});
        QueryExecutors.onTrino().executeQuery("REVOKE role1 FROM USER alice IN hive", new QueryExecutor.QueryParam[0]);
        QueryExecutors.onTrino().executeQuery("REVOKE role1 FROM USER alice IN hive", new QueryExecutor.QueryParam[0]);
        QueryExecutors.onTrino().executeQuery("REVOKE role2 FROM ROLE role1 IN hive", new QueryExecutor.QueryParam[0]);
        QueryExecutors.onTrino().executeQuery("REVOKE role2 FROM ROLE role1 IN hive", new QueryExecutor.QueryParam[0]);
        ((QueryAssert)Assertions.assertThat((AssertProvider)TestRoles.onPrestoAlice().executeQuery("SELECT * FROM hive.information_schema.applicable_roles", new QueryExecutor.QueryParam[0]))).containsOnly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{"alice", "USER", "public", "NO"})});
    }

    @Test(groups={"authorization", "profile_specific_tests"})
    public void testGrantRevokeRoleAccessControl() {
        QueryExecutors.onTrino().executeQuery("CREATE ROLE role1 IN hive", new QueryExecutor.QueryParam[0]);
        QueryExecutors.onTrino().executeQuery("CREATE ROLE role2 IN hive", new QueryExecutor.QueryParam[0]);
        QueryAssert.assertQueryFailure(() -> TestRoles.onPrestoAlice().executeQuery("GRANT role1 TO USER bob IN hive", new QueryExecutor.QueryParam[0])).hasMessageContaining("Cannot grant roles [role1] to [USER bob]");
        QueryAssert.assertQueryFailure(() -> TestRoles.onPrestoAlice().executeQuery("GRANT role1 TO USER bob WITH ADMIN OPTION IN hive", new QueryExecutor.QueryParam[0])).hasMessageContaining("Cannot grant roles [role1] to [USER bob]");
        QueryAssert.assertQueryFailure(() -> TestRoles.onPrestoAlice().executeQuery("REVOKE role1 FROM USER bob IN hive", new QueryExecutor.QueryParam[0])).hasMessageContaining("Cannot revoke roles [role1] from [USER bob]");
        QueryAssert.assertQueryFailure(() -> TestRoles.onPrestoAlice().executeQuery("REVOKE ADMIN OPTION FOR role1 FROM USER bob IN hive", new QueryExecutor.QueryParam[0])).hasMessageContaining("Cannot revoke roles [role1] from [USER bob]");
        QueryExecutors.onTrino().executeQuery("GRANT role1 TO USER alice WITH ADMIN OPTION IN hive", new QueryExecutor.QueryParam[0]);
        TestRoles.onPrestoAlice().executeQuery("GRANT role1 TO USER bob IN hive", new QueryExecutor.QueryParam[0]);
        TestRoles.onPrestoAlice().executeQuery("GRANT role1 TO USER bob WITH ADMIN OPTION IN hive", new QueryExecutor.QueryParam[0]);
        TestRoles.onPrestoAlice().executeQuery("REVOKE ADMIN OPTION FOR role1 FROM USER bob IN hive", new QueryExecutor.QueryParam[0]);
        TestRoles.onPrestoAlice().executeQuery("REVOKE role1 FROM USER bob IN hive", new QueryExecutor.QueryParam[0]);
        QueryExecutors.onTrino().executeQuery("REVOKE ADMIN OPTION FOR role1 FROM USER alice IN hive", new QueryExecutor.QueryParam[0]);
        QueryAssert.assertQueryFailure(() -> TestRoles.onPrestoAlice().executeQuery("GRANT role1 TO USER bob IN hive", new QueryExecutor.QueryParam[0])).hasMessageContaining("Cannot grant roles [role1] to [USER bob]");
        QueryAssert.assertQueryFailure(() -> TestRoles.onPrestoAlice().executeQuery("GRANT role1 TO USER bob WITH ADMIN OPTION IN hive", new QueryExecutor.QueryParam[0])).hasMessageContaining("Cannot grant roles [role1] to [USER bob]");
        QueryAssert.assertQueryFailure(() -> TestRoles.onPrestoAlice().executeQuery("REVOKE role1 FROM USER bob IN hive", new QueryExecutor.QueryParam[0])).hasMessageContaining("Cannot revoke roles [role1] from [USER bob]");
        QueryAssert.assertQueryFailure(() -> TestRoles.onPrestoAlice().executeQuery("REVOKE ADMIN OPTION FOR role1 FROM USER bob IN hive", new QueryExecutor.QueryParam[0])).hasMessageContaining("Cannot revoke roles [role1] from [USER bob]");
        QueryExecutors.onTrino().executeQuery("GRANT role2 TO USER alice IN hive", new QueryExecutor.QueryParam[0]);
        QueryExecutors.onTrino().executeQuery("GRANT role1 TO ROLE role2 WITH ADMIN OPTION IN hive", new QueryExecutor.QueryParam[0]);
        TestRoles.onPrestoAlice().executeQuery("GRANT role1 TO USER bob IN hive", new QueryExecutor.QueryParam[0]);
        TestRoles.onPrestoAlice().executeQuery("GRANT role1 TO USER bob WITH ADMIN OPTION IN hive", new QueryExecutor.QueryParam[0]);
        TestRoles.onPrestoAlice().executeQuery("REVOKE ADMIN OPTION FOR role1 FROM USER bob IN hive", new QueryExecutor.QueryParam[0]);
        TestRoles.onPrestoAlice().executeQuery("REVOKE role1 FROM USER bob IN hive", new QueryExecutor.QueryParam[0]);
        TestRoles.onPrestoAlice().executeQuery("REVOKE ADMIN OPTION FOR role1 FROM ROLE role2 IN hive", new QueryExecutor.QueryParam[0]);
        QueryAssert.assertQueryFailure(() -> TestRoles.onPrestoAlice().executeQuery("GRANT role1 TO USER bob IN hive", new QueryExecutor.QueryParam[0])).hasMessageContaining("Cannot grant roles [role1] to [USER bob]");
        QueryAssert.assertQueryFailure(() -> TestRoles.onPrestoAlice().executeQuery("GRANT role1 TO USER bob WITH ADMIN OPTION IN hive", new QueryExecutor.QueryParam[0])).hasMessageContaining("Cannot grant roles [role1] to [USER bob]");
        QueryAssert.assertQueryFailure(() -> TestRoles.onPrestoAlice().executeQuery("REVOKE role1 FROM USER bob IN hive", new QueryExecutor.QueryParam[0])).hasMessageContaining("Cannot revoke roles [role1] from [USER bob]");
        QueryAssert.assertQueryFailure(() -> TestRoles.onPrestoAlice().executeQuery("REVOKE ADMIN OPTION FOR role1 FROM USER bob IN hive", new QueryExecutor.QueryParam[0])).hasMessageContaining("Cannot revoke roles [role1] from [USER bob]");
    }

    @Test(groups={"authorization", "profile_specific_tests"})
    public void testSetRole() {
        QueryExecutors.onTrino().executeQuery("CREATE ROLE role1 IN hive", new QueryExecutor.QueryParam[0]);
        QueryExecutors.onTrino().executeQuery("CREATE ROLE role2 IN hive", new QueryExecutor.QueryParam[0]);
        QueryExecutors.onTrino().executeQuery("CREATE ROLE role3 IN hive", new QueryExecutor.QueryParam[0]);
        QueryExecutors.onTrino().executeQuery("GRANT role1 TO USER alice IN hive", new QueryExecutor.QueryParam[0]);
        QueryExecutors.onTrino().executeQuery("GRANT role2 TO ROLE role1 IN hive", new QueryExecutor.QueryParam[0]);
        QueryExecutors.onTrino().executeQuery("GRANT role3 TO ROLE role2 IN hive", new QueryExecutor.QueryParam[0]);
        TestRoles.onPrestoAlice().executeQuery("SET ROLE ALL IN hive", new QueryExecutor.QueryParam[0]);
        ((QueryAssert)Assertions.assertThat((AssertProvider)TestRoles.onPrestoAlice().executeQuery("SELECT * FROM hive.information_schema.enabled_roles", new QueryExecutor.QueryParam[0]))).containsOnly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{"public"}), QueryAssert.Row.row((Object[])new Object[]{ROLE1}), QueryAssert.Row.row((Object[])new Object[]{ROLE2}), QueryAssert.Row.row((Object[])new Object[]{ROLE3})});
        TestRoles.onPrestoAlice().executeQuery("SET ROLE NONE IN hive", new QueryExecutor.QueryParam[0]);
        ((QueryAssert)Assertions.assertThat((AssertProvider)TestRoles.onPrestoAlice().executeQuery("SELECT * FROM hive.information_schema.enabled_roles", new QueryExecutor.QueryParam[0]))).containsOnly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{"public"})});
        TestRoles.onPrestoAlice().executeQuery("SET ROLE role1 IN hive", new QueryExecutor.QueryParam[0]);
        ((QueryAssert)Assertions.assertThat((AssertProvider)TestRoles.onPrestoAlice().executeQuery("SELECT * FROM hive.information_schema.enabled_roles", new QueryExecutor.QueryParam[0]))).containsOnly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{"public"}), QueryAssert.Row.row((Object[])new Object[]{ROLE1}), QueryAssert.Row.row((Object[])new Object[]{ROLE2}), QueryAssert.Row.row((Object[])new Object[]{ROLE3})});
        TestRoles.onPrestoAlice().executeQuery("SET ROLE role2 IN hive", new QueryExecutor.QueryParam[0]);
        ((QueryAssert)Assertions.assertThat((AssertProvider)TestRoles.onPrestoAlice().executeQuery("SELECT * FROM hive.information_schema.enabled_roles", new QueryExecutor.QueryParam[0]))).containsOnly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{"public"}), QueryAssert.Row.row((Object[])new Object[]{ROLE2}), QueryAssert.Row.row((Object[])new Object[]{ROLE3})});
        TestRoles.onPrestoAlice().executeQuery("SET ROLE role3 IN hive", new QueryExecutor.QueryParam[0]);
        ((QueryAssert)Assertions.assertThat((AssertProvider)TestRoles.onPrestoAlice().executeQuery("SELECT * FROM hive.information_schema.enabled_roles", new QueryExecutor.QueryParam[0]))).containsOnly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{"public"}), QueryAssert.Row.row((Object[])new Object[]{ROLE3})});
    }

    @Test(groups={"authorization", "profile_specific_tests"})
    public void testSetAdminRole() {
        QueryExecutors.onTrino().executeQuery("SET ROLE NONE IN hive", new QueryExecutor.QueryParam[0]);
        ((QueryAssert)Assertions.assertThat((AssertProvider)QueryExecutors.onTrino().executeQuery("SELECT * FROM hive.information_schema.enabled_roles", new QueryExecutor.QueryParam[0]))).containsOnly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{"public"})});
        QueryExecutors.onTrino().executeQuery("SET ROLE admin IN hive", new QueryExecutor.QueryParam[0]);
        ((QueryAssert)Assertions.assertThat((AssertProvider)QueryExecutors.onTrino().executeQuery("SELECT * FROM hive.information_schema.enabled_roles", new QueryExecutor.QueryParam[0]))).containsOnly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{"public"}), QueryAssert.Row.row((Object[])new Object[]{"admin"})});
    }

    @Test(groups={"authorization", "profile_specific_tests"})
    public void testShowRoles() {
        ((QueryAssert)Assertions.assertThat((AssertProvider)QueryExecutors.onTrino().executeQuery("SHOW ROLES FROM hive", new QueryExecutor.QueryParam[0]))).containsOnly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{"public"}), QueryAssert.Row.row((Object[])new Object[]{"admin"})});
        QueryExecutors.onTrino().executeQuery("CREATE ROLE role1 IN hive", new QueryExecutor.QueryParam[0]);
        ((QueryAssert)Assertions.assertThat((AssertProvider)QueryExecutors.onTrino().executeQuery("SHOW ROLES FROM hive", new QueryExecutor.QueryParam[0]))).containsOnly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{"public"}), QueryAssert.Row.row((Object[])new Object[]{"admin"}), QueryAssert.Row.row((Object[])new Object[]{ROLE1})});
        QueryAssert.assertQueryFailure(() -> TestRoles.onPrestoAlice().executeQuery("SHOW ROLES FROM hive", new QueryExecutor.QueryParam[0])).hasMessageContaining("Cannot show roles");
        QueryExecutors.onTrino().executeQuery("GRANT admin TO alice IN hive", new QueryExecutor.QueryParam[0]);
        TestRoles.onPrestoAlice().executeQuery("SET ROLE admin IN hive", new QueryExecutor.QueryParam[0]);
        ((QueryAssert)Assertions.assertThat((AssertProvider)TestRoles.onPrestoAlice().executeQuery("SHOW ROLES FROM hive", new QueryExecutor.QueryParam[0]))).containsOnly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{"public"}), QueryAssert.Row.row((Object[])new Object[]{"admin"}), QueryAssert.Row.row((Object[])new Object[]{ROLE1})});
    }

    @Test(groups={"authorization", "profile_specific_tests"})
    public void testShowCurrentRoles() {
        ((QueryAssert)Assertions.assertThat((AssertProvider)TestRoles.onPrestoAlice().executeQuery("SHOW CURRENT ROLES FROM hive", new QueryExecutor.QueryParam[0]))).containsOnly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{"public"})});
        QueryExecutors.onTrino().executeQuery("CREATE ROLE role1 IN hive", new QueryExecutor.QueryParam[0]);
        QueryExecutors.onTrino().executeQuery("CREATE ROLE role2 IN hive", new QueryExecutor.QueryParam[0]);
        QueryExecutors.onTrino().executeQuery("GRANT role1 TO alice IN hive", new QueryExecutor.QueryParam[0]);
        QueryExecutors.onTrino().executeQuery("GRANT role2 TO alice IN hive", new QueryExecutor.QueryParam[0]);
        ((QueryAssert)Assertions.assertThat((AssertProvider)TestRoles.onPrestoAlice().executeQuery("SHOW CURRENT ROLES FROM hive", new QueryExecutor.QueryParam[0]))).containsOnly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{"public"}), QueryAssert.Row.row((Object[])new Object[]{ROLE1}), QueryAssert.Row.row((Object[])new Object[]{ROLE2})});
        TestRoles.onPrestoAlice().executeQuery("SET ROLE role2 IN hive", new QueryExecutor.QueryParam[0]);
        ((QueryAssert)Assertions.assertThat((AssertProvider)TestRoles.onPrestoAlice().executeQuery("SHOW CURRENT ROLES FROM hive", new QueryExecutor.QueryParam[0]))).containsOnly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{"public"}), QueryAssert.Row.row((Object[])new Object[]{ROLE2})});
    }

    @Test(groups={"authorization", "profile_specific_tests"})
    public void testShowRoleGrants() {
        ((QueryAssert)Assertions.assertThat((AssertProvider)QueryExecutors.onTrino().executeQuery("SHOW ROLE GRANTS FROM hive", new QueryExecutor.QueryParam[0]))).containsOnly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{"public"}), QueryAssert.Row.row((Object[])new Object[]{"admin"})});
        ((QueryAssert)Assertions.assertThat((AssertProvider)TestRoles.onPrestoAlice().executeQuery("SHOW ROLE GRANTS FROM hive", new QueryExecutor.QueryParam[0]))).containsOnly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{"public"})});
        QueryExecutors.onTrino().executeQuery("CREATE ROLE role1 IN hive", new QueryExecutor.QueryParam[0]);
        QueryExecutors.onTrino().executeQuery("CREATE ROLE role2 IN hive", new QueryExecutor.QueryParam[0]);
        QueryExecutors.onTrino().executeQuery("GRANT role1 TO alice IN hive", new QueryExecutor.QueryParam[0]);
        QueryExecutors.onTrino().executeQuery("GRANT role2 TO role1 IN hive", new QueryExecutor.QueryParam[0]);
        ((QueryAssert)Assertions.assertThat((AssertProvider)QueryExecutors.onTrino().executeQuery("SHOW ROLE GRANTS FROM hive", new QueryExecutor.QueryParam[0]))).containsOnly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{"public"}), QueryAssert.Row.row((Object[])new Object[]{"admin"})});
        ((QueryAssert)Assertions.assertThat((AssertProvider)TestRoles.onPrestoAlice().executeQuery("SHOW ROLE GRANTS FROM hive", new QueryExecutor.QueryParam[0]))).containsOnly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{"public"}), QueryAssert.Row.row((Object[])new Object[]{ROLE1})});
    }

    @Test(groups={"authorization", "profile_specific_tests"})
    public void testSetRoleCreateDropSchema() {
        TestRoles.assertAdminExecute("CREATE SCHEMA hive.test_admin_schema");
        QueryExecutors.onTrino().executeQuery("DROP SCHEMA hive.test_admin_schema", new QueryExecutor.QueryParam[0]);
    }

    @Test(groups={"authorization", "profile_specific_tests"})
    public void testAdminCanDropAnyTable() {
        TestRoles.onPrestoAlice().executeQuery("CREATE TABLE hive.default.test_table (foo BIGINT)", new QueryExecutor.QueryParam[0]);
        TestRoles.assertAdminExecute("DROP TABLE hive.default.test_table");
    }

    @Test(groups={"authorization", "profile_specific_tests"})
    public void testAdminCanRenameAnyTable() {
        TestRoles.onPrestoAlice().executeQuery("CREATE TABLE hive.default.test_table (foo BIGINT)", new QueryExecutor.QueryParam[0]);
        TestRoles.assertAdminExecute("ALTER TABLE hive.default.test_table RENAME TO hive.default.test_table_1");
        TestRoles.onPrestoAlice().executeQuery("DROP TABLE hive.default.test_table_1", new QueryExecutor.QueryParam[0]);
    }

    @Test(groups={"authorization", "profile_specific_tests"})
    public void testAdminCanAddColumnToAnyTable() {
        TestRoles.onPrestoAlice().executeQuery("CREATE TABLE hive.default.test_table (foo BIGINT)", new QueryExecutor.QueryParam[0]);
        TestRoles.assertAdminExecute("ALTER TABLE hive.default.test_table ADD COLUMN bar DATE");
        TestRoles.onPrestoAlice().executeQuery("DROP TABLE hive.default.test_table", new QueryExecutor.QueryParam[0]);
    }

    @Test(groups={"authorization", "profile_specific_tests"})
    public void testAdminCanRenameColumnInAnyTable() {
        TestRoles.onPrestoAlice().executeQuery("CREATE TABLE hive.default.test_table (foo BIGINT)", new QueryExecutor.QueryParam[0]);
        TestRoles.assertAdminExecute("ALTER TABLE hive.default.test_table RENAME COLUMN foo TO bar");
        TestRoles.onPrestoAlice().executeQuery("DROP TABLE hive.default.test_table", new QueryExecutor.QueryParam[0]);
    }

    @Test(groups={"authorization", "profile_specific_tests"})
    public void testAdminCanShowAllGrants() {
        try {
            TestRoles.onPrestoBob().executeQuery("CREATE TABLE hive.default.test_table_bob (foo BIGINT)", new QueryExecutor.QueryParam[0]);
            TestRoles.onPrestoAlice().executeQuery("CREATE TABLE hive.default.test_table_alice (foo BIGINT)", new QueryExecutor.QueryParam[0]);
            QueryExecutors.onTrino().executeQuery("GRANT admin TO alice IN hive", new QueryExecutor.QueryParam[0]);
            TestRoles.onPrestoAlice().executeQuery("SET ROLE ADMIN IN hive", new QueryExecutor.QueryParam[0]);
            ((QueryAssert)Assertions.assertThat((AssertProvider)TestRoles.onPrestoAlice().executeQuery("SHOW GRANTS ON hive.default.test_table_alice", new QueryExecutor.QueryParam[0]))).containsOnly((List)ImmutableList.of((Object)QueryAssert.Row.row((Object[])new Object[]{"alice", "USER", "alice", "USER", "hive", "default", "test_table_alice", "SELECT", "YES", null}), (Object)QueryAssert.Row.row((Object[])new Object[]{"alice", "USER", "alice", "USER", "hive", "default", "test_table_alice", "DELETE", "YES", null}), (Object)QueryAssert.Row.row((Object[])new Object[]{"alice", "USER", "alice", "USER", "hive", "default", "test_table_alice", "UPDATE", "YES", null}), (Object)QueryAssert.Row.row((Object[])new Object[]{"alice", "USER", "alice", "USER", "hive", "default", "test_table_alice", "INSERT", "YES", null})));
            ((QueryAssert)Assertions.assertThat((AssertProvider)TestRoles.onPrestoAlice().executeQuery("SHOW GRANTS ON hive.default.test_table_bob", new QueryExecutor.QueryParam[0]))).containsOnly((List)ImmutableList.of((Object)QueryAssert.Row.row((Object[])new Object[]{"bob", "USER", "bob", "USER", "hive", "default", "test_table_bob", "SELECT", "YES", null}), (Object)QueryAssert.Row.row((Object[])new Object[]{"bob", "USER", "bob", "USER", "hive", "default", "test_table_bob", "DELETE", "YES", null}), (Object)QueryAssert.Row.row((Object[])new Object[]{"bob", "USER", "bob", "USER", "hive", "default", "test_table_bob", "UPDATE", "YES", null}), (Object)QueryAssert.Row.row((Object[])new Object[]{"bob", "USER", "bob", "USER", "hive", "default", "test_table_bob", "INSERT", "YES", null})));
            TestRoles.onPrestoAlice().executeQuery("GRANT SELECT ON hive.default.test_table_alice  TO bob WITH GRANT OPTION", new QueryExecutor.QueryParam[0]);
            TestRoles.onPrestoAlice().executeQuery("GRANT INSERT ON hive.default.test_table_alice  TO bob", new QueryExecutor.QueryParam[0]);
            ((QueryAssert)Assertions.assertThat((AssertProvider)TestRoles.onPrestoAlice().executeQuery("SHOW GRANTS ON hive.default.test_table_alice", new QueryExecutor.QueryParam[0]))).containsOnly((List)ImmutableList.of((Object)QueryAssert.Row.row((Object[])new Object[]{"alice", "USER", "alice", "USER", "hive", "default", "test_table_alice", "SELECT", "YES", null}), (Object)QueryAssert.Row.row((Object[])new Object[]{"alice", "USER", "alice", "USER", "hive", "default", "test_table_alice", "DELETE", "YES", null}), (Object)QueryAssert.Row.row((Object[])new Object[]{"alice", "USER", "alice", "USER", "hive", "default", "test_table_alice", "UPDATE", "YES", null}), (Object)QueryAssert.Row.row((Object[])new Object[]{"alice", "USER", "alice", "USER", "hive", "default", "test_table_alice", "INSERT", "YES", null}), (Object)QueryAssert.Row.row((Object[])new Object[]{"alice", "USER", "bob", "USER", "hive", "default", "test_table_alice", "SELECT", "YES", null}), (Object)QueryAssert.Row.row((Object[])new Object[]{"alice", "USER", "bob", "USER", "hive", "default", "test_table_alice", "INSERT", "NO", null})));
        }
        finally {
            TestRoles.onPrestoAlice().executeQuery("DROP TABLE IF EXISTS hive.default.test_table_alice", new QueryExecutor.QueryParam[0]);
            TestRoles.onPrestoBob().executeQuery("DROP TABLE IF EXISTS hive.default.test_table_bob", new QueryExecutor.QueryParam[0]);
            QueryExecutors.onTrino().executeQuery("REVOKE admin FROM alice IN hive", new QueryExecutor.QueryParam[0]);
        }
    }

    @Test(groups={"authorization", "profile_specific_tests"})
    public void testAdminCanShowGrantsOnlyFromCurrentSchema() {
        try {
            TestRoles.onPrestoBob().executeQuery("CREATE TABLE hive.default.test_table_bob (foo BIGINT)", new QueryExecutor.QueryParam[0]);
            QueryExecutors.onTrino().executeQuery("CREATE SCHEMA hive.test", new QueryExecutor.QueryParam[0]);
            QueryExecutors.onTrino().executeQuery("GRANT admin TO alice IN hive", new QueryExecutor.QueryParam[0]);
            TestRoles.onPrestoAlice().executeQuery("SET ROLE ADMIN IN hive", new QueryExecutor.QueryParam[0]);
            TestRoles.onPrestoAlice().executeQuery("CREATE TABLE hive.test.test_table_bob (foo BIGINT) with (external_location='/tmp')", new QueryExecutor.QueryParam[0]);
            ((QueryAssert)Assertions.assertThat((AssertProvider)TestRoles.onPrestoAlice().executeQuery("SHOW GRANTS ON hive.default.test_table_bob", new QueryExecutor.QueryParam[0]))).containsOnly((List)ImmutableList.of((Object)QueryAssert.Row.row((Object[])new Object[]{"bob", "USER", "bob", "USER", "hive", "default", "test_table_bob", "SELECT", "YES", null}), (Object)QueryAssert.Row.row((Object[])new Object[]{"bob", "USER", "bob", "USER", "hive", "default", "test_table_bob", "DELETE", "YES", null}), (Object)QueryAssert.Row.row((Object[])new Object[]{"bob", "USER", "bob", "USER", "hive", "default", "test_table_bob", "UPDATE", "YES", null}), (Object)QueryAssert.Row.row((Object[])new Object[]{"bob", "USER", "bob", "USER", "hive", "default", "test_table_bob", "INSERT", "YES", null})));
            ((QueryAssert)Assertions.assertThat((AssertProvider)TestRoles.onPrestoAlice().executeQuery("SHOW GRANTS ON hive.test.test_table_bob", new QueryExecutor.QueryParam[0]))).containsOnly((List)ImmutableList.of((Object)QueryAssert.Row.row((Object[])new Object[]{"alice", "USER", "alice", "USER", "hive", "test", "test_table_bob", "SELECT", "YES", null}), (Object)QueryAssert.Row.row((Object[])new Object[]{"alice", "USER", "alice", "USER", "hive", "test", "test_table_bob", "DELETE", "YES", null}), (Object)QueryAssert.Row.row((Object[])new Object[]{"alice", "USER", "alice", "USER", "hive", "test", "test_table_bob", "UPDATE", "YES", null}), (Object)QueryAssert.Row.row((Object[])new Object[]{"alice", "USER", "alice", "USER", "hive", "test", "test_table_bob", "INSERT", "YES", null})));
            ((QueryAssert)Assertions.assertThat((AssertProvider)TestRoles.onPrestoAlice().executeQuery("SELECT * FROM hive.information_schema.table_privileges where table_name = 'test_table_bob'", new QueryExecutor.QueryParam[0]))).containsOnly((List)ImmutableList.of((Object)QueryAssert.Row.row((Object[])new Object[]{"bob", "USER", "bob", "USER", "hive", "default", "test_table_bob", "SELECT", "YES", null}), (Object)QueryAssert.Row.row((Object[])new Object[]{"bob", "USER", "bob", "USER", "hive", "default", "test_table_bob", "DELETE", "YES", null}), (Object)QueryAssert.Row.row((Object[])new Object[]{"bob", "USER", "bob", "USER", "hive", "default", "test_table_bob", "UPDATE", "YES", null}), (Object)QueryAssert.Row.row((Object[])new Object[]{"bob", "USER", "bob", "USER", "hive", "default", "test_table_bob", "INSERT", "YES", null}), (Object)QueryAssert.Row.row((Object[])new Object[]{"alice", "USER", "alice", "USER", "hive", "test", "test_table_bob", "SELECT", "YES", null}), (Object)QueryAssert.Row.row((Object[])new Object[]{"alice", "USER", "alice", "USER", "hive", "test", "test_table_bob", "DELETE", "YES", null}), (Object)QueryAssert.Row.row((Object[])new Object[]{"alice", "USER", "alice", "USER", "hive", "test", "test_table_bob", "UPDATE", "YES", null}), (Object)QueryAssert.Row.row((Object[])new Object[]{"alice", "USER", "alice", "USER", "hive", "test", "test_table_bob", "INSERT", "YES", null})));
        }
        finally {
            TestRoles.onPrestoBob().executeQuery("DROP TABLE IF EXISTS hive.default.test_table_bob", new QueryExecutor.QueryParam[0]);
            TestRoles.onPrestoAlice().executeQuery("DROP TABLE IF EXISTS hive.test.test_table_bob", new QueryExecutor.QueryParam[0]);
            QueryExecutors.onTrino().executeQuery("DROP SCHEMA IF EXISTS hive.test", new QueryExecutor.QueryParam[0]);
            QueryExecutors.onTrino().executeQuery("REVOKE admin FROM alice IN hive", new QueryExecutor.QueryParam[0]);
        }
    }

    @Test(groups={"authorization", "profile_specific_tests"})
    public void testSetRoleTablePermissions() {
        QueryExecutors.onTrino().executeQuery("CREATE ROLE role1 IN hive", new QueryExecutor.QueryParam[0]);
        QueryExecutors.onTrino().executeQuery("CREATE ROLE role2 IN hive", new QueryExecutor.QueryParam[0]);
        QueryExecutors.onTrino().executeQuery("GRANT role1 TO USER bob IN hive", new QueryExecutor.QueryParam[0]);
        QueryExecutors.onTrino().executeQuery("GRANT role2 TO USER bob IN hive", new QueryExecutor.QueryParam[0]);
        TestRoles.onPrestoAlice().executeQuery("CREATE TABLE hive.default.test_table (foo BIGINT)", new QueryExecutor.QueryParam[0]);
        TestRoles.onPrestoAlice().executeQuery("GRANT SELECT ON hive.default.test_table TO ROLE role1", new QueryExecutor.QueryParam[0]);
        TestRoles.onPrestoAlice().executeQuery("GRANT INSERT ON hive.default.test_table TO ROLE role2", new QueryExecutor.QueryParam[0]);
        String select = "SELECT * FROM hive.default.test_table";
        String insert = "INSERT INTO hive.default.test_table (foo) VALUES (1)";
        TestRoles.assertAdminExecute(select);
        TestRoles.assertAdminExecute(insert);
        TestRoles.onPrestoBob().executeQuery(select, new QueryExecutor.QueryParam[0]);
        TestRoles.onPrestoBob().executeQuery(insert, new QueryExecutor.QueryParam[0]);
        ((QueryAssert)Assertions.assertThat((AssertProvider)TestRoles.onPrestoBob().executeQuery("SHOW GRANTS ON hive.default.test_table", new QueryExecutor.QueryParam[0]))).containsOnly((List)ImmutableList.of((Object)QueryAssert.Row.row((Object[])new Object[]{"alice", "USER", ROLE1, "ROLE", "hive", "default", "test_table", "SELECT", "NO", null}), (Object)QueryAssert.Row.row((Object[])new Object[]{"alice", "USER", ROLE2, "ROLE", "hive", "default", "test_table", "INSERT", "NO", null})));
        TestRoles.onPrestoBob().executeQuery("SET ROLE ALL IN hive", new QueryExecutor.QueryParam[0]);
        TestRoles.onPrestoBob().executeQuery(select, new QueryExecutor.QueryParam[0]);
        TestRoles.onPrestoBob().executeQuery(insert, new QueryExecutor.QueryParam[0]);
        ((QueryAssert)Assertions.assertThat((AssertProvider)TestRoles.onPrestoBob().executeQuery("SHOW GRANTS ON hive.default.test_table", new QueryExecutor.QueryParam[0]))).containsOnly((List)ImmutableList.of((Object)QueryAssert.Row.row((Object[])new Object[]{"alice", "USER", ROLE1, "ROLE", "hive", "default", "test_table", "SELECT", "NO", null}), (Object)QueryAssert.Row.row((Object[])new Object[]{"alice", "USER", ROLE2, "ROLE", "hive", "default", "test_table", "INSERT", "NO", null})));
        TestRoles.onPrestoBob().executeQuery("SET ROLE NONE IN hive", new QueryExecutor.QueryParam[0]);
        QueryAssert.assertQueryFailure(() -> TestRoles.onPrestoBob().executeQuery(select, new QueryExecutor.QueryParam[0])).hasMessageContaining("Access Denied");
        QueryAssert.assertQueryFailure(() -> TestRoles.onPrestoBob().executeQuery(insert, new QueryExecutor.QueryParam[0])).hasMessageContaining("Access Denied");
        ((QueryAssert)Assertions.assertThat((AssertProvider)TestRoles.onPrestoBob().executeQuery("SHOW GRANTS ON hive.default.test_table", new QueryExecutor.QueryParam[0]))).containsOnly((List)ImmutableList.of());
        TestRoles.onPrestoBob().executeQuery("SET ROLE role1 IN hive", new QueryExecutor.QueryParam[0]);
        TestRoles.onPrestoBob().executeQuery(select, new QueryExecutor.QueryParam[0]);
        QueryAssert.assertQueryFailure(() -> TestRoles.onPrestoBob().executeQuery(insert, new QueryExecutor.QueryParam[0])).hasMessageContaining("Access Denied");
        ((QueryAssert)Assertions.assertThat((AssertProvider)TestRoles.onPrestoBob().executeQuery("SHOW GRANTS ON hive.default.test_table", new QueryExecutor.QueryParam[0]))).containsOnly((List)ImmutableList.of((Object)QueryAssert.Row.row((Object[])new Object[]{"alice", "USER", ROLE1, "ROLE", "hive", "default", "test_table", "SELECT", "NO", null})));
        TestRoles.onPrestoBob().executeQuery("SET ROLE role2 IN hive", new QueryExecutor.QueryParam[0]);
        QueryAssert.assertQueryFailure(() -> TestRoles.onPrestoBob().executeQuery(select, new QueryExecutor.QueryParam[0])).hasMessageContaining("Access Denied");
        TestRoles.onPrestoBob().executeQuery(insert, new QueryExecutor.QueryParam[0]);
        ((QueryAssert)Assertions.assertThat((AssertProvider)TestRoles.onPrestoBob().executeQuery("SHOW GRANTS ON hive.default.test_table", new QueryExecutor.QueryParam[0]))).containsOnly((List)ImmutableList.of((Object)QueryAssert.Row.row((Object[])new Object[]{"alice", "USER", ROLE2, "ROLE", "hive", "default", "test_table", "INSERT", "NO", null})));
        TestRoles.onPrestoAlice().executeQuery("DROP TABLE hive.default.test_table", new QueryExecutor.QueryParam[0]);
    }

    private static void assertAdminExecute(String query) {
        QueryExecutors.onTrino().executeQuery("SET ROLE NONE IN hive", new QueryExecutor.QueryParam[0]);
        QueryAssert.assertQueryFailure(() -> QueryExecutors.onTrino().executeQuery(query, new QueryExecutor.QueryParam[0])).hasMessageContaining("Access Denied");
        QueryExecutors.onTrino().executeQuery("SET ROLE ALL IN hive", new QueryExecutor.QueryParam[0]);
        QueryAssert.assertQueryFailure(() -> QueryExecutors.onTrino().executeQuery(query, new QueryExecutor.QueryParam[0])).hasMessageContaining("Access Denied");
        QueryExecutors.onTrino().executeQuery("SET ROLE admin IN hive", new QueryExecutor.QueryParam[0]);
        QueryExecutors.onTrino().executeQuery(query, new QueryExecutor.QueryParam[0]);
    }

    private static QueryExecutor onPrestoAlice() {
        return QueryExecutors.connectToTrino("alice@presto");
    }

    private static QueryExecutor onPrestoBob() {
        return QueryExecutors.connectToTrino("bob@presto");
    }
}

