/*
 * Decompiled with CFR 0.152.
 */
package io.trino.tests.product.hive;

import com.google.common.io.Resources;
import com.google.inject.Inject;
import com.google.inject.name.Named;
import io.trino.tempto.assertions.QueryAssert;
import io.trino.tempto.hadoop.hdfs.HdfsClient;
import io.trino.tempto.query.QueryExecutor;
import io.trino.tests.product.utils.QueryExecutors;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Paths;
import org.assertj.core.api.AssertProvider;
import org.assertj.core.api.Assertions;
import org.testng.annotations.Test;

public class TestTextfileSymlinkInputFormat {
    @Inject
    private HdfsClient hdfsClient;
    @Inject
    @Named(value="databases.hive.warehouse_directory_path")
    private String warehouseDirectory;

    @Test(groups={"storage_formats"})
    public void testSymlinkTable() throws Exception {
        String table = "test_textfile_symlink";
        QueryExecutors.onHive().executeQuery("DROP TABLE IF EXISTS " + table, new QueryExecutor.QueryParam[0]);
        QueryExecutors.onHive().executeQuery("CREATE TABLE %s (col int)\nROW FORMAT SERDE 'org.apache.hadoop.hive.serde2.lazy.LazySimpleSerDe'\nSTORED AS INPUTFORMAT 'org.apache.hadoop.hive.ql.io.SymlinkTextInputFormat'\nOUTPUTFORMAT 'org.apache.hadoop.hive.ql.io.HiveIgnoreKeyTextOutputFormat'".formatted(table), new QueryExecutor.QueryParam[0]);
        String tableRoot = this.warehouseDirectory + "/" + table;
        String dataDir = this.warehouseDirectory + "/data_test_textfile_symlink";
        this.saveResourceOnHdfs("data.textfile", dataDir + "/data.textfile");
        this.hdfsClient.saveFile(tableRoot + "/symlink.txt", String.format("hdfs:%s/data.textfile", dataDir));
        ((QueryAssert)Assertions.assertThat((AssertProvider)QueryExecutors.onTrino().executeQuery("SELECT * FROM " + table, new QueryExecutor.QueryParam[0]))).containsExactlyInOrder(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{42})});
        QueryExecutors.onHive().executeQuery("DROP TABLE " + table, new QueryExecutor.QueryParam[0]);
        this.hdfsClient.delete(dataDir);
    }

    @Test(groups={"storage_formats"})
    public void testSymlinkTableWithSymlinkFileContainingNonExistentPath() throws Exception {
        String table = "test_textfile_invalid_symlink";
        QueryExecutors.onHive().executeQuery("DROP TABLE IF EXISTS " + table, new QueryExecutor.QueryParam[0]);
        QueryExecutors.onHive().executeQuery("CREATE TABLE %s (col int)\nROW FORMAT SERDE 'org.apache.hadoop.hive.serde2.lazy.LazySimpleSerDe'\nSTORED AS INPUTFORMAT 'org.apache.hadoop.hive.ql.io.SymlinkTextInputFormat'\nOUTPUTFORMAT 'org.apache.hadoop.hive.ql.io.HiveIgnoreKeyTextOutputFormat'".formatted(table), new QueryExecutor.QueryParam[0]);
        String tableRoot = this.warehouseDirectory + "/" + table;
        String dataDir = this.warehouseDirectory + "/data_test_textfile_invalid_symlink";
        this.saveResourceOnHdfs("data.textfile", dataDir + "/data.textfile");
        this.hdfsClient.saveFile(tableRoot + "/symlink.txt", String.format("hdfs:%s/data.textfile\nhdfs:%s/missingfile.textfile", dataDir, dataDir));
        Assertions.assertThatThrownBy(() -> QueryExecutors.onTrino().executeQuery("SELECT * FROM " + table, new QueryExecutor.QueryParam[0])).hasMessageMatching(".*Manifest file from the location \\[.*data_test_textfile_invalid_symlink\\] contains non-existent path:.*missingfile.textfile");
        QueryExecutors.onHive().executeQuery("DROP TABLE " + table, new QueryExecutor.QueryParam[0]);
        this.hdfsClient.delete(dataDir);
    }

    @Test(groups={"storage_formats"})
    public void testSymlinkTableWithMultipleParentDirectories() throws Exception {
        String table = "test_textfile_symlink_with_multiple_parents";
        QueryExecutors.onHive().executeQuery("DROP TABLE IF EXISTS " + table, new QueryExecutor.QueryParam[0]);
        QueryExecutors.onHive().executeQuery("CREATE TABLE %s (value int)\nROW FORMAT SERDE 'org.apache.hadoop.hive.serde2.lazy.LazySimpleSerDe'\nSTORED AS INPUTFORMAT 'org.apache.hadoop.hive.ql.io.SymlinkTextInputFormat'\nOUTPUTFORMAT 'org.apache.hadoop.hive.ql.io.HiveIgnoreKeyTextOutputFormat'".formatted(table), new QueryExecutor.QueryParam[0]);
        String tableRoot = this.warehouseDirectory + "/" + table;
        String dataDir = this.warehouseDirectory + "/data_test_textfile_symlink_with_multiple_parents";
        String anotherDataDir = this.warehouseDirectory + "/data2_test_textfile_symlink_with_multiple_parents";
        this.saveResourceOnHdfs("data.textfile", dataDir + "/data.textfile");
        this.saveResourceOnHdfs("data.textfile", anotherDataDir + "/data.textfile");
        this.saveResourceOnHdfs("data.avro", dataDir + "/dontread.avro");
        this.hdfsClient.saveFile(tableRoot + "/symlink.txt", String.format("hdfs:%s/data.textfile\nhdfs:%s/data.textfile", dataDir, anotherDataDir));
        ((QueryAssert)Assertions.assertThat((AssertProvider)QueryExecutors.onTrino().executeQuery("SELECT COUNT(*) as cnt FROM " + table, new QueryExecutor.QueryParam[0]))).containsExactlyInOrder(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{2})});
        QueryExecutors.onHive().executeQuery("DROP TABLE " + table, new QueryExecutor.QueryParam[0]);
        this.hdfsClient.delete(dataDir);
        this.hdfsClient.delete(anotherDataDir);
    }

    private void saveResourceOnHdfs(String resource, String location) throws IOException {
        this.hdfsClient.delete(location);
        try (InputStream inputStream = Resources.getResource((String)Paths.get("io/trino/tests/product/hive/data/single_int_column/", resource).toString()).openStream();){
            this.hdfsClient.saveFile(location, inputStream);
        }
    }
}

