/*
 * Decompiled with CFR 0.152.
 */
package io.trino.tests.product.hive.util;

import io.trino.tempto.query.QueryExecutor;
import io.trino.tests.product.utils.QueryExecutors;
import java.util.Objects;

public class TemporaryHiveTable
implements AutoCloseable {
    private final String name;

    public static TemporaryHiveTable temporaryHiveTable(String tableName) {
        return new TemporaryHiveTable(tableName);
    }

    private TemporaryHiveTable(String name) {
        this.name = Objects.requireNonNull(name, "name is null");
    }

    public String getName() {
        return this.name;
    }

    public void closeQuietly(Exception e) {
        block3: {
            try {
                TemporaryHiveTable justCloseIt = this;
                if (justCloseIt != null) {
                    justCloseIt.close();
                }
            }
            catch (Exception closeException) {
                if (e == closeException) break block3;
                e.addSuppressed(closeException);
            }
        }
    }

    @Override
    public void close() {
        QueryExecutors.onHive().executeQuery("DROP TABLE " + this.name, new QueryExecutor.QueryParam[0]);
    }
}

